/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.instruction.BaseInstruction;
import com.ibm.toad.cfparse.instruction.InstructionFormatException;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.instruction.ParseException;
import com.ibm.toad.cfparse.instruction.TagFactory;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.cfparse.utils.CPUtils;
import com.ibm.toad.utils.D;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.StringTokenizer;

public final class Instruction
extends JVMInstruction
implements BaseInstruction {
    private byte[] d_code;
    private BitSet d_uses;
    private String d_tag;
    private ConstantPool d_cp;
    private TagFactory d_fac;
    private String[] d_varTable;
    private boolean marked = false;

    Instruction(TagFactory tagFactory, ConstantPool constantPool, byte[] byArray, int n, int n2) {
        super(byArray[n]);
        this.d_cp = constantPool;
        this.d_code = new byte[n2];
        System.arraycopy(byArray, n, this.d_code, 0, n2);
        this.d_fac = tagFactory;
        this.d_tag = null;
    }

    Instruction(TagFactory tagFactory, ConstantPool constantPool, String string) throws InstructionFormatException {
        this.d_fac = tagFactory;
        this.d_cp = constantPool;
        this.d_tag = null;
        this.verify(string);
    }

    BitSet uses() {
        return this.setUses();
    }

    public void setTag(String string) {
        this.d_tag = string;
    }

    public void setVarTable(String[] stringArray) {
        this.d_varTable = stringArray;
    }

    public BaseInstruction updateOffsets(int[] nArray, int n) {
        if (this.d_operandTypes.equals("") || nArray == null) {
            return this;
        }
        if (this.d_operandTypes.charAt(0) != 'a') {
            return this;
        }
        int n2 = ByteArray.getSignedShortAtOffset(this.d_code, 1);
        int n3 = nArray[n2] - n;
        int n4 = this.getOpCode();
        if (n3 <= Short.MAX_VALUE && n3 >= Short.MIN_VALUE) {
            return this;
        }
        if (n4 != 167 && n4 != 168) {
            return null;
        }
        byte[] byArray = new byte[]{(byte)(n4 == 167 ? 200 : 201), (byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 >>> 0 & 0xFF)};
        Instruction instruction = new Instruction(this.d_fac, this.d_cp, byArray, 0, 5);
        instruction.setTag(this.d_tag);
        return instruction;
    }

    public byte[] getCode(int[] nArray, int n) {
        byte[] byArray = null;
        if (this.d_operandTypes.equals("") || nArray == null) {
            return this.d_code;
        }
        switch (this.d_operandTypes.charAt(0)) {
            case 's': {
                switch (this.d_opCode) {
                    case 171: {
                        int n2 = (4 - (n + 1) % 4) % 4;
                        int n3 = 0;
                        int n4 = 0;
                        byArray = new byte[n2 + this.d_code.length];
                        byArray[n3++] = (byte)this.d_opCode;
                        for (n4 = 0; n4 < n2; ++n4) {
                            byArray[n3++] = 0;
                        }
                        int n5 = ByteArray.getIntAtOffset(this.d_code, 1);
                        int n6 = nArray[n5] - n;
                        byArray[n3++] = (byte)(n6 >>> 24 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 16 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 8 & 0xFF);
                        byArray[n3++] = (byte)(n6 >>> 0 & 0xFF);
                        for (n4 = 5; n4 < 9; ++n4) {
                            byArray[n3++] = this.d_code[n4];
                        }
                        int n7 = ByteArray.getIntAtOffset(this.d_code, 5);
                        int n8 = 9;
                        for (int i = 0; i < n7; ++i) {
                            for (n4 = 0; n4 < 4; ++n4) {
                                byArray[n3++] = this.d_code[n8 + n4];
                            }
                            n5 = ByteArray.getIntAtOffset(this.d_code, n8 += 4);
                            n6 = nArray[n5] - n;
                            byArray[n3++] = (byte)(n6 >>> 24 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 16 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 8 & 0xFF);
                            byArray[n3++] = (byte)(n6 >>> 0 & 0xFF);
                            n8 += 4;
                        }
                        break;
                    }
                    case 170: {
                        int n9 = (4 - (n + 1) % 4) % 4;
                        int n10 = 0;
                        int n11 = 0;
                        byArray = new byte[n9 + this.d_code.length];
                        byArray[n10++] = (byte)this.d_opCode;
                        for (n11 = 0; n11 < n9; ++n11) {
                            byArray[n10++] = 0;
                        }
                        int n12 = ByteArray.getIntAtOffset(this.d_code, 1);
                        int n13 = nArray[n12] - n;
                        byArray[n10++] = (byte)(n13 >>> 24 & 0xFF);
                        byArray[n10++] = (byte)(n13 >>> 16 & 0xFF);
                        byArray[n10++] = (byte)(n13 >>> 8 & 0xFF);
                        byArray[n10++] = (byte)(n13 >>> 0 & 0xFF);
                        for (n11 = 5; n11 < 13; ++n11) {
                            byArray[n10++] = this.d_code[n11];
                        }
                        int n14 = ByteArray.getIntAtOffset(this.d_code, 5);
                        int n15 = ByteArray.getIntAtOffset(this.d_code, 9);
                        int n16 = 13;
                        for (int i = n14; i <= n15; ++i) {
                            n12 = ByteArray.getIntAtOffset(this.d_code, n16);
                            n13 = nArray[n12] - n;
                            byArray[n10++] = (byte)(n13 >>> 24 & 0xFF);
                            byArray[n10++] = (byte)(n13 >>> 16 & 0xFF);
                            byArray[n10++] = (byte)(n13 >>> 8 & 0xFF);
                            byArray[n10++] = (byte)(n13 >>> 0 & 0xFF);
                            n16 += 4;
                        }
                        break;
                    }
                    case 196: {
                        byArray = this.d_code;
                    }
                }
                break;
            }
            case 'a': {
                int n17 = ByteArray.getSignedShortAtOffset(this.d_code, 1);
                int n18 = nArray[n17] - n;
                byArray = new byte[this.d_code.length];
                byArray[0] = (byte)this.d_opCode;
                byArray[1] = (byte)(n18 >>> 8 & 0xFF);
                byArray[2] = (byte)(n18 >>> 0 & 0xFF);
                break;
            }
            case 'A': {
                int n19 = ByteArray.getIntAtOffset(this.d_code, 1);
                int n20 = nArray[n19] - n;
                byArray = new byte[this.d_code.length];
                byArray[0] = (byte)this.d_opCode;
                byArray[1] = (byte)(n20 >>> 24 & 0xFF);
                byArray[2] = (byte)(n20 >>> 16 & 0xFF);
                byArray[3] = (byte)(n20 >>> 8 & 0xFF);
                byArray[4] = (byte)(n20 >>> 0 & 0xFF);
                break;
            }
            default: {
                byArray = this.d_code;
            }
        }
        return byArray;
    }

    private Object[] parseString(String string) throws ParseException {
        boolean bl = false;
        if (this.d_opCode == 170) {
            int n = 0;
            int n2 = string.indexOf(" ");
            String string2 = string.substring(0, n2);
            int n3 = string.indexOf("#", n2);
            int n4 = string.indexOf("-", n3);
            int n5 = string.indexOf("#", n4);
            int n6 = string.indexOf(" ", n5);
            int n7 = 0;
            int n8 = 0;
            try {
                n7 = Integer.parseInt(string.substring(n3 + 1, n4).trim());
                n8 = Integer.parseInt(string.substring(n5 + 1, n6).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Cannot parse " + string);
            }
            Object[] objectArray = new Object[3 + (n8 - n7) + 1];
            int n9 = this.d_fac.tagFor(string2, true);
            objectArray[n++] = new Integer(n9);
            objectArray[n++] = new Integer(n7);
            objectArray[n++] = new Integer(n8);
            string = string.substring(n6).trim();
            for (int i = 0; i <= n8 - n7; ++i) {
                n2 = string.indexOf(" ");
                if (n2 == -1) {
                    n2 = string.length();
                }
                string2 = string.substring(0, n2);
                string = string.substring(n2).trim();
                n9 = this.d_fac.tagFor(string2, true);
                objectArray[n++] = new Integer(n9);
            }
            return objectArray;
        }
        if (this.d_opCode == 171) {
            int n;
            int n10 = 0;
            int n11 = string.indexOf(" ");
            String string3 = string.substring(0, n11);
            int n12 = string.indexOf("#", n11);
            int n13 = string.indexOf(" ", n12);
            int n14 = 0;
            try {
                n14 = Integer.parseInt(string.substring(n12 + 1, n13).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Cannot parse " + string.substring(n12 + 1, n13).trim());
            }
            Object[] objectArray = new Object[2 + n14 * 2];
            int n15 = this.d_fac.tagFor(string3, true);
            objectArray[n10++] = new Integer(n15);
            objectArray[n10++] = new Integer(n14);
            string = string.substring(n13).trim();
            class Pair {
                Integer match;
                Integer tgt;

                public Pair(Integer n, Integer n2) {
                    this.match = n;
                    this.tgt = n2;
                }
            }
            Pair[] pairArray = new Pair[n14];
            for (n = 0; n < n14; ++n) {
                n11 = string.indexOf("(");
                n12 = string.indexOf("#", n11);
                int n16 = string.indexOf(",", n12);
                int n17 = string.indexOf(")", n16);
                int n18 = 0;
                try {
                    n18 = Integer.parseInt(string.substring(n12 + 1, n16));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Cannot parse " + string.substring(n12 + 1, n16));
                }
                string3 = string.substring(n16 + 1, n17).trim();
                string = string.substring(n17 + 1).trim();
                n15 = this.d_fac.tagFor(string3, true);
                pairArray[n] = new Pair(new Integer(n18), new Integer(n15));
            }
            Arrays.sort(pairArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    return ((Pair)object).match.compareTo(((Pair)object2).match);
                }

                public boolean equals(Object object) {
                    return this.equals(object);
                }
            });
            for (n = 0; n < pairArray.length; ++n) {
                objectArray[n10++] = pairArray[n].match;
                objectArray[n10++] = pairArray[n].tgt;
            }
            return objectArray;
        }
        if (this.d_opCode == 196) {
            Object[] objectArray;
            int n = string.indexOf(" ");
            String string4 = string.substring(0, n).trim();
            String string5 = string.substring(n).trim();
            if ((n = string5.indexOf(" ")) != -1) {
                string = string5.substring(n).trim();
                string5 = string5.substring(0, n).trim();
                objectArray = new Object[3];
            } else {
                objectArray = new Object[2];
                string = null;
            }
            if (!(string4.equals("iinc") || string4.substring(1).equals("load") || string4.substring(1).equals("store") || string4.equals("ret"))) {
                throw new ParseException("illegal opCode for widening  " + string4);
            }
            objectArray[0] = string4;
            if (!string5.startsWith("v")) {
                throw new ParseException("local variable must begin with 'v' " + string5);
            }
            try {
                Integer n19 = Integer.valueOf(string5.substring(1));
                int n20 = n19;
                if (n20 < 0 || n20 > 65535) {
                    throw new ParseException("Value out of bounds: " + string5.substring(1));
                }
                objectArray[1] = n19;
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Cannnot parse " + string5.substring(1));
            }
            if (string != null) {
                if (!string.startsWith("#")) {
                    throw new ParseException("integer operand must begin with '#' " + string);
                }
                try {
                    objectArray[2] = Short.valueOf(string.substring(1));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ParseException("Cannot parse " + string.substring(1));
                }
            }
            return objectArray;
        }
        Object[] objectArray = new Object[this.d_operandTypes.length()];
        block64: for (int i = 0; i < this.d_operandTypes.length(); ++i) {
            String string6;
            if (string.length() == 0) {
                if (this.d_operandTypes.charAt(i) != '0') {
                    throw new ParseException("no line, " + i + "/" + this.d_operandTypes.length());
                }
                objectArray[i] = new Byte(0);
                continue;
            }
            if (string.charAt(0) == '\"') {
                string6 = string.substring(0, string.lastIndexOf(34));
                string = string.substring(string.lastIndexOf(34) + 1).trim();
            } else {
                int n = string.indexOf(" ");
                if (n == -1) {
                    string6 = string.trim();
                    string = "";
                } else {
                    string6 = string.substring(0, n).trim();
                    string = string.substring(n + 1).trim();
                }
            }
            switch (this.d_operandTypes.charAt(i)) {
                case 'v': {
                    int n;
                    if (!string6.startsWith("v")) {
                        throw new ParseException("local variable must begin with 'v' " + string6);
                    }
                    try {
                        Short s = Short.valueOf(string6.substring(1));
                        n = s.shortValue();
                        if (n < 0 || n > 255) {
                            throw new ParseException("Cannot parse " + string6.substring(1));
                        }
                        objectArray[i] = s;
                        continue block64;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Cannot parse " + string6.substring(1));
                    }
                }
                case 'V': {
                    if (!string6.startsWith("v")) {
                        throw new ParseException("local variable must begin with 'v' " + string6);
                    }
                    try {
                        objectArray[i] = Short.valueOf(string6.substring(1));
                        continue block64;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Cannot parse " + string6.substring(1));
                    }
                }
                case 'u': {
                    int n;
                    if (!string6.startsWith("#")) {
                        throw new ParseException("integer operand must begin with '#' " + string6);
                    }
                    try {
                        Short s = Short.valueOf(string6.substring(1));
                        n = s.shortValue();
                        if (n < 0 || n > 255) {
                            throw new ParseException("Cannot parse " + string6.substring(1));
                        }
                        objectArray[i] = s;
                        continue block64;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Cannot parse " + string6.substring(1));
                    }
                }
                case '0': 
                case 'i': {
                    if (!string6.startsWith("#")) {
                        throw new ParseException("integer operand must begin with '#' " + string6);
                    }
                    try {
                        objectArray[i] = Byte.valueOf(string6.substring(1));
                        continue block64;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Cannot parse " + string6.substring(1));
                    }
                }
                case 'I': {
                    if (!string6.startsWith("#")) {
                        throw new ParseException("integer operand must begin with '#' " + string6);
                    }
                    try {
                        objectArray[i] = Short.valueOf(string6.substring(1));
                        continue block64;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Cannot parse " + string6.substring(1));
                    }
                }
                case 'l': {
                    if (!string6.startsWith("#")) {
                        throw new ParseException("integer operand must begin with '#' " + string6);
                    }
                    try {
                        objectArray[i] = Integer.valueOf(string6.substring(1));
                        continue block64;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Cannot parse " + string6.substring(1));
                    }
                }
                case 'a': {
                    int n = this.d_fac.tagFor(string6, true);
                    objectArray[i] = new Short((short)n);
                    continue block64;
                }
                case 'A': {
                    int n = this.d_fac.tagFor(string6, true);
                    objectArray[i] = new Integer(n);
                    continue block64;
                }
                case 't': {
                    int n = Instruction.String2arrayTypeCode(string6);
                    if (n == -1) {
                        throw new ParseException("Incorrect typecode" + string6);
                    }
                    objectArray[i] = new Byte((byte)n);
                    continue block64;
                }
                case 'c': {
                    if (this.d_opCode != 18) continue block64;
                    switch (string6.charAt(0)) {
                        case '\"': {
                            objectArray[i] = string6.substring(1);
                            continue block64;
                        }
                        case '#': {
                            try {
                                objectArray[i] = Integer.valueOf(string6.substring(1));
                                continue block64;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new ParseException("Cannot parse " + string6.substring(1));
                            }
                        }
                        case 'F': {
                            try {
                                objectArray[i] = Float.valueOf(string6.substring(1));
                                continue block64;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new ParseException("Cannot parse " + string6.substring(1));
                            }
                        }
                    }
                    throw new ParseException("Cannot parse " + string6);
                }
                case 'C': {
                    if (this.d_opCode == 19) {
                        switch (string6.charAt(0)) {
                            case '\"': {
                                objectArray[i] = string6.substring(1);
                                continue block64;
                            }
                            case '#': {
                                try {
                                    objectArray[i] = Integer.valueOf(string6.substring(1));
                                    continue block64;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ParseException("Cannot parse " + string6.substring(1));
                                }
                            }
                            case 'F': {
                                try {
                                    objectArray[i] = Float.valueOf(string6.substring(1));
                                    continue block64;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ParseException("Cannot parse " + string6.substring(1));
                                }
                            }
                        }
                        throw new ParseException("Cannot parse " + string6);
                    }
                    if (this.d_opCode == 20) {
                        switch (string6.charAt(0)) {
                            case 'L': {
                                try {
                                    objectArray[i] = Long.valueOf(string6.substring(1));
                                    continue block64;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ParseException("Cannot parse " + string6.substring(1));
                                }
                            }
                            case 'D': {
                                try {
                                    objectArray[i] = Double.valueOf(string6.substring(1));
                                    continue block64;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new ParseException("Cannot parse " + string6.substring(1));
                                }
                            }
                        }
                        throw new ParseException("Cannot parse " + string6);
                    }
                    if (this.d_opCode == 178 || this.d_opCode == 179 || this.d_opCode == 180 || this.d_opCode == 181) {
                        int n = string.lastIndexOf(".");
                        if (n == -1 || n == string.length()) {
                            throw new ParseException("Cannot parse " + string);
                        }
                        objectArray[i] = CPUtils.dots2slashes(string.substring(0, n)) + " " + string.substring(n + 1, string.length()) + " " + CPUtils.java2internal(string6);
                        string = "";
                        continue block64;
                    }
                    if (this.d_opCode == 182 || this.d_opCode == 183 || this.d_opCode == 184 || this.d_opCode == 185) {
                        if (this.d_opCode == 185) {
                            int n = string.indexOf("#");
                            if (n == -1) {
                                throw new ParseException("invokeinterface without integer operand " + string6 + " " + string);
                            }
                            string6 = string6 + " " + string.substring(0, n).trim();
                            string = string.substring(n).trim();
                        } else {
                            string6 = string6 + " " + string;
                            string = "";
                        }
                        objectArray[i] = CPUtils.java2internal(string6);
                        continue block64;
                    }
                    if (this.d_opCode != 187 && this.d_opCode != 189 && this.d_opCode != 192 && this.d_opCode != 193 && this.d_opCode != 197) continue block64;
                    if (this.d_opCode == 197) {
                        int n = string.indexOf("#");
                        if (n == -1) {
                            throw new ParseException("multianewarray without integer operand " + string6 + " " + string);
                        }
                        string6 = string6 + " " + string.substring(0, n).trim();
                        string = string.substring(n).trim();
                    } else {
                        string6 = string6 + " " + string;
                        string = "";
                    }
                    if (string6.indexOf("[") != -1) {
                        StringBuffer stringBuffer = new StringBuffer();
                        CPUtils.java2descriptor(string6, stringBuffer);
                        objectArray[i] = stringBuffer.toString().trim();
                        continue block64;
                    }
                    objectArray[i] = CPUtils.dots2slashes(string6).trim();
                    continue block64;
                }
                default: {
                    throw new ParseException("Unknown operandType " + this.d_operandTypes.charAt(i));
                }
            }
        }
        return objectArray;
    }

    private byte[] writeArgs(Object[] objectArray) throws InstructionFormatException {
        int n = -1;
        int n2 = 0;
        if (this.d_operandTypes.length() != objectArray.length && !this.d_operandTypes.equals("special")) {
            throw new InstructionFormatException("Bad Operands");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(this.d_opCode);
        }
        catch (IOException iOException) {
            throw new InstructionFormatException("IO Error");
        }
        int n3 = 0;
        if (this.d_opCode == 170) {
            try {
                dataOutputStream.writeInt((Integer)objectArray[n3++]);
                int n4 = (Integer)objectArray[n3++];
                int n5 = (Integer)objectArray[n3++];
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeInt(n5);
                for (int i = 0; i <= n5 - n4; ++i) {
                    dataOutputStream.writeInt((Integer)objectArray[n3++]);
                }
            }
            catch (ClassCastException classCastException) {
                throw new InstructionFormatException("Expecting Integer");
            }
            catch (IOException iOException) {
                throw new InstructionFormatException("IO Error");
            }
            return byteArrayOutputStream.toByteArray();
        }
        if (this.d_opCode == 171) {
            try {
                dataOutputStream.writeInt((Integer)objectArray[n3++]);
                int n6 = (Integer)objectArray[n3++];
                dataOutputStream.writeInt(n6);
                for (int i = 0; i < n6; ++i) {
                    dataOutputStream.writeInt((Integer)objectArray[n3++]);
                    dataOutputStream.writeInt((Integer)objectArray[n3++]);
                }
            }
            catch (ClassCastException classCastException) {
                throw new InstructionFormatException("Expecting Integer");
            }
            catch (IOException iOException) {
                throw new InstructionFormatException("IO Error");
            }
            return byteArrayOutputStream.toByteArray();
        }
        if (this.d_opCode == 196) {
            int n7 = -1;
            int n8 = JVMInstruction.isOpcode(((String)objectArray[0]).trim());
            if (n8 == -1) {
                throw new InstructionFormatException("Expected valid opCode");
            }
            if (!(objectArray[1] instanceof Integer)) {
                throw new InstructionFormatException("Expected Short");
            }
            int n9 = (Integer)objectArray[1];
            if (objectArray.length == 3) {
                if (!(objectArray[2] instanceof Short)) {
                    throw new InstructionFormatException("Expected Short");
                }
                n7 = ((Short)objectArray[2]).shortValue();
            }
            if (n8 != 132) {
                if (n9 < 255) {
                    try {
                        dataOutputStream.writeByte(n9);
                    }
                    catch (IOException iOException) {
                        throw new InstructionFormatException("IO Error");
                    }
                    this.d_opCode = n8;
                    this.d_name = Instruction.d_instrTable[n8].d_name;
                    this.d_operandTypes = d_instrTable[n8].operandTypes();
                    this.d_len = Instruction.d_instrTable[n8].d_len;
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byArray[0] = (byte)(n8 & 0xFF);
                    return byArray;
                }
                try {
                    dataOutputStream.writeByte(n8);
                    dataOutputStream.writeShort(n9);
                }
                catch (IOException iOException) {
                    throw new InstructionFormatException("IO Error");
                }
            }
            if (n9 < 255 && n7 < 127 && n7 > -128) {
                try {
                    dataOutputStream.writeByte(n9);
                    dataOutputStream.writeByte(n7);
                }
                catch (IOException iOException) {
                    throw new InstructionFormatException("IO Error");
                }
                this.d_opCode = n8;
                this.d_name = Instruction.d_instrTable[n8].d_name;
                this.d_operandTypes = d_instrTable[n8].operandTypes();
                this.d_len = Instruction.d_instrTable[n8].d_len;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byArray[0] = (byte)(n8 & 0xFF);
                return byArray;
            }
            try {
                dataOutputStream.writeByte(n8);
                dataOutputStream.writeShort(n9);
                dataOutputStream.writeShort(n7);
            }
            catch (IOException iOException) {
                throw new InstructionFormatException("IO Error");
            }
            return byteArrayOutputStream.toByteArray();
        }
        block48: for (int i = 0; i < this.d_operandTypes.length(); ++i) {
            switch (this.d_operandTypes.charAt(i)) {
                case 'u': 
                case 'v': {
                    if (!(objectArray[i] instanceof Short)) {
                        throw new InstructionFormatException("Expected Unsigned Byte (" + this.d_operandTypes.charAt(i) + ")");
                    }
                    Short s = (Short)objectArray[i];
                    short s2 = s;
                    if (s2 < 0 || s2 > 255) {
                        throw new InstructionFormatException("Expected Unsigned Byte (" + this.d_operandTypes.charAt(i) + ")");
                    }
                    try {
                        dataOutputStream.writeByte(s2);
                        continue block48;
                    }
                    catch (IOException iOException) {
                        throw new InstructionFormatException("IO Error");
                    }
                }
                case '0': 
                case 'i': 
                case 't': {
                    if (!(objectArray[i] instanceof Byte)) {
                        throw new InstructionFormatException("Expected Byte (" + this.d_operandTypes.charAt(i) + ")");
                    }
                    try {
                        dataOutputStream.writeByte(((Byte)objectArray[i]).byteValue());
                        continue block48;
                    }
                    catch (IOException iOException) {
                        throw new InstructionFormatException("IO Error");
                    }
                }
                case 'I': 
                case 'V': 
                case 'a': {
                    if (!(objectArray[i] instanceof Short)) {
                        throw new InstructionFormatException("Expected Short");
                    }
                    try {
                        dataOutputStream.writeShort(((Short)objectArray[i]).shortValue());
                        continue block48;
                    }
                    catch (IOException iOException) {
                        throw new InstructionFormatException("IO Error");
                    }
                }
                case 'A': 
                case 'l': {
                    if (!(objectArray[i] instanceof Integer)) {
                        throw new InstructionFormatException("Expected Integer");
                    }
                    try {
                        dataOutputStream.writeInt((Integer)objectArray[i]);
                        continue block48;
                    }
                    catch (IOException iOException) {
                        throw new InstructionFormatException("IO Error");
                    }
                }
                case 'c': {
                    if (this.d_opCode == 18) {
                        if (objectArray[i] instanceof String) {
                            n = this.d_cp.find(8, (String)objectArray[i]);
                            if (n == -1) {
                                n = this.d_cp.addString((String)objectArray[i]);
                            }
                        } else if (objectArray[i] instanceof Integer) {
                            int n10 = (Integer)objectArray[i];
                            n = this.d_cp.find(n10);
                            if (n == -1) {
                                n = this.d_cp.addInteger(n10);
                            }
                        } else if (objectArray[i] instanceof Float) {
                            float f = ((Float)objectArray[i]).floatValue();
                            n = this.d_cp.find(f);
                            if (n == -1) {
                                n = this.d_cp.addFloat(f);
                            }
                        } else {
                            throw new InstructionFormatException("Wrong Type");
                        }
                    }
                    try {
                        if (n > 255) {
                            n2 = 19;
                            dataOutputStream.writeShort(n);
                            continue block48;
                        }
                        dataOutputStream.writeByte(n);
                        continue block48;
                    }
                    catch (IOException iOException) {
                        throw new InstructionFormatException("IO Error");
                    }
                }
                case 'C': {
                    if (this.d_opCode == 19) {
                        if (objectArray[i] instanceof String) {
                            n = this.d_cp.find(8, (String)objectArray[i]);
                            if (n == -1) {
                                n = this.d_cp.addString((String)objectArray[i]);
                            }
                        } else if (objectArray[i] instanceof Integer) {
                            int n11 = (Integer)objectArray[i];
                            n = this.d_cp.find(n11);
                            if (n == -1) {
                                n = this.d_cp.addInteger(n11);
                            }
                        } else if (objectArray[i] instanceof Float) {
                            float f = ((Float)objectArray[i]).floatValue();
                            n = this.d_cp.find(f);
                            if (n == -1) {
                                n = this.d_cp.addFloat(f);
                            }
                        } else {
                            throw new InstructionFormatException("Wrong Type");
                        }
                        try {
                            if (n < 255) {
                                n2 = 18;
                                dataOutputStream.writeByte(n);
                                continue block48;
                            }
                            dataOutputStream.writeShort(n);
                            continue block48;
                        }
                        catch (IOException iOException) {
                            throw new InstructionFormatException("IO Error");
                        }
                    }
                    if (this.d_opCode == 20) {
                        if (objectArray[i] instanceof Long) {
                            long l = (Long)objectArray[i];
                            n = this.d_cp.find(l);
                            if (n == -1) {
                                n = this.d_cp.addLong(l);
                            }
                        } else if (objectArray[i] instanceof Double) {
                            double d = (Double)objectArray[i];
                            n = this.d_cp.find(d);
                            if (n == -1) {
                                n = this.d_cp.addDouble(d);
                            }
                        } else {
                            throw new InstructionFormatException("Wrong Type");
                        }
                        try {
                            dataOutputStream.writeShort(n);
                            continue block48;
                        }
                        catch (IOException iOException) {
                            throw new InstructionFormatException("IO Error");
                        }
                    }
                    if (this.d_opCode == 178 || this.d_opCode == 179 || this.d_opCode == 180 || this.d_opCode == 181) {
                        if (!(objectArray[i] instanceof String)) {
                            throw new InstructionFormatException("Wrong Type");
                        }
                        n = this.d_cp.find(9, (String)objectArray[i]);
                        if (n == -1) {
                            n = this.d_cp.addField((String)objectArray[i]);
                        }
                        try {
                            dataOutputStream.writeShort(n);
                            continue block48;
                        }
                        catch (IOException iOException) {
                            throw new InstructionFormatException("IO Error");
                        }
                    }
                    if (this.d_opCode == 182 || this.d_opCode == 183 || this.d_opCode == 184) {
                        if (!(objectArray[i] instanceof String)) {
                            throw new InstructionFormatException("Wrong Type");
                        }
                        n = this.d_cp.find(10, (String)objectArray[i]);
                        if (n == -1) {
                            n = this.d_cp.addMethod((String)objectArray[i]);
                        }
                        try {
                            dataOutputStream.writeShort(n);
                            continue block48;
                        }
                        catch (IOException iOException) {
                            throw new InstructionFormatException("IO Error");
                        }
                    }
                    if (this.d_opCode == 185) {
                        if (!(objectArray[i] instanceof String)) {
                            throw new InstructionFormatException("Wrong Type");
                        }
                        n = this.d_cp.find(11, (String)objectArray[i]);
                        if (n == -1) {
                            n = this.d_cp.addInterface((String)objectArray[i]);
                        }
                        try {
                            dataOutputStream.writeShort(n);
                            continue block48;
                        }
                        catch (IOException iOException) {
                            throw new InstructionFormatException("IO Error");
                        }
                    }
                    if (this.d_opCode != 187 && this.d_opCode != 189 && this.d_opCode != 192 && this.d_opCode != 193 && this.d_opCode != 197) continue block48;
                    if (!(objectArray[i] instanceof String)) {
                        throw new InstructionFormatException("Wrong Type");
                    }
                    n = this.d_cp.find(7, (String)objectArray[i]);
                    if (n == -1) {
                        n = this.d_cp.addClass((String)objectArray[i]);
                    }
                    try {
                        dataOutputStream.writeShort(n);
                        continue block48;
                    }
                    catch (IOException iOException) {
                        throw new InstructionFormatException("IO Error");
                    }
                }
                default: {
                    throw new InstructionFormatException("Unknown operandType " + this.d_operandTypes.charAt(i));
                }
            }
        }
        if (n2 != 0) {
            this.d_opCode = n2;
            this.d_name = Instruction.d_instrTable[n2].d_name;
            this.d_operandTypes = d_instrTable[n2].operandTypes();
            this.d_len = Instruction.d_instrTable[n2].d_len;
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byArray[0] = (byte)(n2 & 0xFF);
            return byArray;
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void verify(String string) throws InstructionFormatException {
        int n;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new InstructionFormatException("null Instruction");
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.endsWith(":")) {
            this.d_tag = string3.substring(0, string3.length() - 1);
        }
        if (this.d_tag == null) {
            string2 = string3;
        } else {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new InstructionFormatException("malformed tag, no opcode");
            }
            string2 = stringTokenizer.nextToken();
        }
        this.d_opCode = n = JVMInstruction.isOpcode(string2);
        this.d_name = Instruction.d_instrTable[n].d_name;
        this.d_operandTypes = d_instrTable[n].operandTypes();
        this.d_len = Instruction.d_instrTable[n].d_len;
        if (this.d_operandTypes.equals("unused")) {
            throw new InstructionFormatException("unused instruction");
        }
        int n2 = string.indexOf(string2);
        D.azzert(n2 != -1, "Argh: sArgs == -1");
        String string4 = string.substring(n2 + string2.length()).trim();
        try {
            Object[] objectArray = this.parseString(string4);
            this.d_code = this.writeArgs(objectArray);
            return;
        }
        catch (ParseException parseException) {
            throw new InstructionFormatException(parseException.getMessage());
        }
    }

    private BitSet setUses() {
        if (this.marked) {
            return this.d_uses;
        }
        this.marked = true;
        if (this.d_len != 0) {
            String string = this.d_operandTypes;
            int n = this.d_operandTypes.length();
            block4: for (int i = 0; i < n; ++i) {
                switch (this.d_operandTypes.charAt(i)) {
                    case 'c': {
                        if (this.d_uses == null) {
                            this.d_uses = new BitSet(this.d_cp.length());
                        }
                        this.d_uses.set(ByteArray.getByteAtOffset(this.d_code, 1));
                        continue block4;
                    }
                    case 'C': {
                        if (this.d_uses == null) {
                            this.d_uses = new BitSet(this.d_cp.length());
                        }
                        this.d_uses.set(ByteArray.getShortAtOffset(this.d_code, 1));
                    }
                }
            }
        }
        return this.d_uses;
    }

    void sprintOperand(StringBuffer stringBuffer, int n, char c) {
        int n2 = 0;
        switch (c) {
            case 'c': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(this.d_cp.getAsJava(n2));
                break;
            }
            case 'C': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append(this.d_cp.getAsJava(n2));
                break;
            }
            case 'v': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                if (this.d_varTable != null) {
                    stringBuffer.append(this.d_varTable[n2]);
                    break;
                }
                stringBuffer.append("v" + n2);
                break;
            }
            case 'V': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                if (this.d_varTable != null) {
                    stringBuffer.append(this.d_varTable[n2]);
                    break;
                }
                stringBuffer.append("v" + n2);
                break;
            }
            case '0': 
            case 'u': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'i': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                if (n2 > 127) {
                    n2 -= 256;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'I': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                if (n2 > Short.MAX_VALUE) {
                    n2 -= 65536;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'l': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'a': {
                n2 = ByteArray.getSignedShortAtOffset(this.d_code, n);
                stringBuffer.append(this.d_fac.getTag(n2));
                break;
            }
            case 'A': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append(this.d_fac.getTag(n2));
                break;
            }
            case 't': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(Instruction.arrayTypeCode2String(n2));
                break;
            }
            default: {
                stringBuffer.append("<unknown operand type: " + c + ">");
            }
        }
    }

    public int getLength(int n) {
        if (this.d_len != 0 || this.d_opCode == 196) {
            return this.d_code.length;
        }
        int n2 = (4 - (n + 1) % 4) % 4;
        return this.d_code.length + n2;
    }

    public String getTag() {
        return this.d_tag;
    }

    public int getOpCode() {
        return this.d_opCode;
    }

    public String toBytes() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.d_code.length; ++i) {
            int n = ByteArray.getByteAtOffset(this.d_code, i);
            if (n < 10) {
                stringBuffer.append("0x0" + Integer.toHexString(n) + " ");
                continue;
            }
            stringBuffer.append("0x" + Integer.toHexString(n) + " ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer;
        block13: {
            char[] cArray;
            block12: {
                cArray = new char[]{'i', 'l', 'f', 'd', 'a'};
                stringBuffer = new StringBuffer(this.name() + " ");
                if (this.len() != 0) break block12;
                switch (this.d_opCode) {
                    case 170: {
                        int n = 1;
                        this.sprintOperand(stringBuffer, n, 'A');
                        stringBuffer.append(" ");
                        int n2 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                        this.sprintOperand(stringBuffer, n, 'l');
                        stringBuffer.append("-");
                        int n3 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                        this.sprintOperand(stringBuffer, n, 'l');
                        n += 4;
                        stringBuffer.append(" ");
                        for (int i = n2; i <= n3; ++i) {
                            this.sprintOperand(stringBuffer, n, 'A');
                            n += 4;
                            stringBuffer.append(" ");
                        }
                        break block13;
                    }
                    case 171: {
                        int n = 1;
                        this.sprintOperand(stringBuffer, n, 'A');
                        stringBuffer.append(" ");
                        int n4 = ByteArray.getIntAtOffset(this.d_code, n += 4);
                        this.sprintOperand(stringBuffer, n, 'l');
                        n += 4;
                        stringBuffer.append(" ");
                        for (int i = 0; i < n4; ++i) {
                            stringBuffer.append("(");
                            this.sprintOperand(stringBuffer, n, 'l');
                            stringBuffer.append(", ");
                            this.sprintOperand(stringBuffer, n += 4, 'A');
                            n += 4;
                            stringBuffer.append(") ");
                        }
                        break block13;
                    }
                    case 196: {
                        int n = ByteArray.getByteAtOffset(this.d_code, 1);
                        JVMInstruction jVMInstruction = d_instrTable[n];
                        stringBuffer.append(jVMInstruction.name() + " ");
                        this.sprintOperand(stringBuffer, 2, 'V');
                        stringBuffer.append(" ");
                        if (n != 132) break block13;
                        this.sprintOperand(stringBuffer, 4, 'I');
                        break block13;
                    }
                    default: {
                        throw new D.AssertionException("Unknown special op code");
                    }
                }
            }
            if (this.d_varTable != null && this.d_opCode > 25 && this.d_opCode < 46) {
                int n = this.d_opCode - 26;
                int n5 = n % 4;
                stringBuffer.setLength(0);
                stringBuffer.append(cArray[n /= 4] + "load " + this.d_varTable[n5]);
            } else if (this.d_varTable != null && this.d_opCode > 58 && this.d_opCode < 79) {
                int n = this.d_opCode - 59;
                int n6 = n % 4;
                stringBuffer.setLength(0);
                stringBuffer.append(cArray[n /= 4] + "store " + this.d_varTable[n6]);
            } else {
                int n = 1;
                int n7 = this.d_operandTypes.length();
                for (int i = 0; i < n7; ++i) {
                    this.sprintOperand(stringBuffer, n, this.d_operandTypes.charAt(i));
                    n += Instruction.argSkip(this.d_operandTypes.charAt(i));
                    stringBuffer.append(" ");
                }
            }
        }
        return stringBuffer.toString();
    }
}

