/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse;

import com.ibm.toad.cfparse.ConstantPoolEntry;
import com.ibm.toad.cfparse.utils.CPUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Hashtable;

public final class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    private int d_numConstants = 1;
    private ConstantPoolEntry[] d_constants = new ConstantPoolEntry[1];
    private HashMap d_hashN2C;
    private HashMap d_hashC2i;

    public int length() {
        return this.d_numConstants;
    }

    public int find(int n, String string) {
        int n2 = -1;
        ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)this.d_hashN2C.get(n + string);
        if (constantPoolEntry != null) {
            Integer n3 = (Integer)this.d_hashC2i.get(constantPoolEntry);
            if (n3 == null) {
                System.out.println("Whoops: " + constantPoolEntry);
            }
            n2 = n3;
        }
        return n2;
    }

    public int find(ConstantPoolEntry constantPoolEntry) {
        return this.find(this.getType(constantPoolEntry), constantPoolEntry.getAsString());
    }

    public int find(float f) {
        for (int i = 1; i < this.d_numConstants; ++i) {
            if (this.getType(i) != 4 || f != ((FloatEntry)this.get(i)).getValue()) continue;
            return i;
        }
        return -1;
    }

    public int find(int n) {
        for (int i = 1; i < this.d_numConstants; ++i) {
            if (this.getType(i) != 3 || n != ((IntegerEntry)this.get(i)).getValue()) continue;
            return i;
        }
        return -1;
    }

    public int find(double d) {
        for (int i = 1; i < this.d_numConstants; ++i) {
            if (this.getType(i) != 6 || d != ((DoubleEntry)this.get(i)).getValue()) continue;
            return i;
        }
        return -1;
    }

    public int find(long l) {
        for (int i = 1; i < this.d_numConstants; ++i) {
            if (this.getType(i) != 5 || l != ((LongEntry)this.get(i)).getValue()) continue;
            return i;
        }
        return -1;
    }

    public int findUtf8(String string) {
        for (int i = 1; i < this.d_numConstants; ++i) {
            if (this.getType(i) != 1 || string != ((Utf8Entry)this.get(i)).getValue()) continue;
            return i;
        }
        return -1;
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_numConstants);
        bitSet.set(0);
        for (int i = 1; i < this.d_numConstants; ++i) {
            ConstantPoolEntry constantPoolEntry = this.get(i);
            if (constantPoolEntry != null) {
                int[] nArray = constantPoolEntry.getIndices();
                if (nArray == null) continue;
                for (int j = 0; j < nArray.length; ++j) {
                    bitSet.set(nArray[j]);
                }
                continue;
            }
            bitSet.set(i);
        }
        return bitSet;
    }

    public int getType(int n) {
        if (n < 0 || n > this.d_numConstants) {
            return -1;
        }
        return this.getType(this.get(n));
    }

    public int getType(ConstantPoolEntry constantPoolEntry) {
        if (constantPoolEntry instanceof ClassEntry) {
            return 7;
        }
        if (constantPoolEntry instanceof FieldrefEntry) {
            return 9;
        }
        if (constantPoolEntry instanceof MethodrefEntry) {
            return 10;
        }
        if (constantPoolEntry instanceof InterfaceMethodrefEntry) {
            return 11;
        }
        if (constantPoolEntry instanceof StringEntry) {
            return 8;
        }
        if (constantPoolEntry instanceof IntegerEntry) {
            return 3;
        }
        if (constantPoolEntry instanceof FloatEntry) {
            return 4;
        }
        if (constantPoolEntry instanceof LongEntry) {
            return 5;
        }
        if (constantPoolEntry instanceof DoubleEntry) {
            return 6;
        }
        if (constantPoolEntry instanceof NameAndTypeEntry) {
            return 12;
        }
        return !(constantPoolEntry instanceof Utf8Entry) ? -1 : 1;
    }

    public String getAsString(int n) {
        return this.get(n).getAsString();
    }

    public String getAsJava(int n) {
        return this.get(n).getAsJava();
    }

    public ConstantPoolEntry get(int n) {
        return this.d_constants[n];
    }

    public void remove(int n) {
        if (n < 0 || n >= this.d_numConstants - 1) {
            return;
        }
        for (int i = n; i < this.d_numConstants - 1; ++i) {
            this.d_constants[i] = this.d_constants[i + 1];
        }
        --this.d_numConstants;
    }

    public void removeAll() {
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[]{new Utf8Entry("<dummy Entry>")};
        this.d_numConstants = 1;
        this.d_hashN2C = new HashMap();
        this.d_hashC2i = new HashMap();
    }

    public void sort(int[] nArray) {
        int n;
        int n2 = 0;
        for (int i = 1; i < this.d_numConstants; ++i) {
            if (nArray[i] != -1) continue;
            ++n2;
        }
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[this.d_numConstants - n2 + 1];
        constantPoolEntryArray[0] = new Utf8Entry("<dummy Entry>");
        for (n = 1; n < this.d_numConstants; ++n) {
            if (nArray[n] == -1) continue;
            ConstantPoolEntry constantPoolEntry = this.get(n);
            if (constantPoolEntry == null) {
                constantPoolEntryArray[nArray[n]] = null;
                continue;
            }
            int[] nArray2 = constantPoolEntry.getIndices();
            switch (this.getType(constantPoolEntry)) {
                case 7: 
                case 8: {
                    constantPoolEntry.setIndices(new int[]{nArray[nArray2[0]]});
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    constantPoolEntry.setIndices(new int[]{nArray[nArray2[0]], nArray[nArray2[1]]});
                }
            }
            constantPoolEntryArray[nArray[n]] = constantPoolEntry;
        }
        this.d_numConstants -= n2;
        this.d_constants = constantPoolEntryArray;
        this.d_hashN2C = new HashMap();
        this.d_hashC2i = new HashMap();
        for (n = 1; n < this.d_numConstants; ++n) {
            if (this.d_constants[n] == null) continue;
            this.d_hashN2C.put(this.getType(n) + this.d_constants[n].getAsString(), this.d_constants[n]);
            this.d_hashC2i.put(this.d_constants[n], new Integer(n));
        }
    }

    public void editMethodName(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof MethodrefEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        ConstantPoolEntry constantPoolEntry2 = this.d_constants[constantPoolEntry.getIndices()[1]];
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry2.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public void editFieldName(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof FieldrefEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        ConstantPoolEntry constantPoolEntry2 = this.d_constants[constantPoolEntry.getIndices()[1]];
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry2.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public void editClass(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof ClassEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public void editString(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof StringEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public void editUtf8String(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof Utf8Entry)) {
            return;
        }
        Utf8Entry utf8Entry = (Utf8Entry)constantPoolEntry;
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
    }

    public void editInterfaceName(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof InterfaceMethodrefEntry)) {
            return;
        }
        this.d_hashN2C.remove(this.getType(constantPoolEntry) + constantPoolEntry.getAsString());
        ConstantPoolEntry constantPoolEntry2 = this.d_constants[constantPoolEntry.getIndices()[1]];
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry2.getIndices()[0]];
        this.d_hashN2C.remove(this.getType(utf8Entry) + utf8Entry.getAsString());
        utf8Entry.setValue(string);
        this.d_hashN2C.put(this.getType(utf8Entry) + utf8Entry.getAsString(), utf8Entry);
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
    }

    public void editNameAndType(int n, Hashtable hashtable, Hashtable hashtable2) {
        ConstantPoolEntry constantPoolEntry = this.d_constants[n];
        if (!(constantPoolEntry instanceof NameAndTypeEntry)) {
            return;
        }
        Utf8Entry utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[0]];
        String string = (String)hashtable.get(utf8Entry.getAsString());
        if (string != null) {
            utf8Entry.setValue(string);
        }
        utf8Entry = (Utf8Entry)this.d_constants[constantPoolEntry.getIndices()[1]];
        String string2 = utf8Entry.getAsString();
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n3;
            if ((n3 = string2.indexOf("L", n2)) == -1) break;
            int n4 = string2.indexOf(";", n3);
            stringBuffer.append(string2.substring(n2, n3 + 1));
            Hashtable hashtable3 = (Hashtable)hashtable2.get(string2.substring(n3 + 1, n4).replace('/', '.'));
            String string3 = string2.substring(n3 + 1, n4);
            if (hashtable3 != null) {
                String string4 = (String)hashtable3.get(string2.substring(n3 + 1, n4).replace('/', '.'));
                if (string4 != null) {
                    string3 = string4;
                }
                boolean bl2 = true;
            }
            stringBuffer.append(string3);
            n2 = n4;
        }
        stringBuffer.append(string2.substring(n2, string2.length()));
        if (stringBuffer.toString() != null) {
            utf8Entry.setValue(stringBuffer.toString());
        }
    }

    public int addClass(String string) {
        int n = this.addUtf8(string = string.replace('.', '/'));
        ClassEntry classEntry = new ClassEntry(n);
        int n2 = this.find(classEntry);
        if (n2 == -1) {
            return this.addNewElement(classEntry);
        }
        return n2;
    }

    public int addField(String string) {
        int n;
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string.indexOf(" ") + 1, string.lastIndexOf(" "));
        String string4 = string.substring(string.lastIndexOf(" ") + 1, string.length());
        int n2 = this.addClass(string2);
        FieldrefEntry fieldrefEntry = new FieldrefEntry(n2, n = this.addNameAndType(string3, string4));
        int n3 = this.find(fieldrefEntry);
        if (n3 == -1) {
            return this.addNewElement(fieldrefEntry);
        }
        return n3;
    }

    public int addMethod(String string) {
        int n;
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string.indexOf(" ") + 1, string.lastIndexOf(" "));
        String string4 = string.substring(string.lastIndexOf(" ") + 1, string.length());
        int n2 = this.addClass(string2);
        MethodrefEntry methodrefEntry = new MethodrefEntry(n2, n = this.addNameAndType(string3, string4));
        int n3 = this.find(methodrefEntry);
        if (n3 == -1) {
            return this.addNewElement(methodrefEntry);
        }
        return n3;
    }

    public int addInterface(String string) {
        int n;
        String string2 = string.substring(0, string.indexOf(" "));
        String string3 = string.substring(string.indexOf(" ") + 1, string.lastIndexOf(" "));
        String string4 = string.substring(string.lastIndexOf(" ") + 1, string.length());
        int n2 = this.addClass(string2);
        InterfaceMethodrefEntry interfaceMethodrefEntry = new InterfaceMethodrefEntry(n2, n = this.addNameAndType(string3, string4));
        int n3 = this.find(interfaceMethodrefEntry);
        if (n3 == -1) {
            return this.addNewElement(interfaceMethodrefEntry);
        }
        return n3;
    }

    public int addString(String string) {
        int n = this.addUtf8(string);
        StringEntry stringEntry = new StringEntry(n);
        int n2 = this.find(stringEntry);
        if (n2 == -1) {
            return this.addNewElement(stringEntry);
        }
        return n2;
    }

    public int addInteger(int n) {
        int n2 = this.find(n);
        if (n2 == -1) {
            return this.addNewElement(new IntegerEntry(n));
        }
        return n2;
    }

    public int addFloat(float f) {
        int n = this.find(f);
        if (n == -1) {
            return this.addNewElement(new FloatEntry(f));
        }
        return n;
    }

    public int addLong(long l) {
        int n = this.find(l);
        if (n == -1) {
            return this.addNewElement(new LongEntry(l));
        }
        return n;
    }

    public int addDouble(double d) {
        int n = this.find(d);
        if (n == -1) {
            return this.addNewElement(new DoubleEntry(d));
        }
        return n;
    }

    public int addNameAndType(String string, String string2) {
        int n;
        int n2 = this.addUtf8(string);
        NameAndTypeEntry nameAndTypeEntry = new NameAndTypeEntry(n2, n = this.addUtf8(string2));
        int n3 = this.find(nameAndTypeEntry);
        if (n3 == -1) {
            return this.addNewElement(nameAndTypeEntry);
        }
        return n3;
    }

    public int addUtf8(String string) {
        int n = this.findUtf8(string = string.intern());
        if (n == -1) {
            return this.addNewElement(new Utf8Entry(string));
        }
        return n;
    }

    public ConstantPool() {
        this.d_constants[0] = new Utf8Entry("<dummy Entry>");
        this.d_hashN2C = new HashMap();
        this.d_hashC2i = new HashMap();
    }

    public ConstantPool(InputStream inputStream) throws IOException {
        this();
        this.read(new DataInputStream(inputStream));
    }

    void read(DataInputStream dataInputStream) throws IOException {
        int n;
        this.d_numConstants = dataInputStream.readUnsignedShort();
        this.d_constants = new ConstantPoolEntry[this.d_numConstants];
        this.d_constants[0] = new Utf8Entry("<dummy Entry>");
        for (n = 1; n < this.d_numConstants; ++n) {
            if (!this.readConstant(dataInputStream, n)) continue;
            ++n;
        }
        for (n = 1; n < this.d_numConstants; ++n) {
            if (this.d_constants[n] == null) continue;
            this.d_hashN2C.put(this.getType(n) + this.d_constants[n].getAsString(), this.d_constants[n]);
            this.d_hashC2i.put(this.d_constants[n], new Integer(n));
        }
    }

    private int addNewElement(ConstantPoolEntry constantPoolEntry) {
        if (this.d_constants == null || this.d_numConstants == this.d_constants.length) {
            this.resize();
        }
        this.d_constants[this.d_numConstants] = constantPoolEntry;
        int n = this.d_numConstants++;
        if (constantPoolEntry instanceof LongEntry || constantPoolEntry instanceof DoubleEntry) {
            if (this.d_numConstants == this.d_constants.length) {
                this.resize();
            }
            ++this.d_numConstants;
        }
        this.d_hashN2C.put(this.getType(constantPoolEntry) + constantPoolEntry.getAsString(), constantPoolEntry);
        this.d_hashC2i.put(constantPoolEntry, new Integer(n));
        return n;
    }

    private void resize() {
        ConstantPoolEntry[] constantPoolEntryArray = new ConstantPoolEntry[this.d_numConstants + 10];
        if (this.d_constants != null) {
            System.arraycopy(this.d_constants, 0, constantPoolEntryArray, 0, this.d_numConstants);
        }
        this.d_constants = constantPoolEntryArray;
    }

    private boolean readConstant(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = dataInputStream.readUnsignedByte();
        switch (n2) {
            case 7: {
                int n3 = dataInputStream.readUnsignedShort();
                this.d_constants[n] = new ClassEntry(n3);
                break;
            }
            case 8: {
                int n4 = dataInputStream.readUnsignedShort();
                this.d_constants[n] = new StringEntry(n4);
                break;
            }
            case 9: {
                int n5 = dataInputStream.readUnsignedShort();
                int n6 = dataInputStream.readUnsignedShort();
                this.d_constants[n] = new FieldrefEntry(n5, n6);
                break;
            }
            case 10: {
                int n7 = dataInputStream.readUnsignedShort();
                int n8 = dataInputStream.readUnsignedShort();
                this.d_constants[n] = new MethodrefEntry(n7, n8);
                break;
            }
            case 11: {
                int n9 = dataInputStream.readUnsignedShort();
                int n10 = dataInputStream.readUnsignedShort();
                this.d_constants[n] = new InterfaceMethodrefEntry(n9, n10);
                break;
            }
            case 3: {
                int n11 = dataInputStream.readInt();
                this.d_constants[n] = new IntegerEntry(n11);
                break;
            }
            case 4: {
                float f = dataInputStream.readFloat();
                this.d_constants[n] = new FloatEntry(f);
                break;
            }
            case 5: {
                long l = dataInputStream.readLong();
                this.d_constants[n] = new LongEntry(l);
                break;
            }
            case 6: {
                double d = dataInputStream.readDouble();
                this.d_constants[n] = new DoubleEntry(d);
                break;
            }
            case 12: {
                int n12 = dataInputStream.readUnsignedShort();
                int n13 = dataInputStream.readUnsignedShort();
                this.d_constants[n] = new NameAndTypeEntry(n12, n13);
                break;
            }
            case 1: {
                String string = dataInputStream.readUTF();
                this.d_constants[n] = new Utf8Entry(string);
                break;
            }
            default: {
                throw new IOException("Unknown class file constant tag <" + n2 + "> in constant pool");
            }
        }
        return n2 == 6 || n2 == 5;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numConstants);
        for (int i = 1; i < this.d_numConstants; ++i) {
            ConstantPoolEntry constantPoolEntry = this.d_constants[i];
            if (constantPoolEntry == null) continue;
            constantPoolEntry.write(dataOutputStream);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("CONSTANT POOL:\n");
        for (int i = 1; i < this.d_numConstants; ++i) {
            ConstantPoolEntry constantPoolEntry = this.d_constants[i];
            if (constantPoolEntry == null) continue;
            stringBuffer.append("  " + i + ": " + constantPoolEntry.toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public static final class IntegerEntry
    extends ConstantPoolEntry {
        private int d_integer;

        public String toString() {
            return "Integer: " + this.d_integer;
        }

        public void setValue(int n) {
            this.d_integer = n;
        }

        public int getValue() {
            return this.d_integer;
        }

        public String getAsString() {
            return String.valueOf(this.d_integer);
        }

        public String getAsJava() {
            return "#" + this.d_integer;
        }

        public boolean equals(Object object) {
            return object instanceof IntegerEntry && this.d_integer == ((IntegerEntry)object).getValue();
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeInt(this.d_integer);
        }

        IntegerEntry(int n) {
            this.d_integer = n;
        }
    }

    public static final class FloatEntry
    extends ConstantPoolEntry {
        private float d_float;

        public String toString() {
            return "Float: " + this.d_float;
        }

        public String getAsString() {
            return String.valueOf(this.d_float);
        }

        public void setValue(float f) {
            this.d_float = f;
        }

        public float getValue() {
            return this.d_float;
        }

        public String getAsJava() {
            return "F" + this.d_float;
        }

        public boolean equals(Object object) {
            return object instanceof FloatEntry && this.d_float == ((FloatEntry)object).getValue();
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeFloat(this.d_float);
        }

        FloatEntry(float f) {
            this.d_float = f;
        }
    }

    public static final class DoubleEntry
    extends ConstantPoolEntry {
        private double d_double;

        public String toString() {
            return "Double: " + this.d_double;
        }

        public String getAsString() {
            return String.valueOf(this.d_double);
        }

        public void setValue(double d) {
            this.d_double = d;
        }

        public double getValue() {
            return this.d_double;
        }

        public String getAsJava() {
            return "D" + this.d_double;
        }

        public boolean equals(Object object) {
            return object instanceof DoubleEntry && this.toString().equals(((DoubleEntry)object).toString());
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(6);
            dataOutputStream.writeDouble(this.d_double);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        DoubleEntry(double d) {
            this.d_double = d;
        }
    }

    public static final class LongEntry
    extends ConstantPoolEntry {
        private long d_long;

        public String toString() {
            return "Long: " + this.d_long;
        }

        public void setValue(long l) {
            this.d_long = l;
        }

        public long getValue() {
            return this.d_long;
        }

        public String getAsString() {
            return String.valueOf(this.d_long);
        }

        public String getAsJava() {
            return "L" + this.d_long;
        }

        public boolean equals(Object object) {
            return object instanceof LongEntry && this.d_long == ((LongEntry)object).getValue();
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(5);
            dataOutputStream.writeLong(this.d_long);
        }

        LongEntry(long l) {
            this.d_long = l;
        }
    }

    public static final class Utf8Entry
    extends ConstantPoolEntry {
        private String d_string;
        private String d_rewrite;

        public String toString() {
            return "Utf8: " + this.d_rewrite;
        }

        public void setValue(String string) {
            this.d_string = string;
            this.d_rewrite = this.rewrite(string);
        }

        public String getValue() {
            return this.d_string;
        }

        public String getAsString() {
            return this.d_rewrite;
        }

        public String getAsJava() {
            return "\"" + this.d_rewrite + "\"";
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeUTF(this.d_string);
        }

        public boolean equals(Object object) {
            return object instanceof Utf8Entry && this.d_rewrite.equals(((Utf8Entry)object).getAsString());
        }

        private String rewrite(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            block10: for (int i = 0; i < string.length(); ++i) {
                switch (string.charAt(i)) {
                    case '\b': {
                        stringBuffer.append('\\');
                        stringBuffer.append('b');
                        continue block10;
                    }
                    case '\t': {
                        stringBuffer.append('\\');
                        stringBuffer.append('t');
                        continue block10;
                    }
                    case '\n': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        continue block10;
                    }
                    case '\f': {
                        stringBuffer.append('\\');
                        stringBuffer.append('f');
                        continue block10;
                    }
                    case '\r': {
                        stringBuffer.append('\\');
                        stringBuffer.append('r');
                        continue block10;
                    }
                    case '\"': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\"');
                        continue block10;
                    }
                    case '\'': {
                        stringBuffer.append('\\');
                        stringBuffer.append('n');
                        continue block10;
                    }
                    case '\\': {
                        stringBuffer.append('\\');
                        stringBuffer.append('\\');
                        continue block10;
                    }
                    default: {
                        stringBuffer.append(string.charAt(i));
                    }
                }
            }
            return stringBuffer.toString();
        }

        Utf8Entry(String string) {
            this.d_string = string;
            this.d_rewrite = this.rewrite(string);
        }
    }

    public final class StringEntry
    extends ConstantPoolEntry {
        private int d_index;

        public int[] getIndices() {
            return new int[]{this.d_index};
        }

        void setIndices(int[] nArray) {
            this.d_index = nArray[0];
        }

        public String toString() {
            return "String: " + this.d_index + " (" + this.getAsJava() + ")";
        }

        public String getAsString() {
            return ConstantPool.this.get(this.d_index).getAsString();
        }

        public String getAsJava() {
            return ConstantPool.this.get(this.d_index).getAsJava();
        }

        public boolean equals(Object object) {
            if (!(object instanceof StringEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_index).equals(ConstantPool.this.get(nArray[0]));
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(8);
            dataOutputStream.writeShort(this.d_index);
        }

        StringEntry(int n) {
            this.d_index = n;
        }
    }

    public final class ClassEntry
    extends ConstantPoolEntry {
        private int d_index;

        public int[] getIndices() {
            return new int[]{this.d_index};
        }

        void setIndices(int[] nArray) {
            this.d_index = nArray[0];
        }

        public String toString() {
            return "Class: " + this.d_index + " (" + this.getAsJava() + ")";
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_index);
        }

        public String getAsJava() {
            String string = ConstantPool.this.getAsString(this.d_index);
            if (!string.startsWith("[")) {
                return CPUtils.slashes2dots(this.getAsString());
            }
            StringBuffer stringBuffer = new StringBuffer();
            CPUtils.descriptor2java(string, 0, stringBuffer);
            return stringBuffer.toString();
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(7);
            dataOutputStream.writeShort(this.d_index);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClassEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_index).equals(ConstantPool.this.get(nArray[0]));
        }

        ClassEntry(int n) {
            this.d_index = n;
        }
    }

    public final class NameAndTypeEntry
    extends ConstantPoolEntry {
        private int d_idxName;
        private int d_idxType;

        public int[] getIndices() {
            return new int[]{this.d_idxName, this.d_idxType};
        }

        void setIndices(int[] nArray) {
            this.d_idxName = nArray[0];
            this.d_idxType = nArray[1];
        }

        public String toString() {
            return "NameAndType: " + this.d_idxName + " " + this.d_idxType + " (" + this.getAsJava() + ")";
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxName) + " " + ConstantPool.this.getAsString(this.d_idxType);
        }

        public String getAsJava() {
            return this.getNameAsJava() + "." + this.getTypeAsJava();
        }

        String getNameAsJava() {
            return ConstantPool.this.getAsString(this.d_idxName);
        }

        String getTypeAsJava() {
            return CPUtils.internal2java(ConstantPool.this.getAsString(this.d_idxType));
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(12);
            dataOutputStream.writeShort(this.d_idxName);
            dataOutputStream.writeShort(this.d_idxType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof NameAndTypeEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxName).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxType).equals(ConstantPool.this.get(nArray[1]));
        }

        NameAndTypeEntry(int n, int n2) {
            this.d_idxName = n;
            this.d_idxType = n2;
        }
    }

    public final class FieldrefEntry
    extends ConstantPoolEntry {
        private int d_idxClass;
        private int d_idxNameAndType;

        public int[] getIndices() {
            return new int[]{this.d_idxClass, this.d_idxNameAndType};
        }

        void setIndices(int[] nArray) {
            this.d_idxClass = nArray[0];
            this.d_idxNameAndType = nArray[1];
        }

        public String toString() {
            return "Fieldref: " + this.d_idxClass + " " + this.d_idxNameAndType + " (" + this.getAsJava() + ")";
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxClass) + " " + ConstantPool.this.getAsString(this.d_idxNameAndType);
        }

        public String getAsJava() {
            NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)ConstantPool.this.get(this.d_idxNameAndType);
            String string = nameAndTypeEntry.getTypeAsJava();
            String string2 = nameAndTypeEntry.getNameAsJava();
            return string + " " + ConstantPool.this.getAsJava(this.d_idxClass) + "." + string2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FieldrefEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxClass).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxNameAndType).equals(ConstantPool.this.get(nArray[1]));
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(9);
            dataOutputStream.writeShort(this.d_idxClass);
            dataOutputStream.writeShort(this.d_idxNameAndType);
        }

        FieldrefEntry(int n, int n2) {
            this.d_idxClass = n;
            this.d_idxNameAndType = n2;
        }
    }

    public final class MethodrefEntry
    extends ConstantPoolEntry {
        private int d_idxClass;
        private int d_idxNameAndType;

        public int[] getIndices() {
            return new int[]{this.d_idxClass, this.d_idxNameAndType};
        }

        void setIndices(int[] nArray) {
            this.d_idxClass = nArray[0];
            this.d_idxNameAndType = nArray[1];
        }

        public String toString() {
            return "Methodref: " + this.d_idxClass + " " + this.d_idxNameAndType + " (" + this.getAsJava() + ")";
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxClass) + " " + ConstantPool.this.getAsString(this.d_idxNameAndType);
        }

        public String getAsJava() {
            String string;
            NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)ConstantPool.this.get(this.d_idxNameAndType);
            String string2 = nameAndTypeEntry.getTypeAsJava();
            int n = string2.indexOf(" ");
            String string3 = "";
            if (n == -1) {
                string = string2;
            } else {
                string3 = string2.substring(0, n);
                string = string2.substring(n + 1);
            }
            String string4 = nameAndTypeEntry.getNameAsJava();
            return string3 + " " + ConstantPool.this.getAsJava(this.d_idxClass) + "." + string4 + string;
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(10);
            dataOutputStream.writeShort(this.d_idxClass);
            dataOutputStream.writeShort(this.d_idxNameAndType);
        }

        public boolean equals(Object object) {
            if (!(object instanceof MethodrefEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxClass).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxNameAndType).equals(ConstantPool.this.get(nArray[1]));
        }

        MethodrefEntry(int n, int n2) {
            this.d_idxClass = n;
            this.d_idxNameAndType = n2;
        }
    }

    public final class InterfaceMethodrefEntry
    extends ConstantPoolEntry {
        private int d_idxClass;
        private int d_idxNameAndType;

        public int[] getIndices() {
            return new int[]{this.d_idxClass, this.d_idxNameAndType};
        }

        void setIndices(int[] nArray) {
            this.d_idxClass = nArray[0];
            this.d_idxNameAndType = nArray[1];
        }

        public String toString() {
            return "InterfaceMethodref: " + this.d_idxClass + " " + this.d_idxNameAndType + " (" + this.getAsJava() + ")";
        }

        public String getAsString() {
            return ConstantPool.this.getAsString(this.d_idxClass) + " " + ConstantPool.this.getAsString(this.d_idxNameAndType);
        }

        public String getAsJava() {
            String string;
            NameAndTypeEntry nameAndTypeEntry = (NameAndTypeEntry)ConstantPool.this.get(this.d_idxNameAndType);
            String string2 = nameAndTypeEntry.getTypeAsJava();
            int n = string2.indexOf(" ");
            String string3 = "";
            if (n == -1) {
                string = string2;
            } else {
                string3 = string2.substring(0, n);
                string = string2.substring(n + 1);
            }
            String string4 = nameAndTypeEntry.getNameAsJava();
            return string3 + " " + ConstantPool.this.getAsJava(this.d_idxClass) + "." + string4 + string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof InterfaceMethodrefEntry)) {
                return false;
            }
            ConstantPoolEntry constantPoolEntry = (ConstantPoolEntry)object;
            int[] nArray = constantPoolEntry.getIndices();
            return ConstantPool.this.get(this.d_idxClass).equals(ConstantPool.this.get(nArray[0])) && ConstantPool.this.get(this.d_idxNameAndType).equals(ConstantPool.this.get(nArray[1]));
        }

        void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeByte(11);
            dataOutputStream.writeShort(this.d_idxClass);
            dataOutputStream.writeShort(this.d_idxNameAndType);
        }

        InterfaceMethodrefEntry(int n, int n2) {
            this.d_idxClass = n;
            this.d_idxNameAndType = n2;
        }
    }
}

