/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASEvent;
import com.ibm.ras.RASIMessageEvent;
import com.ibm.ras.RASMessageFormatter;
import com.ibm.ras.RASUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class RASMessageEvent
extends RASEvent
implements RASIMessageEvent {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 2783570584026644572L;
    private String messageFile = null;

    public RASMessageEvent() {
        this.setMessageEvent(true);
    }

    protected RASMessageEvent(long type, String text, Object[] parms, String messageFile) {
        super(type, text, parms);
        this.setMessageFile(messageFile);
        this.setMessageEvent(true);
    }

    protected RASMessageEvent(long type, String text, String[] parms, String messageFile) {
        this(type, text, (Object[])parms, messageFile);
    }

    public RASMessageEvent(long type, String text, Object[] parms, String messageFile, String loggingClass, String loggingMethod, String org, String prod, String comp, String server, String client, Throwable exception) {
        this(type, text, parms, messageFile);
        if (loggingClass != null) {
            this.setAttribute("loggingClass", loggingClass);
        }
        if (loggingMethod != null) {
            this.setAttribute("loggingMethod", loggingMethod);
        }
        if (org != null) {
            this.setAttribute("organization", org);
        }
        if (prod != null) {
            this.setAttribute("product", prod);
        }
        if (comp != null) {
            this.setAttribute("component", comp);
        }
        if (server != null) {
            this.setAttribute("server", server);
        }
        if (client != null) {
            this.setAttribute("client", client);
        }
        if (exception != null) {
            this.setAttribute("exception", exception);
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            this.setAttribute("exceptionTrace", sw.toString());
        }
    }

    public RASMessageEvent(long type, String text, String[] parms, String messageFile, String loggingClass, String loggingMethod, String org, String prod, String comp, String server, String client, Throwable exception) {
        this(type, text, (Object[])parms, messageFile, loggingClass, loggingMethod, org, prod, comp, server, client, exception);
    }

    public String getMessageFile() {
        return this.messageFile;
    }

    public void setMessageFile(String messageFile) {
        this.messageFile = messageFile;
    }

    public Hashtable getSupportedTypes() {
        Hashtable ht = super.getSupportedTypes();
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_INFO"), new Long(1L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_WARN"), new Long(2L));
        ht.put(RASUtil.rasMsgs.getMessage("TYPE_ERR"), new Long(4L));
        return ht;
    }

    public long maskLongValue(String types2) {
        long result = super.maskLongValue(types2);
        StringTokenizer st = new StringTokenizer(types2);
        while (st.hasMoreElements()) {
            String type = st.nextToken();
            if (type.equals("TYPE_INFO") || type.equals("TYPE_INFORMATION")) {
                result |= 1L;
                continue;
            }
            if (type.equals("TYPE_WARN") || type.equals("TYPE_WARNING")) {
                result |= 2L;
                continue;
            }
            if (type.equals("TYPE_ERR") || type.equals("TYPE_ERROR")) {
                result |= 4L;
                continue;
            }
            if (type.equals("DEFAULT_MESSAGE_MASK")) {
                result |= 7L;
                continue;
            }
            if (!type.equals("ALL_MESSAGE_MASK")) continue;
            result |= 0xFFFFFFFFFFFFFFFFL;
        }
        return result;
    }

    public String maskToString(long types2) {
        StringBuffer bfr = new StringBuffer(super.maskToString(types2));
        if ((types2 & 1L) != 0L) {
            bfr.append("TYPE_INFO ");
        }
        if ((types2 & 2L) != 0L) {
            bfr.append("TYPE_WARN ");
        }
        if ((types2 & 4L) != 0L) {
            bfr.append("TYPE_ERR ");
        }
        return bfr.toString().trim();
    }

    public String toString() {
        RASMessageFormatter f = new RASMessageFormatter();
        return f.format(this);
    }
}

