/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ffdc.util.formatting;

import com.ibm.ffdc.config.Formatter;
import com.ibm.ffdc.config.IncidentStream;
import com.ibm.ffdc.util.Klass;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Array;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFormatter
implements Formatter {
    @Override
    public final void formatTo(final Object o, IncidentStream is) {
        Class<?> cl = o.getClass();
        Class<?> componentType = cl.getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException();
        }
        if (Klass.isPrimitive(componentType)) {
            IncidentStream.Writer<OutputStream> writer = new IncidentStream.Writer<OutputStream>(){

                @Override
                public void writeTo(OutputStream os2) throws IOException {
                    PrintWriter pw = new PrintWriter(os2);
                    ArrayFormatter.this.formatTo(pw, o);
                    pw.flush();
                    os2.flush();
                }
            };
            is.write(writer);
            return;
        }
        this.formatTo(is, o);
    }

    private void formatTo(PrintWriter pw, Object objectToFormat) {
        int alength = Array.getLength(objectToFormat);
        pw.print('[');
        for (int i = 0; i < alength; ++i) {
            Object o = Array.get(objectToFormat, i);
            pw.print(o);
            pw.print(alength - i == 1 ? (char)']' : ' ');
        }
        pw.println();
    }

    private void formatTo(IncidentStream is, Object objectToFormat) {
        int alength = Array.getLength(objectToFormat);
        is.write(null, Character.valueOf('['));
        for (int i = 0; i < alength; ++i) {
            Object o = Array.get(objectToFormat, i);
            is.write(null, o);
        }
        is.write(null, Character.valueOf(']'));
    }

    @Override
    public String[] getSupportedTypeNames() {
        return new String[]{"[.*"};
    }

    @Override
    public boolean isSupported(Class<?> klass) {
        return klass.isArray();
    }
}

