/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EJBComponent;
import com.ibm.etools.commonarchive.ModuleComponent;
import com.ibm.etools.commonarchive.ModuleRef;
import com.ibm.etools.commonarchive.ServletComponent;
import com.ibm.etools.commonarchive.impl.EJBModuleRefImpl;
import com.ibm.etools.commonarchive.impl.WARFileImpl;
import com.ibm.etools.commonarchive.impl.WebModuleRefImpl;
import com.ibm.etools.commonarchive.nls.CommonArchiveWASResourceHandler;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveRuntimeException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletType;

public class ModuleRefHelper {
    public static final String EXCEPTION_OCCCURRED = CommonArchiveWASResourceHandler.getString("Exception_occurred_adding__EXC_");

    public void addCopyRequiredFiles(EJBModuleRefImpl ejbModuleRef, ModuleComponent aComponent) {
        String className;
        if (aComponent.getModuleFile() == null) {
            return;
        }
        EnterpriseBean ejb = ((EJBComponent)aComponent).getDeploymentDescriptor();
        ArrayList<String> classNames = new ArrayList<String>(4);
        classNames.add(ejb.getHomeInterfaceName());
        classNames.add(ejb.getRemoteInterfaceName());
        classNames.add(ejb.getEjbClassName());
        if (ejb.isEntity() && (className = ((Entity)ejb).getPrimaryKeyName()) != null && !className.startsWith("java")) {
            classNames.add(className);
        }
        for (int i = 0; i < classNames.size(); ++i) {
            String className2 = (String)classNames.get(i);
            if (className2 == null) continue;
            String classUri = ArchiveUtil.classNameToUri(className2);
            try {
                ejbModuleRef.getModuleFile().addCopy(aComponent.getModuleFile().getFile(classUri));
                continue;
            }
            catch (FileNotFoundException iox) {
                continue;
            }
            catch (DuplicateObjectException dox) {
                // empty catch block
            }
        }
    }

    public void addCopyRequiredFiles(WebModuleRefImpl webModuleRef, ModuleComponent aComponent) {
    }

    public void basicAdd(EJBModuleRefImpl ejbModuleRef, ModuleComponent aComponent) {
        EJBComponent ejbComp = (EJBComponent)aComponent;
        try {
            ejbModuleRef.getEJBJar().getEnterpriseBeans().add(ejbComp.getDeploymentDescriptor());
            ejbModuleRef.getEJBJarBinding().getEjbBindings().add(ejbComp.getBindings());
            ejbModuleRef.getEJBJarExtension().getEjbExtensions().add(ejbComp.getExtensions());
            ejbModuleRef.getComponents().add(aComponent);
        }
        catch (Exception ex) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, ex);
        }
    }

    public void basicAdd(WebModuleRefImpl webModuleRef, ModuleComponent aComponent) {
        ServletComponent servletComp = (ServletComponent)aComponent;
        try {
            webModuleRef.getWebApp().getServlets().add(servletComp.getDeploymentDescriptor());
            webModuleRef.getWebAppExtension().getExtendedServlets().add(servletComp.getExtensions());
            webModuleRef.getComponents().add(aComponent);
        }
        catch (ArchiveWrappedException ex) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, ex);
        }
    }

    public void buildComponentList(EJBModuleRefImpl ejbModuleRef, EList list) {
        try {
            EList ejbs = ejbModuleRef.getEJBJar().getEnterpriseBeans();
            for (int i = 0; i < ejbs.size(); ++i) {
                EnterpriseBean ejb = (EnterpriseBean)ejbs.get(i);
                EJBComponent component2 = this.getCommonArchiveFactory().createEJBComponent();
                component2.setDeploymentDescriptor(ejb);
                list.add(component2);
            }
        }
        catch (ArchiveWrappedException ex) {
            throw new ArchiveRuntimeException(CommonArchiveWASResourceHandler.getString("list_components_ejb_EXC_", new Object[]{ejbModuleRef.getModuleFile().getURI()}), ex);
        }
    }

    public void buildComponentList(WebModuleRefImpl webModuleRef, EList list) {
        try {
            EList servlets = webModuleRef.getWebApp().getServlets();
            for (int i = 0; i < servlets.size(); ++i) {
                Servlet servlet = (Servlet)servlets.get(i);
                ServletComponent component2 = this.getCommonArchiveFactory().createServletComponent();
                component2.setDeploymentDescriptor(servlet);
                list.add(component2);
            }
        }
        catch (ArchiveWrappedException ex) {
            throw new ArchiveRuntimeException(CommonArchiveWASResourceHandler.getString("list_components_war_EXC_", new Object[]{webModuleRef.getModuleFile().getURI()}), ex);
        }
    }

    protected CommonarchiveFactory getCommonArchiveFactory() {
        return CommonarchiveFactory.eINSTANCE;
    }

    public void remove(EJBModuleRefImpl ejbModuleRef, ModuleComponent aComponent) {
        EJBComponent ejbComp = (EJBComponent)aComponent;
        try {
            ejbModuleRef.getEJBJar().getEnterpriseBeans().remove(ejbComp.getDeploymentDescriptor());
            ejbModuleRef.getEJBJarBinding().getEjbBindings().remove(ejbComp.getBindings());
            ejbModuleRef.getEJBJarExtension().getEjbExtensions().remove(ejbComp.getExtensions());
            ejbModuleRef.getComponents().remove(aComponent);
        }
        catch (ArchiveWrappedException ex) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, ex);
        }
    }

    public void remove(WebModuleRefImpl webModuleRef, ModuleComponent aComponent) {
        ServletComponent servletComp = (ServletComponent)aComponent;
        try {
            webModuleRef.getWebApp().getServlets().remove(servletComp.getDeploymentDescriptor());
            webModuleRef.getWebAppExtension().getExtendedServlets().remove(servletComp.getExtensions());
            webModuleRef.getComponents().remove(aComponent);
        }
        catch (ArchiveWrappedException ex) {
            throw new ArchiveRuntimeException(EXCEPTION_OCCCURRED, ex);
        }
    }

    public void addCopyRequiredFiles(WARFileImpl warFile, ModuleComponent aComponent) {
        if (aComponent.getModuleFile() == null) {
            return;
        }
        Servlet aServlet = ((ServletComponent)aComponent).getDeploymentDescriptor();
        if (aServlet == null || aServlet.getWebType() == null) {
            return;
        }
        String uri = null;
        if (aServlet.getWebType().isJspType()) {
            uri = ((JSPType)aServlet.getWebType()).getJspFile();
            if (uri == null) {
                return;
            }
        } else {
            String className = ((ServletType)aServlet.getWebType()).getClassName();
            if (className == null) {
                return;
            }
            uri = ArchiveUtil.concatUri("WEB-INF/classes/", ArchiveUtil.classNameToUri(className), '/');
        }
        try {
            warFile.addCopy(aComponent.getModuleFile().getFile(uri));
        }
        catch (FileNotFoundException iox) {
        }
        catch (DuplicateObjectException dox) {
            // empty catch block
        }
    }

    public ModuleComponent addCopy(EJBModuleRefImpl ejbModuleRef, ModuleComponent aComponent) throws DuplicateObjectException {
        ModuleComponent comp = ejbModuleRef.getComponent(aComponent.getComponentName());
        if (comp != null) {
            throw new DuplicateObjectException(aComponent.getComponentName(), comp);
        }
        ModuleComponent copy = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory().copy(aComponent);
        this.basicAdd(ejbModuleRef, copy);
        this.addCopyRequiredFiles(ejbModuleRef, aComponent);
        return copy;
    }

    public ModuleComponent addCopy(WebModuleRefImpl webModuleRef, ModuleComponent aComponent) throws DuplicateObjectException {
        ModuleComponent comp = webModuleRef.getComponent(aComponent.getComponentName());
        if (comp != null) {
            throw new DuplicateObjectException(aComponent.getComponentName(), comp);
        }
        ModuleComponent copy = CommonarchivePackage.eINSTANCE.getCommonarchiveFactory().copy(aComponent);
        this.basicAdd(webModuleRef, copy);
        this.addCopyRequiredFiles(webModuleRef, aComponent);
        return copy;
    }

    public boolean containsComponent(ModuleRef moduleRef, String name) {
        if (name == null) {
            return false;
        }
        EList comps = moduleRef.getComponents();
        for (int i = 0; i < comps.size(); ++i) {
            ModuleComponent component2 = (ModuleComponent)comps.get(i);
            if (!name.equals(component2.getComponentName())) continue;
            return true;
        }
        return false;
    }

    public ModuleComponent getComponent(ModuleRef moduleRef, String name) {
        if (name == null) {
            return null;
        }
        EList comps = moduleRef.getComponents();
        for (int i = 0; i < comps.size(); ++i) {
            ModuleComponent component2 = (ModuleComponent)comps.get(i);
            if (!name.equals(component2.getComponentName())) continue;
            return component2;
        }
        return null;
    }

    public EList getComponents(EJBModuleRefImpl ejbModuleRef, EList list) {
        if (list.isEmpty()) {
            this.buildComponentList(ejbModuleRef, list);
        }
        return list;
    }

    public EList getComponents(WebModuleRefImpl webModuleRef, EList list) {
        if (list.isEmpty()) {
            this.buildComponentList(webModuleRef, list);
        }
        return list;
    }
}

