/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.commonarchive.util;

import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import com.ibm.etools.commonarchive.EARFile;

public class ArchiveUtil
extends org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil {
    public static String getDefaultAltBindingsUri(ModuleExtension ext, EARFile ear) {
        String root = ArchiveUtil.getOrCreateAltRoot(ext, ear);
        String shortName = ext.getDefaultBindingsShortName();
        if (shortName == null) {
            return null;
        }
        return ArchiveUtil.concatUri(root, shortName, '/');
    }

    public static String getOrCreateAltRoot(ModuleExtension ext, EARFile ear) {
        if (!ArchiveUtil.isNullOrEmpty(ext.getAltRoot())) {
            return ext.getAltRoot();
        }
        String root = null;
        int index = 0;
        do {
            root = ArchiveUtil.concatUri("ALT-INF", ext.getModule().getUri(), '/');
            if (index > 0) {
                root = root + index;
            }
            ++index;
        } while (ArchiveUtil.altRootCollides(root, ext, ear));
        ext.setAltRoot(root);
        return root;
    }

    protected static boolean altRootCollides(String root, ModuleExtension ext, EARFile ear) {
        String altBindings = ext.getAltBindings();
        String altExtensions = ext.getAltExtensions();
        String altDD = ext.getModule().getAltDD();
        if (ArchiveUtil.isNullOrEmpty(altBindings) && ArchiveUtil.isNullOrEmpty(altExtensions) && ArchiveUtil.isNullOrEmpty(altDD)) {
            altBindings = ArchiveUtil.concatUri(root, ext.getDefaultBindingsShortName(), '/');
            altExtensions = ArchiveUtil.concatUri(root, ext.getDefaultExtensionsShortName(), '/');
            altDD = ArchiveUtil.concatUri(root, ext.getDeploymentDescriptorShortName(), '/');
            return ear.isDuplicate(altBindings) || ear.isDuplicate(altExtensions) || ear.isDuplicate(altDD);
        }
        return !ArchiveUtil.isNullOrEmpty(altBindings) && altBindings.startsWith(root) || !ArchiveUtil.isNullOrEmpty(altExtensions) && altExtensions.startsWith(root) || !ArchiveUtil.isNullOrEmpty(altDD) && altDD.startsWith(root);
    }

    public static String getDefaultAltDDUri(ModuleExtension ext, EARFile ear) {
        String root = ArchiveUtil.getOrCreateAltRoot(ext, ear);
        return ArchiveUtil.concatUri(root, ext.getDeploymentDescriptorShortName(), '/');
    }

    public static String getDefaultAltExtensionsUri(ModuleExtension ext, EARFile ear) {
        String root = ArchiveUtil.getOrCreateAltRoot(ext, ear);
        String shortName = ext.getDefaultExtensionsShortName();
        if (shortName == null) {
            return null;
        }
        return ArchiveUtil.concatUri(root, shortName, '/');
    }
}

