/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.tran;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.tran.TxSync;
import com.ibm.ws.LocalTransaction.ContainerSynchronization;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.ArrayList;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public class SyncDriver
implements Synchronization,
ContainerSynchronization {
    private static final TraceComponent tc = Tr.register(SyncDriver.class, "EJBContainer", "com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.tran.SyncDriver";
    private ArrayList txSyncParticipants;
    private ArrayList synchronizationParticipants;
    private Object coord;

    SyncDriver(UOWCoordinator uowCoord) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.coord = uowCoord;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(UOWCoordinator uowCoord, TxSync ts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> UOWCoordinator, TxSync");
        }
        this.coord = uowCoord;
        this.txSyncParticipants = new ArrayList(10);
        this.txSyncParticipants.add(ts);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(Transaction globalTxCoord) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.coord = globalTxCoord;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(Transaction globalTxCoord, TxSync ts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> Transaction, TxSync");
        }
        this.coord = globalTxCoord;
        this.txSyncParticipants = new ArrayList(10);
        this.txSyncParticipants.add(ts);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(LocalTransactionCoordinator localTxCoord) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.coord = localTxCoord;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    SyncDriver(LocalTransactionCoordinator localTxCoord, TxSync ts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init> LocalTransactionCoordinator, TxSync ");
        }
        this.coord = localTxCoord;
        this.txSyncParticipants = new ArrayList(10);
        this.txSyncParticipants.add(ts);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(TxSync ts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addParticipant (" + ts + ")");
        }
        if (this.txSyncParticipants == null) {
            this.txSyncParticipants = new ArrayList(10);
        }
        ArrayList arrayList = this.txSyncParticipants;
        synchronized (arrayList) {
            this.txSyncParticipants.add(ts);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addParticipant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipant(Synchronization s) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addParticipant (" + s + ")");
        }
        if (this.synchronizationParticipants == null) {
            this.synchronizationParticipants = new ArrayList(10);
        }
        ArrayList arrayList = this.synchronizationParticipants;
        synchronized (arrayList) {
            this.synchronizationParticipants.add(s);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addParticipant");
        }
    }

    public void beforeCompletion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
        }
        try {
            int i;
            if (this.synchronizationParticipants != null) {
                int synchronizationParticipantsSize = this.synchronizationParticipants.size();
                for (i = 0; i < synchronizationParticipantsSize; ++i) {
                    ((Synchronization)this.synchronizationParticipants.get(i)).beforeCompletion();
                }
            }
            if (this.txSyncParticipants != null) {
                int txSyncParticipantsSize = this.txSyncParticipants.size();
                for (i = 0; i < txSyncParticipantsSize; ++i) {
                    ((TxSync)this.txSyncParticipants.get(i)).beforeCompletion();
                }
                for (i = 0; i < txSyncParticipantsSize; ++i) {
                    ((TxSync)this.txSyncParticipants.get(i)).beforeCompletionFinally();
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ejs.util.tran.SyncDriver.beforeCompletion", "155", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event(tc, "beforeCompletion failed: ", ex);
            }
            LocalTransactionCoordinator lCoord = TransactionManagerFactory.getLocalTransactionCurrent().getLocalTranCoord();
            RuntimeException newex = new RuntimeException(ex);
            try {
                if (lCoord != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Marking local tx for rollback");
                    }
                    lCoord.setRollbackOnly();
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event(tc, "Marking global tx for rollback");
                    }
                    Transaction globalTxCoord = (Transaction)this.coord;
                    globalTxCoord.setRollbackOnly();
                }
            }
            catch (Exception exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ejs.util.tran.SyncDriver.beforeCompletion", "176", this);
                Tr.warning(tc, "CAUGHT_EXCEPTION_THROWING_NEW_EXCEPTION_CNTR0035E", new Object[]{exc, newex.toString()});
            }
            throw newex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    public void afterCompletion(int status) {
        int i;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion (" + this.print(status) + ")");
        }
        boolean committed = false;
        if (status == 3) {
            committed = true;
        }
        if (this.synchronizationParticipants != null) {
            int sychronizationParticipantsSize = this.synchronizationParticipants.size();
            for (i = 0; i < sychronizationParticipantsSize; ++i) {
                try {
                    ((Synchronization)this.synchronizationParticipants.get(i)).afterCompletion(status);
                    continue;
                }
                catch (Throwable ex) {
                    FFDCFilter.processException(ex, "com.ibm.ejs.util.tran.SyncDriver.afterCompletion", "208", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event(tc, "afterCompletion failed", new Object[]{tc, ex});
                }
            }
        }
        if (this.txSyncParticipants != null) {
            int txSyncParticipantsSize = this.txSyncParticipants.size();
            for (i = 0; i < txSyncParticipantsSize; ++i) {
                try {
                    ((TxSync)this.txSyncParticipants.get(i)).afterCompletion(committed, this.coord);
                    continue;
                }
                catch (Throwable ex) {
                    FFDCFilter.processException(ex, "com.ibm.ejs.util.tran.SyncDriver.afterCompletion", "219", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    Tr.event(tc, "afterCompletion failed", new Object[]{tc, ex});
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public void setCompleting(boolean isCompleting) {
        int i;
        if (this.synchronizationParticipants != null) {
            int sychronizationParticipantsSize = this.synchronizationParticipants.size();
            for (i = 0; i < sychronizationParticipantsSize; ++i) {
                if (!(this.synchronizationParticipants.get(i) instanceof ContainerSynchronization)) continue;
                ((ContainerSynchronization)this.synchronizationParticipants.get(i)).setCompleting(isCompleting);
            }
        }
        if (this.txSyncParticipants != null) {
            int txSyncParticipantsSize = this.txSyncParticipants.size();
            for (i = 0; i < txSyncParticipantsSize; ++i) {
                if (!(this.txSyncParticipants.get(i) instanceof ContainerSynchronization)) continue;
                ((ContainerSynchronization)this.txSyncParticipants.get(i)).setCompleting(isCompleting);
            }
        }
    }

    private String print(int Status2) {
        if (Status2 == 5) {
            return "StatusUnknown";
        }
        if (Status2 == 1) {
            return "StatusMarkedRollback";
        }
        if (Status2 == 0) {
            return "StatusActive";
        }
        if (Status2 == 2) {
            return "StatusPrepared";
        }
        if (Status2 == 6) {
            return "StatusNoTransaction";
        }
        if (Status2 == 7) {
            return "StatusPreparing";
        }
        if (Status2 == 8) {
            return "StatusCommitting";
        }
        if (Status2 == 3) {
            return "StatusCommitted";
        }
        if (Status2 == 9) {
            return "StatusRollingBack";
        }
        if (Status2 == 4) {
            return "StatusRolledBack";
        }
        return "ERROR! UNKNOWN STATUS";
    }
}

