/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.deployment.utilities;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;

public class JarEntry {
    private static String copyright = "Licensed Material - Property of IBMIBM(R) VisualAge(R) for Java(TM), Version 2.0 - Professional/Enterprise Update(C) Copyright IBM Corp. 1998 - All Rights Reserved.US Government Users Restricted Rights - Use, duplication or disclosurerestricted by GSA ADP Schedule Contract with IBM Corp.";
    private ZipEntry zipentry = null;
    private String fileName = null;
    private String manifestHeader = null;
    private byte[] byteArray = null;

    public JarEntry(String en, String fn) {
        this.zipentry = new ZipEntry(en);
        this.fileName = fn;
    }

    public JarEntry(String en, String fn, byte[] b) {
        this.zipentry = new ZipEntry(en);
        this.fileName = fn;
        this.byteArray = b;
    }

    public byte[] getByteArray() throws IOException {
        if (this.byteArray == null) {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(this.getFileName()));
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            int bytesRead = inStream.read();
            while (bytesRead != -1) {
                byteStream.write(bytesRead);
                bytesRead = inStream.read();
            }
            if (byteStream != null) {
                this.byteArray = byteStream.toByteArray();
                byteStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
        return this.byteArray;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getManifestHeader() {
        return this.manifestHeader;
    }

    public ZipEntry getZipEntry() {
        return this.zipentry;
    }

    public void setManifestHeader(String tag) {
        this.manifestHeader = tag;
    }
}

