/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.sm.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.ejb.EJBObject;

public class Utils {
    private static final String rootContextPrefix = "ejsadmin/";
    private static final int UUID_LENGTH = 16;
    private static TraceComponent tc = Tr.register(Utils.class);

    public static String getIdString(EJBObject obj) throws RemoteException {
        return Long.toString((Long)obj.getPrimaryKey());
    }

    public static String getIdString(Long id) {
        return Long.toString(id);
    }

    public static Long getId(String stringVal) {
        return new Long(Long.parseLong(stringVal));
    }

    public static final String relativeName(String className) {
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(index + 1, className.length());
        }
        return className;
    }

    public static final String packageName(String className) {
        int index = className.lastIndexOf(46);
        if (index != -1) {
            return className.substring(0, index);
        }
        return null;
    }

    public static Properties byteArrayToProperties(byte[] val) throws RemoteException {
        try {
            Properties result = new Properties();
            ByteArrayInputStream bi = new ByteArrayInputStream(val);
            result.load(bi);
            return result;
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ejs.sm.util.Utils.byteArrayToProperties", "70");
            throw new RemoteException("", e);
        }
    }

    public static byte[] propertiesToByteArray(Properties val) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        val.save(bo, "");
        return bo.toByteArray();
    }

    public static byte[] serializeObject(Object obj) throws RemoteException {
        if (obj == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            oo.flush();
            return bo.toByteArray();
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ejs.sm.util.Utils.serializeObject", "93");
            throw new RemoteException("", e);
        }
    }

    public static Object deserializeObject(byte[] val) throws RemoteException {
        if (val == null) {
            return null;
        }
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(val);
            ObjectInputStream oi = new ObjectInputStream(bi);
            return oi.readObject();
        }
        catch (IOException i) {
            FFDCFilter.processException(i, "com.ibm.ejs.sm.util.Utils.deserializeObject", "107");
            throw new RemoteException("", i);
        }
        catch (ClassNotFoundException c) {
            FFDCFilter.processException(c, "com.ibm.ejs.sm.util.Utils.deserializeObject", "110");
            throw new RemoteException("", c);
        }
    }

    public static boolean intToBoolean(int val) {
        return val > 0;
    }

    public static int booleanToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    public static int enumLength(Enumeration vEnum) {
        int length = 0;
        while (vEnum.hasMoreElements()) {
            ++length;
            Object e = vEnum.nextElement();
        }
        return length;
    }

    public static String getLocalHostName() throws RemoteException {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws RemoteException {
                    return Utils.getLocalHostIPAddress().getHostName();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException(pae, "com.ibm.ejs.sm.util.Utils.getLocalHostName", "146");
            throw (RemoteException)pae.getException();
        }
    }

    public static InetAddress getLocalHostIPAddress() throws RemoteException {
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            FFDCFilter.processException(pae, "com.ibm.ejs.sm.util.Utils.getLocalHostIPAddress", "163");
            UnknownHostException e = (UnknownHostException)pae.getException();
            throw new RemoteException("", e);
        }
    }

    public static String getUuid(long id) {
        String uuid = Long.toHexString(id);
        if (uuid.length() < 16) {
            for (int i = 16 - uuid.length(); i > 0; --i) {
                uuid = uuid + "0";
            }
        }
        return uuid;
    }

    public static void main(String[] args) {
        System.out.println(new String(Utils.getUuid(1L)));
    }

    public static String replaceString(String oriStr, String oldStr, String newStr) {
        StringBuffer strBuf = null;
        int oldStrLength = oldStr.length();
        int i = 0;
        while ((i = oriStr.indexOf(oldStr)) > -1) {
            strBuf = new StringBuffer().append(oriStr.substring(0, i));
            strBuf.append(newStr);
            strBuf.append(oriStr.substring(i + oldStrLength));
            oriStr = strBuf.toString();
        }
        return oriStr;
    }

    public static String getRootContextPrefix() {
        return rootContextPrefix;
    }

    public static String qualifyRepositoryHomeName(String nodeName, String homeName) {
        return "ejsadmin/homes/" + homeName;
    }

    public static String unqualifyRepositoryHomeName(String nodeName, String homeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unqualifyRepositoryHomeName", new Object[]{nodeName, homeName});
        }
        String unqualifiedHomeName = homeName;
        String prefix = "ejsadmin/homes/";
        if (!homeName.startsWith(prefix)) {
            Tr.event(tc, "home prefix was not qualified: cannot unqualify", homeName);
        } else {
            unqualifiedHomeName = homeName.substring(prefix.length());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unqualifyRepositoryHomeName", unqualifiedHomeName);
        }
        return unqualifiedHomeName;
    }

    public static String defaultNodeName(String hostName, boolean qualifyHomeNameEnabled) throws UnknownHostException, RemoteException {
        String os2;
        InetAddress myIpAddress;
        InetAddress ipAddress = null;
        boolean ipAddressAsName = false;
        boolean localHost = false;
        String name = null;
        if (hostName == null || hostName.equals("") || hostName.equalsIgnoreCase("localhost")) {
            localHost = true;
            ipAddress = Utils.getLocalHostIPAddress();
            myIpAddress = ipAddress;
            hostName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return myIpAddress.getHostName();
                }
            });
            if (hostName == null) {
                hostName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return myIpAddress.getHostAddress();
                    }
                });
                ipAddressAsName = true;
                Tr.event(tc, "IP address is used as node name", hostName);
            }
        }
        name = hostName;
        if (!localHost) {
            try {
                final String myName = name;
                ipAddress = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        return InetAddress.getByName(myName);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                FFDCFilter.processException(pae, "com.ibm.ejs.sm.util.Utils.defaultNodeName", "303");
                UnknownHostException ex = (UnknownHostException)pae.getException();
                Tr.event(tc, "DNS lookup for hostName failed. ", ex);
                throw ex;
            }
            if (name.equals(ipAddress.getHostAddress()) && (name = (String)AccessController.doPrivileged(new PrivilegedAction(myIpAddress = ipAddress){
                final /* synthetic */ InetAddress val$myIpAddress;
                {
                    this.val$myIpAddress = inetAddress;
                }

                public Object run() {
                    return this.val$myIpAddress.getHostName();
                }
            })) == null) {
                name = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return myIpAddress.getHostAddress();
                    }
                });
                ipAddressAsName = true;
                Tr.event(tc, "IP address is used as node name", name);
            }
        }
        if (qualifyHomeNameEnabled && !ipAddressAsName) {
            StringTokenizer hostNameTokens = new StringTokenizer(name, ".");
            name = hostNameTokens.nextToken();
        }
        if ((os2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name").toLowerCase();
            }
        })).indexOf("netware") != -1) {
            return name.toLowerCase();
        }
        return name;
    }
}

