/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.RasMessage;
import java.util.Locale;

public class RasMessageImpl
implements RasMessage {
    private static final long serialVersionUID = 1129327429831172616L;
    private long ivTimeStamp;
    private String ivThreadId;
    private String ivMessageSeverity;
    private String ivMessageKey;
    private String[] ivMessageParms;
    private String ivResourceBundleName;
    private String ivMessageOriginator;
    private String ivLocalizedMessage;
    private String ivLocalizedMessageLocale;

    public RasMessageImpl(long timeStamp, String threadId, String messageSeverity, String messageKey, Object[] messageParms, String resourceBundleName, String messageOriginator, String localizedMessage, String localizedMessageLocale) {
        this.ivTimeStamp = timeStamp;
        this.ivThreadId = threadId;
        this.ivMessageSeverity = messageSeverity;
        if (messageParms != null) {
            this.ivMessageParms = new String[messageParms.length];
            for (int i = 0; i < messageParms.length; ++i) {
                if (messageParms[i] == null) continue;
                this.ivMessageParms[i] = messageParms[i].toString();
            }
        } else {
            this.ivMessageParms = new String[0];
        }
        this.ivMessageKey = messageKey;
        this.ivResourceBundleName = resourceBundleName;
        this.ivMessageOriginator = messageOriginator;
        this.ivLocalizedMessage = localizedMessage;
        this.ivLocalizedMessageLocale = localizedMessageLocale;
    }

    public RasMessageImpl(MessageEvent event2) {
        this(event2.getTimeStamp(), event2.getThreadId(), event2.getMessageSeverity(), event2.getMessageKey(), event2.getMessageInserts(), event2.getResourceBundleName(), event2.getMessageOriginator(), null, null);
    }

    public RasMessageImpl() {
    }

    public long getTimeStamp() {
        return this.ivTimeStamp;
    }

    public String getThreadId() {
        return this.ivThreadId;
    }

    public String getMessageSeverity() {
        return this.ivMessageSeverity;
    }

    public String getMessageKey() {
        return this.ivMessageKey;
    }

    public String getResourceBundleName() {
        return this.ivResourceBundleName;
    }

    public String getMessageOriginator() {
        return this.ivMessageOriginator;
    }

    public String getLocalizedMessage(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (locale != null && this.ivLocalizedMessage != null && locale.toString().equals(this.ivLocalizedMessageLocale)) {
            return this.ivLocalizedMessage;
        }
        if (this.ivResourceBundleName == null) {
            return this.ivMessageKey;
        }
        String key = this.ivMessageKey.replace(' ', '.');
        if (this.ivMessageParms == null) {
            return TraceNLS.getStringFromBundle(this.ivResourceBundleName, key, locale, this.ivMessageKey);
        }
        return TraceNLS.getFormattedMessage(this.ivResourceBundleName, key, locale, this.ivMessageParms, this.ivMessageKey);
    }
}

