/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHeader;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceException;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.bootstrap.WsLogManager;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.WriteAbortedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.server.ServerCloneException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.ejb.EJBException;
import javax.jms.JMSException;
import javax.mail.MessagingException;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import org.omg.CORBA.portable.UnknownException;
import org.xml.sax.SAXException;

public class RasHelper {
    private static TimeZone sysTimeZone = TimeZone.getDefault();
    private static final int MAX_BYTES = 4096;
    private static final int COLUMN_BYTES = 4;
    private static final int COLUMN_TOTAL = 8;
    private static final int COLUMN_INDENT = 4;
    private static String svProcessId = "";
    private static String svVersion = "";
    private static String svVerboseVersion = "";
    private static String svServerName = "";
    private static boolean svServer = false;
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String svFileNameSuffix = null;

    public static String getProcessId() {
        return svProcessId;
    }

    public static String getVersionId() {
        return svVersion;
    }

    public static String getVerboseVersion() {
        return svVerboseVersion;
    }

    public static boolean isServer() {
        return svServer;
    }

    public static void setServer() {
        svServer = true;
        LogManager o = LogManager.getLogManager();
        if (o instanceof WsLogManager) {
            ((WsLogManager)o).disableReset();
        }
        if (!WSLauncher.isZOS()) {
            Tr.createServerStartupListener();
        }
    }

    public static String getServerName() {
        return svServerName;
    }

    public static void setServerAttributes(String serverName, String processId, String version, String verboseVersion) {
        if (serverName != null) {
            svServerName = serverName;
        }
        if (processId != null) {
            svProcessId = processId;
        }
        if (version != null) {
            svVersion = version;
        }
        if (verboseVersion != null) {
            svVerboseVersion = verboseVersion;
        }
    }

    public static void setServerAttributes(String serverName, String processId, String version) {
        RasHelper.setServerAttributes(serverName, processId, version, null);
    }

    public static void setFileNameSuffix(String fileNameSuffix) {
        svFileNameSuffix = fileNameSuffix;
    }

    private static final String escape(String src) {
        if (src == null) {
            return "";
        }
        StringBuffer result = null;
        int max = src.length();
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = src.charAt(i);
            if ((Character.isWhitespace(c) || !Character.isISOControl(c)) && Character.getType(c) != 0) continue;
            String hexVal = Integer.toHexString(c);
            String replacement = "\\u" + ("0000" + hexVal).substring(hexVal.length());
            if (result == null) {
                result = new StringBuffer(src);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return src;
        }
        return result.toString();
    }

    public static final String throwableToString(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        RasHelper.printStackTrace(t, p);
        return RasHelper.escape(s.toString());
    }

    private static final void printStackTrace(Throwable t, PrintWriter p) {
        if (t == null) {
            p.println("none");
            return;
        }
        t.printStackTrace(p);
        if (t instanceof TraceException) {
            TraceException te = (TraceException)((Object)t);
            Throwable[] subexs = te.getSubexceptions();
            if (subexs == null) {
                return;
            }
            for (int i = 0; i < subexs.length; ++i) {
                p.println("----- Begin backtrace for subexception[" + i + "]");
                RasHelper.printStackTrace(subexs[i], p);
            }
            return;
        }
        boolean autoRecursion = true;
        Throwable tNext = null;
        while (autoRecursion) {
            tNext = t.getCause();
            if (tNext != null) {
                t = tNext;
                continue;
            }
            tNext = RasHelper.getNestedThrowable(t);
            if (tNext == null) {
                return;
            }
            if (RasHelper.pstRecursesOnNested(t)) {
                t = tNext;
                continue;
            }
            autoRecursion = false;
        }
        p.println("---- Begin backtrace for Nested Throwables");
        RasHelper.printStackTrace(tNext, p);
    }

    private static final Throwable getNestedThrowable(Throwable t) {
        if (t instanceof UnknownException) {
            return ((UnknownException)t).originalEx;
        }
        if (t instanceof RemoteException) {
            return ((RemoteException)t).detail;
        }
        if (t instanceof InvocationTargetException) {
            return ((InvocationTargetException)t).getTargetException();
        }
        if (t instanceof NamingException) {
            return ((NamingException)t).getRootCause();
        }
        if (t instanceof EJBException) {
            return ((EJBException)t).getCausedByException();
        }
        if (t instanceof SQLException) {
            return ((SQLException)t).getNextException();
        }
        if (t instanceof MessagingException) {
            return ((MessagingException)t).getNextException();
        }
        if (t instanceof SAXException) {
            return ((SAXException)t).getException();
        }
        if (t instanceof JspException) {
            return ((JspException)t).getCause();
        }
        if (t instanceof ServletException) {
            return ((ServletException)t).getRootCause();
        }
        if (t instanceof ResourceException) {
            return ((ResourceException)t).getCause();
        }
        if (t instanceof JMSException) {
            return ((JMSException)t).getLinkedException();
        }
        if (t instanceof UndeclaredThrowableException) {
            return ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        if (t instanceof WriteAbortedException) {
            return ((WriteAbortedException)t).detail;
        }
        if (t instanceof ServerCloneException) {
            return ((ServerCloneException)t).detail;
        }
        if (t instanceof PrivilegedActionException) {
            return ((PrivilegedActionException)t).getException();
        }
        return null;
    }

    private static final boolean pstRecursesOnNested(Throwable t) {
        if (t instanceof UnknownException) {
            return false;
        }
        if (t instanceof MessagingException) {
            return false;
        }
        if (t instanceof SAXException) {
            return false;
        }
        if (t instanceof JspException) {
            return false;
        }
        if (t instanceof ServletException) {
            return false;
        }
        if (t instanceof NamingException) {
            return false;
        }
        if (t instanceof SQLException) {
            return false;
        }
        return !(t instanceof JMSException);
    }

    static String[] split(String aString, int ch) {
        if (aString == null || aString.equals("")) {
            return new String[0];
        }
        int numComponents = 0;
        int curIndex = 0;
        while (true) {
            curIndex = aString.indexOf(ch, curIndex);
            ++numComponents;
            if (curIndex == -1) break;
            ++curIndex;
        }
        String[] result = new String[numComponents];
        int start = 0;
        int end = aString.indexOf(ch, 0);
        for (int i = 0; i < numComponents; ++i) {
            result[i] = i + 1 == numComponents ? aString.substring(start) : aString.substring(start, end);
            start = end + 1;
            end = aString.indexOf(ch, start);
        }
        return result;
    }

    static final String peelQuotes(String aString) {
        if (aString == null || aString.equals("")) {
            return null;
        }
        if (aString.startsWith("\"")) {
            aString = aString.substring(1);
        }
        if (aString.endsWith("\"")) {
            aString = aString.substring(0, aString.length() - 1);
        }
        if (aString.equals("")) {
            return null;
        }
        return aString;
    }

    static String[] primitiveArrayToString(Object o) {
        if (Byte.TYPE.equals(o.getClass().getComponentType())) {
            return new String[]{RasHelper.byteArrayToHexString((byte[])o)};
        }
        if (Integer.TYPE.equals(o.getClass().getComponentType())) {
            int[] tmp = (int[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = Integer.toString(tmp[i]);
            }
            return result;
        }
        if (Short.TYPE.equals(o.getClass().getComponentType())) {
            short[] tmp = (short[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = Short.toString(tmp[i]);
            }
            return result;
        }
        if (Long.TYPE.equals(o.getClass().getComponentType())) {
            long[] tmp = (long[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = Long.toString(tmp[i]);
            }
            return result;
        }
        if (Float.TYPE.equals(o.getClass().getComponentType())) {
            float[] tmp = (float[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = Float.toString(tmp[i]);
            }
            return result;
        }
        if (Double.TYPE.equals(o.getClass().getComponentType())) {
            double[] tmp = (double[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = Double.toString(tmp[i]);
            }
            return result;
        }
        if (Character.TYPE.equals(o.getClass().getComponentType())) {
            char[] tmp = (char[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = "" + tmp[i] + "";
            }
            return result;
        }
        if (Boolean.TYPE.equals(o.getClass().getComponentType())) {
            boolean[] tmp = (boolean[])o;
            String[] result = new String[tmp.length];
            for (int i = tmp.length - 1; i >= 0; --i) {
                result[i] = Boolean.toString(tmp[i]);
            }
            return result;
        }
        return new String[]{"Illegal trace argument: array of " + o.getClass().getComponentType()};
    }

    static String byteArrayToHexString(byte[] b) {
        int length = b.length > 4096 ? 4096 : b.length;
        StringBuffer result = new StringBuffer(length * 2 + 8);
        for (int i = 0; i < length; ++i) {
            if (i % 4 == 0 && i != 0) {
                result.append(" ");
            }
            if (i % 32 == 0) {
                if (i != 0) {
                    result.append("\n");
                }
                for (int j = 0; j < 4; ++j) {
                    result.append(" ");
                }
            }
            result.append(hexChars[b[i] >> 4 & 0xF]);
            result.append(hexChars[b[i] & 0xF]);
        }
        if (length != b.length) {
            result.append("...");
        }
        return new String(result);
    }

    static DateFormat getBasicDateFormatter() {
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
        if (formatter instanceof SimpleDateFormat) {
            SimpleDateFormat sdFormatter = (SimpleDateFormat)formatter;
            String pattern = sdFormatter.toPattern();
            int patternLength = pattern.length();
            int endOfSecsIndex = pattern.lastIndexOf(115) + 1;
            String newPattern = pattern.substring(0, endOfSecsIndex) + ":SSS z";
            if (endOfSecsIndex < patternLength) {
                newPattern = newPattern + pattern.substring(endOfSecsIndex, patternLength);
            }
            newPattern = newPattern.replace('h', 'H');
            newPattern = newPattern.replace('K', 'H');
            newPattern = newPattern.replace('k', 'H');
            newPattern = newPattern.replace('a', ' ');
            newPattern = newPattern.trim();
            sdFormatter.applyPattern(newPattern);
            formatter = sdFormatter;
        } else {
            formatter = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        if (sysTimeZone != null) {
            formatter.setTimeZone(sysTimeZone);
        }
        return formatter;
    }

    static String generateOutputFileName(String fileName, String defaultPrefix, TraceComponent tc) throws RasException {
        String tempName = null;
        if (fileName == null || fileName.equals("")) {
            tempName = RasHelper.generateFilename(defaultPrefix);
            Tr.warning(tc, "MSG_INVALID_FILENAME", new Object[]{fileName, defaultPrefix, tempName});
        } else {
            tempName = fileName.trim();
        }
        if (WSLauncher.isZOS() && svFileNameSuffix != null) {
            int index = tempName.lastIndexOf(46);
            tempName = index == -1 ? tempName + '.' + svFileNameSuffix : tempName.substring(0, index) + '.' + svFileNameSuffix + tempName.substring(index);
        }
        File x = new File(tempName);
        tempName = x.getAbsolutePath();
        RasHelper.validateFileName(tempName);
        return tempName;
    }

    static void validateFileName(String fileName) throws RasException {
        File file = new File(fileName);
        String name = file.getName();
        if (name == null || name.equals("")) {
            throw new RasException("File name " + fileName + " does not have a usable name qualifier");
        }
        String directory = null;
        if (RasHelper.fileExists(file)) {
            directory = file.getParent();
        } else {
            directory = file.getParent();
            if (directory == null) {
                String tempName = file.getAbsolutePath();
                int last = tempName.lastIndexOf(File.separator);
                if (last == -1) {
                    throw new RasException("Incoherent file name of " + fileName);
                }
                directory = tempName.substring(0, last);
                file = new File(directory);
            } else {
                file = new File(directory);
                if (!RasHelper.fileExists(file) && !RasHelper.makeDirectories(file)) {
                    throw new RasException("Unable to create directory  " + directory + " for file " + fileName);
                }
            }
        }
        if (!RasHelper.canWriteFile(file)) {
            throw new RasException("Ras does not have necessary permission to write file " + name + " to directory " + file.getAbsolutePath());
        }
    }

    private static String generateFilename(String defaultPrefix) throws RasException {
        try {
            Date date = new Date(System.currentTimeMillis());
            SimpleDateFormat formatter = new SimpleDateFormat("yy.MM.dd_HH.mm.ss");
            String ts = formatter.format(date);
            String name = svServerName + "_" + defaultPrefix + "_" + ts + ".txt";
            String baseDir = RasProperties.getDefaultLoggingDirectory();
            name = baseDir + File.separator + name;
            return name;
        }
        catch (Throwable t) {
            throw new RasException(t);
        }
    }

    static String getDefaultDumpFileName() throws RasException {
        return RasProperties.getDefaultLoggingDirectory() + File.separator + "DefaultRingBufferContent.txt";
    }

    static FileOutputStream createFileOutputStream(String fileName, boolean append) throws RasException {
        final String tempFileName = fileName;
        final boolean tempAppend = append;
        try {
            FileOutputStream fs = (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileOutputStream(tempFileName, tempAppend);
                }
            });
            return fs;
        }
        catch (Throwable t) {
            throw new RasException("Unable to create FileOutputStream over file " + fileName, t);
        }
    }

    static String getSystemProperty(String propName) {
        final String temp = propName;
        try {
            String prop = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(temp);
                }
            });
            return prop;
        }
        catch (SecurityException se) {
            return null;
        }
    }

    static void setSystemOut(PrintStream stream) throws RasException {
        final PrintStream tempStream = stream;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setOut(tempStream);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            throw new RasException("Unable to replace System.out", t);
        }
    }

    static void setSystemErr(PrintStream stream) throws RasException {
        final PrintStream tempStream = stream;
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setErr(tempStream);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            throw new RasException("Unable to replace System.err", t);
        }
    }

    static String getHostName() throws RasException {
        try {
            String hostName = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getLocalHost().getHostName();
                }
            });
            return hostName;
        }
        catch (Throwable t) {
            throw new RasException("Unable to obtain host name ", t);
        }
    }

    static InputStream getResourceAsStream(String resource) throws RasException {
        final String tempResource = resource;
        try {
            InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Thread.currentThread().getContextClassLoader().getResourceAsStream(tempResource);
                }
            });
            return stream;
        }
        catch (Throwable t) {
            throw new RasException("unable to get resource " + resource, t);
        }
    }

    static boolean deleteFile(File fileToDelete) {
        try {
            final File tempFileToDelete = fileToDelete;
            Boolean deleted = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToDelete.delete());
                }
            });
            return deleted;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean fileExists(String fileNameToCheck) {
        File fileToCheck = new File(fileNameToCheck);
        return RasHelper.fileExists(fileToCheck);
    }

    public static boolean fileExists(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.exists());
                }
            });
            return exists;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean containsRasHeader(String filename) {
        File file = new File(filename);
        if (!RasHelper.fileExists(file)) {
            return false;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            boolean foundHeadLine = false;
            boolean foundTailLine = false;
            boolean foundServerLine = false;
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("************ Start Display Current Environment ************")) {
                    foundHeadLine = true;
                } else if (line.startsWith("************* End Display Current Environment *************")) {
                    foundTailLine = true;
                } else if (line.startsWith(RasHeader.serverArr[0])) {
                    foundServerLine = true;
                }
                if (!foundHeadLine || !foundTailLine || !foundServerLine) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static boolean canReadFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.canRead());
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static long fileLastModified(File fileToCheck) throws RasException {
        final File tempFileToCheck = fileToCheck;
        try {
            Long time2 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(tempFileToCheck.lastModified());
                }
            });
            long realTime = time2;
            if (realTime == 0L) {
                throw new RasException("Unable to determine time file was last modified");
            }
            return realTime;
        }
        catch (Throwable t) {
            throw new RasException("Unable to determine time file was last modified", t);
        }
    }

    static long getFileLength(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Long size = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(tempFileToCheck.length());
                }
            });
            return size;
        }
        catch (SecurityException se) {
            return 0L;
        }
    }

    static boolean canWriteFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.canWrite());
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean createNewFile(File fileToCreate) throws IOException, RasException {
        final File tempFileToCreate = fileToCreate;
        try {
            Boolean bool = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new Boolean(tempFileToCreate.createNewFile());
                }
            });
            return bool;
        }
        catch (Throwable t) {
            throw new RasException("unable to create new file", t);
        }
    }

    static boolean makeDirectories(File dirToMake) {
        final File tempDirToMake = dirToMake;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempDirToMake.mkdirs());
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static boolean renameFile(File current, File newName) {
        final File tempCurrentFile = current;
        final File tempNewName = newName;
        try {
            Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempCurrentFile.renameTo(tempNewName));
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static boolean isFile(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean isFile = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.isFile());
                }
            });
            return isFile;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    static String[] listFileNames(File file) {
        final File tempFile = file;
        try {
            String[] result = (String[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return tempFile.list();
                }
            });
            return result;
        }
        catch (SecurityException se) {
            return new String[0];
        }
    }

    static boolean isDirectory(File fileToCheck) {
        final File tempFileToCheck = fileToCheck;
        try {
            Boolean exists = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Boolean(tempFileToCheck.isDirectory());
                }
            });
            return exists;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public static String getThreadId() {
        LogRecord logRecord = new LogRecord(Level.FINE, "x");
        return RasHelper.getThreadId(logRecord);
    }

    public static String getThreadId(LogRecord logRecord) {
        int length;
        StringBuffer buffer = new StringBuffer(16);
        String tid = Integer.toHexString(logRecord.getThreadID());
        for (int i = length = tid.length(); i < 8; ++i) {
            buffer.append('0');
        }
        buffer.append(tid);
        return buffer.toString();
    }

    static FileInputStream createFileInputStream(String fileName) throws RasException {
        final String tempFileName = fileName;
        try {
            FileInputStream fs = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileInputStream(tempFileName);
                }
            });
            return fs;
        }
        catch (Throwable t) {
            throw new RasException("Unable to create FileInputStream for file " + fileName, t);
        }
    }

    public static void copyFile(File src, File dest) throws IOException {
        if (src == null || !RasHelper.fileExists(src) || !RasHelper.canReadFile(src)) {
            throw new IOException("Copy Failed: Source file does not exist or cannot be read.");
        }
        if (dest == null) {
            throw new IOException("Copy Failed: Destination file is null");
        }
        if (!RasHelper.fileExists(dest)) {
            try {
                RasHelper.createNewFile(dest);
            }
            catch (RasException re2) {
                if (re2.getCause() instanceof IOException) {
                    throw (IOException)re2.getCause();
                }
                throw new IOException(re2.toString());
            }
        }
        if (!(RasHelper.fileExists(dest) && RasHelper.isFile(dest) && RasHelper.canWriteFile(dest))) {
            throw new IOException("Copy Failed: Invalid destination file - " + dest);
        }
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int bytesRead;
            in = RasHelper.createFileInputStream(src.getPath());
            out = RasHelper.createFileOutputStream(dest.getPath(), false);
            byte[] buf = new byte[4096];
            while ((bytesRead = in.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
        }
        catch (RasException re3) {
            if (re3.getCause() instanceof IOException) {
                throw (IOException)re3.getCause();
            }
            throw new IOException(re3.toString());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Throwable t) {
                    in = null;
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable t) {
                    out = null;
                }
            }
        }
    }

    public static byte[] printHeader(OutputStream output) {
        String javaVersion;
        String verboseVersion;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        ps.println("************ Start Display Current Environment ************");
        String version = RasHelper.getVersionId();
        if (version != null && !version.equals("")) {
            ps.println(MessageFormat.format(RasHeader.server, version, RasHelper.getServerName(), RasHelper.getProcessId()));
        }
        if ((verboseVersion = RasHelper.getVerboseVersion()) != null && !verboseVersion.equals("")) {
            ps.println(MessageFormat.format("Detailed IFix information: {0}", verboseVersion));
        }
        if ((javaVersion = RasHelper.getSystemProperty("java.version")) == null) {
            javaVersion = RasHelper.getSystemProperty("java.fullversion");
        }
        String a = RasHelper.getSystemProperty("os.name");
        String b = RasHelper.getSystemProperty("os.version");
        ps.println(MessageFormat.format("Host Operating System is {0}, version {1}", a, b));
        a = RasHelper.getSystemProperty("java.compiler");
        b = RasHelper.getSystemProperty("java.vm.name");
        ps.println(MessageFormat.format("Java version = {0}, Java Compiler = {1}, Java VM name = {2}", javaVersion, a, b));
        a = RasHelper.getSystemProperty("was.install.root");
        ps.println(MessageFormat.format("was.install.root = {0}", a));
        a = RasHelper.getSystemProperty("user.install.root");
        ps.println(MessageFormat.format("user.install.root = {0}", a));
        a = RasHelper.getSystemProperty("java.home");
        ps.println(MessageFormat.format("Java Home = {0}", a));
        a = RasHelper.getSystemProperty("ws.ext.dirs");
        ps.println(MessageFormat.format("ws.ext.dirs = {0}", a));
        a = RasHelper.getSystemProperty("java.class.path");
        ps.println(MessageFormat.format("Classpath = {0}", a));
        a = RasHelper.getSystemProperty("java.library.path");
        ps.println(MessageFormat.format("Java Library path = {0}", a));
        ps.println("************* End Display Current Environment *************");
        ps.flush();
        byte[] bytes = baos.toByteArray();
        if (output != null) {
            try {
                output.write(bytes);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        return bytes;
    }

    static {
        try {
            svProcessId = Long.toString(System.currentTimeMillis());
        }
        catch (Throwable t) {
            svProcessId = "Unknown";
        }
    }
}

