/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.ras;

import com.ibm.ejs.ras.CBuff;
import com.ibm.ejs.ras.ExtendedTraceLogger;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.RasProperties;
import com.ibm.ejs.ras.TraceLogger;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.LogRecord;

class CBuffLogger
implements WsHandler {
    private CBuff ivCBuff;

    CBuffLogger(int size) {
        if (size < 1) {
            size = 8;
        }
        int sizeInKB = size * 1024;
        this.ivCBuff = new CBuff(sizeInKB);
    }

    synchronized void setSize(int size) {
        if (size < 1) {
            return;
        }
        int sizeInKB = size * 1024;
        this.ivCBuff.setSize(sizeInKB);
    }

    synchronized int getSize() {
        int size = this.ivCBuff.getSize() / 1024;
        return size;
    }

    synchronized void clear() {
        int size = this.ivCBuff.getSize();
        this.ivCBuff = new CBuff(size);
    }

    public synchronized void processEvent(LogRecord event2) {
        if (ManagerAdmin.svTraceEnabled) {
            WsLogRecord wsLogRecord = WsLogRecordFactory.getWsLogRecordIfConvertible(event2);
            if (wsLogRecord != null && wsLogRecord.getExtension("service_log_only") != null) {
                return;
            }
            this.ivCBuff.put(event2);
        }
    }

    synchronized void dump(String fileToWriteTo, boolean overwriteIfNecessary) throws RasException {
        FileOutputStream fs = null;
        try {
            RasHelper.validateFileName(fileToWriteTo.trim());
            if (RasHelper.fileExists(fileToWriteTo) && !overwriteIfNecessary) {
                throw new RasException("Will not overwrite existing file: " + fileToWriteTo);
            }
            fs = RasHelper.createFileOutputStream(fileToWriteTo, false);
            TraceLogger logger = null;
            logger = RasProperties.svTraceFormat.equals("loganalyzer") ? new ExtendedTraceLogger(fs) : (RasProperties.svTraceFormat.equals("advanced") ? new TraceLogger((OutputStream)fs, false) : new TraceLogger((OutputStream)fs, true));
            logger.printHeader();
            Enumeration vEnum = this.ivCBuff.elements();
            while (vEnum.hasMoreElements()) {
                LogRecord event2 = (LogRecord)vEnum.nextElement();
                logger.processEvent(event2);
            }
        }
        catch (RasException re2) {
            throw new RasException("Failed to open file " + fileToWriteTo, re2);
        }
        catch (Throwable t) {
            throw new RasException("Failure dumping the ring buffer " + fileToWriteTo, t);
        }
        finally {
            try {
                fs.close();
            }
            catch (Throwable t) {}
        }
    }
}

