/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.CORBA.iiop.IOR;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.oa.EJSObjectAdapter;
import com.ibm.ejs.oa.EJSRootOAImpl;
import com.ibm.ejs.oa.InvalidServantException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.CSIServant;
import com.ibm.websphere.csi.ObjectAdapter;
import com.ibm.websphere.csi.ServantManager;
import com.ibm.wsspi.cluster.Identity;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Object;

public class EJSOAImpl
implements EJSObjectAdapter,
ObjectAdapter {
    private final EJSRootOAImpl rootOA;
    private ServantManager sm;
    private final ByteArray key;
    private static final TraceComponent tc = Tr.register(EJSOAImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");

    EJSOAImpl(EJSRootOAImpl rootOA, String oaName, ServantManager sm) {
        this.rootOA = rootOA;
        this.sm = sm;
        this.key = new ByteArray(oaName.getBytes());
    }

    EJSOAImpl(EJSRootOAImpl rootOA, String oaName) {
        this.rootOA = rootOA;
        this.sm = null;
        this.key = new ByteArray(oaName.getBytes());
    }

    public void registerServantManager(ServantManager servantManager) throws CSIException {
        this.sm = servantManager;
    }

    public void registerServant(CSIServant servant, byte[] key) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(CSIServant, byte[])");
        }
        try {
            this.registerServant((Remote)servant, key, servant.wlmable(), false);
        }
        catch (Exception ex) {
            throw new CSIException("registerServant failed", (Throwable)ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(CSIServant, byte[])");
        }
    }

    public void registerServant(CSIServant servant, byte[] key, boolean useLsd) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(CSIServant, byte[], useLsd)");
        }
        try {
            this.registerServant((Remote)servant, key, servant.wlmable(), useLsd);
        }
        catch (Exception ex) {
            throw new CSIException("registerServant failed", (Throwable)ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(CSIServant, byte[], useLsd)");
        }
    }

    public void registerServant(CSIServant servant, ByteArray key, boolean useLsd) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(CSIServant, ByteArray, useLsd)");
        }
        try {
            this.registerServant((Remote)servant, key, servant.wlmable(), useLsd);
        }
        catch (Exception ex) {
            throw new CSIException("registerServant failed", (Throwable)ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(CSIServant, ByteArray, useLsd)");
        }
    }

    public void registerServant(Remote servant, byte[] key, boolean wlmable, boolean useLsd) throws InvalidServantException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(Remote, byte[], wlmable, useLsd)");
        }
        try {
            Object tie;
            if (!EJSPlatformHelper.isZOS()) {
                PortableRemoteObject.exportObject((Remote)servant);
            }
            if ((tie = (Object)javax.rmi.CORBA.Util.getTie((Remote)servant)).getClass().getName().equals("com.ibm.ejs.container._EJSWrapper_Tie")) {
                String remoteClassName = servant.getClass().getName();
                Tr.warning(tc, "WSVR0056W", remoteClassName);
            }
            this.rootOA.registerServant(tie, key, wlmable, useLsd, this);
        }
        catch (RemoteException e) {
            throw new InvalidServantException("PortableRemoteObject.exportObject failed", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(Remote, byte[], wlmable, useLsd)");
        }
    }

    public void registerServant(Remote servant, ByteArray key, boolean wlmable, boolean useLsd) throws InvalidServantException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(Remote, ByteArray, wlmable, useLsd)");
        }
        try {
            Object tie;
            if (!EJSPlatformHelper.isZOS()) {
                PortableRemoteObject.exportObject((Remote)servant);
            }
            if ((tie = (Object)javax.rmi.CORBA.Util.getTie((Remote)servant)).getClass().getName().equals("com.ibm.ejs.container._EJSWrapper_Tie")) {
                String remoteClassName = servant.getClass().getName();
                Tr.warning(tc, "WSVR0056W", remoteClassName);
            }
            this.rootOA.registerServant(tie, key, wlmable, useLsd, this);
        }
        catch (RemoteException e) {
            throw new InvalidServantException("PortableRemoteObject.exportObject failed", e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(Remote, ByteArray, wlmable, useLsd)");
        }
    }

    public void registerServant(Remote servant, ByteArray key, Identity cluster, boolean useLsd) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(Remote, ByteArray, Identity, useLsd)");
        }
        try {
            Object tie;
            if (!EJSPlatformHelper.isZOS()) {
                try {
                    PortableRemoteObject.exportObject((Remote)servant);
                }
                catch (RemoteException rex) {
                    throw new InvalidServantException("PortableRemoteObject.exportObject failed", rex);
                }
            }
            if ((tie = (Object)javax.rmi.CORBA.Util.getTie((Remote)servant)).getClass().getName().equals("com.ibm.ejs.container._EJSWrapper_Tie")) {
                String remoteClassName = servant.getClass().getName();
                Tr.warning(tc, "WSVR0056W", remoteClassName);
            }
            this.rootOA.registerServant(tie, key, cluster, useLsd, this);
        }
        catch (Exception ex) {
            throw new CSIException("registerServant failed", (Throwable)ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(Remote, ByteArray, Identity, useLsd)");
        }
    }

    public void registerServant(Object servant) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(org.omg.CORBA.Object)");
        }
        this.rootOA.registerServant(servant);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(org.omg.CORBA.Object)");
        }
    }

    public void registerServant(Object servant, byte[] key) throws InvalidServantException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.registerServant(org.omg.CORBA.Object, byte[])");
        }
        this.registerServant(servant, key, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.registerServant(org.omg.CORBA.Object, byte[])");
        }
    }

    public void registerServant(Object servant, byte[] key, boolean wlmable) throws InvalidServantException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant(org.omg.CORBA.Object, byte[], wlmable)");
        }
        this.rootOA.registerServant(servant, key, wlmable, true, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant(org.omg.CORBA.Object, byte[], wlmable)");
        }
    }

    public void registerServant(Object servant, byte[] key, Identity cluster) throws InvalidServantException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "registerServant(org.omg.CORBA.Object, byte[], Identity)");
        }
        this.rootOA.registerServant(servant, key, cluster, true, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerServant(org.omg.CORBA.Object, byte[], Identity)");
        }
    }

    public void unregisterServant(CSIServant servant) throws CSIException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "unregisterServant");
        }
        try {
            Object tie = (Object)javax.rmi.CORBA.Util.getTie((Remote)servant);
            if (!EJSPlatformHelper.isZOS()) {
                this.rootOA.unregisterServantNoOrb(tie);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "> PortableRemoteObject.unexportObject");
                }
                PortableRemoteObject.unexportObject((Remote)servant);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "< PortableRemoteObject.unexportObject");
                }
            } else {
                this.rootOA.unregisterServant(tie);
            }
        }
        catch (RemoteException e) {
            throw new CSIException("PortableRemoteObject.unexportObject failed", (Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.unregisterServant");
        }
    }

    public void unregisterServant(Object servant) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.unregisterServant");
        }
        this.rootOA.unregisterServant(servant);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.unregisterServant");
        }
    }

    final ByteArray getKey() {
        return this.key;
    }

    public Object keyToObject(byte[] key) throws RemoteException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "keyToObject", key);
        }
        java.lang.Object servant = null;
        if (this.sm != null && (servant = this.sm.keyToObject(key)) instanceof Remote) {
            servant = javax.rmi.CORBA.Util.getTie((Remote)((Remote)servant));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "keyToObject", Util.identity((java.lang.Object)servant));
        }
        return (Object)servant;
    }

    public IOR createIOR(ByteArray key, Identity cluster, boolean useLsd, String typeid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "EJSOAImpl.createIOR(byte[], Identity, boolean, String)");
        }
        IOR ior = this.rootOA.createIOR(key, cluster, useLsd, typeid, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "EJSOAImpl.createIOR(byte[], Identity, boolean, String)");
        }
        return ior;
    }
}

