/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.models.base.extensions.applicationext.util;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.applicationext.ApplicationextPackage;
import com.ibm.ejs.models.base.extensions.applicationext.ModuleExtension;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.Module;

public class ApplicationExtensionCoreSynchronizeAdapter
extends AdapterImpl {
    public void notifyChanged(Notification msg) {
        if (msg.getFeature() == ApplicationPackage.eINSTANCE.getApplication_Modules()) {
            this.modifiedModules(msg);
        } else if (msg.getFeature() == ApplicationextPackage.eINSTANCE.getApplicationExtension_Application()) {
            this.modifiedApplication(msg);
        }
    }

    private void modifiedModules(Notification msg) {
        switch (msg.getEventType()) {
            case 4: {
                this.removedModule((Module)msg.getOldValue());
                break;
            }
            case 6: {
                this.removedModules((Collection)msg.getOldValue());
            }
        }
    }

    private void removedModule(Module module) {
        ApplicationExtension appExt = (ApplicationExtension)this.getTarget();
        ModuleExtension modExt = appExt.getModuleExtension(module);
        appExt.getModuleExtensions().remove(modExt);
    }

    private void removedModules(Collection modules) {
        Iterator it = modules.iterator();
        while (it.hasNext()) {
            this.removedModule((Module)it.next());
        }
    }

    private void modifiedApplication(Notification msg) {
        Application app = null;
        switch (msg.getEventType()) {
            case 1: {
                app = (Application)msg.getOldValue();
                if (app != null) {
                    app.eAdapters().remove(this);
                }
                if ((app = (Application)msg.getNewValue()) == null) break;
                this.beginListening(app);
                break;
            }
            case 2: {
                app = (Application)msg.getOldValue();
                if (app == null) break;
                app.eAdapters().remove(this);
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        Application app = ((ApplicationExtension)newTarget).getApplication();
        if (app != null) {
            this.beginListening(app);
        }
    }

    private void beginListening(Application app) {
        if (!app.eAdapters().contains(this)) {
            app.eAdapters().add(this);
        }
    }
}

