/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultFactory;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.ssl.config.SSLConfigManager;
import java.util.Vector;
import org.omg.CORBA.INITIALIZE;

public class ServiceInit {
    private static Vector orbRegistry = new Vector();
    private static ServiceInit serviceInit = null;
    private static boolean initialized = false;
    private static final TraceComponent tc = Tr.register(ServiceInit.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    private ServiceInit() {
    }

    public static ServiceInit getInstance() {
        if (serviceInit == null) {
            serviceInit = new ServiceInit();
        }
        return serviceInit;
    }

    public synchronized void initialize(ORB theORB) {
        initialized = true;
        this.init(theORB);
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    private void init(ORB theORB) {
        String logMethod = "ServiceInit.init";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, logMethod);
        }
        try {
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            boolean secEnabled = csiv2.getBoolean("com.ibm.CORBA.securityEnabled");
            if (secEnabled) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security is enabled in ServiceInit.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityConfiguration initialized");
                }
                Tr.audit(tc, "security.GettingConfig");
                SSLConfigManager sslConfigManager = SSLConfigManager.getInstance();
                sslConfigManager.initializeClientSSL();
                String authTarget = AuthenticationTarget.strings.get(new Integer(csiv2.getInteger("com.ibm.CORBA.authenticationTarget"))).toUpperCase();
                if (authTarget.equals("LOCALOS")) {
                    Tr.audit(tc, "security.AuthTarget", new Object[]{"SWAM"});
                } else {
                    Tr.audit(tc, "security.AuthTarget", new Object[]{authTarget});
                }
                String principalName = csiv2.getString("com.ibm.CORBA.principalName");
                if (principalName != null && !principalName.equals("")) {
                    Tr.audit(tc, "security.Principal", new Object[]{csiv2.getString("com.ibm.CORBA.principalName")});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Initializing ORB security.");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security is being initialized for ORB: " + theORB);
                }
                if (orbRegistry.contains(theORB)) {
                    Tr.error(tc, "security.JSAS0465E");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, logMethod);
                    }
                    return;
                }
                orbRegistry.addElement(theORB);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "LocateRequest processing in the ORB has been forced on.");
                }
                if (csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
                    MechanismFactory mechFactory = new MechanismFactory();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "MechanismFactory initialized");
                    }
                    VaultImpl vault = VaultFactory.createVault(mechFactory, theORB);
                    vault.setORB(theORB);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "VaultImpl initialized");
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security is disabled in ServiceInit.");
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.ServiceInit.init", "223");
            Tr.error(tc, "security.JSAS0011E", new Object[]{e});
            throw new INITIALIZE();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, logMethod);
        }
    }
}

