/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Vector;

public class SecurityAttributeList {
    private static final byte[] emptyByteArray = new byte[0];
    private static final String[] emptyStringArray = new String[0];
    private static final TraceComponent tc = Tr.register(SecurityAttributeList.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    private SecurityAttributeList() {
    }

    public static byte[] getAttributeByteArray(String[] attributeStringArray) {
        int totalLength = 2;
        int idx = 0;
        int arrLength = attributeStringArray.length > 65535 ? 65535 : attributeStringArray.length;
        Vector<byte[]> v = new Vector<byte[]>(arrLength);
        byte[] rtnVal = null;
        byte[] tmp1 = null;
        byte[] tmp2 = null;
        byte[] bytePair = new byte[2];
        if (attributeStringArray.length > 65535) {
            Tr.debug(tc, "64K or more strings to convert.  Converting first 64K-1 strings.");
        }
        if (attributeStringArray != null) {
            if (arrLength == 0) {
                rtnVal = emptyByteArray;
            } else {
                int n;
                for (n = 0; n < arrLength; ++n) {
                    byte[] tmp = StringBytesConversion.getConvertedBytes(attributeStringArray[n]);
                    if (tmp.length > 65535) {
                        StringBuffer stbuf = new StringBuffer();
                        stbuf.append("Group name exceeded 64K in size. First 20 characters are: ");
                        stbuf.append(attributeStringArray[n].substring(20));
                        tmp = StringBytesConversion.getConvertedBytes(stbuf.toString());
                        Tr.debug(tc, stbuf.toString());
                    }
                    v.addElement(tmp);
                    totalLength += 2 + tmp.length;
                }
                rtnVal = new byte[totalLength];
                idx = SecurityAttributeList.arrayInsert(SecurityAttributeList.intToBytePair(arrLength, bytePair), rtnVal, idx);
                for (n = 0; n < arrLength; ++n) {
                    tmp1 = (byte[])v.elementAt(n);
                    tmp2 = SecurityAttributeList.intToBytePair(tmp1.length, bytePair);
                    idx = SecurityAttributeList.arrayInsert(tmp2, rtnVal, idx);
                    idx = SecurityAttributeList.arrayInsert(tmp1, rtnVal, idx);
                }
            }
        }
        return rtnVal;
    }

    public static String[] getAttributeStringArray(byte[] attributeByteArray) {
        if (attributeByteArray == null) {
            return null;
        }
        String[] rtnVal = null;
        if (attributeByteArray != null) {
            if (attributeByteArray.length == 0) {
                rtnVal = emptyStringArray;
            } else {
                int idx = 0;
                int numStrings = SecurityAttributeList.bytePairToInt(SecurityAttributeList.getSubArray(attributeByteArray, idx, 2));
                idx += 2;
                rtnVal = new String[numStrings];
                for (int n = 0; n < numStrings; ++n) {
                    int strLen = SecurityAttributeList.bytePairToInt(SecurityAttributeList.getSubArray(attributeByteArray, idx, 2));
                    byte[] tmp = SecurityAttributeList.getSubArray(attributeByteArray, idx += 2, strLen);
                    idx += strLen;
                    rtnVal[n] = StringBytesConversion.getConvertedString(tmp);
                }
            }
        }
        return rtnVal;
    }

    private static int bytePairToInt(byte[] b) {
        return (b[0] & 0xFF) << 8 | b[1] & 0xFF;
    }

    private static byte[] intToBytePair(int i, byte[] b) {
        b[0] = (byte)((i & 0xFF00) >> 8);
        b[1] = (byte)(i & 0xFF);
        return b;
    }

    private static int arrayInsert(byte[] srcArray, byte[] tarArray, int idx) {
        System.arraycopy(srcArray, 0, tarArray, idx, srcArray.length);
        return idx + srcArray.length;
    }

    private static byte[] getSubArray(byte[] srcArray, int idx, int length) {
        byte[] rtnVal = new byte[length];
        System.arraycopy(srcArray, idx, rtnVal, 0, length);
        return rtnVal;
    }

    private static String getFormattedStringArrayDump(String[] st) {
        StringBuffer stbuf = new StringBuffer("Num Strings ");
        stbuf.append(st.length);
        for (int n = 0; n < st.length; ++n) {
            stbuf.append("\n[");
            stbuf.append(n);
            stbuf.append("] ");
            stbuf.append(st[n]);
        }
        return stbuf.toString();
    }
}

