/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.BasicAuthWithRealm;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.orbimpl.transport.ConnectionInformationImpl;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.csiv2.TrustedIDEvaluatorFactory;
import com.ibm.ws.util.StringUtils;
import com.ibm.wsspi.security.csiv2.TrustedIDEvaluator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.MARSHAL;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.RequestInfo;
import org.omg.Security.OpaqueHelper;
import org.omg.Security.OpaqueHolder;

public class CSIUtil {
    private Codec codec = null;
    private ORB orb = null;
    private VaultImpl vault = null;
    private CurrentImpl current = null;
    private byte[] nullByteArray = new byte[0];
    private static CSIUtil csiUtil = null;
    private static final TraceComponent tc = Tr.register(CSIUtil.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static final Class thisClass = CSIUtil.class;

    public static CSIUtil getInstance() {
        if (csiUtil == null) {
            csiUtil = new CSIUtil();
        }
        return csiUtil;
    }

    public CSIUtil() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            this.getORB();
            this.vault = VaultImpl.getInstance();
        }
    }

    public SASContextBody get_message_from_sc(ServiceContext sc) {
        return this.get_message_from_sc(sc.context_data);
    }

    public SASContextBody get_message_from_sc(com.ibm.CORBA.iiop.ServiceContext sc) {
        return this.get_message_from_sc(sc.getContextData());
    }

    public SASContextBody get_message_from_sc(byte[] context_data) {
        Any any = null;
        SASContextBody msg = null;
        try {
            if (context_data != null) {
                any = this.getCodec().decode_value(context_data, SASContextBodyHelper.type());
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The context_data in the service_context is null.");
            }
            if (any != null) {
                msg = SASContextBodyHelper.extract(any);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The any object from the service context was null.");
            }
        }
        catch (MARSHAL e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "183", this);
            Tr.debug(tc, "CORBA MARSHALL exception getting message from service context", (Object)e);
        }
        catch (BAD_OPERATION ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "188", this);
            Tr.debug(tc, "CORBA_BAD_OPERATION getting message from service context", new Object[]{ex});
        }
        catch (FormatMismatch fm) {
            Manager.Ffdc.log(fm, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "193", this);
            Tr.debug(tc, "FormatMismatch getting message from service context", new Object[]{fm});
        }
        catch (TypeMismatch tm) {
            Manager.Ffdc.log(tm, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_message_from_sc", "198", this);
            Tr.debug(tc, "TypeMismatch getting message from service context", new Object[]{tm});
        }
        return msg;
    }

    public ServiceContext get_sc_from_request(RequestInfo info) {
        ServiceContext sc = null;
        sc = ((ExtendedServerRequestInfo)info).getRequestServiceContext(15);
        return sc;
    }

    public ServiceContext get_sc_from_reply(RequestInfo info) {
        ServiceContext sc = null;
        sc = ((ExtendedClientRequestInfo)info).getReplyServiceContext(15);
        return sc;
    }

    public com.ibm.CORBA.iiop.ServiceContext get_sc_from_request(GIOPMessageContext gmc) {
        com.ibm.CORBA.iiop.ServiceContext sc = null;
        try {
            sc = gmc.getServiceContexts().get(15);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return sc;
    }

    public com.ibm.CORBA.iiop.ServiceContext get_sc_from_reply(GIOPMessageContext gmc) {
        com.ibm.CORBA.iiop.ServiceContext sc = null;
        try {
            sc = gmc.getServiceContexts().get(15);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return sc;
    }

    public ServiceContext create_sc_from_ec_message(EstablishContext establishContext) {
        ServiceContext sc = null;
        ORB orb = this.getORB();
        if (orb != null) {
            byte[] data;
            block8: {
                SASContextBody msg = new SASContextBody();
                msg.establish_msg(establishContext);
                Any any = orb.create_any();
                SASContextBodyHelper.insert(any, msg);
                data = null;
                try {
                    data = this.getCodec().encode_value(any);
                }
                catch (InvalidTypeForEncoding itfe) {
                    Manager.Ffdc.log(itfe, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_ec_message", "305", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "An InvalidTypeForEncoding exception occurred.", new Object[]{itfe});
                }
            }
            if (data != null) {
                sc = new ServiceContext(15, data);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create_sc_from_ec_message The service context data is null.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create_sc_from_ec_message There is no ORB, I can't go on.");
        }
        return sc;
    }

    public ServiceContext create_sc_from_mic_message(MessageInContext messageInContext) {
        ServiceContext sc = null;
        ORB orb = this.getORB();
        if (orb != null) {
            byte[] data;
            block8: {
                SASContextBody msg = new SASContextBody();
                msg.in_context_msg(messageInContext);
                Any any = orb.create_any();
                SASContextBodyHelper.insert(any, msg);
                data = null;
                try {
                    data = this.getCodec().encode_value(any);
                }
                catch (InvalidTypeForEncoding itfe) {
                    Manager.Ffdc.log(itfe, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_mic_message", "356", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "create_sc_from_mic_message An InvalidTypeForEncoding exception occurred.", new Object[]{itfe});
                }
            }
            if (data != null) {
                sc = new ServiceContext(15, data);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create_sc_from_mic_message The service context data is null.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "create_sc_from_mic_message There is no ORB, I can't go on.");
        }
        return sc;
    }

    public ServiceContext create_sc_from_ce_message(ContextError ce) {
        ServiceContext sc = null;
        ORB orb = this.getORB();
        if (orb != null) {
            byte[] data;
            block8: {
                SASContextBody msg = new SASContextBody();
                msg.error_msg(ce);
                Any any = orb.create_any();
                SASContextBodyHelper.insert(any, msg);
                data = null;
                try {
                    data = this.getCodec().encode_value(any);
                }
                catch (InvalidTypeForEncoding itfe) {
                    Manager.Ffdc.log(itfe, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_ce_message", "406", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "An InvalidTypeForEncoding exception occurred.", new Object[]{itfe});
                }
            }
            if (data != null) {
                sc = new ServiceContext(15, data);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The service context data is null.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The orb is null.");
        }
        return sc;
    }

    public ServiceContext create_sc_from_cec_message(CompleteEstablishContext cec) {
        ServiceContext sc = null;
        ORB orb = this.getORB();
        if (orb != null) {
            byte[] data;
            block8: {
                SASContextBody msg = new SASContextBody();
                msg.complete_msg(cec);
                Any any = orb.create_any();
                SASContextBodyHelper.insert(any, msg);
                data = null;
                try {
                    data = this.getCodec().encode_value(any);
                }
                catch (InvalidTypeForEncoding itfe) {
                    Manager.Ffdc.log(itfe, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_sc_from_cec_message", "456", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "InvalidTypeForEncoding exception.", new Object[]{itfe});
                }
            }
            if (data != null) {
                sc = new ServiceContext(15, data);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The service context data is null.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "The orb is null.");
        }
        return sc;
    }

    public void print_ec_message(EstablishContext ec, String logMethod) {
        StringBuffer logMsg = new StringBuffer(100);
        logMsg.append("Message type is ASSOC_ESTABLISH_CONTEXT - client_context_id: ").append(ec.client_context_id);
        if (ec.identity_token != null) {
            if (ec.identity_token.discriminator() == 0) {
                logMsg.append(", identity_token: ITTAbsent");
            } else if (ec.identity_token.discriminator() == 1) {
                logMsg.append(", identity_token: ITTAnonymous");
            } else if (ec.identity_token.discriminator() == 8) {
                logMsg.append(", identity_token: ITTDistinguishedName");
            } else if (ec.identity_token.discriminator() == 2) {
                logMsg.append(", identity_token: ITTPrincipalName");
            } else if (ec.identity_token.discriminator() == 4) {
                logMsg.append(", identity_token: ITTX509CertChain");
            } else {
                logMsg.append(", identity_token: unknown type");
            }
        }
        if (ec.client_authentication_token != null) {
            logMsg.append(", client_authentication_token length: ").append(ec.client_authentication_token.length);
        }
        Tr.debug(tc, logMsg.toString());
    }

    public void print_cec_message(CompleteEstablishContext cec, String logMethod) {
        StringBuffer logMsg = new StringBuffer(100);
        logMsg.append("Message type is ASSOC_COMPLETE_ESTABLISH_CONTEXT - client_context_id: ").append(cec.client_context_id).append(", context_stateful: ").append(cec.context_stateful);
        if (cec.final_context_token != null) {
            logMsg.append(", final_context_token length: ").append(cec.final_context_token.length);
        }
        Tr.debug(tc, logMsg.toString());
    }

    public void print_ce_message(ContextError ce, String logMethod) {
        StringBuffer logMsg = new StringBuffer(100);
        logMsg.append("Message type is ASSOC_CONTEXT_ERROR - client_context_id: ").append(ce.client_context_id).append(", major_status: ").append(ce.major_status).append(", minor_status: ").append(ce.minor_status);
        if (ce.error_token != null) {
            logMsg.append(", error_token length: ").append(ce.error_token.length);
        }
        Tr.debug(tc, logMsg.toString());
    }

    public void print_mic_message(MessageInContext mic, String logMethod) {
        StringBuffer logMsg = new StringBuffer(100);
        logMsg.append("Message type is ASSOC_MESSAGE_IN_CONTEXT - client_context_id: ").append(mic.client_context_id).append(", discard_context: ").append(mic.discard_context);
        Tr.debug(tc, logMsg.toString());
    }

    public ORB getORB() {
        if (this.orb == null) {
            this.vault = VaultImpl.getInstance();
            if (this.vault != null) {
                this.orb = this.vault.getORB();
            }
        }
        return this.orb;
    }

    public VaultImpl getVault() {
        if (this.vault == null) {
            this.vault = VaultImpl.getInstance();
        }
        return this.vault;
    }

    public Codec getCodec() {
        if (this.codec == null) {
            this.codec = this.getVault().getCodec();
        }
        return this.codec;
    }

    public CurrentImpl getCurrent() {
        if (this.current == null) {
            this.current = this.getVault().getCurrent();
        }
        return this.current;
    }

    public SecurityContextImpl get_security_context_impl(String mechType, String connectionKey) {
        SecurityContextImpl secCtx = null;
        this.vault = this.getVault();
        MechanismFactory _mechanismFactory = this.vault.getMechanismFactory();
        try {
            secCtx = _mechanismFactory.getSecurityContext(mechType, connectionKey);
        }
        catch (MechanismAmbiguityException mae) {
            Manager.Ffdc.log(mae, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.get_security_context_impl", "657", this);
            secCtx = null;
            Tr.debug(tc, "MechanismAmbiguityException trying to get security context.", new Object[]{mae});
        }
        return secCtx;
    }

    public String parseCert(java.security.cert.X509Certificate[] cert) throws AuthenticationFailedException {
        String result;
        try {
            Class<?> cl = Class.forName("com.ibm.ws.security.core.UserMappingImpl");
            Method theMethod = cl.getMethod("mapCertificateToName", java.security.cert.X509Certificate[].class);
            Object theRes = theMethod.invoke(cl.newInstance(), new Object[]{cert});
            result = (String)theRes;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parseCert", "678", this);
            throw new AuthenticationFailedException(e.getMessage());
        }
        return result;
    }

    public String parseDN(String s) throws AuthenticationFailedException {
        String result;
        try {
            Class<?> cl = Class.forName("com.ibm.ws.security.core.UserMappingImpl");
            Method theMethod = cl.getMethod("mapDNToName", String.class);
            Object theRes = theMethod.invoke(cl.newInstance(), s);
            result = (String)theRes;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parseDN", "695", this);
            throw new AuthenticationFailedException(e.getMessage());
        }
        return result;
    }

    public String parsePrincipal(String s) throws AuthenticationFailedException {
        String result;
        try {
            Class<?> cl = Class.forName("com.ibm.ws.security.core.UserMappingImpl");
            Method theMethod = cl.getMethod("mapPrincipalToName", String.class);
            Object theRes = theMethod.invoke(cl.newInstance(), s);
            result = (String)theRes;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parsePrincipal", "710", this);
            throw new AuthenticationFailedException(e.getMessage());
        }
        return result;
    }

    public static java.security.cert.X509Certificate convert(X509Certificate cert) {
        try {
            byte[] encoded = cert.getEncoded();
            ByteArrayInputStream bis = new ByteArrayInputStream(encoded);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            return (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        }
        catch (java.security.cert.CertificateEncodingException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.CSIUtil.convert", "725");
        }
        catch (CertificateEncodingException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.CSIUtil.convert", "727");
        }
        catch (java.security.cert.CertificateException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.CSIUtil.convert", "729");
        }
        return null;
    }

    public static X509Certificate convert(java.security.cert.X509Certificate cert) {
        try {
            byte[] encoded = cert.getEncoded();
            return X509Certificate.getInstance(encoded);
        }
        catch (java.security.cert.CertificateEncodingException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.CSIUtil.convert", "740");
        }
        catch (CertificateEncodingException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.CSIUtil.convert", "742");
        }
        catch (CertificateException e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityUtilityImpl.CSIUtil.convert", "744");
        }
        return null;
    }

    public boolean isTrusted(java.security.cert.X509Certificate[] cert) {
        boolean isTrusted = false;
        TrustedIDEvaluator tie = TrustedIDEvaluatorFactory.getInstance();
        if (tie != null) {
            isTrusted = tie.isTrusted(cert);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check for user associated with cert returning " + isTrusted);
            }
        }
        return isTrusted;
    }

    public boolean isTrusted(String name, String password) {
        boolean isTrusted = false;
        TrustedIDEvaluator tie = TrustedIDEvaluatorFactory.getInstance();
        if (tie != null) {
            isTrusted = tie.isTrusted(name, password);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check for " + name + " with password returning " + isTrusted);
            }
        }
        return isTrusted;
    }

    public boolean isTrusted(String name) {
        boolean isTrusted = false;
        TrustedIDEvaluator tie = TrustedIDEvaluatorFactory.getInstance();
        if (tie != null) {
            isTrusted = tie.isTrusted(name);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Check for " + name + " returning " + isTrusted);
            }
        }
        return isTrusted;
    }

    public String get_server_session_hash(ConnectionInformationImpl connectionInfo, int client_context_id) {
        StringBuffer server_session_hash = new StringBuffer(50);
        server_session_hash.append(connectionInfo.getRemoteHost()).append(":").append(connectionInfo.getRemotePort()).append(":").append(connectionInfo.getConnectionCreationTime()).append(":").append(client_context_id);
        return server_session_hash.toString();
    }

    public String read_detailed_message(RequestInfo info) {
        String detailString;
        ServiceContext context = null;
        try {
            context = info.get_reply_service_context(14);
        }
        catch (BAD_PARAM e) {
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.read_detailed_message", "827", this);
        }
        if (context == null) {
            detailString = "";
        } else {
            CDRInputStream in = ORB.createCDRInputStream((ORB)this.orb, (byte[])context.context_data, (int)context.context_data.length);
            in.consumeEndian();
            detailString = in.read_wstring();
        }
        return detailString;
    }

    public short get_message_type(RequestInfo info) {
        ServiceContext sc = null;
        SASContextBody msg = null;
        sc = ((ExtendedServerRequestInfo)info).getRequestServiceContext(15);
        if (sc != null && (msg = this.get_message_from_sc(sc)) != null) {
            return msg.discriminator();
        }
        return -1;
    }

    public byte[] create_gss_initial_context_token(String theOID, OpaqueHolder in_token) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create_gss_initial_context_token", new Object[]{theOID, in_token, this});
        }
        try {
            CSIUtil csiUtil = new CSIUtil();
            if (OID.compareOIDs(theOID, "oid:2.23.130.1.1.1")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected GSSUP mechanism mapped in token base Security Context ");
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "create_gss_initial_context_token: Unexpected GSSUP mechanism mapped in token base Security Context ");
            }
            GSSFactory gssFactory = this.vault.getGSSFactory(theOID);
            byte[] credToken = in_token.value;
            ORB orb = this.getORB();
            if (orb == null && csiUtil.getVault() != null && (orb = csiUtil.getVault().getORB()) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Orb is null.");
                }
                int major = 15;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "create_gss_initial_context_token: Orb is null.");
            }
            Any any = orb.create_any();
            if (any == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Any is null.");
                }
                int major = 15;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "create_gss_initial_context_token: Any is null.");
            }
            OpaqueHelper.insert(any, credToken);
            byte[] encodedToken = null;
            byte[] token = null;
            try {
                encodedToken = this.getCodec().encode_value(any);
                token = gssFactory.encodeGSSToken(encodedToken);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_gss_initial_context_token", "942", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Orb is null.");
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "create_gss_initial_context_token: Orb is null.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create_gss_initial_context_token", token);
            }
            return token;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.create_gss_initial_context_token", "958", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Java exception: " + e.toString());
            }
            int major = 15;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "create_gss_initial_context_token: Java exception: " + e.toString());
        }
    }

    public void parse_gss_initial_context_token(byte[] in_gss_token, OpaqueHolder opaqueToken) throws WSSecurityContextException {
        try {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "parse_gss_initial_context_token", new Object[]{in_gss_token, opaqueToken, this});
            }
            String oidFromGSStoken = GSSFactory.getMechOIDFromGSSToken(in_gss_token);
            String _mechanismType = null;
            MechanismFactory mechFactory = this.getVault().getMechanismFactory();
            if (mechFactory == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MechanismFactory is null.");
                }
                int major = 15;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "MechanismFactory is null.");
            }
            _mechanismType = mechFactory.getMechanismTypeIdentity(oidFromGSStoken);
            String theOID = GSSFactory.mapMechTypeToOid(_mechanismType);
            if (OID.compareOIDs(theOID, "oid:2.23.130.1.1.1")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected GSSUP mechanism mapped in token base Security Context ");
                }
                int major = 12;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: Unexpected GSSUP mechanism mapped in token base Security Context ");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "OID from receiving GSS token: " + oidFromGSStoken + ", OID mapped from Security Context: " + theOID);
            }
            if (!OID.compareOIDs(oidFromGSStoken, theOID)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Mismatched OID from receiving GSS token with respect to token-base Security Context");
                }
                int major = 12;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: Mismatched OID from receiving GSS token with respect to token-base Security Context");
            }
            GSSFactory gssFactory = this.vault.getGSSFactory(theOID);
            byte[] token = null;
            try {
                token = gssFactory.decodeGSSToken(in_gss_token);
            }
            catch (GSSEncodeDecodeException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1038", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "GSSEncodeDecodeException: " + e.toString());
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: GSSEncodeDecodeException: " + e.toString());
            }
            Any any = null;
            try {
                any = this.getCodec().decode_value(token, OpaqueHelper.type());
            }
            catch (TypeMismatch ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1055", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "org.omg.IOP.CodecPackage.TypeMismatch exception: " + ex.toString(), new Object[]{ex});
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: org.omg.IOP.CodecPackage.TypeMismatch exception: " + ex.toString());
            }
            catch (FormatMismatch ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1067", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "org.omg.IOP.CodecPackage.FormatMismatch exception: " + ex.toString(), new Object[]{ex});
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: org.omg.IOP.CodecPackage.FormatMismatch exception: " + ex.toString());
            }
            try {
                opaqueToken.value = OpaqueHelper.extract(any);
            }
            catch (BAD_OPERATION ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1082", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "org.omg.CORBA.BAD_OPERATION exception extracting token from Any: " + ex.toString(), new Object[]{ex});
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: org.omg.CORBA.BAD_OPERATION exception extracting token from Any: " + ex.toString());
            }
            if (opaqueToken.value == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Could not extract token from Any.");
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: Could not extract token from Any.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "parse_gss_initial_context_token");
            }
            return;
        }
        catch (MechanismAmbiguityException mae) {
            Manager.Ffdc.log(mae, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1108", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MechanismAmbiguityException occurred in getMechanismTypeIdentity.", new Object[]{mae});
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gss_initial_context_token", "1114", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "java.lang.Exception: " + e.toString(), new Object[]{e});
            }
            int major = 13;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "CSIUtil.parse_gss_initial_context_token: java.lang.Exception: " + e.toString());
        }
    }

    public void parse_gssup_initial_context_token(byte[] in_token, BasicAuthWithRealm ba) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "parse_gssup_initial_context_token", new Object[]{in_token, ba, this});
        }
        try {
            GSSFactory gssFactory = this.vault.getGSSFactory("oid:2.23.130.1.1.1");
            byte[] token = null;
            try {
                token = gssFactory.decodeGSSToken(in_token);
            }
            catch (GSSEncodeDecodeException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1144", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "GSSEncodeDecodeException: " + e.toString());
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "parse_gssup_initial_context_token: GSSEncodeDecodeException: " + e.toString());
            }
            Any any = null;
            try {
                any = this.getCodec().decode_value(token, InitialContextTokenHelper.type());
            }
            catch (TypeMismatch ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1160", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "org.omg.IOP.CodecPackage.TypeMismatch exception: " + ex.toString(), new Object[]{ex});
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "parse_gssup_initial_context_token: org.omg.IOP.CodecPackage.TypeMismatch exception: " + ex.toString());
            }
            catch (FormatMismatch ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1171", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "org.omg.IOP.CodecPackage.FormatMismatch exception: " + ex.toString(), new Object[]{ex});
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "parse_gssup_initial_context_token: org.omg.IOP.CodecPackage.FormatMismatch exception: " + ex.toString());
            }
            InitialContextToken ict = null;
            try {
                ict = InitialContextTokenHelper.extract(any);
            }
            catch (BAD_OPERATION ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1188", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "org.omg.CORBA.BAD_OPERATION exception extracting token from Any: " + ex.toString(), new Object[]{ex});
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "parse_gssup_initial_context_token: org.omg.CORBA.BAD_OPERATION exception extracting token from Any: " + ex.toString());
            }
            String target_name = null;
            try {
                target_name = gssFactory.decodeExportedTargetName(ict.target_name);
            }
            catch (GSSEncodeDecodeException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1206", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "GSSEncodeDecodeException: " + e.toString());
                }
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "parse_gssup_initial_context_token: GSSEncodeDecodeException: " + e.toString());
            }
            try {
                String user_realm = new String(ict.username, "UTF8");
                String password = new String(ict.password, "UTF8");
                String username = "";
                String realm = "";
                Object user_realm_token = null;
                if (user_realm != null && !user_realm.equals("")) {
                    int delimit = user_realm.lastIndexOf("@");
                    if (delimit < 0) {
                        username = user_realm;
                        realm = target_name;
                    } else {
                        username = user_realm.substring(0, delimit);
                        realm = user_realm.substring(delimit + 1);
                    }
                }
                ba.setUserid(username);
                ba.setPassword(password);
                ba.setRealm(target_name);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Security name from GSS token: " + ba.getUserid() + "@" + ba.getRealm() + ", password: " + StringUtils.mask(ba.getPassword()));
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "parse_gssup_initial_context_token");
                }
                return;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1253", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "java.lang.Exception: " + e.toString(), new Object[]{e});
                }
                int major = 13;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "parse_gssup_initial_context_token: java.lang.Exception: " + e.toString());
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.parse_gssup_initial_context_token", "1265", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "java.lang.Exception: " + e.toString(), new Object[]{e});
            }
            int major = 13;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "parse_gssup_initial_context_token: java.lang.Exception: " + e.toString());
        }
    }

    public static String clean(String inString) {
        String outString = null;
        if (inString != null && ((outString = inString.trim()).startsWith("\"") && outString.endsWith("\"") || outString.startsWith("'") && outString.endsWith("'"))) {
            outString = outString.substring(1, outString.length() - 1).trim();
        }
        return outString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serializeRootException() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeRootException", this);
        }
        byte[] error_token = this.nullByteArray;
        Throwable t = this.getCurrent().getRootException();
        Tr.debug(tc, "Root exception", new Object[]{t});
        if (t != null) {
            Throwable temp = t;
            int i = 0;
            while (temp != null) {
                while (temp != null && temp instanceof WSLoginFailedException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "instanceof WSLoginFailedException");
                    }
                    if ((temp = ((WSLoginFailedException)temp).getCause()) != null) {
                        t = temp;
                    }
                    if (i++ <= 10) continue;
                }
                while (temp != null && temp instanceof RemoteException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "instanceof java.rmi.RemoteException");
                    }
                    if ((temp = ((RemoteException)temp).detail) != null) {
                        t = temp;
                    }
                    if (i++ <= 10) continue;
                }
                while (temp != null && temp instanceof WSSecurityException) {
                    ArrayList l;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "instanceof WSSecurityException");
                    }
                    if ((l = ((WSSecurityException)temp).getExceptions()) != null && l.size() > 0 && (temp = (Throwable)l.get(0)) != null) {
                        t = temp;
                    }
                    if (i++ <= 10) continue;
                    break;
                }
                if (i++ <= 10) continue;
            }
        }
        if (t != null) {
            ByteArrayOutputStream baos = null;
            ObjectOutputStream oos = null;
            try {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(t);
                oos.flush();
                error_token = baos.toByteArray();
                if (tc.isDebugEnabled()) {
                    if (error_token != null) {
                        Tr.debug(tc, "Serializing root cause exception, byte array size: " + error_token.length, new Object[]{t});
                    } else {
                        Tr.debug(tc, "Error serializing root cause exception, byte array = 0", new Object[]{t});
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.serializeRootException", "1386", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception serializing the root cause exception: " + e.getMessage(), new Object[]{e});
                }
            }
            finally {
                try {
                    if (baos != null) {
                        baos.close();
                    }
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeRootException", error_token);
        }
        return error_token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserializeRootException(byte[] error_token) {
        Throwable t = null;
        if (error_token != null && !Arrays.equals(error_token, this.nullByteArray)) {
            ByteArrayInputStream bais = null;
            ObjectInputStream ois = null;
            try {
                bais = new ByteArrayInputStream(error_token);
                ois = new ObjectInputStream(bais);
                t = (Throwable)ois.readObject();
                if (tc.isDebugEnabled()) {
                    if (t != null) {
                        Tr.debug(tc, "Deserializing root cause exception, exception = " + t.getMessage(), new Object[]{t});
                    } else {
                        Tr.debug(tc, "Error deserializing root cause exception, t = null", new Object[]{t});
                    }
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.deserializeRootException", "1438", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception serializing the root cause exception: " + e.getMessage(), new Object[]{e});
                }
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (Exception e) {}
            }
            this.getCurrent().setRootException(t);
        }
    }

    public ContextManager getContextManager() {
        return ContextManagerFactory.getInstance();
    }

    public void setUnauthenticatedToNullIfNeeded() {
        if (SecurityObjectLocator.getAdminData().getBoolean("isServerProcess")) {
            try {
                Subject subject = this.getContextManager().getInvocationSubject();
                WSCredential wsCred = SubjectHelper.getWSCredentialFromSubject(subject);
                if (wsCred != null && wsCred.isUnauthenticated()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting invocation cred to NULL.");
                    }
                    this.getContextManager().setInvocationSubject(null);
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityUtilityImpl.CSIUtil.setUnauthenticatedToNullIfNeeded", "1497", this);
            }
        }
    }

    public java.security.cert.X509Certificate[] convertJavaxToJavaCerts(X509Certificate[] temp_cert_chain) {
        java.security.cert.X509Certificate[] cert_chain = null;
        if (temp_cert_chain != null) {
            cert_chain = new java.security.cert.X509Certificate[temp_cert_chain.length];
            for (int i = 0; i < temp_cert_chain.length; ++i) {
                cert_chain[i] = CSIUtil.convert(temp_cert_chain[i]);
            }
            if (tc.isDebugEnabled() && cert_chain != null) {
                Tr.debug(tc, "Transport layer certificate chain found.");
            }
            if (tc.isDebugEnabled() && cert_chain != null) {
                for (int j = 0; j < cert_chain.length; ++j) {
                    Tr.debug(tc, "   Certificate[" + j + "]: " + cert_chain[j].toString());
                }
            }
        }
        return cert_chain;
    }

    public boolean isCORBAAuthRequired() {
        return this.getContextManager().isAuthenticateSpecialMethodsEnabled() && this.getContextManager().isSecurityServiceStarted();
    }
}

