/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import java.util.Hashtable;

public class AuthenticationTarget {
    public static final int Unknown = 0;
    public static final String UnknownString = "unknown";
    public static final int LTPA = 1;
    public static final String LTPAString = "ltpa";
    public static final int LocalOS = 2;
    public static final String LocalOSString = "localos";
    public static final int DCE = 3;
    public static final String DCEString = "dce";
    public static final int BasicAuth = 4;
    public static final String BasicAuthString = "basicauth";
    public static final int DigitalCerts = 5;
    public static final String DigitalCertsString = "digitalcerts";
    public static final int KRB5 = 6;
    public static final String KRB5String = "krb5";
    public static final int SWAM = 7;
    public static final String SWAMString = "swam";
    public static final int RSAToken = 8;
    public static final String RSATokenString = "rsatoken";
    public static final int Custom = 9;
    public static final String CustomString = "custom";
    private static final TraceComponent tc = Tr.register(AuthenticationTarget.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    public static Hashtable<Integer, String> strings = new Hashtable();
    public static Hashtable<String, Integer> ids = new Hashtable();

    public final String authTargetToOid(int in_authTarget) {
        String theoid = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (in_authTarget == 9) {
            theoid = csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID");
        } else if (in_authTarget == 4) {
            theoid = "oid:2.23.130.1.1.1";
        } else if (in_authTarget == 1) {
            theoid = "oid:1.3.18.0.2.30.2";
        } else if (in_authTarget == 6) {
            theoid = "oid:1.2.840.113554.1.2.2";
        } else if (in_authTarget == 2) {
            theoid = "No OID for this mechanism";
        } else {
            switch (csiv2.getInteger("com.ibm.CORBA.authenticationTarget")) {
                case 9: {
                    theoid = csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID");
                    break;
                }
                case 4: {
                    theoid = "oid:2.23.130.1.1.1";
                    break;
                }
                case 1: {
                    theoid = "oid:1.3.18.0.2.30.2";
                    break;
                }
                case 6: {
                    theoid = "oid:1.2.840.113554.1.2.2";
                    break;
                }
                case 2: {
                    theoid = "No OID for this mechanism";
                    break;
                }
                default: {
                    theoid = "oid:2.23.130.1.1.1";
                }
            }
        }
        return theoid;
    }

    public final String authTargetToMechType(int in_authTarget) {
        String theMechType = UnknownString;
        switch (in_authTarget) {
            case 6: {
                theMechType = KRB5String;
                break;
            }
            case 1: {
                theMechType = LTPAString;
                break;
            }
            case 4: {
                theMechType = BasicAuthString;
                break;
            }
            case 8: {
                theMechType = RSATokenString;
                break;
            }
            case 9: {
                theMechType = CustomString;
            }
        }
        return theMechType;
    }

    public final int authTargetToMechType(String auth) {
        int mechType = 0;
        if ((auth = auth.toLowerCase()).equals(LTPAString)) {
            mechType = 1;
        } else if (auth.equals(LocalOSString)) {
            mechType = 2;
        } else if (auth.equals(DCEString)) {
            mechType = 3;
        } else if (auth.equals(4)) {
            mechType = 4;
        } else if (auth.equals(DigitalCertsString)) {
            mechType = 5;
        } else if (auth.equals(KRB5String)) {
            mechType = 6;
        } else if (auth.equals(RSATokenString)) {
            mechType = 8;
        } else if (auth.equals(CustomString)) {
            mechType = 9;
        }
        return mechType;
    }

    public final int oidToAuthTarget(String in_OID) {
        int authtarget = 0;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (in_OID != null && in_OID.length() != 0) {
            if (OID.compareOIDs(in_OID, csiv2.getString("com.ibm.CSI.WSSecurityContextCustomOID"))) {
                authtarget = 9;
            } else if (OID.compareOIDs(in_OID, "oid:2.23.130.1.1.1")) {
                authtarget = 4;
            } else if (OID.compareOIDs(in_OID, "oid:1.3.18.0.2.30.2")) {
                authtarget = 1;
            } else if (OID.compareOIDs(in_OID, "oid:1.2.840.113554.1.2.2")) {
                authtarget = 6;
            } else if (OID.compareOIDs(in_OID, "No OID for this mechanism")) {
                authtarget = 2;
            }
        } else {
            authtarget = csiv2.getInteger("com.ibm.CORBA.authenticationTarget");
        }
        return authtarget;
    }

    public final int mechtypeToAuthTarget(String mechType) throws MechanismAmbiguityException {
        if (mechType != null && mechType.length() != 0) {
            if (mechType.equalsIgnoreCase(VaultConstants.CLIENT_CERT_MECH_TYPE)) {
                return SecurityObjectLocator.getCSIv2Config().getInteger("com.ibm.CORBA.authenticationTarget");
            }
            if (mechType.equalsIgnoreCase(VaultConstants.LTPA_MECH_TYPE)) {
                return 1;
            }
            if (mechType.equalsIgnoreCase("1.3")) {
                return 1;
            }
            if (mechType.equalsIgnoreCase("5.1")) {
                return 1;
            }
            if (mechType.equalsIgnoreCase(VaultConstants.CUSTOM_MECH_TYPE)) {
                return 9;
            }
            if (mechType.equalsIgnoreCase("1.7")) {
                return 9;
            }
            if (mechType.equalsIgnoreCase("5.9")) {
                return 9;
            }
            if (mechType.equalsIgnoreCase(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                return 2;
            }
            if (mechType.equalsIgnoreCase("1.4")) {
                return 2;
            }
            if (mechType.equalsIgnoreCase("5.2")) {
                return 2;
            }
            if (mechType.equalsIgnoreCase(VaultConstants.KRB5_MECH_TYPE)) {
                return 6;
            }
            if (mechType.equalsIgnoreCase("1.6")) {
                return 6;
            }
            if (mechType.equalsIgnoreCase("5.8")) {
                return 6;
            }
            if (mechType.equalsIgnoreCase("4.1")) {
                return 6;
            }
            if (mechType.equalsIgnoreCase(VaultConstants.GSSUP_MECH_TYPE) || mechType.equalsIgnoreCase(VaultConstants.BASIC_AUTH_MECH_TYPE)) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("1.5")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("1.5.1")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("1.5.2")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("1.5.4")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("5.7.4")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("5.7.1")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("5.7.2")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("5.7.5")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("1.1")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("1.1.1")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("1.1.2")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("5.6")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("5.3")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase("5.4")) {
                return 4;
            }
            if (mechType.equalsIgnoreCase(SWAMString)) {
                return 7;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unknown security mechanism type.");
            }
            throw new MechanismAmbiguityException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Unknown security mechanism type.");
        }
        throw new MechanismAmbiguityException();
    }

    static {
        strings.put(new Integer(0), UnknownString);
        strings.put(new Integer(1), LTPAString);
        strings.put(new Integer(2), LocalOSString);
        strings.put(new Integer(3), DCEString);
        strings.put(new Integer(4), BasicAuthString);
        strings.put(new Integer(5), DigitalCertsString);
        strings.put(new Integer(6), KRB5String);
        strings.put(new Integer(7), SWAMString);
        strings.put(new Integer(9), CustomString);
        ids.put(UnknownString, new Integer(0));
        ids.put(LTPAString, new Integer(1));
        ids.put(LocalOSString, new Integer(2));
        ids.put(DCEString, new Integer(3));
        ids.put(BasicAuthString, new Integer(4));
        ids.put(DigitalCertsString, new Integer(5));
        ids.put(KRB5String, new Integer(6));
        ids.put(SWAMString, new Integer(7));
        ids.put(CustomString, new Integer(9));
    }
}

