/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectGSSUPImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSPasswordCheckFailedException;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.Security.OpaqueHolder;
import org.omg.SecurityLevel2.CredentialsHolder;

public final class WSSecurityContextImpl
implements WSSecurityContext {
    private GSSFactory _gFactory = new GSSFactory("oid:2.23.130.1.1.1");
    private ORB _orb = null;
    private VaultImpl vault = null;
    private static final TraceComponent tc = Tr.register(WSSecurityContextImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public WSSecurityContextImpl() {
        if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
            this.vault = VaultImpl.getInstance();
            this._orb = this.vault.getORB();
        } else {
            this._orb = GlobalORBFactory.globalORB();
        }
    }

    public byte[] initSecContext(WSCredential cred, String targetServerName, String realm) throws WSSecurityContextException {
        Subject subject = SubjectHelper.createSubjectFromWSCredential(cred);
        String authMechOid = null;
        try {
            authMechOid = cred.getOID();
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.initSecContext(subject, targetServerName, realm, authMechOid);
    }

    public byte[] initSecContext(Subject subject, String serverName, String in_realm) throws WSSecurityContextException {
        String authMechOid = null;
        WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
        try {
            if (cred != null) {
                authMechOid = cred.getOID();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.initSecContext(subject, serverName, in_realm, authMechOid);
    }

    public byte[] initSecContext(Subject subject, String serverName, String in_realm, String authMechOid) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initSecContext", new Object[]{subject, serverName, in_realm, this});
        }
        try {
            CSIUtil csiUtil = new CSIUtil();
            String realm = null;
            WSPrincipal wsPrincipal = SubjectHelper.getPrincipalFromSubject(subject);
            if (wsPrincipal != null) {
                realm = RealmSecurityName.getRealm(((WSPrincipalImpl)wsPrincipal).getName());
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "realm retrieved off of the subject: " + realm);
                }
                if (realm == null || realm.equals("") || realm.equalsIgnoreCase("<default>")) {
                    realm = null;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "retrieved a null wsPrincipal from subject");
            }
            if (realm == null) {
                realm = RealmSecurityName.getRealm(in_realm);
            }
            if (realm == null || realm.equals("")) {
                realm = in_realm;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Data to be set on GSSUP token: Realm = " + realm + ", serverName = " + serverName);
            }
            InitialContextToken ict = new InitialContextToken();
            WSCredential cred = SubjectHelper.getWSCredentialFromSubject(subject);
            String username = RealmSecurityName.getSecurityName(cred.getRealmSecurityName());
            try {
                ict.target_name = this._gFactory.encodeExportedTargetName(realm);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.initSecContext", "169", this);
                Tr.debug(tc, "Unable to get target_name from passed-in target name.  Original exception = " + e);
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "Unable to get target_name from passed-in target name.  Original exception = " + e);
            }
            String scoped_username = null;
            scoped_username = (realm == null || realm.equals("")) && username != null && !username.equals("") ? username : ((username == null || username.equals("")) && realm != null && !realm.equals("") ? "@" + realm : (username != null && !username.equals("") && realm != null && !realm.equals("") ? username + "@" + realm : ""));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scoped username in GSSUP token: " + scoped_username);
            }
            ict.username = scoped_username.getBytes("UTF8");
            String password = StringBytesConversion.getConvertedString(cred.getCredentialToken());
            if (password == null) {
                password = "";
            }
            ict.password = password.getBytes("UTF8");
            Any any = this._orb.create_any();
            if (any == null) {
                Tr.debug(tc, "Any is NULL.");
                int major = 14;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "Any is NULL.");
            }
            InitialContextTokenHelper.insert(any, ict);
            byte[] encodedToken = null;
            try {
                encodedToken = csiUtil.getCodec().encode_value(any);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.initSecContext", "223", this);
                Tr.debug(tc, "Exception getting codec factory and encoding Any.  Original exception: " + e);
                int major = 18;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "Exception getting codec factory and encoding Any.  Original exception: " + e);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initSecContext", encodedToken);
            }
            return encodedToken;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.initSecContext", "239", this);
            Tr.debug(tc, "Java exception in initSecContext:  Original exception = " + e);
            int major = 13;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Java exception in initSecContext:  Original exception = " + e);
        }
    }

    public WSSecurityContextResult acceptSecContext(byte[] gssInitToken) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext", new Object[]{gssInitToken, this});
        }
        WSSecurityContextResult res = this.acceptSecContext(gssInitToken, null, null);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext(gssInitToken)");
        }
        return res;
    }

    public WSSecurityContextResult acceptSecContext(byte[] gssInitToken, Map appContext) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext", new Object[]{gssInitToken, appContext, this});
        }
        WSSecurityContextResult res = this.acceptSecContext(gssInitToken, appContext, null);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext(gssInitToken)");
        }
        return res;
    }

    public WSSecurityContextResult acceptSecContext(byte[] gssInitToken, Map appContext, String authMechOid) throws WSSecurityContextException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "acceptSecContext", new Object[]{gssInitToken, appContext, this});
        }
        Object cred = null;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        boolean method2 = false;
        Object privileges = null;
        CredentialsHolder credsHolder = new CredentialsHolder();
        OpaqueHolder continuation_data = new OpaqueHolder();
        OpaqueHolder auth_specific_data = new OpaqueHolder();
        Object authStat = null;
        try {
            CSIUtil csiUtil = new CSIUtil();
            Any any = csiUtil.getCodec().decode_value(gssInitToken, InitialContextTokenHelper.type());
            InitialContextToken ict = InitialContextTokenHelper.extract(any);
            String target_name = this._gFactory.decodeExportedTargetName(ict.target_name);
            String user_realm = new String(ict.username, "UTF8");
            String password = new String(ict.password, "UTF8");
            String username = "";
            String realm = "";
            Object user_realm_token = null;
            if (user_realm != null && !user_realm.equals("")) {
                int delimit = user_realm.lastIndexOf("@");
                if (delimit < 0) {
                    username = user_realm;
                    realm = RealmSecurityName.getRealm(target_name);
                    if (realm == null || realm.equals("")) {
                        realm = target_name;
                    }
                } else {
                    username = user_realm.substring(0, delimit);
                    realm = user_realm.substring(delimit + 1);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Security name for WS credential: " + username + "@" + target_name + ", password: " + StringUtils.mask(password));
            }
            if (username == null || username.length() < 1) {
                Tr.debug(tc, "Userid is null.");
                int major = 15;
                int minor = 0;
                throw new WSSecurityContextException(major, minor, "Userid is null.");
            }
            if (username.equals("UNAUTHENTICATED")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received unauthenticated GSSUP token.");
                }
                return new WSSecurityContextResult(null, null);
            }
            Subject subject = null;
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            try {
                subject = ContextManagerFactory.getInstance().login(realm, username, password, csiv2.getString("com.ibm.CSI.rmiInboundLoginConfig"), null, null, appContext);
            }
            catch (WSLoginFailedException le) {
                int majorCode = 0;
                WSPasswordCheckFailedException WSEx = this.getWSPasswordCheckFailedException(le);
                if (WSEx != null) {
                    if (WSEx.isInvalidUserID()) {
                        majorCode = 1;
                    } else if (WSEx.isInvalidPassword()) {
                        majorCode = 2;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isInvalidUserID:" + WSEx.isInvalidUserID() + " isInvalidPassword:" + WSEx.isInvalidPassword());
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSLoginFailedException occurred in acceptSecContext: " + le.getMessage(), new Object[]{le});
                }
                Manager.Ffdc.log(le, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "380", this);
                throw new WSSecurityContextException(majorCode, 0, le.getMessage(), le);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred in acceptSecContext: " + e.getMessage(), new Object[]{e});
                }
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "388", this);
                throw new WSSecurityContextException(0, 0, e.getMessage(), e);
            }
            if (subject != null) {
                boolean isSWAM;
                boolean bl = isSWAM = csiv2.getInteger("com.ibm.CORBA.authenticationTarget") == 7;
                if (csiv2.getBoolean("com.ibm.CORBA.delegateBasicAuth") && (isSWAM || csiv2.getInteger("com.ibm.CORBA.authenticationTarget") == 2)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Caching basicauth subject");
                    }
                    if (this.vault != null) {
                        Subject basicauth_subject = SubjectHelper.createBasicAuthSubject(realm, username, password);
                        this.vault.addBasicAuthSubject(realm + "/" + username, basicauth_subject);
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "acceptSecContext");
                }
                return new WSSecurityContextResult(null, subject);
            }
            int major = 0;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Authentication Failed.");
        }
        catch (WSSecurityContextException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "423", this);
            Tr.debug(tc, "Caught WSSecurityContextException, reason: " + ex.getMessage(), new Object[]{ex});
            throw ex;
        }
        catch (GSSEncodeDecodeException ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "430", this);
            Tr.debug(tc, "GSSEncodeDecodeException occurred, reason: " + ex.getMessage(), new Object[]{ex});
            int major = 18;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "GSSEncodeDecodeException occurred, reason: " + ex.getMessage());
        }
        catch (BAD_OPERATION ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "439", this);
            Tr.debug(tc, "Corba BAD_OPERATION exception occurred, reason: " + ex.getMessage(), new Object[]{ex});
            int major = 9;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Corba BAD_OPERATION exception occurred, reason: " + ex.getMessage());
        }
        catch (TypeMismatch ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "448", this);
            Tr.debug(tc, "Codec Factory Type Mismatch exception occurred.", new Object[]{ex});
            int major = 18;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Codec Factory Type Mismatch exception occurred.");
        }
        catch (FormatMismatch ex) {
            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "457", this);
            Tr.debug(tc, "Codec Factory FormatMismatch exception occurred.", new Object[]{ex});
            int major = 18;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Codec Factory FormatMismatch exception occurred.");
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.WSSecurityContextImpl.acceptSecContext", "466", this);
            Tr.debug(tc, "Java exception occurred.", new Object[]{e});
            int major = 13;
            int minor = 0;
            throw new WSSecurityContextException(major, minor, "Java exception occurred.");
        }
    }

    public void completeSecContext(byte[] final_token) {
    }

    public void dispose() {
    }

    private WSPasswordCheckFailedException getWSPasswordCheckFailedException(WSLoginFailedException le) {
        ArrayList innerExsWSLogin = le.getExceptions();
        WSPasswordCheckFailedException WSEx = null;
        if (innerExsWSLogin != null) {
            for (int i = 0; i < innerExsWSLogin.size(); ++i) {
                ArrayList innerExsPWFail;
                Throwable innerEx = (Throwable)innerExsWSLogin.get(i);
                if (!(innerEx instanceof PasswordCheckFailedException) || (innerExsPWFail = ((PasswordCheckFailedException)innerEx).getExceptions()) == null) continue;
                for (int j = 0; j < innerExsPWFail.size(); ++j) {
                    Throwable innerEx2 = (Throwable)innerExsPWFail.get(j);
                    if (!(innerEx2 instanceof WSPasswordCheckFailedException)) continue;
                    WSEx = (WSPasswordCheckFailedException)innerEx2;
                    return WSEx;
                }
            }
        }
        return WSEx;
    }
}

