/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectGSSUPImpl;

import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.PrincipalAuthFailReason;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponentHolder;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.MechanismAmbiguityException;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.WSSecurityContextFactory;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSSecurityContext;
import com.ibm.websphere.security.auth.WSSecurityContextException;
import com.ibm.websphere.security.auth.WSSecurityContextResult;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CSI.AuthorizationElement;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.GSSUP.InitialContextToken;
import org.omg.GSSUP.InitialContextTokenHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.RequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.Security.AssociationStatus;
import org.omg.Security.AuthenticationStatus;
import org.omg.Security.OpaqueHolder;

public class SecurityContextImpl
extends com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl {
    private static final long serialVersionUID = -1105303684764338362L;
    private static final TraceComponent tc = Tr.register(SecurityContextImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    ORB orb;
    Codec codec;
    VaultImpl vault;
    String mechType;
    GSSFactory _gFactory;

    private SecurityContextImpl() {
        this.orb = null;
        this.codec = null;
        this.vault = null;
        this.mechType = null;
        this._gFactory = null;
    }

    public SecurityContextImpl(VaultImpl in_vault, String in_connectionKey) {
        block4: {
            super(in_vault, in_connectionKey);
            this.orb = null;
            this.codec = null;
            this.vault = null;
            this.mechType = null;
            this._gFactory = null;
            if (in_vault != null) {
                this.vault = in_vault;
                this.orb = in_vault.getORB();
                MechanismFactory mechFactory = in_vault.getMechanismFactory();
                this._gFactory = this.vault.getGSSFactory("oid:2.23.130.1.1.1");
                try {
                    if (mechFactory != null) {
                        this._mechanismType = mechFactory.getMechanismTypeIdentity();
                    }
                }
                catch (MechanismAmbiguityException mae) {
                    Manager.Ffdc.log(mae, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.SecurityContextImpl", "144", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "MechanismAmbiguityException occurred in getMechanismTypeIdentity.", new Object[]{mae});
                }
            }
        }
    }

    public SecurityContextImpl(VaultImpl in_vault, String in_connectionKey, String in_MechType) {
        block4: {
            super(in_vault, in_connectionKey);
            this.orb = null;
            this.codec = null;
            this.vault = null;
            this.mechType = null;
            this._gFactory = null;
            if (in_vault != null) {
                this.vault = in_vault;
                MechanismFactory mechFactory = in_vault.getMechanismFactory();
                try {
                    if (mechFactory != null) {
                        this._mechanismType = mechFactory.getMechanismTypeIdentity();
                    }
                }
                catch (MechanismAmbiguityException mae) {
                    Manager.Ffdc.log(mae, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.SecurityContextImpl", "171", this);
                    if (!tc.isDebugEnabled()) break block4;
                    Tr.debug(tc, "MechanismAmbiguityException occurred in getMechanismTypeIdentity.", new Object[]{mae});
                }
            }
        }
    }

    public synchronized AssociationStatus csi_continue_security_context(ClientRequestInfo info, com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl secCtx) {
        String logMsg = null;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_continue_security_context", new Object[]{info, secCtx, this});
        }
        ServiceContext sc = null;
        CSIUtil csiUtil = new CSIUtil();
        SASContextBody msg = null;
        switch (info.reply_status()) {
            case 2: {
                try {
                    Any exception = info.received_exception();
                    if (tc.isDebugEnabled()) {
                        logMsg = "A USER_EXCEPTION has been received: " + exception.type().id();
                        Tr.debug(tc, logMsg);
                    }
                }
                catch (BadKind bk) {
                    Manager.Ffdc.log(bk, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_continue_security_context", "219", this);
                }
            }
            case 0: 
            case 3: 
            case 4: {
                ContextError ce;
                sc = csiUtil.get_sc_from_reply((RequestInfo)info);
                if (sc != null) {
                    msg = csiUtil.get_message_from_sc(sc);
                }
                if (msg != null && msg.discriminator() == 1) {
                    CompleteEstablishContext cec = msg.complete_msg();
                    csiUtil.print_cec_message(cec, "csi_continue_security_context");
                    WSSecurityContext wsSecContext = null;
                    wsSecContext = csiUtil.getCurrent().getWSSecurityContext();
                    if (wsSecContext == null) break;
                    try {
                        wsSecContext.completeSecContext(cec.final_context_token);
                        wsSecContext.dispose();
                        wsSecContext = null;
                    }
                    catch (WSSecurityContextException ex1) {
                        Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_continue_security_context", "251", this);
                        logMsg = "Caught WSSecurityContextException in WSSecurityContext.completeSecContext(), reason: " + ex1.toString();
                        Tr.debug(tc, logMsg, new Object[]{ex1});
                        PrincipalAuthFailReason.map_auth_fail_to_minor_code(ex1.getMajor(), StringBytesConversion.getConvertedBytes(logMsg));
                    }
                    break;
                }
                if (msg == null || msg.discriminator() != 4 || (ce = msg.error_msg()) == null) break;
                csiUtil.deserializeRootException(ce.error_token);
                csiUtil.print_ce_message(ce, "csi_continue_security_context");
                break;
            }
            case 1: {
                ContextError ce;
                try {
                    Any exception = info.received_exception();
                    SystemException ex = ((ExtendedClientRequestInfo)info).getSystemException();
                    if (tc.isDebugEnabled()) {
                        logMsg = "A SYSTEM_EXCEPTION has been received: " + exception.type().id() + ", Minor code: " + Long.toHexString(ex.minor);
                        Tr.debug(tc, logMsg);
                    }
                }
                catch (BadKind bk) {
                    Manager.Ffdc.log(bk, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_continue_security_context", "288", this);
                }
                sc = csiUtil.get_sc_from_reply((RequestInfo)info);
                if (sc == null) {
                    return AssociationStatus.SecAssocFailure;
                }
                msg = csiUtil.get_message_from_sc(sc);
                if (msg == null || msg.discriminator() != 4 || (ce = msg.error_msg()) == null) break;
                csiUtil.deserializeRootException(ce.error_token);
                csiUtil.print_ce_message(ce, "csi_continue_security_context");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_continue_security_context", AssociationStatus.SecAssocSuccess);
        }
        return AssociationStatus.SecAssocSuccess;
    }

    public synchronized void csi_initialize(byte[] chan_bindings, byte[] in_token, X509Certificate[] cert_chain, OpaqueHolder out_token) throws WSLoginFailedException {
        this.csi_initialize(chan_bindings, in_token, cert_chain, out_token, null);
    }

    /*
     * Loose catch block
     */
    public synchronized void csi_initialize(byte[] chan_bindings, byte[] in_token, X509Certificate[] cert_chain, OpaqueHolder out_token, final Map appContext) throws WSLoginFailedException {
        block37: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "csi_initialize", new Object[]{chan_bindings, in_token, cert_chain, out_token, this});
            }
            String logMsg = "";
            OpaqueHolder continuation_data = new OpaqueHolder();
            OpaqueHolder auth_specific_data = new OpaqueHolder();
            byte[] authFailReason = new byte[]{100};
            auth_specific_data.value = authFailReason;
            continuation_data.value = StringBytesConversion.getConvertedBytes(logMsg);
            AuthenticationStatus authStat = null;
            Subject subject = null;
            final ContextManager ctxMgr = ContextManagerFactory.getInstance();
            String realm = ctxMgr.getDefaultRealm();
            try {
                block39: {
                    block38: {
                        WSSecurityContext wsSecContext;
                        block36: {
                            if (tc.isDebugEnabled()) {
                                logMsg = "Setting identityName: " + this.getIdentityName();
                                Tr.debug(tc, logMsg);
                            }
                            if (!this.getIdentityName().equals("ClientAuthenticationToken")) break block38;
                            wsSecContext = null;
                            WSSecurityContextFactory wsFactory = WSSecurityContextFactory.getInstance();
                            wsSecContext = wsFactory.createContext("oid:2.23.130.1.1.1");
                            if (this._gFactory == null) {
                                this._gFactory = this.vault.getGSSFactory("oid:2.23.130.1.1.1");
                            }
                            byte[] gssInitToken = this._gFactory.decodeGSSToken(in_token);
                            WSSecurityContextResult wsresult = null;
                            wsresult = appContext == null ? wsSecContext.acceptSecContext(gssInitToken) : wsSecContext.acceptSecContext(gssInitToken, appContext);
                            if (wsresult != null && wsresult.getSubject() != null) {
                                subject = wsresult.getSubject();
                                if (wsresult.getFinalToken() != null) {
                                    this.setFinalToken(wsresult.getFinalToken());
                                }
                                this._contextState = 3;
                                this._principalAuthFailReason = (byte)100;
                                this._clientSubject = subject;
                                this._targetSubject = null;
                                this._mechanismType = this.mechType;
                                if (tc.isDebugEnabled()) {
                                    logMsg = "Authentication success";
                                    Tr.debug(tc, logMsg);
                                }
                                break block36;
                            }
                            if (tc.isDebugEnabled()) {
                                logMsg = "Subject returned from acceptSecContext is NULL, must be unuathenticated cred.";
                                Tr.debug(tc, logMsg);
                            }
                            subject = SubjectHelper.createUnauthenticatedSubject();
                            this._contextState = 3;
                            this._principalAuthFailReason = (byte)100;
                            this._clientSubject = subject;
                            this._targetSubject = null;
                            this._mechanismType = this.mechType;
                        }
                        Object var19_30 = null;
                        auth_specific_data.value = authFailReason;
                        continuation_data.value = StringBytesConversion.getConvertedBytes(logMsg);
                        if (authStat == AuthenticationStatus.SecAuthFailure) {
                            Tr.debug(tc, logMsg);
                        }
                        try {
                            wsSecContext.dispose();
                            wsSecContext = null;
                        }
                        catch (WSSecurityContextException ex1) {
                            Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "482", this);
                            authStat = AuthenticationStatus.SecAuthFailure;
                            authFailReason[0] = (byte)ex1.getMajor();
                            logMsg = "Caught WSSecurityContextException in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                            Tr.debug(tc, logMsg, new Object[]{ex1});
                        }
                        break block39;
                        {
                            catch (WSSecurityContextException ex1) {
                                Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "446", this);
                                authStat = AuthenticationStatus.SecAuthFailure;
                                authFailReason[0] = (byte)ex1.getMajor();
                                logMsg = "Caught WSSecurityContextException in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                                Tr.debug(tc, logMsg, new Object[]{ex1});
                                throw ex1;
                            }
                            catch (Exception ex1) {
                                Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "456", this);
                                authStat = AuthenticationStatus.SecAuthFailure;
                                authFailReason[0] = 13;
                                logMsg = "Caught Java exception in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                                Tr.debug(tc, logMsg, new Object[]{ex1});
                                throw ex1;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var19_31 = null;
                            auth_specific_data.value = authFailReason;
                            continuation_data.value = StringBytesConversion.getConvertedBytes(logMsg);
                            if (authStat == AuthenticationStatus.SecAuthFailure) {
                                Tr.debug(tc, logMsg);
                            }
                            try {
                                wsSecContext.dispose();
                                wsSecContext = null;
                            }
                            catch (WSSecurityContextException ex1) {
                                Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "482", this);
                                authStat = AuthenticationStatus.SecAuthFailure;
                                authFailReason[0] = (byte)ex1.getMajor();
                                logMsg = "Caught WSSecurityContextException in WSSecurityContext.acceptSecContext(), reason: " + ex1.toString();
                                Tr.debug(tc, logMsg, new Object[]{ex1});
                            }
                            throw throwable;
                        }
                    }
                    if (this.getIdentityName().equals("ClientCertificate") && cert_chain != null) {
                        if (tc.isDebugEnabled()) {
                            logMsg = "ClientCertificate == " + cert_chain[0].toString();
                            Tr.debug(tc, logMsg);
                        }
                        final String identityName = this.getIdentityName();
                        final byte[] identityValue = this.getIdentityValue();
                        final String _realm = realm;
                        final X509Certificate[] cert_chain_final = cert_chain;
                        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                                CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                                Subject subject = ctxMgr.login(_realm, cert_chain_final, csiv2.getString("com.ibm.CSI.rmiInboundLoginConfig"), null, null, appContext);
                                if (subject != null) {
                                    WSCredential credential = (WSCredential)subject.getPublicCredentials().iterator().next();
                                    if (identityName != null) {
                                        credential.set("wssecurity.identity_name", identityName);
                                        credential.set("wssecurity.identity_value", identityValue);
                                    }
                                    return subject;
                                }
                                return null;
                            }
                        };
                        try {
                            subject = (Subject)AccessController.doPrivileged(action);
                            this._contextState = 3;
                            this._principalAuthFailReason = (byte)100;
                            this._clientSubject = subject;
                            this._targetSubject = null;
                            this._mechanismType = this.mechType;
                        }
                        catch (PrivilegedActionException e) {
                            if (tc.isDebugEnabled()) {
                                logMsg = "Exception occurred: " + e.getException().getMessage();
                                Tr.debug(tc, logMsg);
                            }
                            Manager.Ffdc.log(e.getException(), this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "548", this);
                            throw e.getException();
                        }
                    }
                    if (this.getIdentityName().startsWith("ITT") || this.getIdentityName().equals("TransportLayerData") && in_token != null) {
                        String userId = StringBytesConversion.getConvertedString(in_token);
                        if (userId == null || userId.length() < 1) {
                            logMsg = "IdentityAssertion Security name == NULL.";
                            Tr.debug(tc, logMsg);
                            this._contextState = 4;
                            this._principalAuthFailReason = 1;
                            this._principalAuthFailDetail = StringBytesConversion.getConvertedBytes(logMsg);
                            return;
                        }
                        if (tc.isDebugEnabled()) {
                            logMsg = "IdentityAssertion Security name == " + userId;
                            Tr.debug(tc, logMsg);
                        }
                        final String identityName = this.getIdentityName();
                        final byte[] identityValue = this.getIdentityValue();
                        final String _realm = realm;
                        final String _userid = userId;
                        PrivilegedExceptionAction action = new PrivilegedExceptionAction(){

                            public Object run() throws WSLoginFailedException, CredentialDestroyedException, CredentialExpiredException {
                                CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
                                Subject subject = ctxMgr.login(_realm, _userid, csiv2.getString("com.ibm.CSI.rmiInboundLoginConfig"), null, null, appContext);
                                if (subject != null) {
                                    WSCredential credential = SubjectHelper.getWSCredentialFromSubject(subject);
                                    if (identityName != null) {
                                        credential.set("wssecurity.identity_name", identityName);
                                        credential.set("wssecurity.identity_value", identityValue);
                                    }
                                    return subject;
                                }
                                return null;
                            }
                        };
                        try {
                            subject = (Subject)AccessController.doPrivileged(action);
                        }
                        catch (PrivilegedActionException e) {
                            if (tc.isDebugEnabled()) {
                                logMsg = "Exception occurred: " + e.getException().getMessage();
                                Tr.debug(tc, logMsg, new Object[]{e.getException()});
                            }
                            Manager.Ffdc.log(e.getException(), this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "618", this);
                            throw e.getException();
                        }
                    }
                }
                if (subject != null) {
                    this._contextState = 3;
                    this._principalAuthFailReason = (byte)100;
                    this._clientSubject = subject;
                    this._targetSubject = null;
                    this._mechanismType = this.mechType;
                    if (tc.isDebugEnabled()) {
                        logMsg = "Authentication success";
                        Tr.debug(tc, logMsg);
                    }
                    break block37;
                }
                throw new WSLoginFailedException("Subject is null.  Authentication Failed.");
            }
            catch (WSLoginFailedException e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "649", this);
                this._contextState = 4;
                this._principalAuthFailReason = auth_specific_data.value[0];
                this._principalAuthFailDetail = continuation_data.value;
                if (tc.isDebugEnabled()) {
                    logMsg = "Authentication failed";
                    Tr.debug(tc, logMsg);
                }
                throw e;
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_initialize", "665", this);
                this._contextState = 4;
                this._principalAuthFailReason = auth_specific_data.value[0];
                this._principalAuthFailDetail = continuation_data.value;
                if (tc.isDebugEnabled()) {
                    logMsg = "Authentication failed";
                    Tr.debug(tc, logMsg);
                }
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_initialize");
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized boolean csi_client_preprotect(ClientRequestInfo info, com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl secCtx) {
        logMethod = "csi_client_preprotect";
        logMsg = null;
        if (SecurityContextImpl.tc.isEntryEnabled()) {
            Tr.entry(SecurityContextImpl.tc, "csi_client_preprotect", new Object[]{info, secCtx, this});
        }
        sc = null;
        secNameHolder = new StringHolder();
        csiUtil = new CSIUtil();
        subject = null;
        ae = new AuthorizationElement[]{new AuthorizationElement(0, new byte[0])};
        it = secCtx.getIdentityToken();
        csiv2EffectivePolicy = this.vault.get_effective_policy(info.request_id());
        clientSessionKey = csiv2EffectivePolicy.getClientSessionKey();
        username = "";
        password = "";
        realm = "";
        client_auth_token = null;
        stateful_context_id = 0L;
        sessionMgr = this.vault.getSessionManager();
        if (csiv2EffectivePolicy.isStateful()) {
            stateful_context_id = csiv2EffectivePolicy.getStatefulContextID();
            if (SecurityContextImpl.tc.isDebugEnabled()) {
                logMsg = "Effective policy indicates stateful request, client_context_id: " + stateful_context_id;
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
        } else if (SecurityContextImpl.tc.isDebugEnabled()) {
            logMsg = "Effective policy indicates stateless request.";
            Tr.debug(SecurityContextImpl.tc, logMsg);
        }
        if ((tokenType = secCtx.getTokenType()) != null && tokenType.equals("ClientAuthOnly")) {
            if (csiv2EffectivePolicy != null && ((realm = RealmSecurityName.getRealm(csiv2EffectivePolicy.getTargetSecurityName())) == null || realm.equals(""))) {
                realm = csiv2EffectivePolicy.getTargetSecurityName();
            }
            if (realm == null || realm.equals("")) {
                realm = RealmSecurityName.getRealm(secNameHolder.value);
            }
            subject = this.getClientSubject();
        } else if (tokenType != null && tokenType.equals("ClientAuthAndIdentityOnly")) {
            try {
                csiv2 = SecurityObjectLocator.getCSIv2Config();
                alternatePerformTrustedId = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId");
                alternatePerformTrustedPassword = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword");
                if (alternatePerformTrustedId != null && !alternatePerformTrustedId.equals("") && alternatePerformTrustedPassword != null && !alternatePerformTrustedPassword.equals("")) {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "Alternate ID/Password has been specified.  Sending alternate Userid/Password for trusted identity.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    username = alternatePerformTrustedId;
                    realm = ContextManagerFactory.getInstance().getDefaultRealm();
                    password = alternatePerformTrustedPassword;
                    subject = SubjectHelper.createBasicAuthSubject(realm, username, password);
                } else if (!csiv2.getBoolean("com.ibm.ws.security.isUseRegistryServerId")) {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "UserRegistry server ID is not set and alternate ID/Password is not specified.  Sending server's LTPA token for trusted identity.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    ctxMgr = ContextManagerFactory.getInstance();
                    realm = ctxMgr.getDefaultRealm();
                    subject = ctxMgr.getServerSubject();
                } else {
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "Alternate ID/Password is not specified.  Sending server's Userid/Password for trusted identity.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    username = csiv2.getString("com.ibm.CORBA.loginUserid");
                    realm = RealmSecurityName.getRealm(csiv2.getString("com.ibm.CORBA.principalName"));
                    password = csiv2.getString("com.ibm.CORBA.loginPassword");
                    if (password == null || password.equals("")) {
                        if (SecurityContextImpl.tc.isDebugEnabled()) {
                            logMsg = "UserRegistry server passowrd is not set and alternate ID/Password is not specified.  Sending server's LTPA token for trusted identity.";
                            Tr.debug(SecurityContextImpl.tc, logMsg);
                        }
                        subject = ContextManagerFactory.getInstance().getServerSubject();
                    } else {
                        if (SecurityContextImpl.tc.isDebugEnabled()) {
                            logMsg = "Alternate ID/Password is not specified.  Sending server's Userid/Password for trusted identity.";
                            Tr.debug(SecurityContextImpl.tc, logMsg);
                        }
                        subject = SubjectHelper.createBasicAuthSubject(realm, username, password);
                    }
                }
                if (!SecurityContextImpl.tc.isDebugEnabled()) ** GOTO lbl88
                logMsg = "Forming Client Authentication Token with Server's credentials: username = " + username + " realm = " + realm;
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_client_preprotect", "842", new Object[]{this});
                if (SecurityContextImpl.tc.isDebugEnabled()) {
                    logMsg = "Cannot get server's credentials (userid/password/realm) from security configuration";
                    Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{e});
                }
                if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                    sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
                }
                throw new NO_PERMISSION(logMsg, 1229066386, CompletionStatus.COMPLETED_NO);
            }
        } else if (SecurityContextImpl.tc.isDebugEnabled()) {
            logMsg = "No Client Authentication Token will be put in the request";
            Tr.debug(SecurityContextImpl.tc, logMsg);
        }
lbl88:
        // 6 sources

        if (subject != null) {
            try {
                block52: {
                    wsFactory = WSSecurityContextFactory.getInstance();
                    wsSecContext = wsFactory.createContext("oid:2.23.130.1.1.1");
                    csiUtil.getCurrent().setWSSecurityContext(wsSecContext);
                    gssInitToken = wsSecContext.initSecContext(subject, csiv2EffectivePolicy.getTargetHostName(), realm);
                    if (gssInitToken != null) {
                        if (this._gFactory == null) {
                            this._gFactory = this.vault.getGSSFactory("oid:2.23.130.1.1.1");
                        }
                    } else {
                        logMsg = "The token returned by initSecContext was null.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                        if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                            sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
                        }
                        throw new BAD_PARAM(logMethod + ": " + logMsg, 1229066437, CompletionStatus.COMPLETED_NO);
                    }
                    client_auth_token = this._gFactory.encodeGSSToken(gssInitToken);
                    if (!WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) ** GOTO lbl148
                    if (SecurityContextImpl.tc.isDebugEnabled()) {
                        logMsg = "Adding authorization token to the request.";
                        Tr.debug(SecurityContextImpl.tc, logMsg);
                    }
                    subjectPriv = subject;
                    tokenHolder = null;
                    try {
                        tokenHolder = (TokenHolder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                Iterator<Object> privateCreds = subjectPriv.getPrivateCredentials().iterator();
                                while (privateCreds != null && privateCreds.hasNext()) {
                                    Object cred = privateCreds.next();
                                    if (!(cred instanceof TokenHolder) || !((TokenHolder)cred).getName().equals(WSOpaqueTokenHelper.getInstance().getOpaqueTokenName()) || ((TokenHolder)cred).getVersion() != WSOpaqueTokenHelper.getInstance().getOpaqueTokenVersion()) continue;
                                    if (tc.isDebugEnabled()) {
                                        String logMsg = "Returning token holder containing opaque authz token.";
                                        Tr.debug(tc, logMsg);
                                    }
                                    return (TokenHolder)cred;
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_client_preprotect", "955", new Object[]{this});
                        if (!SecurityContextImpl.tc.isDebugEnabled()) break block52;
                        logMsg = "Exception getting private/public tokens from Subject.";
                        Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{e.getException()});
                    }
                }
                if (tokenHolder != null) {
                    ae[0] = new AuthorizationElement(1229066447, tokenHolder.getBytes());
                }
                if (!SecurityContextImpl.tc.isDebugEnabled()) ** GOTO lbl148
                logMsg = "Didn't find an authz token to propagate.";
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
            catch (WSSecurityContextException ex1) {
                Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_client_preprotect", "982", new Object[]{this});
                logMsg = "Caught WSSecurityContextException in WSSecurityContext.initSecContext(), reason: " + ex1.toString();
                Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                    sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
                }
                PrincipalAuthFailReason.map_auth_fail_to_minor_code(ex1.getMajor(), StringBytesConversion.getConvertedBytes(ex1.toString()));
            }
            catch (Exception ex1) {
                Manager.Ffdc.log(ex1, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_client_preprotect", "993", new Object[]{this});
                logMsg = "Caught Java exception in WSSecurityContext.initSecContext(), reason:, " + ex1.toString();
                Tr.debug(SecurityContextImpl.tc, logMsg, new Object[]{ex1});
                if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                    sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
                }
                throw new INTERNAL(logMsg, 1229066386, CompletionStatus.COMPLETED_NO);
            }
        } else if (tokenType != null && tokenType.equals("ClientAuthOnly") || tokenType != null && tokenType.equals("ClientAuthAndIdentityOnly") && subject == null) {
            if (SecurityContextImpl.tc.isDebugEnabled()) {
                logMsg = SecurityMessages.getMsgOrUseDefault("JSAS0020W", "JSAS0020W: Unable to get credentials.");
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
            if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                sessionMgr.csi_client_session_status_update(stateful_context_id, clientSessionKey, 7);
            }
            throw new NO_PERMISSION(logMsg, 1229066386, CompletionStatus.COMPLETED_NO);
        }
lbl148:
        // 7 sources

        if (client_auth_token == null) {
            client_auth_token = new byte[]{};
            if (SecurityContextImpl.tc.isDebugEnabled()) {
                logMsg = "Client Authentication Token is null.";
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
        }
        ec = new EstablishContext(stateful_context_id, ae, it, client_auth_token);
        csiUtil.print_ec_message(ec, "csi_client_preprotect");
        if (ec != null) {
            sc = csiUtil.create_sc_from_ec_message(ec);
            if (csiv2EffectivePolicy.isStateful() && stateful_context_id != 0L) {
                sessionMgr.csi_client_session_ecmessage_update(stateful_context_id, clientSessionKey, ec);
            }
        }
        if (sc != null) {
            info.add_request_service_context(sc, true);
            if (SecurityContextImpl.tc.isDebugEnabled()) {
                logMsg = "Security context data is " + sc.context_data.length + " bytes in length";
                Tr.debug(SecurityContextImpl.tc, logMsg);
            }
        }
        if (SecurityContextImpl.tc.isEntryEnabled()) {
            Tr.exit(SecurityContextImpl.tc, "csi_client_preprotect", Boolean.TRUE);
        }
        return true;
    }

    public synchronized boolean csi_server_preprotect(ServerRequestInfo info, com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl secCtx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "csi_server_preprotect", new Object[]{info, secCtx, this});
        }
        ServiceContext sc = null;
        CSIUtil csiUtil = new CSIUtil();
        long client_context_id = this.get_stateful_context_id();
        boolean stateful = false;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CSI.claimStateful") && client_context_id > 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stateful set to true for CompleteEstablishContext.  ContextID: " + client_context_id);
            }
            stateful = true;
        }
        switch (info.reply_status()) {
            case 0: {
                if (csiUtil.get_message_type((RequestInfo)info) == 5) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SUCCESSFUL reply for MessageInContext.  No service context created for reply per CSIv2 spec.");
                    }
                    return true;
                }
                CompleteEstablishContext cec = null;
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Security context data is " + sc.context_data.length + " bytes in length");
                break;
            }
            case 1: {
                try {
                    Any exception = info.sending_exception();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "A SYSTEM_EXCEPTION occurred: " + exception.type().id() + ".  Sending ContextError.");
                    }
                }
                catch (BadKind bk) {
                    Manager.Ffdc.log(bk, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_server_preprotect", "1149", this);
                }
                byte[] error_token = csiUtil.serializeRootException();
                ContextError ce = null;
                if (secCtx != null) {
                    ce = secCtx.get_minor_code() == 1229079304 ? new ContextError(client_context_id, 4, 1, error_token) : new ContextError(client_context_id, 0, secCtx.get_minor_code(), error_token);
                    csiUtil.print_ce_message(ce, "csi_server_preprotect");
                } else {
                    ce = new ContextError(client_context_id, 0, 0, error_token);
                    csiUtil.print_ce_message(ce, "csi_server_preprotect");
                }
                sc = csiUtil.create_sc_from_ce_message(ce);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Security context data is " + sc.context_data.length + " bytes in length");
                break;
            }
            case 2: {
                if (csiUtil.get_message_type((RequestInfo)info) == 5) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "USER_EXCEPTION reply for MessageInContext.  No service context created for reply per CSIv2 spec.");
                    }
                    return true;
                }
                Any exception = null;
                try {
                    exception = info.sending_exception();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "A USER_EXCEPTION occurred: " + exception.type().id() + ".  Sending CompleteEstablishContext.");
                    }
                }
                catch (BadKind bk) {
                    Manager.Ffdc.log(bk, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.csi_server_preprotect", "1211", this);
                }
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                CompleteEstablishContext cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Security context data is " + sc.context_data.length + " bytes in length");
                break;
            }
            case 3: {
                if (csiUtil.get_message_type((RequestInfo)info) == 5) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "LOCATION_FORWARD reply for MessageInContext.  No service context created for reply per CSIv2 spec.");
                    }
                    return true;
                }
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                CompleteEstablishContext cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Security context data is " + sc.context_data.length + " bytes in length");
                break;
            }
            case 4: {
                if (csiUtil.get_message_type((RequestInfo)info) == 5) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "TRANSPORT_RETRY reply for MessageInContext.  No service context created for reply per CSIv2 spec.");
                    }
                    return true;
                }
                byte[] final_token = new byte[]{};
                if (this.getFinalToken() != null) {
                    final_token = this.getFinalToken();
                }
                CompleteEstablishContext cec = new CompleteEstablishContext(client_context_id, stateful, final_token);
                csiUtil.print_cec_message(cec, "csi_server_preprotect");
                sc = csiUtil.create_sc_from_cec_message(cec);
                if (sc == null) break;
                info.add_reply_service_context(sc, true);
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Security context data is " + sc.context_data.length + " bytes in length");
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "csi_server_preprotect", Boolean.TRUE);
        }
        return true;
    }

    protected Codec getCodec() {
        return this.vault.getCodec();
    }

    public byte[] create_gssup_initial_context_token(String username, String password, String realm, ClientRequestInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create_gssup_initial_context_token", new Object[]{username, password, realm, info, this});
        }
        String logMsg = "";
        try {
            Any any;
            CSIv2TaggedComponent ctag;
            CSIv2TaggedComponentHolder ctagholder;
            CSIUtil csiUtil = new CSIUtil();
            GSSFactory gssFactory = this.vault.getGSSFactory("oid:2.23.130.1.1.1");
            InitialContextToken ict = new InitialContextToken();
            String target = null;
            CSIv2EffectivePerformPolicy policy = null;
            if (csiUtil.getVault() != null) {
                policy = csiUtil.getVault().get_effective_policy(info.request_id());
            } else if (this.vault != null) {
                policy = this.vault.get_effective_policy(info.request_id());
            }
            if (policy != null && (ctagholder = policy.getCSIv2TaggedComponent()) != null && (ctag = ctagholder.value) != null && ctag.getAS_context_mech_holder() != null && ctag.getAS_context_mech_holder().value != null) {
                try {
                    ict.target_name = ctag.getAS_context_mech_holder().value.target_name;
                }
                catch (Exception e) {
                    Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.create_gssup_initial_context_token", "1362", this);
                    throw new BAD_PARAM("Unable to get target_name from AS_Context.  Original exception = " + e, 1229066438, CompletionStatus.COMPLETED_NO);
                }
                if (ict.target_name != null) {
                    try {
                        target = gssFactory.decodeExportedTargetName(ict.target_name);
                    }
                    catch (GSSEncodeDecodeException e) {
                        Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.create_gssup_initial_context_token", "1378", this);
                        throw new BAD_PARAM(logMsg + "  Original exception = " + e, 1229066437, CompletionStatus.COMPLETED_NO);
                    }
                }
            }
            if (ict.target_name == null) {
                ict.target_name = new byte[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Sending NULL target_name in GSSUP token.");
                }
            }
            if ((realm == null || realm.equals("")) && ((realm = RealmSecurityName.getRealm(target)) == null || realm.equals(""))) {
                realm = target;
            }
            String scoped_username = null;
            scoped_username = (realm == null || realm.equals("")) && username != null && !username.equals("") ? username : ((username == null || username.equals("")) && realm != null && !realm.equals("") ? "@" + realm : (username != null && !username.equals("") && realm != null && !realm.equals("") ? username + "@" + realm : ""));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Scoped username in GSSUP token: " + scoped_username);
            }
            ict.username = scoped_username.getBytes("UTF8");
            if (password == null) {
                password = "";
            }
            ict.password = password.getBytes("UTF8");
            if (this.orb == null && csiUtil.getVault() != null) {
                this.orb = csiUtil.getVault().getORB();
                if (this.orb == null) {
                    throw new INTERNAL("Orb is NULL.", 1229066420, CompletionStatus.COMPLETED_NO);
                }
            }
            if ((any = this.orb.create_any()) == null) {
                throw new INTERNAL("Any is NULL.", 1229066420, CompletionStatus.COMPLETED_NO);
            }
            InitialContextTokenHelper.insert(any, ict);
            byte[] encodedToken = null;
            byte[] token = null;
            try {
                encodedToken = this.getCodec().encode_value(any);
                token = gssFactory.encodeGSSToken(encodedToken);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.create_gssup_initial_context_token", "1457", this);
                throw new INTERNAL("Exception getting codec factory and encoding Any.  Original exception: " + e, 1229066417, CompletionStatus.COMPLETED_NO);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "create_gssup_initial_context_token", token);
            }
            return token;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectGSSUPImpl.SecurityContextImpl.create_gssup_initial_context_token", "1470", this);
            throw new BAD_PARAM(logMsg + "  Original exception = " + e, 1229066437, CompletionStatus.COMPLETED_NO);
        }
    }
}

