/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityContextImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2EffectivePerformPolicy;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.ClientSessionKey;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.wsspi.security.token.PropagationToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.X509CertificateChainHelper;
import org.omg.IOP.ServiceContext;

public class SessionEntry {
    private byte[] session_entry_bytes = null;
    private int session_state = 4;
    private long session_usage_timestamp = 0L;
    private long client_context_id = 0L;
    private EstablishContext ec_message = null;
    private SecurityContextImpl sec_ctx = null;
    private int gcCount = 0;
    private String unique_server_session_hash = "";
    private String unique_client_session_hash = "";
    private ClientSessionKey client_session_key = null;
    private Map propagation_token_map = null;
    private boolean basic_auth_type = false;
    private boolean renegotiate_to_stateless = false;
    private X509Certificate[] cert_chain = null;
    private byte[] cert_chain_bytes = null;
    private byte[] in_token = null;
    private String remote_host = "";
    private int remote_port = 0;
    private String remote_connection_unique_id = "";
    private String identity_assertion_type = "";
    private byte[] identity_assertion_data = null;
    private byte[] opaque_authz_token = null;
    private CSIv2EffectivePerformPolicy effective_policy = null;
    private byte[] transport_layer_data = null;
    private byte transport_layer_data_type = 0;
    private static final String variable_data_name = "NATIVE_VARIABLE_DATA";
    private static final String ec_message_name = "ESTABLISH_CONTEXT_DATA";
    private static final String cert_chain_name = "CERT_CHAIN_DATA";
    private static final String in_token_name = "CLIENT_AUTH_TOKEN_DATA";
    private static final String identity_assertion_data_name = "IDENTITY_ASSERTION_DATA";
    private static final String opaque_authz_token_name = "OPAQUE_AUTHZ_DATA";
    private static final String effective_policy_name = "EFFECTIVE_POLICY";
    private static final String prop_token_name = "com.ibm.ws.security.token.PropagationTokenImpl";
    private static final String transport_layer_data_name = "TRANSPORT_LAYER_DATA";
    private static final CSIUtil csiUtil = new CSIUtil();
    private static final TraceComponent tc = Tr.register(SessionEntry.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");

    public SessionEntry(long context_id, EstablishContext ec, String hash) {
        this.client_context_id = context_id;
        this.ec_message = ec;
        this.unique_server_session_hash = hash;
    }

    public SessionEntry(long context_id) {
        this.client_context_id = context_id;
    }

    public SessionEntry(byte[] session_bytes) throws Exception {
        this.constructFromBytes(session_bytes);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session contents after de-serialization: " + this.toString());
        }
    }

    public int get_session_state() {
        return this.session_state;
    }

    public void set_session_state(int state) {
        this.session_entry_bytes = null;
        this.session_state = state;
    }

    public long get_client_context_id() {
        return this.client_context_id;
    }

    public void set_client_context_id(long context_id) {
        this.session_entry_bytes = null;
        this.client_context_id = context_id;
    }

    public EstablishContext get_ec_message() {
        return this.ec_message;
    }

    public void set_ec_message(EstablishContext ec) {
        this.session_entry_bytes = null;
        this.ec_message = ec;
    }

    public SecurityContextImpl get_security_context_holder() {
        return this.sec_ctx;
    }

    public void set_security_context_holder(SecurityContextImpl secCtxHolder) {
        this.session_entry_bytes = null;
        this.sec_ctx = secCtxHolder;
    }

    public void set_unique_server_session_hash(String hash) {
        this.session_entry_bytes = null;
        this.unique_server_session_hash = hash;
    }

    public String get_unique_server_session_hash() {
        return this.unique_server_session_hash;
    }

    public void set_unique_client_session_hash(String hash) {
        this.session_entry_bytes = null;
        this.unique_client_session_hash = hash;
    }

    public String get_unique_client_session_hash() {
        return this.unique_client_session_hash;
    }

    public void update_session_usage_timestamp() {
        this.session_usage_timestamp = System.currentTimeMillis();
    }

    public long get_session_usage_timestamp() {
        return this.session_usage_timestamp;
    }

    public void set_client_session_key(ClientSessionKey clientSessionKey) {
        this.session_entry_bytes = null;
        this.client_session_key = clientSessionKey;
        if (clientSessionKey != null) {
            this.unique_client_session_hash = clientSessionKey.get_client_session_hash();
        }
    }

    public ClientSessionKey get_client_session_key() {
        if (this.client_session_key == null && this.unique_client_session_hash != null) {
            this.client_session_key = new ClientSessionKey(this.unique_client_session_hash);
        }
        return this.client_session_key;
    }

    public Map get_propagation_token_map() {
        return this.propagation_token_map;
    }

    public void set_propagation_token_map(Map tokenMap) {
        this.session_entry_bytes = null;
        this.propagation_token_map = tokenMap;
    }

    public void set_basic_auth_type() {
        this.session_entry_bytes = null;
        this.basic_auth_type = true;
    }

    public boolean get_basic_auth_type() {
        return this.basic_auth_type;
    }

    public void set_cert_chain(X509Certificate[] chain) {
        this.session_entry_bytes = null;
        this.cert_chain_bytes = null;
        this.cert_chain = chain;
    }

    public byte[] get_identity_assertion_data() {
        return this.identity_assertion_data;
    }

    public void set_identity_assertion_data(byte[] data) {
        this.session_entry_bytes = null;
        this.identity_assertion_data = data;
    }

    public String get_identity_assertion_type() {
        return this.identity_assertion_type;
    }

    public void set_identity_assertion_type(String type) {
        this.session_entry_bytes = null;
        this.identity_assertion_type = type;
    }

    public X509Certificate[] get_cert_chain() {
        if (this.cert_chain == null && this.cert_chain_bytes != null) {
            try {
                this.cert_chain = SessionEntry.convertBytesToCertChain(this.cert_chain_bytes);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.get_cert_chain", "295");
                this.cert_chain = null;
            }
        }
        return this.cert_chain;
    }

    public void set_in_token(byte[] token) {
        this.session_entry_bytes = null;
        this.in_token = token;
    }

    public byte[] get_in_token() {
        return this.in_token;
    }

    public void set_remote_host(String host) {
        this.session_entry_bytes = null;
        this.remote_host = host;
    }

    public String get_remote_host() {
        return this.remote_host;
    }

    public void set_remote_port(int port) {
        this.session_entry_bytes = null;
        this.remote_port = port;
    }

    public int get_remote_port() {
        return this.remote_port;
    }

    public void set_remote_connection_unique_id(String unique_id) {
        this.session_entry_bytes = null;
        this.remote_connection_unique_id = unique_id;
    }

    public String get_remote_connection_unique_id() {
        return this.remote_connection_unique_id;
    }

    public void set_renegotiate_to_stateless() {
        this.session_entry_bytes = null;
        this.renegotiate_to_stateless = true;
    }

    public void reset_renegotiate_to_stateless() {
        this.session_entry_bytes = null;
        this.renegotiate_to_stateless = false;
    }

    public boolean get_renegotiate_to_stateless() {
        return this.renegotiate_to_stateless;
    }

    public void set_transport_layer_data_type(byte type) {
        this.transport_layer_data_type = type;
    }

    public byte get_transport_layer_data_type() {
        return this.transport_layer_data_type;
    }

    public void set_opaque_authz_token(byte[] oat) {
        this.opaque_authz_token = oat;
    }

    public byte[] get_opaque_authz_token() {
        return this.opaque_authz_token;
    }

    public void set_effective_policy(CSIv2EffectivePerformPolicy policy) {
        this.effective_policy = policy;
    }

    public CSIv2EffectivePerformPolicy get_effective_policy() {
        return this.effective_policy;
    }

    public void set_transport_layer_data(byte[] data) {
        this.transport_layer_data = data;
    }

    public byte[] get_transport_layer_data() {
        return this.transport_layer_data;
    }

    public static X509Certificate[] convertBytesToCertChain(byte[] cert_chain_bytes) throws Exception {
        X509Certificate[] cert_chain = null;
        if (cert_chain_bytes != null) {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Any read_Any = csiUtil.getCodec().decode_value(cert_chain_bytes, X509CertificateChainHelper.type());
            byte[] decodedCChain = X509CertificateChainHelper.extract(read_Any);
            ByteArrayInputStream bais = new ByteArrayInputStream(decodedCChain);
            CertPath myCertPath = cf.generateCertPath(bais);
            List<? extends Certificate> certList = myCertPath.getCertificates();
            cert_chain = new X509Certificate[certList.size()];
            for (int i = 0; i < certList.size(); ++i) {
                cert_chain[i] = (X509Certificate)certList.get(i);
            }
        }
        return cert_chain;
    }

    public static byte[] convertCertChainToBytes(X509Certificate[] cert_chain) throws Exception {
        if (cert_chain != null) {
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(cert_chain.length);
            HashSet<X509Certificate> set = new HashSet<X509Certificate>(cert_chain.length);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            for (int j = 0; j < cert_chain.length; ++j) {
                ByteArrayInputStream bais = new ByteArrayInputStream(cert_chain[j].getEncoded());
                X509Certificate tmpClientCert = (X509Certificate)cf.generateCertificate(bais);
                if (!set.add(tmpClientCert)) continue;
                certList.add(tmpClientCert);
            }
            CertificateFactory cfx = CertificateFactory.getInstance("X.509");
            CertPath myCertPath = cfx.generateCertPath(certList);
            ORB orb = VaultImpl.getInstance().getORB();
            Any theAny = orb.create_any();
            X509CertificateChainHelper.insert(theAny, myCertPath.getEncoded());
            return csiUtil.getCodec().encode_value(theAny);
        }
        return null;
    }

    public boolean compare_establish_context_messages(EstablishContext ec) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compare_establish_context_messages", new Object[]{ec, this});
        }
        boolean identity_token_equals = false;
        boolean client_auth_token_equals = false;
        boolean authorization_token_equals = false;
        boolean final_decision = false;
        client_auth_token_equals = Arrays.equals(this.ec_message.client_authentication_token, ec.client_authentication_token);
        if (ec.identity_token.discriminator() != this.ec_message.identity_token.discriminator()) {
            identity_token_equals = false;
        } else if (ec.identity_token.discriminator() == 0) {
            identity_token_equals = true;
        } else if (ec.identity_token.discriminator() == 1) {
            identity_token_equals = true;
        } else if (ec.identity_token.discriminator() == 2) {
            identity_token_equals = Arrays.equals(this.ec_message.identity_token.principal_name(), ec.identity_token.principal_name());
        } else if (ec.identity_token.discriminator() == 8) {
            identity_token_equals = Arrays.equals(this.ec_message.identity_token.dn(), ec.identity_token.dn());
        } else if (ec.identity_token.discriminator() == 4) {
            identity_token_equals = Arrays.equals(this.ec_message.identity_token.certificate_chain(), ec.identity_token.certificate_chain());
        }
        if (this.ec_message.authorization_token.length != ec.authorization_token.length) {
            authorization_token_equals = false;
        } else if (this.ec_message.authorization_token.length == 0) {
            authorization_token_equals = true;
        } else {
            for (int i = 0; i < ec.authorization_token.length; ++i) {
                if (this.ec_message.authorization_token[i] != null && ec.authorization_token[i] != null) {
                    authorization_token_equals = Arrays.equals(this.ec_message.authorization_token[i].the_element, ec.authorization_token[i].the_element);
                    boolean bl = authorization_token_equals = this.ec_message.authorization_token[i].the_type == ec.authorization_token[i].the_type;
                    if (authorization_token_equals) continue;
                    break;
                }
                if (this.ec_message.authorization_token[i] == null && ec.authorization_token[i] == null) {
                    authorization_token_equals = true;
                    continue;
                }
                authorization_token_equals = false;
                break;
            }
        }
        boolean bl = final_decision = client_auth_token_equals && identity_token_equals && authorization_token_equals;
        if (tc.isDebugEnabled()) {
            if (final_decision) {
                Tr.debug(tc, "EstablishContext compare succeeded.");
            } else {
                Tr.debug(tc, "EstablishContext compare failed: client_auth_tokens=" + client_auth_token_equals + ", identity_tokens=" + identity_token_equals + ", authorization_tokens=" + authorization_token_equals);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compare_establish_context_messages", new Boolean(final_decision));
        }
        return final_decision;
    }

    private void constructFromBytes(byte[] session_bytes) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "constructFromBytes", new Object[]{session_bytes, this});
        }
        if (session_bytes != null) {
            try {
                ArrayList tokenHolders = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(session_bytes);
                for (int i = 0; i < tokenHolders.size(); ++i) {
                    TokenHolder th = (TokenHolder)tokenHolders.get(i);
                    String name = th.getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Handling token name: " + name);
                    }
                    if (name != null && name.equals(cert_chain_name)) {
                        this.cert_chain = null;
                        this.cert_chain_bytes = th.getBytes();
                        continue;
                    }
                    if (name != null && name.equals(in_token_name)) {
                        this.in_token = th.getBytes();
                        continue;
                    }
                    if (name != null && name.equals(identity_assertion_data_name)) {
                        this.identity_assertion_data = th.getBytes();
                        continue;
                    }
                    if (name != null && name.equals(transport_layer_data_name)) {
                        this.transport_layer_data = th.getBytes();
                        continue;
                    }
                    if (name != null && name.equals(ec_message_name)) {
                        SASContextBody msg = csiUtil.get_message_from_sc(new ServiceContext(15, th.getBytes()));
                        this.ec_message = msg.establish_msg();
                        continue;
                    }
                    if (name != null && name.equals(effective_policy_name)) {
                        this.effective_policy = new CSIv2EffectivePerformPolicy(th.getBytes());
                        continue;
                    }
                    if (name != null && name.equals(opaque_authz_token_name)) {
                        this.opaque_authz_token = th.getBytes();
                        continue;
                    }
                    if (name != null && name.equals(variable_data_name)) {
                        this.deserializeVariables(th.getBytes());
                        continue;
                    }
                    if (name == null || !name.equals(prop_token_name) || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "TODO: Not handling the deserialization of the propagation token yet.");
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.constructFromBytes", "639", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception constructing private service context.", new Object[]{e});
                }
                throw e;
            }
        } else {
            throw new INTERNAL("Service context data is not found.");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "constructFromBytes");
        }
    }

    public byte[] getBytes() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBytes", this);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session contents prior to serialization: " + this.toString());
        }
        if (this.session_entry_bytes == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Serializing session.");
            }
            ArrayList<TokenHolder> tokenHolders = new ArrayList<TokenHolder>();
            try {
                TokenHolder th = this.serializeVariables();
                tokenHolders.add(th);
                ServiceContext sc = null;
                if (this.ec_message != null && (sc = csiUtil.create_sc_from_ec_message(this.ec_message)) != null) {
                    tokenHolders.add(new TokenHolder(sc.context_data, ec_message_name, 1));
                }
                if (this.in_token != null) {
                    tokenHolders.add(new TokenHolder(this.in_token, in_token_name, 1));
                }
                if (this.opaque_authz_token != null) {
                    tokenHolders.add(new TokenHolder(this.opaque_authz_token, opaque_authz_token_name, 1));
                }
                if (this.identity_assertion_data != null) {
                    tokenHolders.add(new TokenHolder(this.identity_assertion_data, identity_assertion_data_name, 1));
                }
                if (this.effective_policy != null) {
                    tokenHolders.add(new TokenHolder(this.effective_policy.getBytes(), effective_policy_name, 1));
                }
                if (this.transport_layer_data != null) {
                    tokenHolders.add(new TokenHolder(this.transport_layer_data, transport_layer_data_name, 1));
                }
                if (this.propagation_token_map != null) {
                    for (String key : this.propagation_token_map.keySet()) {
                        PropagationToken propToken = (PropagationToken)this.propagation_token_map.get(key);
                        if (propToken == null) continue;
                        long expiration = propToken.getExpiration();
                        long timeRemaining = expiration - System.currentTimeMillis() - 900000L;
                        if (timeRemaining < 0L) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Refreshing propagation token from session.");
                            }
                            propToken = (PropagationToken)propToken.clone();
                        }
                        final PropagationToken fToken = propToken;
                        byte[] tokenBytes = (byte[])AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return fToken.getBytes();
                            }
                        });
                        tokenHolders.add(new TokenHolder(tokenBytes, propToken.getName(), propToken.getVersion()));
                    }
                }
                if (this.cert_chain != null && this.cert_chain_bytes == null) {
                    this.cert_chain_bytes = SessionEntry.convertCertChainToBytes(this.cert_chain);
                }
                if (this.cert_chain_bytes != null) {
                    tokenHolders.add(new TokenHolder(this.cert_chain_bytes, cert_chain_name, 1));
                }
                this.session_entry_bytes = WSOpaqueTokenHelper.getInstance().createOpaqueTokenFromTokenHolderList(null, tokenHolders);
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.getBytes", "755", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception getting session bytes for private security context.", new Object[]{e});
                }
                throw e;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBytes", this.session_entry_bytes);
        }
        return this.session_entry_bytes;
    }

    private TokenHolder serializeVariables() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeVariables", this);
        }
        TokenHolder th = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(300);
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeBoolean(this.basic_auth_type);
            dos.writeBoolean(this.renegotiate_to_stateless);
            dos.writeInt(this.session_state);
            dos.writeInt(this.remote_port);
            dos.writeLong(this.session_usage_timestamp);
            dos.writeLong(this.client_context_id);
            dos.writeByte(this.transport_layer_data_type);
            if (this.remote_connection_unique_id != null && this.remote_connection_unique_id.length() > 0) {
                dos.writeInt(this.remote_connection_unique_id.length());
                dos.write(this.remote_connection_unique_id.getBytes(), 0, this.remote_connection_unique_id.length());
            } else {
                dos.writeInt(0);
            }
            if (this.unique_server_session_hash != null && this.unique_server_session_hash.length() > 0) {
                dos.writeInt(this.unique_server_session_hash.length());
                dos.write(this.unique_server_session_hash.getBytes(), 0, this.unique_server_session_hash.length());
            } else {
                dos.writeInt(0);
            }
            if (this.unique_client_session_hash != null && this.unique_client_session_hash.length() > 0) {
                dos.writeInt(this.unique_client_session_hash.length());
                dos.write(this.unique_client_session_hash.getBytes(), 0, this.unique_client_session_hash.length());
            } else {
                dos.writeInt(0);
            }
            if (this.remote_host != null && this.remote_host.length() > 0) {
                dos.writeInt(this.remote_host.length());
                dos.write(this.remote_host.getBytes(), 0, this.remote_host.length());
            } else {
                dos.writeInt(0);
            }
            if (this.identity_assertion_type != null && this.identity_assertion_type.length() > 0) {
                dos.writeInt(this.identity_assertion_type.length());
                dos.write(this.identity_assertion_type.getBytes(), 0, this.identity_assertion_type.length());
            } else {
                dos.writeInt(0);
            }
            th = new TokenHolder(baos.toByteArray(), variable_data_name, 1);
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.serializeVariables", "851", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception serializing native variables.", new Object[]{e});
            }
            throw e;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
            if (dos != null) {
                dos.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeVariables", th);
        }
        return th;
    }

    private void deserializeVariables(byte[] inputData) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deserializeVariables", new Object[]{inputData, this});
        }
        Object th = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(inputData);
        DataInputStream dis = new DataInputStream(bais);
        try {
            byte[] stringBytes;
            this.basic_auth_type = dis.readBoolean();
            this.renegotiate_to_stateless = dis.readBoolean();
            this.session_state = dis.readInt();
            this.remote_port = dis.readInt();
            this.session_usage_timestamp = dis.readLong();
            this.client_context_id = dis.readLong();
            this.transport_layer_data_type = dis.readByte();
            int stringSize = dis.readInt();
            if (stringSize > 0) {
                stringBytes = new byte[stringSize];
                dis.read(stringBytes, 0, stringSize);
                this.remote_connection_unique_id = new String(stringBytes);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes = new byte[stringSize];
                dis.read(stringBytes, 0, stringSize);
                this.unique_server_session_hash = new String(stringBytes);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes = new byte[stringSize];
                dis.read(stringBytes, 0, stringSize);
                this.unique_client_session_hash = new String(stringBytes);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes = new byte[stringSize];
                dis.read(stringBytes, 0, stringSize);
                this.remote_host = new String(stringBytes);
            }
            if ((stringSize = dis.readInt()) > 0) {
                stringBytes = new byte[stringSize];
                dis.read(stringBytes, 0, stringSize);
                this.identity_assertion_type = new String(stringBytes);
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.SessionEntry.deserializeVariables", "947", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception de-serializing native variables.", new Object[]{e});
            }
            throw e;
        }
        finally {
            if (bais != null) {
                bais.close();
            }
            if (dis != null) {
                dis.close();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeVariables");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nsession_entry_bytes null? " + (this.session_entry_bytes == null));
        sb.append("\nec_message null? " + (this.ec_message == null));
        sb.append("\nsec_ctx null? " + (this.sec_ctx == null));
        sb.append("\nin_token null? " + (this.in_token == null));
        sb.append("\nopaque_authz_token null? " + (this.opaque_authz_token == null));
        sb.append("\ntransport_layer_data null? " + (this.transport_layer_data == null));
        sb.append("\ncert_chain null? " + (this.cert_chain == null && this.cert_chain_bytes == null));
        sb.append("\nclient_session_key null? " + (this.client_session_key == null));
        sb.append("\npropagation_token_map null? " + (this.propagation_token_map == null));
        sb.append("\nidentity_assertion_data null? " + (this.identity_assertion_data == null));
        sb.append("\nidentity_assertion_type: " + this.identity_assertion_type);
        sb.append("\nsession_state: " + this.session_state);
        sb.append("\nsession_usage_timestamp: " + this.session_usage_timestamp);
        sb.append("\nclient_context_id: " + this.client_context_id);
        sb.append("\ngcCount: " + this.gcCount);
        sb.append("\nunique_server_session_hash: " + this.unique_server_session_hash);
        sb.append("\nunique_client_session_hash: " + this.unique_client_session_hash);
        sb.append("\nbasic_auth_type: " + this.basic_auth_type);
        sb.append("\nrenegotiate_to_stateless: " + this.renegotiate_to_stateless);
        sb.append("\nremote_host: " + this.remote_host);
        sb.append("\nremote_port: " + this.remote_port);
        sb.append("\nremote_connection_unique_id: " + this.remote_connection_unique_id);
        return sb.toString();
    }
}

