/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectCSIv2UtilityImpl;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ComponentDataHolder;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSEncodeDecodeException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.AuthenticationTarget;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SecurityTaggedComponent;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.util.PlatformHelperFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CSIIOP.AS_ContextSec;
import org.omg.CSIIOP.AS_ContextSecHolder;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechHolder;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SAS_ContextSec;
import org.omg.CSIIOP.SAS_ContextSecHolder;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHelper;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHolder;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TLS_SEC_TRANSHolder;
import org.omg.CSIIOP.TransportAddress;
import org.omg.CSIIOP.TransportAddressHolder;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.TaggedComponent;

public final class CSIv2TaggedComponent
extends SecurityTaggedComponent {
    private static final TraceComponent tc = Tr.register(CSIv2TaggedComponent.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    private static String hostname = CSIv2TaggedComponent.getHostName();
    private static List secureChainList = null;
    private static boolean secureChainListInitialized = false;
    private static List insecureChainList = null;
    private static boolean insecureChainListInitialized = false;
    private static Hashtable csiv2TagCache = new Hashtable();
    private boolean _stateful = true;
    private int transport_tagID = 0;
    private String serviceConfigList = null;
    private TLS_SEC_TRANSHolder transport_mech_TLSHolder = null;
    private SECIOP_SEC_TRANSHolder transport_mech_SECIOPHolder = null;
    private AS_ContextSecHolder as_context_mech_holder = null;
    private SAS_ContextSecHolder sas_context_mech_holder = null;
    private Profile profile = null;
    private TransportAddressHolder tAddrH = null;
    private static short trans_target_requires = 0;
    private static final Class thisClass = CSIv2TaggedComponent.class;

    public TransportAddressHolder get_Transport_Address() {
        return this.tAddrH;
    }

    public int get_Transport_tagID() {
        return this.transport_tagID;
    }

    public String get_Service_Configuration_List() {
        return this.serviceConfigList;
    }

    private CSIv2TaggedComponent(CompoundSecMechHolder cSecMechHolder, boolean stateful, ORB orb, Profile tagged_profile) {
        this.initialize(cSecMechHolder, stateful, orb, tagged_profile);
    }

    public void initialize(CompoundSecMechHolder cSecMechHolder, boolean stateful, ORB orb, Profile tagged_profile) {
        block37: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", new Object[]{cSecMechHolder, new Boolean(stateful), orb, tagged_profile, this});
            }
            this.profile = tagged_profile;
            CSIUtil csiUtil = new CSIUtil();
            short targetReqQOP = 0;
            short targetSupQOP = 0;
            try {
                this.set_tagID(33);
                this._stateful = stateful;
                TaggedComponent tcomp = cSecMechHolder.value.transport_mech;
                if (tcomp != null) {
                    Any theAny;
                    this.transport_tagID = tcomp.tag;
                    if (this.transport_tagID == 36) {
                        theAny = null;
                        try {
                            theAny = csiUtil.getCodec().decode_value(tcomp.component_data, TLS_SEC_TRANSHelper.type());
                        }
                        catch (MARSHAL e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "227", this);
                            Tr.debug(tc, e.getMessage(), (Object)e);
                        }
                        catch (BAD_OPERATION ex) {
                            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "232", this);
                            Tr.debug(tc, ex.getMessage(), (Object)ex);
                        }
                        catch (FormatMismatch fm) {
                            Manager.Ffdc.log(fm, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "237", this);
                            Tr.debug(tc, fm.getMessage(), (Object)fm);
                        }
                        catch (TypeMismatch tm) {
                            Manager.Ffdc.log(tm, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "242", this);
                            Tr.debug(tc, tm.getMessage(), (Object)tm);
                        }
                        this.transport_mech_TLSHolder = new TLS_SEC_TRANSHolder(TLS_SEC_TRANSHelper.extract(theAny));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CSI Security Transport values, transport layer: TLS, target requires = " + this.transport_mech_TLSHolder.value.target_requires + " target supports = " + this.transport_mech_TLSHolder.value.target_supports);
                        }
                        targetReqQOP = (short)(targetReqQOP | this.transport_mech_TLSHolder.value.target_requires);
                        targetSupQOP = (short)(targetSupQOP | this.transport_mech_TLSHolder.value.target_supports);
                        if (this.transport_mech_TLSHolder.value.addresses != null || this.transport_mech_TLSHolder.value.addresses.length != 0) {
                            this.tAddrH = new TransportAddressHolder(this.transport_mech_TLSHolder.value.addresses[0]);
                        }
                    } else if (this.transport_tagID == 35) {
                        theAny = null;
                        try {
                            theAny = csiUtil.getCodec().decode_value(tcomp.component_data, SECIOP_SEC_TRANSHelper.type());
                        }
                        catch (MARSHAL e) {
                            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "273", this);
                            Tr.debug(tc, e.getMessage(), (Object)e);
                        }
                        catch (BAD_OPERATION ex) {
                            Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "278", this);
                            Tr.debug(tc, ex.getMessage(), (Object)ex);
                        }
                        catch (FormatMismatch fm) {
                            Manager.Ffdc.log(fm, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "283", this);
                            Tr.debug(tc, fm.getMessage(), (Object)fm);
                        }
                        catch (TypeMismatch tm) {
                            Manager.Ffdc.log(tm, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "288", this);
                            Tr.debug(tc, tm.getMessage(), (Object)tm);
                        }
                        this.transport_mech_SECIOPHolder = new SECIOP_SEC_TRANSHolder(SECIOP_SEC_TRANSHelper.extract(theAny));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CSI Security Transport values, transport layer: SECIOP, target requires = " + this.transport_mech_SECIOPHolder.value.target_requires + " target supports = " + this.transport_mech_SECIOPHolder.value.target_supports);
                        }
                        targetReqQOP = (short)(targetReqQOP | this.transport_mech_SECIOPHolder.value.target_requires);
                        targetSupQOP = (short)(targetSupQOP | this.transport_mech_SECIOPHolder.value.target_supports);
                        if (this.transport_mech_SECIOPHolder.value.addresses != null && this.transport_mech_SECIOPHolder.value.addresses.length != 0) {
                            this.tAddrH = new TransportAddressHolder(this.transport_mech_SECIOPHolder.value.addresses[0]);
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CSI Security Transport values, transport layer: NULL");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI Security Transport values, transport layer: NULL");
                }
                if (cSecMechHolder.value.as_context_mech != null) {
                    byte[] namebytes;
                    this.as_context_mech_holder = new AS_ContextSecHolder(cSecMechHolder.value.as_context_mech);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CSI Client Authentication values, client auth layer: target_requires =  " + this.as_context_mech_holder.value.target_requires + " target_supports = " + this.as_context_mech_holder.value.target_supports);
                    }
                    targetReqQOP = (short)(targetReqQOP | this.as_context_mech_holder.value.target_requires);
                    targetSupQOP = (short)(targetSupQOP | this.as_context_mech_holder.value.target_supports);
                    if (cSecMechHolder.value.as_context_mech.target_name != null && cSecMechHolder.value.as_context_mech.client_authentication_mech != null && (namebytes = cSecMechHolder.value.as_context_mech.target_name).length != 0) {
                        try {
                            GSSFactory gFact = new GSSFactory(cSecMechHolder.value.as_context_mech.client_authentication_mech);
                            this.set_targetCompleteName(gFact.decodeExportedTargetName(namebytes));
                        }
                        catch (GSSEncodeDecodeException gEx) {
                            Manager.Ffdc.log(gEx, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "354", this);
                            Tr.error(tc, "security.JSAS0622E", new Object[]{gEx});
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI Client Authentication values, client auth layer: NULL");
                }
                if (cSecMechHolder.value.sas_context_mech != null) {
                    this.sas_context_mech_holder = new SAS_ContextSecHolder(cSecMechHolder.value.sas_context_mech);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "CSI Security Attribute values, attribute layer: target_requires = " + this.sas_context_mech_holder.value.target_requires + " target_supports = " + this.sas_context_mech_holder.value.target_supports);
                    }
                    targetReqQOP = (short)(targetReqQOP | this.sas_context_mech_holder.value.target_requires);
                    targetSupQOP = (short)(targetSupQOP | this.sas_context_mech_holder.value.target_supports);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "CSI Security Attribute values, attribute layer: NULL");
                }
                this.set_targetCoalescedReqQOP(targetReqQOP);
                this.set_targetCoalescedSuppQOP(targetSupQOP);
            }
            catch (Exception ex) {
                Manager.Ffdc.log(ex, this, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.initialize", "421", this);
                if (!tc.isDebugEnabled()) break block37;
                Tr.debug(tc, "Exception creating new CSIv2 Tagged Component.", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public TLS_SEC_TRANSHolder getTLS_SEC_TRANS() {
        return this.transport_mech_TLSHolder;
    }

    public SECIOP_SEC_TRANSHolder getSECIOP_SEC_TRANS() {
        return this.transport_mech_SECIOPHolder;
    }

    public static synchronized CSIv2TaggedComponent[] getCSIv2TaggedComponentList(Profile profile, IOR ior) {
        byte[] tagComp = profile.getTaggedComponent(33);
        if (tagComp == null && ior != null) {
            Profile proxyProfile = ior.getProfile(0);
            if (profile == null && proxyProfile != null) {
                profile = proxyProfile;
            }
            tagComp = proxyProfile.getTaggedComponent(33);
        }
        return CSIv2TaggedComponent.getCSIv2TaggedComponentList(tagComp, profile);
    }

    public static synchronized CSIv2TaggedComponent[] getCSIv2TaggedComponentList(byte[] tagComp, Profile tagged_profile) {
        CSIv2TaggedComponent[] csiv2TagComp;
        ByteArray tagCompByteArray;
        block23: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getCSIv2TaggedComponentList", new Object[]{tagComp, tagged_profile});
            }
            CSIUtil csiUtil = new CSIUtil();
            ORB orb = VaultImpl.getInstance().getORB();
            Any read_Any = null;
            tagCompByteArray = null;
            csiv2TagComp = null;
            try {
                if (tagComp != null) {
                    tagCompByteArray = new ByteArray(tagComp);
                    csiv2TagComp = (CSIv2TaggedComponent[])csiv2TagCache.get(tagCompByteArray);
                    if (csiv2TagComp != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Returning existing CSIv2 tag list from the cache (size=" + csiv2TagCache.size() + ").");
                        }
                        return csiv2TagComp;
                    }
                    try {
                        read_Any = csiUtil.getCodec().decode_value(tagComp, CompoundSecMechListHelper.type());
                    }
                    catch (MARSHAL e) {
                        Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "524");
                        Tr.debug(tc, e.getMessage(), (Object)e);
                    }
                    catch (BAD_OPERATION ex) {
                        Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "529");
                        Tr.debug(tc, ex.getMessage(), (Object)ex);
                    }
                    catch (FormatMismatch fm) {
                        Manager.Ffdc.log(fm, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "534");
                        Tr.debug(tc, fm.getMessage(), (Object)fm);
                    }
                    catch (TypeMismatch tm) {
                        Manager.Ffdc.log(tm, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "539");
                        Tr.debug(tc, tm.getMessage(), (Object)tm);
                    }
                    CompoundSecMechList cSecMechList = CompoundSecMechListHelper.extract(read_Any);
                    if (cSecMechList.mechanism_list != null) {
                        CompoundSecMechHolder cSecMechHolder = new CompoundSecMechHolder();
                        csiv2TagComp = new CSIv2TaggedComponent[cSecMechList.mechanism_list.length];
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, cSecMechList.mechanism_list.length + " CompoundSecMechanism(s) in Tagged Component.");
                        }
                        for (int i = 0; i < cSecMechList.mechanism_list.length; ++i) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "*** READING CSIv2 TAG " + (i + 1) + " of " + cSecMechList.mechanism_list.length + " ***");
                            }
                            cSecMechHolder.value = cSecMechList.mechanism_list[i];
                            csiv2TagComp[i] = new CSIv2TaggedComponent(cSecMechHolder, cSecMechList.stateful, orb, tagged_profile);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "*** COMPLETED ADDING CSIv2 TAGS ***");
                        }
                    }
                    break block23;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Tagged component is null.");
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "582");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Java Exception getting CSIv2TaggedComponent.", e);
                }
                return null;
            }
        }
        if (tagCompByteArray != null && csiv2TagComp != null) {
            if (csiv2TagCache.size() > 50) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Clearing CSIv2 Tag cache, larger than 50 objects.");
                }
                csiv2TagCache.clear();
            }
            csiv2TagCache.put(tagCompByteArray, csiv2TagComp);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added CSIv2 tag to the cache (size=" + csiv2TagCache.size() + ").");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCSIv2TaggedComponentList", csiv2TagComp);
        }
        return csiv2TagComp;
    }

    public static final synchronized ArrayList getCSIv2ComponentData(SecurityConnectionInterceptor connInt, String fullSecName, Profile taggedProfile, String realmName, boolean isAdmin, boolean createPartialTags) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCSIv2ComponentData", new Object[]{connInt, fullSecName, taggedProfile, realmName, new Boolean(isAdmin), createPartialTags});
        }
        try {
            ORB orb = VaultImpl.getInstance().getORB();
            Any theAny = null;
            CSIUtil csiUtil = new CSIUtil();
            int transportCount = 1;
            GSSFactory gssFactory = null;
            CompoundSecMech[] cSecMechs = null;
            CompoundSecMechList cSecMechList = null;
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not zOS");
                }
                if ((csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired") || csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported")) && csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported") && !csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")) {
                    transportCount = 2;
                }
            }
            String claimMessageSupportedAuthMechList = csiv2.getString("com.ibm.CSI.claimMessageSupportedAuthMechList");
            Tr.debug(tc, "claimMessageSupportedAuthMechList " + claimMessageSupportedAuthMechList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "claimMessageSupportedAuthMechList " + (claimMessageSupportedAuthMechList == null ? " is null, not good." : " = " + claimMessageSupportedAuthMechList));
            }
            claimMessageSupportedAuthMechList = claimMessageSupportedAuthMechList.toLowerCase();
            ArrayList compoundSecMechList = new ArrayList();
            int authTarget = csiv2.getInteger("com.ibm.CORBA.authenticationTarget");
            if (tc.isDebugEnabled()) {
                AuthenticationTarget authenticationTarget = new AuthenticationTarget();
                Tr.debug(tc, "Authentication target is " + authenticationTarget.authTargetToMechType(authTarget));
                Tr.debug(tc, "**** ADDING CSIv2 TAGGED COMPONENTS ****");
            }
            if (authTarget == 6) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication target is KRB5");
                }
                if (claimMessageSupportedAuthMechList.contains("krb5")) {
                    gssFactory = new GSSFactory("oid:1.2.840.113554.1.2.2");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*KRB5* authentication mechanism exported.");
                    }
                }
                if (csiv2.getBoolean("com.ibm.websphere.security.krb.allowLTPAAuth") && claimMessageSupportedAuthMechList.contains("ltpa")) {
                    gssFactory = new GSSFactory("oid:1.3.18.0.2.30.2");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*LTPA* authentication mechanism exported.");
                    }
                }
                if (claimMessageSupportedAuthMechList.contains("basicauth")) {
                    gssFactory = new GSSFactory("oid:2.23.130.1.1.1");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*GSSUP* authentication mechanism exported.");
                    }
                }
                if (isAdmin) {
                    gssFactory = new GSSFactory("oid:1.3.18.0.2.30.6");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*RSA* authentication mechanism exported.");
                    }
                }
            } else if (authTarget == 1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication target is LTPA");
                }
                if (claimMessageSupportedAuthMechList.contains("ltpa")) {
                    gssFactory = new GSSFactory("oid:1.3.18.0.2.30.2");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*LTPA* authentication mechanism exported.");
                    }
                }
                if (claimMessageSupportedAuthMechList.contains("basicauth")) {
                    gssFactory = new GSSFactory("oid:2.23.130.1.1.1");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*GSSUP* authentication mechanism exported.");
                    }
                }
                if (isAdmin) {
                    gssFactory = new GSSFactory("oid:1.3.18.0.2.30.6");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*RSA* authentication mechanism exported.");
                    }
                }
            } else if (authTarget == 2) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication target is LocalOS");
                }
                if (claimMessageSupportedAuthMechList.contains("krb5")) {
                    gssFactory = new GSSFactory("oid:1.2.840.113554.1.2.2");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*KRB5* authentication mechanism exported.");
                    }
                }
                if (claimMessageSupportedAuthMechList.contains("basicauth")) {
                    gssFactory = new GSSFactory("oid:2.23.130.1.1.1");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*GSSUP* authentication mechanism exported.");
                    }
                }
                if (isAdmin) {
                    gssFactory = new GSSFactory("oid:1.3.18.0.2.30.6");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*RSA* authentication mechanism exported.");
                    }
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Authentication target is SWAM");
                }
                if (claimMessageSupportedAuthMechList.contains("basicauth")) {
                    gssFactory = new GSSFactory("oid:2.23.130.1.1.1");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*GSSUP* authentication mechanism exported.");
                    }
                }
                if (isAdmin) {
                    gssFactory = new GSSFactory("oid:1.3.18.0.2.30.6");
                    CSIv2TaggedComponent.createCompoundSecMechs(transportCount, gssFactory, compoundSecMechList, connInt, taggedProfile, realmName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "*RSA* authentication mechanism exported.");
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "*** Compound security mechanism list have " + compoundSecMechList.size() + " CSIv2 TAGS ***");
                Tr.debug(tc, "*** COMPLETED PROCESSING CSIv2 TAGS ***");
            }
            ArrayList<CompoundSecMechList> cSecMechListArray = new ArrayList<CompoundSecMechList>(1);
            ArrayList<ComponentDataHolder> cDataHolderArray = new ArrayList<ComponentDataHolder>(1);
            cSecMechs = compoundSecMechList.toArray(new CompoundSecMech[compoundSecMechList.size()]);
            cSecMechList = new CompoundSecMechList(csiv2.getBoolean("com.ibm.CSI.claimStateful"), cSecMechs);
            cSecMechListArray.add(cSecMechList);
            if (createPartialTags) {
                AS_ContextSec as_context_mech_null = new AS_ContextSec(0, 0, new byte[0], new byte[0]);
                SAS_ContextSec sas_context_mech_null = new SAS_ContextSec(0, 0, new ServiceConfiguration[0], new byte[0][], 0);
                CompoundSecMech compoundSecMechFirst = (CompoundSecMech)compoundSecMechList.get(0);
                TaggedComponent first_transport_mech = compoundSecMechFirst.transport_mech;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Going to create a compoundSecMech tag with only a transport layer set to : " + first_transport_mech + ", target_requires: " + trans_target_requires);
                }
                CompoundSecMech compoundSecMechTransportOnly = new CompoundSecMech(trans_target_requires, first_transport_mech, as_context_mech_null, sas_context_mech_null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Created a compoundSecMech with only a transport layer: " + compoundSecMechTransportOnly);
                }
                CompoundSecMech[] cSecMechsTransport = new CompoundSecMech[]{compoundSecMechTransportOnly};
                CompoundSecMechList cSecMechListTransport = new CompoundSecMechList(csiv2.getBoolean("com.ibm.CSI.claimStateful"), cSecMechsTransport);
                cSecMechListArray.add(cSecMechListTransport);
            }
            theAny = orb.create_any();
            for (int i = 0; i < cSecMechListArray.size(); ++i) {
                byte[] data;
                block53: {
                    CompoundSecMechList secMechList = (CompoundSecMechList)cSecMechListArray.get(i);
                    if (secMechList != null) {
                        CompoundSecMechListHelper.insert(theAny, secMechList);
                    }
                    data = null;
                    try {
                        data = csiUtil.getCodec().encode_value(theAny);
                    }
                    catch (InvalidTypeForEncoding itfe) {
                        Manager.Ffdc.log(itfe, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1539");
                        if (!tc.isDebugEnabled()) break block53;
                        Tr.debug(tc, "An InvalidTypeForEncoding exception occurred.", new Object[]{itfe});
                    }
                }
                ComponentDataHolder cdata = new ComponentDataHolder();
                cDataHolderArray.add(i, cdata);
                cdata.value = new ComponentData(33, data);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CSI Tagged Component exported.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCSIv2ComponentData", cDataHolderArray);
            }
            return cDataHolderArray;
        }
        catch (Exception ex) {
            Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1555");
            Tr.debug(tc, ex.getMessage(), new Object[]{ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCSIv2ComponentData", null);
            }
            return null;
        }
    }

    private static void createCompoundSecMechs(int transportCount, GSSFactory gssFactory, List compoundSecMechList, SecurityConnectionInterceptor connInt, Profile taggedProfile, String realmName) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCompoundSecMechs", new Object[]{gssFactory.getOID()});
            }
            try {
                for (int i = 0; i < transportCount; ++i) {
                    CompoundData compoundData = null;
                    compoundData = CSIv2TaggedComponent.createTransportLayerTag(i, transportCount, connInt, taggedProfile);
                    TaggedComponent transport_mech = (TaggedComponent)compoundData._mechanism;
                    trans_target_requires = compoundData._requires;
                    compoundData = CSIv2TaggedComponent.createMessageLayerTag(gssFactory, realmName);
                    AS_ContextSec as_context_mech = (AS_ContextSec)compoundData._mechanism;
                    short as_target_requires = compoundData._requires;
                    compoundData = CSIv2TaggedComponent.createAttributeLayerTag(gssFactory, realmName);
                    SAS_ContextSec sas_context_mech = (SAS_ContextSec)compoundData._mechanism;
                    short sas_target_requires = compoundData._requires;
                    short base_target_requires = (short)(trans_target_requires | as_target_requires | sas_target_requires);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Base target_requires exported for CSIv2: " + base_target_requires);
                    }
                    CompoundSecMech compoundSecMech = null;
                    if (transport_mech != null && as_context_mech != null && sas_context_mech != null) {
                        compoundSecMech = new CompoundSecMech(base_target_requires, transport_mech, as_context_mech, sas_context_mech);
                    }
                    if (compoundSecMech == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Added compound security mechanism to the list.");
                    }
                    compoundSecMechList.add(compoundSecMech);
                }
            }
            catch (Exception e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.createCompoundSecMechs", "1054");
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "An exception occurred adding a compound tag.", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCompoundSecMechs");
        }
    }

    private static CompoundData createTransportLayerTag(int currentTransportCount, int totalTransportCount, SecurityConnectionInterceptor connInt, Profile taggedProfile) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTransportLayerTag");
        }
        TaggedComponent transport_mech = null;
        ORB orb = VaultImpl.getInstance().getORB();
        Any theAny = null;
        CSIUtil csiUtil = new CSIUtil();
        short trans_target_supports = 0;
        short trans_target_requires = 0;
        int trans_port = 0;
        TransportAddress[] taddrList = new TransportAddress[1];
        TLS_SEC_TRANS tlsTrans = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired") || csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported")) {
            byte[] data;
            block62: {
                String sslPort;
                SSLServerConnectionData serverConnData;
                SSLServerConnectionData serverClientCertConnData;
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegrityRequired")) {
                    trans_target_requires = (short)(trans_target_requires | 2);
                    trans_target_supports = (short)(trans_target_supports | 2);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialityRequired")) {
                    trans_target_requires = (short)(trans_target_requires | 4);
                    trans_target_supports = (short)(trans_target_supports | 4);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageIntegritySupported")) {
                    trans_target_supports = (short)(trans_target_supports | 2);
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialitySupported")) {
                    trans_target_supports = (short)(trans_target_supports | 4);
                }
                trans_target_supports = (short)(trans_target_supports | 0x20);
                if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported") && !csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")) {
                    if (currentTransportCount % 2 == 1 && !PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        trans_target_requires = (short)(trans_target_requires | 0x40);
                        trans_target_supports = (short)(trans_target_supports | 0x40);
                        serverClientCertConnData = connInt.getCSIClientCertRegisteredSSLServerConnectionDataObject();
                        if (serverClientCertConnData != null) {
                            trans_port = serverClientCertConnData.getServerPort();
                            if (trans_port <= 0) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        } else {
                            trans_port = csiv2.getInteger("com.ibm.CSI.ClientCertSSLPort");
                            if (trans_port <= 0 && tc.isDebugEnabled()) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        }
                    } else {
                        serverConnData = connInt.getCSIRegisteredSSLServerConnectionDataObject();
                        if (serverConnData != null) {
                            trans_port = serverConnData.getServerPort();
                            if (trans_port == 0) {
                                try {
                                    sslPort = orb.getProperty("com.ibm.CSI.SSLPort");
                                    trans_port = sslPort == null ? 0 : Integer.parseInt(sslPort);
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                            if (trans_port <= 0) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        } else {
                            trans_port = csiv2.getInteger("com.ibm.CSI.SSLPort");
                            if (trans_port == 0) {
                                try {
                                    sslPort = orb.getProperty("com.ibm.CSI.SSLPort");
                                    trans_port = sslPort == null ? 0 : Integer.parseInt(sslPort);
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                            if (trans_port <= 0) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        }
                    }
                } else if (csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")) {
                    trans_target_requires = (short)(trans_target_requires | 0x40);
                    trans_target_supports = (short)(trans_target_supports | 0x40);
                    if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                        serverClientCertConnData = connInt.getCSIClientCertRegisteredSSLServerConnectionDataObject();
                        if (serverClientCertConnData != null) {
                            trans_port = serverClientCertConnData.getServerPort();
                            if (trans_port <= 0) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        } else {
                            trans_port = csiv2.getInteger("com.ibm.CSI.ClientCertSSLPort");
                            if (trans_port <= 0) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        }
                    } else {
                        serverConnData = connInt.getCSIRegisteredSSLServerConnectionDataObject();
                        if (serverConnData != null) {
                            trans_port = serverConnData.getServerPort();
                            if (trans_port == 0) {
                                try {
                                    sslPort = orb.getProperty("com.ibm.CSI.SSLPort");
                                    trans_port = sslPort == null ? 0 : Integer.parseInt(sslPort);
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                            if (trans_port <= 0) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        } else {
                            trans_port = csiv2.getInteger("com.ibm.CSI.SSLPort");
                            if (trans_port == 0) {
                                try {
                                    sslPort = orb.getProperty("com.ibm.CSI.SSLPort");
                                    trans_port = sslPort == null ? 0 : Integer.parseInt(sslPort);
                                }
                                catch (NumberFormatException nfe) {
                                    // empty catch block
                                }
                            }
                            if (trans_port <= 0) {
                                Tr.error(tc, "security.JSAS0446E");
                            }
                        }
                    }
                } else {
                    serverConnData = connInt.getCSIRegisteredSSLServerConnectionDataObject();
                    if (serverConnData != null) {
                        trans_port = serverConnData.getServerPort();
                        if (trans_port == 0) {
                            try {
                                sslPort = orb.getProperty("com.ibm.CSI.SSLPort");
                                trans_port = sslPort == null ? 0 : Integer.parseInt(sslPort);
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                        if (trans_port <= 0) {
                            Tr.error(tc, "security.JSAS0446E");
                        }
                    } else {
                        trans_port = csiv2.getInteger("com.ibm.CSI.SSLPort");
                        if (trans_port == 0) {
                            try {
                                sslPort = orb.getProperty("com.ibm.CSI.SSLPort");
                                trans_port = sslPort == null ? 0 : Integer.parseInt(sslPort);
                            }
                            catch (NumberFormatException nfe) {
                                // empty catch block
                            }
                        }
                        if (trans_port <= 0 && tc.isDebugEnabled()) {
                            Tr.error(tc, "security.JSAS0446E");
                        }
                    }
                }
                if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting the TCP/IP port in the IOR profile to 0");
                    }
                    taggedProfile.setPort(0);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Transport security target_requires for CSIv2: " + trans_target_requires + ". Transport security target_supports for CSIv2: " + trans_target_supports);
                }
                short short_trans_port = (short)trans_port;
                taddrList[0] = new TransportAddress(hostname, short_trans_port);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Configured hostname at transport layer for CSIv2: " + hostname + ". Configured port at transport layer for CSIv2: " + trans_port);
                }
                tlsTrans = new TLS_SEC_TRANS(trans_target_supports, trans_target_requires, taddrList);
                theAny = orb.create_any();
                TLS_SEC_TRANSHelper.insert(theAny, tlsTrans);
                data = null;
                try {
                    data = csiUtil.getCodec().encode_value(theAny);
                }
                catch (InvalidTypeForEncoding itfe) {
                    Manager.Ffdc.log(itfe, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1162");
                    if (!tc.isDebugEnabled()) break block62;
                    Tr.debug(tc, "An InvalidTypeForEncoding exception occurred.", new Object[]{itfe});
                }
            }
            transport_mech = new TaggedComponent(36, data);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SSL/TLS transport security mechanism exported for CSIv2.");
            }
        } else {
            transport_mech = new TaggedComponent(34, new byte[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No transport security mechanism exported for CSIv2.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTransportLayerTag");
        }
        return new CompoundData(transport_mech, trans_target_requires);
    }

    private static CompoundData createMessageLayerTag(GSSFactory gssFactory, String realmName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMessageLayerTag", realmName);
        }
        AS_ContextSec as_context_mech = null;
        ORB orb = VaultImpl.getInstance().getORB();
        Object theAny = null;
        Object strm1 = null;
        CSIUtil csiUtil = new CSIUtil();
        short as_target_supports = 0;
        short as_target_requires = 0;
        byte[] as_client_auth_mech = null;
        byte[] as_target_name = null;
        String tName = null;
        boolean addComponentTag = false;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        String serverName = orb.getProperty("com.ibm.CORBA.ServerName");
        if (!csiv2.getBoolean("com.ibm.CORBA.serverSecurityEnabled") && !serverName.equals("nodeagent") && !serverName.equals("dmgr") && csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
            as_context_mech = new AS_ContextSec(0, 0, new byte[0], new byte[0]);
        } else {
            if (csiv2.getBoolean("com.ibm.CSI.claimClientAuthenticationRequired")) {
                as_target_requires = 64;
                as_target_supports = 64;
            }
            if (csiv2.getBoolean("com.ibm.CSI.claimClientAuthenticationSupported")) {
                as_target_supports = 64;
            }
            if (csiv2.getBoolean("com.ibm.CSI.claimClientAuthenticationSupported") || csiv2.getBoolean("com.ibm.CSI.claimClientAuthenticationRequired")) {
                block20: {
                    as_client_auth_mech = gssFactory.getOID().getDER();
                    if (OID.compareOIDs("oid:1.2.840.113554.1.2.2", csiv2.getString("com.ibm.CSI.WSSecurityContextActiveOID")) && OID.compareOIDs("oid:1.2.840.113554.1.2.2", gssFactory.getOID().toString())) {
                        tName = csiv2.getString("com.ibm.websphere.security.krb.spn") + "@" + csiv2.getString("com.ibm.websphere.security.krb.realm");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Kerberos SPN: " + tName);
                        }
                    } else {
                        tName = RealmSecurityName.getRealm(csiv2.getString("com.ibm.CORBA.principalName"));
                        tName = realmName;
                    }
                    if (tName == null || tName.length() == 0) {
                        tName = csiv2.getString("com.ibm.CORBA.realmName");
                    }
                    try {
                        as_target_name = gssFactory.encodeExportedTargetName(tName);
                    }
                    catch (GSSEncodeDecodeException gssed) {
                        Manager.Ffdc.log(gssed, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.createMessageLayerTag", "1484");
                        if (!tc.isDebugEnabled()) break block20;
                        Tr.debug(tc, "A GSSEncodeDecodeException exception occurred.", new Object[]{gssed});
                    }
                }
                if (as_target_name == null) {
                    as_target_name = new byte[]{};
                }
                as_context_mech = new AS_ContextSec(as_target_supports, as_target_requires, as_client_auth_mech, as_target_name);
            }
        }
        if (as_context_mech == null) {
            as_context_mech = new AS_ContextSec(0, 0, new byte[0], new byte[0]);
        }
        if (tc.isDebugEnabled()) {
            if (as_target_supports != 0) {
                if (tName != null && tName.length() != 0) {
                    Tr.debug(tc, "Exported target name object: " + tName);
                } else {
                    Tr.debug(tc, "No exported target name object exported for CSIv2.");
                }
                Tr.debug(tc, "Client auth target_requires for CSIv2: " + as_target_requires + ". Client auth target_supports for CSIv2: " + as_target_supports);
            } else {
                Tr.debug(tc, "No client auth security mechanism exported for CSIv2.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createMessageLayerTag");
        }
        return new CompoundData(as_context_mech, as_target_requires);
    }

    private static CompoundData createAttributeLayerTag(GSSFactory gssFactory, String realmName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAttributeLayerTag", realmName);
        }
        SAS_ContextSec sas_context_mech = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        ORB orb = VaultImpl.getInstance().getORB();
        CDROutputStream strm1 = null;
        short sas_target_supports = 0;
        short sas_target_requires = 0;
        byte[] sas_name = null;
        ServiceConfiguration[] privilege_authorities = null;
        privilege_authorities = new ServiceConfiguration[]{new ServiceConfiguration(0, sas_name)};
        byte[][] supported_naming_mechanismsList = new byte[][]{};
        int supported_identity_types = 0;
        String serverName = orb.getProperty("com.ibm.CORBA.ServerName");
        if (!csiv2.getBoolean("com.ibm.CORBA.serverSecurityEnabled") && !serverName.equals("nodeagent") && !serverName.equals("dmgr") && csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
            sas_context_mech = new SAS_ContextSec(0, 0, new ServiceConfiguration[0], new byte[0][], 0);
        } else if (csiv2.getBoolean("com.ibm.CSI.claimIdentityAssertionSupported") || csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled")) {
            if (csiv2.getBoolean("com.ibm.CSI.claimIdentityAssertionSupported")) {
                int numOfSuppNamingMech = 1;
                supported_naming_mechanismsList = new byte[numOfSuppNamingMech][];
                supported_naming_mechanismsList[0] = gssFactory.getOID().getDER();
                supported_identity_types = 15;
                sas_target_supports = (short)(sas_target_supports | 0x400);
            }
            if (csiv2.getBoolean("com.ibm.CSI.rmiInboundPropagationEnabled")) {
                strm1 = ORB.createCDROutputStream((ORB)orb);
                strm1.write_string(realmName);
                sas_name = strm1.toByteArray();
                privilege_authorities = new ServiceConfiguration[]{new ServiceConfiguration(1229066446, sas_name)};
            } else {
                strm1 = ORB.createCDROutputStream((ORB)orb);
                strm1.write_string("");
                sas_name = strm1.toByteArray();
                privilege_authorities = new ServiceConfiguration[]{new ServiceConfiguration(0, sas_name)};
            }
            sas_context_mech = new SAS_ContextSec(sas_target_supports, sas_target_requires, privilege_authorities, supported_naming_mechanismsList, supported_identity_types);
        }
        if (sas_context_mech == null) {
            sas_context_mech = new SAS_ContextSec(0, 0, new ServiceConfiguration[0], new byte[0][], 0);
        }
        if (tc.isDebugEnabled()) {
            if ((sas_target_supports & 0x400) != 0) {
                Tr.debug(tc, "Identity assertion exported for CSIv2.");
            } else {
                Tr.debug(tc, "No identity assertion exported for CSIv2.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAttributeLayerTag");
        }
        return new CompoundData(sas_context_mech, sas_target_requires);
    }

    public boolean isStateFul() {
        return this._stateful;
    }

    public AS_ContextSecHolder getAS_context_mech_holder() {
        return this.as_context_mech_holder;
    }

    public SAS_ContextSecHolder getSAS_context_mech_holder() {
        return this.sas_context_mech_holder;
    }

    public Profile getIORProfile() {
        return this.profile;
    }

    public static synchronized IOR changeSSLPortForWLM(IOR ior, String host, short sslPort, short sslClientCertPort) {
        CSIv2Config csiv2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeSSLPortForWLM", new Object[]{ior, host, new Short(sslPort), new Short(sslClientCertPort)});
        }
        if (!(csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CORBA.securityEnabled")) {
            return null;
        }
        byte[] csiv2Tag = null;
        CSIUtil csiUtil = new CSIUtil();
        ORB orb = VaultImpl.getInstance().getORB();
        Any tagInsideAny = null;
        Profile profile = null;
        try {
            if (ior == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WLM Failover: IOR passed in is null.");
                }
                return null;
            }
            profile = ior.getProfile(0);
            csiv2Tag = profile.getTaggedComponent(33);
            if (csiv2Tag != null) {
                byte[] data;
                block52: {
                    try {
                        tagInsideAny = csiUtil.getCodec().decode_value(csiv2Tag, CompoundSecMechListHelper.type());
                    }
                    catch (MARSHAL e) {
                        Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1660");
                        Tr.debug(tc, e.getMessage(), new Object[]{e});
                    }
                    catch (BAD_OPERATION ex) {
                        Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1665");
                        Tr.debug(tc, ex.getMessage(), new Object[]{ex});
                    }
                    catch (FormatMismatch fm) {
                        Manager.Ffdc.log(fm, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1670");
                        Tr.debug(tc, fm.getMessage(), new Object[]{fm});
                    }
                    catch (TypeMismatch tm) {
                        Manager.Ffdc.log(tm, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.changeSSLPortForWLM", "1675");
                        Tr.debug(tc, tm.getMessage(), new Object[]{tm});
                    }
                    CompoundSecMechList csiv2SecMechList = null;
                    if (tagInsideAny != null) {
                        csiv2SecMechList = CompoundSecMechListHelper.extract(tagInsideAny);
                    }
                    if (csiv2SecMechList != null && csiv2SecMechList.mechanism_list != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WLM Failover: " + csiv2SecMechList.mechanism_list.length + " CompoundSecMechanism(s) in Tagged Component.");
                        }
                        for (int i = 0; i < csiv2SecMechList.mechanism_list.length; ++i) {
                            byte[] data2;
                            block51: {
                                TaggedComponent tcomp = csiv2SecMechList.mechanism_list[i].transport_mech;
                                if (tcomp == null || tcomp.tag != 36) continue;
                                Any theAny = null;
                                try {
                                    theAny = csiUtil.getCodec().decode_value(tcomp.component_data, TLS_SEC_TRANSHelper.type());
                                }
                                catch (MARSHAL e) {
                                    Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "1711");
                                    Tr.debug(tc, e.getMessage(), new Object[]{e});
                                }
                                catch (BAD_OPERATION ex) {
                                    Manager.Ffdc.log(ex, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "1716");
                                    Tr.debug(tc, ex.getMessage(), new Object[]{ex});
                                }
                                catch (FormatMismatch fm) {
                                    Manager.Ffdc.log(fm, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "1721");
                                    Tr.debug(tc, fm.getMessage(), new Object[]{fm});
                                }
                                catch (TypeMismatch tm) {
                                    Manager.Ffdc.log(tm, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.CSIv2TaggedComponent", "1726");
                                    Tr.debug(tc, tm.getMessage(), new Object[]{tm});
                                }
                                TLS_SEC_TRANSHolder transport_mech_TLSHolder = new TLS_SEC_TRANSHolder(TLS_SEC_TRANSHelper.extract(theAny));
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "WLM Failover: CSI Security Transport values, transport layer: TLS, target requires = " + transport_mech_TLSHolder.value.target_requires + " target supports = " + transport_mech_TLSHolder.value.target_supports);
                                }
                                if (transport_mech_TLSHolder.value.addresses != null || transport_mech_TLSHolder.value.addresses.length != 0) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "WLM Failover: Old Host = " + transport_mech_TLSHolder.value.addresses[0].host_name + ", New Host = " + host);
                                    }
                                    if ((transport_mech_TLSHolder.value.target_requires & 0x40) != 0) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "WLM Failover: ClientCert Req: Old Port = " + transport_mech_TLSHolder.value.addresses[0].port + ", New Port = " + sslClientCertPort);
                                        }
                                        transport_mech_TLSHolder.value.addresses[0].port = sslClientCertPort;
                                        transport_mech_TLSHolder.value.addresses[0].host_name = host;
                                    } else if ((transport_mech_TLSHolder.value.target_supports & 0x40) != 0) {
                                        if (i == 0) {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "WLM Failover: ClientCert Supt1: Old Port = " + transport_mech_TLSHolder.value.addresses[0].port + ", New Port = " + sslPort);
                                            }
                                            transport_mech_TLSHolder.value.addresses[0].port = sslPort;
                                            transport_mech_TLSHolder.value.addresses[0].host_name = host;
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug(tc, "WLM Failover: ClientCert Supt2: Old Port = " + transport_mech_TLSHolder.value.addresses[0].port + ", New Port = " + sslClientCertPort);
                                            }
                                            transport_mech_TLSHolder.value.addresses[0].port = sslClientCertPort;
                                            transport_mech_TLSHolder.value.addresses[0].host_name = host;
                                        }
                                    } else {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "WLM Failover: ClientCert NotSupt: Old Port = " + transport_mech_TLSHolder.value.addresses[0].port + ", New Port = " + sslPort);
                                        }
                                        transport_mech_TLSHolder.value.addresses[0].port = sslPort;
                                        transport_mech_TLSHolder.value.addresses[0].host_name = host;
                                    }
                                }
                                theAny = orb.create_any();
                                TLS_SEC_TRANSHelper.insert(theAny, transport_mech_TLSHolder.value);
                                data2 = null;
                                try {
                                    data2 = csiUtil.getCodec().encode_value(theAny);
                                }
                                catch (InvalidTypeForEncoding itfe) {
                                    Manager.Ffdc.log(itfe, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1792");
                                    if (!tc.isDebugEnabled()) break block51;
                                    Tr.debug(tc, "An InvalidTypeForEncoding exception occurred.", new Object[]{itfe});
                                }
                            }
                            csiv2SecMechList.mechanism_list[i].transport_mech = new TaggedComponent(36, data2);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WLM Failover: No CSIv2 CompoundSecMech structures in tagged component.");
                        }
                        return null;
                    }
                    tagInsideAny = orb.create_any();
                    try {
                        CompoundSecMechListHelper.insert(tagInsideAny, csiv2SecMechList);
                    }
                    catch (SystemException e) {
                        Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1825");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "WLM Failover: Error inserting CSIv2 CompoundSecMech into Any.", new Object[]{e});
                        }
                        return null;
                    }
                    data = null;
                    try {
                        data = csiUtil.getCodec().encode_value(tagInsideAny);
                    }
                    catch (InvalidTypeForEncoding itfe) {
                        Manager.Ffdc.log(itfe, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2ComponentData", "1838");
                        if (!tc.isDebugEnabled()) break block52;
                        Tr.debug(tc, "WLM Failover: An InvalidTypeForEncoding exception occurred.", new Object[]{itfe});
                    }
                }
                ComponentDataHolder cDataHolder = new ComponentDataHolder();
                cDataHolder.value = new ComponentData(33, data);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WLM Failover: CSI Tagged Component exported.");
                }
                TaggedComponent tagc = null;
                if (cDataHolder.value != null) {
                    Tr.debug(tc, "WLM Failover: Adding tagged component ID: " + cDataHolder.value.componentID);
                    tagc = new TaggedComponent(cDataHolder.value.componentID, cDataHolder.value.componentBodyValue);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WLM Failover: No security tagged components applied to IOR during create.");
                }
                if (tagc != null) {
                    profile.putTaggedComponent(33, tagc.component_data);
                    ior.putProfile(profile);
                    return ior;
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WLM Failover: No CSIv2 tagged component exists in IOR.");
            }
            return null;
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getCSIv2TaggedComponentList", "1888");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WLM Failover: Java Exception getting CSIv2TaggedComponent.", new Object[]{e});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "changeSSLPortForWLM", null);
            }
            return null;
        }
    }

    public static List getSecureChains() {
        if (!secureChainListInitialized) {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            secureChainList = (List)security2.getObject("iiop.secure.transports");
            secureChainListInitialized = true;
        }
        return secureChainList;
    }

    public static List getInsecureChains() {
        if (!insecureChainListInitialized) {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            insecureChainList = (List)security2.getObject("iiop.insecure.transports");
            insecureChainListInitialized = true;
        }
        return insecureChainList;
    }

    private static String getHostName() {
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (!csiv2.getBoolean("com.ibm.CORBA.securityEnabled")) {
            return null;
        }
        try {
            hostname = VaultImpl.getInstance().getORB().getLocalHost();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Transport host name = " + hostname);
            }
            if (PlatformHelperFactory.getPlatformHelper().isZOS() && hostname != null) {
                return hostname;
            }
            try {
                final String hostString = hostname;
                hostname = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws UnknownHostException {
                        InetAddress host = InetAddress.getByName(hostString);
                        return host.getHostAddress();
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getHostName", "1987");
                hostname = "localhost";
            }
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, thisClass, "com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent.getHostName", "1994");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception getting hostname for transport address.", new Object[]{e});
            }
            hostname = null;
        }
        if (hostname == null || hostname.length() == 0) {
            hostname = "localHost";
        }
        return hostname;
    }

    private static class CompoundData {
        public Object _mechanism = null;
        public short _requires = 0;

        CompoundData(Object mechanism, short requires) {
            this._mechanism = mechanism;
            this._requires = requires;
        }
    }
}

