/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ComponentDataHolder;
import com.ibm.IExtendedSecurityPriv.ObjectDoesNotExistHere;
import com.ibm.ISecurityLocalObjectBaseL13Impl.APPSECTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.DomainInfo;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SSLTaggedComponent;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.CSIv2TaggedComponent;
import com.ibm.ISecurityUtilityImpl.MechanismFactory;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.security.auth.Subject;

public class SecurityTaggedComponentAssistorImpl {
    private int connectionType = 0;
    private ORB orb = null;
    private SecurityConnectionInterceptor _connInterceptor = null;
    private static final short WebSphereAS = 16384;
    private ComponentData[] compDataArray = null;
    private ComponentData[] appCompDataArray = null;
    private static final TraceComponent tc = Tr.register(SecurityTaggedComponentAssistorImpl.class, "SASRas", "com.ibm.ISecurityL13SupportImpl.sec");
    public static final String SecurityWebSphereContext = "Security.WebSphere";
    public static Hashtable completeTagsTable = new Hashtable();
    public static ComponentData[] completeCompDataArray = null;
    public static ComponentData[] completeAppCompDataArray = null;

    public SecurityTaggedComponentAssistorImpl(int connectionType, SecurityConnectionInterceptor connInterceptor) {
        this.connectionType = connectionType;
        this._connInterceptor = connInterceptor;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public static SecurityTaggedComponentAssistorImpl[] create(ORB orb, MechanismFactory in_MechanismFactory, SecurityConnectionInterceptor connInterceptor) {
        SecurityTaggedComponentAssistorImpl TCPassistor = null;
        SecurityTaggedComponentAssistorImpl SSLassistor = null;
        SecurityTaggedComponentAssistorImpl APPSECassistor = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        int assistorCount = 0;
        Tr.debug(tc, "Handling Application Server Security tagged component assistor");
        Tr.debug(tc, "Creating Application Server SecurityTaggedComonentAssistorImpl.");
        APPSECassistor = new SecurityTaggedComponentAssistorImpl(2, connInterceptor);
        ++assistorCount;
        Tr.debug(tc, "Handling CSIv2 tagged component assistors.");
        if (!csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")) {
            Tr.debug(tc, "Creating TCP/IP SecurityTaggedComponentAssistorImpl.");
            TCPassistor = new SecurityTaggedComponentAssistorImpl(0, connInterceptor);
            ++assistorCount;
        }
        if (csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired") || csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported")) {
            Tr.debug(tc, "Creating SSL SecurityTaggedComponentAssistorImpl.");
            SSLassistor = new SecurityTaggedComponentAssistorImpl(2, connInterceptor);
            ++assistorCount;
        }
        SecurityTaggedComponentAssistorImpl[] assistorList = new SecurityTaggedComponentAssistorImpl[assistorCount];
        int i = 0;
        if (TCPassistor != null) {
            assistorList[i] = TCPassistor;
            ++i;
        }
        if (SSLassistor != null) {
            assistorList[i] = SSLassistor;
            ++i;
        }
        if (APPSECassistor != null) {
            assistorList[i] = APPSECassistor;
            ++i;
        }
        Tr.debug(tc, "Tagged assistorList [ " + i + " ] created.");
        return assistorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized ComponentData[] getComponentData(Profile taggedProfile, boolean isAdmin, boolean createPartialTags) throws ObjectDoesNotExistHere {
        String domainName;
        block49: {
            block48: {
                int app_taglistLength;
                int taglistLength;
                ComponentDataHolder ssltag_cdata;
                ComponentDataHolder app_apptag_cdata;
                ComponentDataHolder complete_app_csiv2_cdata;
                ComponentDataHolder app_csiv2_cdata;
                ComponentDataHolder apptag_cdata;
                ComponentDataHolder complete_csiv2_cdata;
                ComponentDataHolder csiv2_cdata;
                block47: {
                    SecurityConfig appSec;
                    boolean pushed;
                    String appRealm;
                    String fullSecName;
                    ArrayList array_app_csiv2_cdata;
                    block46: {
                        domainName = null;
                        if (createPartialTags) {
                            domainName = SecurityObjectLocator.getSecurityConfigManager().getDomainName();
                        }
                        if (this.compDataArray != null && !SecurityObjectLocator.getSecurityConfigManager().isAdminAgent() && !PlatformHelperFactory.getPlatformHelper().isZOS()) break block48;
                        ArrayList array_csiv2_cdata = new ArrayList(1);
                        csiv2_cdata = null;
                        complete_csiv2_cdata = null;
                        apptag_cdata = null;
                        array_app_csiv2_cdata = new ArrayList(1);
                        app_csiv2_cdata = null;
                        complete_app_csiv2_cdata = null;
                        app_apptag_cdata = null;
                        ssltag_cdata = null;
                        fullSecName = this.getSecurityName();
                        String adminRealm = null;
                        if (SecurityObjectLocator.getSecurityConfigManager().isAdminAgent()) {
                            adminRealm = RealmSecurityName.getRealm(SecurityObjectLocator.getCSIv2Config().getString("com.ibm.CORBA.principalName"));
                            if (adminRealm == null || adminRealm.length() < 1) {
                                adminRealm = DomainInfo.getAdminRealm();
                            }
                        } else {
                            adminRealm = DomainInfo.getAdminRealm();
                        }
                        if ((appRealm = DomainInfo.getAppRealm()) == null || appRealm.equals("")) {
                            appRealm = adminRealm;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adminRealm = " + adminRealm + " appRealm = " + appRealm);
                        }
                        taglistLength = 2;
                        app_taglistLength = 1;
                        pushed = false;
                        pushed = SecurityObjectLocator.pushAdminContext();
                        try {
                            CSIv2Config csiv2;
                            array_csiv2_cdata = CSIv2TaggedComponent.getCSIv2ComponentData(this._connInterceptor, fullSecName, taggedProfile, adminRealm, isAdmin, createPartialTags);
                            csiv2_cdata = (ComponentDataHolder)array_csiv2_cdata.get(0);
                            if (createPartialTags && array_csiv2_cdata.size() > 1) {
                                complete_csiv2_cdata = csiv2_cdata;
                                csiv2_cdata = (ComponentDataHolder)array_csiv2_cdata.get(1);
                            }
                            apptag_cdata = APPSECTaggedComponent.getAPPSECComponentData(this._connInterceptor, isAdmin);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generated admin appsec and csiv2 tags");
                            }
                            if ((csiv2 = SecurityObjectLocator.getCSIv2Config()).getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired") || csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported")) {
                                ssltag_cdata = SSLTaggedComponent.getSSLComponentData(this._connInterceptor);
                                ++taglistLength;
                                ++app_taglistLength;
                            }
                            Object var22_21 = null;
                            if (!pushed) break block46;
                        }
                        catch (Throwable throwable) {
                            Object var22_22 = null;
                            if (pushed) {
                                SecurityObjectLocator.popContext();
                            }
                            throw throwable;
                        }
                        SecurityObjectLocator.popContext();
                    }
                    if ((appSec = SecurityObjectLocator.getSecurityConfig("AppSecurity")) != null) {
                        try {
                            pushed = false;
                            UserRegistryConfig appUR = appSec.getActiveUserRegistry(false);
                            CSIv2Config appCSIv2 = appSec.getCSIv2Config(false);
                            if (appUR != null || appCSIv2 != null) {
                                pushed = SecurityObjectLocator.pushAppContext("");
                                array_app_csiv2_cdata = CSIv2TaggedComponent.getCSIv2ComponentData(this._connInterceptor, fullSecName, taggedProfile, appRealm, isAdmin, createPartialTags);
                                app_csiv2_cdata = (ComponentDataHolder)array_app_csiv2_cdata.get(0);
                                if (createPartialTags && array_app_csiv2_cdata.size() > 1) {
                                    complete_app_csiv2_cdata = app_csiv2_cdata;
                                    app_csiv2_cdata = (ComponentDataHolder)array_app_csiv2_cdata.get(1);
                                }
                                ++app_taglistLength;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "generated application csiv2 tag");
                                }
                            }
                            if (appSec.isSet("appEnabled")) {
                                if (!pushed) {
                                    pushed = SecurityObjectLocator.pushAppContext("");
                                }
                                if (tc.isDebugEnabled() && isAdmin) {
                                    Tr.debug(tc, "WARNING! isAdmin=true but setting admin=false in application appsec tag");
                                }
                                app_apptag_cdata = APPSECTaggedComponent.getAPPSECComponentData(this._connInterceptor, false);
                                ++app_taglistLength;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "generated application appsec tag");
                                }
                            }
                            Object var24_27 = null;
                            if (!pushed) break block47;
                        }
                        catch (Throwable throwable) {
                            Object var24_28 = null;
                            if (pushed) {
                                SecurityObjectLocator.popContext();
                            }
                            throw throwable;
                        }
                        SecurityObjectLocator.popContext();
                    }
                }
                int index = 0;
                int completeTag_index = 0;
                int app_index = 0;
                int completeTag_app_index = 0;
                this.compDataArray = new ComponentData[taglistLength];
                completeCompDataArray = new ComponentData[taglistLength];
                if (app_taglistLength > 0) {
                    this.appCompDataArray = new ComponentData[app_taglistLength];
                    if (createPartialTags) {
                        completeAppCompDataArray = new ComponentData[taglistLength];
                    }
                }
                if (csiv2_cdata != null && csiv2_cdata.value != null) {
                    this.compDataArray[index] = csiv2_cdata.value;
                    if (app_csiv2_cdata != null && app_csiv2_cdata.value != null) {
                        this.appCompDataArray[app_index] = app_csiv2_cdata.value;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added app_csiv2_cdata to appCompDataArray");
                        }
                    } else {
                        this.appCompDataArray[app_index] = csiv2_cdata.value;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added app_csiv2_cdata to appCompDataArray but with same value as for csiv2_cdata");
                        }
                    }
                    ++index;
                    ++app_index;
                }
                if (createPartialTags && complete_csiv2_cdata != null && complete_csiv2_cdata.value != null) {
                    SecurityTaggedComponentAssistorImpl.completeCompDataArray[completeTag_index] = complete_csiv2_cdata.value;
                    if (complete_app_csiv2_cdata != null && complete_app_csiv2_cdata.value != null) {
                        SecurityTaggedComponentAssistorImpl.completeAppCompDataArray[completeTag_app_index] = complete_app_csiv2_cdata.value;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added app_csiv2_cdata to appCompDataArray");
                        }
                    } else {
                        SecurityTaggedComponentAssistorImpl.completeAppCompDataArray[completeTag_app_index] = complete_csiv2_cdata.value;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "added app_csiv2_cdata to appCompDataArray but with same value as for csiv2_cdata");
                        }
                    }
                    ++completeTag_index;
                    ++completeTag_app_index;
                }
                if (apptag_cdata != null && apptag_cdata.value != null) {
                    this.compDataArray[index] = apptag_cdata.value;
                    ++index;
                    if (createPartialTags) {
                        SecurityTaggedComponentAssistorImpl.completeCompDataArray[completeTag_index] = apptag_cdata.value;
                        ++completeTag_index;
                    }
                }
                if (app_apptag_cdata != null && app_apptag_cdata.value != null) {
                    this.appCompDataArray[app_index] = app_apptag_cdata.value;
                    ++app_index;
                    if (createPartialTags) {
                        SecurityTaggedComponentAssistorImpl.completeAppCompDataArray[completeTag_app_index] = app_apptag_cdata.value;
                        ++completeTag_app_index;
                    }
                }
                if (ssltag_cdata != null && ssltag_cdata.value != null) {
                    this.compDataArray[index] = ssltag_cdata.value;
                    this.appCompDataArray[app_index] = ssltag_cdata.value;
                    if (createPartialTags) {
                        SecurityTaggedComponentAssistorImpl.completeCompDataArray[completeTag_index] = ssltag_cdata.value;
                        SecurityTaggedComponentAssistorImpl.completeAppCompDataArray[completeTag_app_index] = ssltag_cdata.value;
                    }
                }
                break block49;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Tags already created for server.  Returning cached component data.");
            }
        }
        if (createPartialTags && domainName != null) {
            HashMap<String, ComponentData[]> cdataMap = new HashMap<String, ComponentData[]>(2);
            cdataMap.put("admin", completeCompDataArray);
            cdataMap.put("application", completeAppCompDataArray);
            completeTagsTable.put(domainName, cdataMap);
        }
        if (isAdmin) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "returning tag component with global domain info");
            }
            return this.compDataArray;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "returning tag component with  app domain info");
        }
        return this.appCompDataArray;
    }

    private String getSecurityName() {
        String fullyQualifiedSecurityName = null;
        WSCredential serverCred = null;
        try {
            Subject serverSubject = ContextManagerFactory.getInstance().getServerSubject();
            serverCred = SubjectHelper.getWSCredentialFromSubject(serverSubject);
            CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
            fullyQualifiedSecurityName = serverCred == null ? csiv2.getString("com.ibm.CORBA.principalName") : serverCred.getRealmSecurityName();
        }
        catch (Exception e) {
            Manager.Ffdc.log(e, this, "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityTaggedComponentAssistorImpl.getSecurityName", "449", this);
            Tr.debug(tc, e.getMessage(), new Object[]{e});
        }
        return fullyQualifiedSecurityName;
    }
}

