/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.CORBA.services.redirector;

import com.ibm.ffdc.Manager;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletResponse;

public class ConnectionStream
implements Runnable {
    protected Thread running;
    protected InputStream input;
    protected OutputStream output;
    protected byte[] buf = new byte[2048];
    protected ServletResponse response;
    protected boolean busy = true;

    public ConnectionStream(InputStream in, OutputStream out) {
        this.input = in;
        this.output = out;
        this.start();
    }

    public ConnectionStream(InputStream in, OutputStream out, ServletResponse response) {
        this.response = response;
        this.input = in;
        this.output = out;
        this.start();
    }

    public void setClientInput(InputStream in) {
        this.input = in;
    }

    public void setClientOutput(OutputStream out, ServletResponse response) {
        this.output = out;
        this.response = response;
    }

    public void start() {
        if (this.running == null) {
            this.running = new Thread(this);
            this.running.start();
        }
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        while (this.busy) {
            this.readBuffer();
        }
        this.running.stop();
    }

    public void stop() {
        this.busy = false;
    }

    protected void readBuffer() {
        try {
            int count;
            int time2 = 0;
            int buflen = this.input.available();
            while (buflen <= 0 && this.busy) {
                Thread.sleep(time2);
                if (time2 < 10) {
                    ++time2;
                }
                buflen = this.input.available();
            }
            this.buf = new byte[buflen];
            if (!this.busy) {
                return;
            }
            int n = this.input.read(this.buf, 0, this.buf.length);
            int n2 = count = n <= 0 ? 0 : n;
            if (this.response != null) {
                this.response.setContentLength(count);
            }
            this.output.write(this.buf, 0, count);
        }
        catch (Throwable e) {
            Manager.Ffdc.log(e, this, "com.ibm.CORBA.services.redirector.ConnectionStream.readBuffer", "114", this);
            this.stop();
        }
    }
}

