/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import javax.transaction.xa.Xid;

public class MQXid
extends JmqiObject
implements Xid {
    private int formatId;
    private byte[] gtrid;
    private byte[] bqual;
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final char[] Hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MQXid(int formatId, byte[] gtrid, byte[] bqual) {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 462;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 462, new Object[]{new Integer(formatId), gtrid, bqual});
        }
        this.formatId = formatId;
        this.gtrid = gtrid;
        this.bqual = bqual;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 462);
        }
    }

    public int getFormatId() {
        int traceContext = 0;
        int fid = 504;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 504);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 504, (Object)new Integer(this.formatId));
        }
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getGlobalTransactionId()", (Object)this.gtrid);
        }
        return this.gtrid;
    }

    public byte[] getBranchQualifier() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getBranchQualifier()", (Object)this.bqual);
        }
        return this.bqual;
    }

    public String toString() {
        int fid = 463;
        StringBuffer result = new StringBuffer();
        result.append("format: " + this.formatId);
        result.append(", gtrid: " + MQXid.byteToHex(this.gtrid));
        result.append(", bqual: " + MQXid.byteToHex(this.bqual));
        String traceRet1 = result.toString();
        return traceRet1;
    }

    public boolean equals(Object obj) {
        int fid = 464;
        Xid other = null;
        if (!(obj instanceof Xid)) {
            return false;
        }
        other = (Xid)obj;
        if (this.formatId != other.getFormatId()) {
            return false;
        }
        byte[] otherGtrid = other.getGlobalTransactionId();
        if (this.gtrid.length != otherGtrid.length) {
            return false;
        }
        for (int i = 0; i < this.gtrid.length; ++i) {
            if (this.gtrid[i] == otherGtrid[i]) continue;
            return false;
        }
        byte[] otherBqual = other.getBranchQualifier();
        if (this.bqual.length != otherBqual.length) {
            return false;
        }
        for (int i = 0; i < this.bqual.length; ++i) {
            if (this.bqual[i] == otherBqual[i]) continue;
            return false;
        }
        return true;
    }

    static String byteToHex(byte[] data) {
        StringBuffer result = new StringBuffer(128);
        if (data != null) {
            for (int i = 0; i < data.length; ++i) {
                result.append(Hex[data[i] >> 4 & 0xF]);
                result.append(Hex[data[i] & 0xF]);
            }
        }
        return result.toString();
    }
}

