/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQDestination;
import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSubscription;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.MQSD;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class MQTopic
extends MQDestination {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQTopic.java, java.classes, k700, k700-L080529 1.41.1.1 08/06/01 08:55:24";
    private boolean durable;
    private boolean managed;
    private boolean subscribed;
    private MQSubscription subscriptionReference;
    private MQDestination unmanagedDestinationReference;
    private static HashSet validParameters = new HashSet<Object>(Arrays.asList("SubscriptionExpiry", "SubscriptionUserData", "SubscriptionCorrelationId", "PublicationPriority", "PublicationAccountingToken", "PublicationApplicationIdData"));
    private static HashSet integerParameters = new HashSet<Object>(Arrays.asList("SubscriptionExpiry", "PublicationPriority"));

    public MQTopic(MQQueueManager qMgr, String topicName, String topicObject, int openAs, int options) throws MQException {
        this(qMgr, topicName, topicObject, openAs, options, null);
        int traceContext = 0;
        int fid = 624;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 624, new Object[]{qMgr, topicName, topicObject, new Integer(openAs), new Integer(options)});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 624);
        }
    }

    public MQTopic(MQQueueManager qMgr, String topicName, String topicObject, int openAs, int options, String alternateUserId) throws MQException {
        super(8, qMgr, topicObject, options, alternateUserId);
        int traceContext = 0;
        int fid = 625;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 625, new Object[]{qMgr, topicName, topicObject, new Integer(openAs), new Integer(options), alternateUserId});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 625, "sccsid = ", (Object)sccsid);
        }
        if (openAs == 1) {
            if ((this.getOpenOptions() & 8) != 0) {
                MQException ex = new MQException(2, 2440, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 625, (Throwable)ex);
                }
                throw ex;
            }
            if ((this.getOpenOptions() & 0x20) == 0) {
                this.setOpenOptions(this.getOpenOptions() | 0x20);
            }
            if ((this.getOpenOptions() & 0) == 0) {
                this.setOpenOptions(this.getOpenOptions() | 0);
            }
            this.openForSubscription(null, topicName, null, null);
        } else {
            this.openForPublication(topicName);
        }
        this.parentQmgr.registerTopic(this);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 625);
        }
    }

    private void openForPublication(String topicName) throws MQException {
        int traceContext = 0;
        int fid = 626;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 626, new Object[]{topicName});
        }
        try {
            this.setQueueManagerCmdLevel(this.Hconn.getHconn().getCmdLevel());
        }
        catch (JmqiException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 626, (Throwable)e);
            }
            MQException traceRet1 = new MQException(e.getCompCode(), e.getReason(), (Object)this, e);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 626, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        this.subscribed = false;
        MQOD mqObjectDescriptor = this.createMQOD();
        mqObjectDescriptor.setVersion(4);
        if (this.isValidStringParameter(topicName)) {
            mqObjectDescriptor.getObjectString().setVsString(topicName);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 626, "topic string = " + mqObjectDescriptor.getObjectString() + "\ntopic object = " + mqObjectDescriptor.getObjectName() + "\nqueue manager = " + mqObjectDescriptor.getObjectQMgrName() + "\noptions = " + this.getOpenOptions(), (Object)"");
        }
        this.open(mqObjectDescriptor);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 626);
        }
    }

    public MQTopic(MQQueueManager qMgr, String topicName, String topicObject, int options, String alternateUserId, String subscriptionName) throws MQException {
        this(qMgr, topicName, topicObject, options, alternateUserId, subscriptionName, null);
        int traceContext = 0;
        int fid = 627;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 627, new Object[]{qMgr, topicName, topicObject, new Integer(options), alternateUserId, subscriptionName});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 627);
        }
    }

    public MQTopic(MQQueueManager qMgr, String topicName, String topicObject, int options, String alternateUserId, String subscriptionName, Hashtable parameters) throws MQException {
        super(8, qMgr, topicObject, options, alternateUserId);
        int traceContext = 0;
        int fid = 628;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 628, new Object[]{qMgr, topicName, topicObject, new Integer(options), alternateUserId, subscriptionName, parameters});
        }
        if (subscriptionName == null && (this.getOpenOptions() & 8) != 0) {
            MQException ex = new MQException(2, 2440, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 628, (Throwable)ex, 1);
            }
            throw ex;
        }
        if ((this.getOpenOptions() & 0x20) == 0) {
            this.setOpenOptions(this.getOpenOptions() | 0x20);
        }
        if (!MQTopic.validTopicParameters(parameters)) {
            MQException ex = new MQException(2, 2046, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 628, (Throwable)ex, 2);
            }
            throw ex;
        }
        this.openForSubscription(null, topicName, subscriptionName, parameters);
        this.parentQmgr.registerTopic(this);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 628);
        }
    }

    public MQTopic(MQQueueManager qMgr, MQDestination destination, String topicName, String topicObject, int options) throws MQException {
        this(qMgr, destination, topicName, topicObject, options, null, null, null);
        int traceContext = 0;
        int fid = 629;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 629, new Object[]{qMgr, destination, topicName, topicObject, new Integer(options)});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 629);
        }
    }

    public MQTopic(MQQueueManager qMgr, MQDestination destination, String topicName, String topicObject, int options, String alternateUserId) throws MQException {
        this(qMgr, destination, topicName, topicObject, options, alternateUserId, null, null);
        int traceContext = 0;
        int fid = 630;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 630, new Object[]{qMgr, destination, topicName, topicObject, new Integer(options), alternateUserId});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 630);
        }
    }

    public MQTopic(MQQueueManager qMgr, MQDestination destination, String topicName, String topicObject, int options, String alternateUserId, String subscriptionName) throws MQException {
        this(qMgr, destination, topicName, topicObject, options, alternateUserId, subscriptionName, null);
        int traceContext = 0;
        int fid = 631;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 631, new Object[]{qMgr, destination, topicName, topicObject, new Integer(options), alternateUserId, subscriptionName});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 631);
        }
    }

    public MQTopic(MQQueueManager qMgr, MQDestination destination, String topicName, String topicObject, int options, String alternateUserId, String subscriptionName, Hashtable parameters) throws MQException {
        super(8, qMgr, topicObject, options, alternateUserId);
        int traceContext = 0;
        int fid = 632;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 632, new Object[]{qMgr, destination, topicName, topicObject, new Integer(options), alternateUserId, subscriptionName, parameters});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 632, "sccsid = ", (Object)sccsid);
        }
        if (destination == null) {
            MQException ex = new MQException(2, 2152, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 632, (Throwable)ex, 1);
            }
            throw ex;
        }
        if ((options & 0x20) != 0) {
            MQException ex = new MQException(2, 2046, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 632, (Throwable)ex, 2);
            }
            throw ex;
        }
        if (!MQTopic.validTopicParameters(parameters)) {
            MQException ex = new MQException(2, 2046, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 632, (Throwable)ex, 3);
            }
            throw ex;
        }
        if (subscriptionName == null && (options & 8) != 0) {
            MQException ex = new MQException(2, 2440, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 632, (Throwable)ex, 4);
            }
            throw ex;
        }
        this.openForSubscription(destination, topicName, subscriptionName, parameters);
        this.parentQmgr.registerTopic(this);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 632);
        }
    }

    private static boolean validTopicParameters(Hashtable parameters) {
        if (parameters == null) {
            return true;
        }
        Iterator allParameters = parameters.keySet().iterator();
        while (allParameters.hasNext()) {
            Object currentParameter = allParameters.next();
            if (!validParameters.contains(currentParameter)) {
                return false;
            }
            Object currentParameterValue = parameters.get(currentParameter);
            boolean isIntegerParameter = integerParameters.contains(currentParameter);
            if (isIntegerParameter && currentParameterValue instanceof Integer) {
                return true;
            }
            if (!(currentParameterValue instanceof String)) {
                return false;
            }
            if (!isIntegerParameter) continue;
            try {
                Integer.parseInt((String)currentParameterValue);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return true;
    }

    private void openForSubscription(MQDestination destination, String topicName, String subscriptionName, Hashtable parameters) throws MQException {
        boolean subcriptionOpen;
        int traceContext = 0;
        int fid = 633;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 633, new Object[]{destination, topicName, subscriptionName, parameters});
        }
        try {
            this.setQueueManagerCmdLevel(this.Hconn.getHconn().getCmdLevel());
        }
        catch (JmqiException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 633, (Throwable)e);
            }
            MQException traceRet1 = new MQException(e.getCompCode(), e.getReason(), (Object)this, e);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 633, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        int options = this.getOpenOptions();
        this.subscribed = true;
        if (destination != null) {
            this.Hobj = destination.Hobj;
        }
        this.unmanagedDestinationReference = destination;
        boolean durableRequested = (options & 8) == 8;
        boolean durablePossible = subscriptionName != null && subscriptionName.length() > 0;
        this.durable = durableRequested && durablePossible;
        boolean bl = this.managed = destination == null;
        if (this.managed) {
            this.setOpenOptions(this.getOpenOptions() | 0x20);
        }
        MQSD mqSubscriptionDescriptor = this.createMQSD(topicName, subscriptionName, parameters);
        this.subscriptionReference = new MQSubscription(this, mqSubscriptionDescriptor);
        this.resourceOpen = subcriptionOpen = this.subscriptionReference.isOpen();
        this.setOpen(subcriptionOpen);
        this.setName(mqSubscriptionDescriptor.getResolvedObjectString().getVsString());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 633);
        }
    }

    private MQSD createMQSD(String topicName, String subscriptionName, Hashtable parameters) throws MQException {
        int traceContext = 0;
        int fid = 634;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 634, new Object[]{topicName, subscriptionName, parameters});
        }
        MQSD mqSubscriptionDescriptor = this.env.newMQSD();
        String altUserId = this.getAlternateUserId();
        if (this.isValidStringParameter(altUserId)) {
            mqSubscriptionDescriptor.setAlternateUserId(altUserId);
        } else {
            altUserId = mqSubscriptionDescriptor.getAlternateUserId();
            this.setAlternateUserId(altUserId);
        }
        String objectName = this.getName();
        if (this.isValidStringParameter(objectName)) {
            mqSubscriptionDescriptor.setObjectName(objectName);
        } else {
            objectName = mqSubscriptionDescriptor.getObjectName();
            this.setName(objectName);
        }
        if (this.isValidStringParameter(topicName)) {
            mqSubscriptionDescriptor.getObjectString().setVsString(topicName);
        }
        int options = this.getOpenOptions();
        mqSubscriptionDescriptor.setOptions(options);
        if (this.isValidStringParameter(subscriptionName)) {
            mqSubscriptionDescriptor.getSubName().setVsString(subscriptionName);
        }
        if (parameters != null) {
            String subUserData;
            Object subExp;
            String subCorrel;
            Object pubPrior;
            String pubApplIdentityData;
            String pubAccToken;
            String alternateSecurityId = (String)parameters.get("AlternateSecurityId");
            if (this.isValidStringParameter(alternateSecurityId)) {
                mqSubscriptionDescriptor.setAlternateSecurityId(alternateSecurityId);
            }
            if (this.isValidStringParameter(pubAccToken = (String)parameters.get("PublicationAccountingToken"))) {
                byte[] pubAccountingToken = pubAccToken.getBytes();
                mqSubscriptionDescriptor.setPubAccountingToken(pubAccountingToken);
            }
            if (this.isValidStringParameter(pubApplIdentityData = (String)parameters.get("PublicationApplicationIdData"))) {
                mqSubscriptionDescriptor.setPubApplIdentityData(pubApplIdentityData);
            }
            if ((pubPrior = parameters.get("PublicationPriority")) != null) {
                if (pubPrior instanceof Integer) {
                    mqSubscriptionDescriptor.setPubPriority(((Integer)pubPrior).intValue());
                } else if (pubPrior instanceof String && this.isValidStringParameter((String)pubPrior)) {
                    mqSubscriptionDescriptor.setPubPriority(Integer.parseInt((String)pubPrior));
                }
            }
            if (this.isValidStringParameter(subCorrel = (String)parameters.get("SubscriptionCorrelationId"))) {
                byte[] subCorrelId = subCorrel.getBytes();
                mqSubscriptionDescriptor.setSubCorrelId(subCorrelId);
            }
            if ((subExp = parameters.get("SubscriptionExpiry")) != null) {
                if (subExp instanceof Integer) {
                    mqSubscriptionDescriptor.setSubExpiry(((Integer)subExp).intValue());
                } else if (subExp instanceof String && this.isValidStringParameter((String)subExp)) {
                    Integer subExpiry = new Integer((String)subExp);
                    mqSubscriptionDescriptor.setSubExpiry(subExpiry.intValue());
                }
            }
            if (this.isValidStringParameter(subUserData = (String)parameters.get("SubscriptionUserData"))) {
                mqSubscriptionDescriptor.getSubUserData().setVsString(subUserData);
            }
        }
        mqSubscriptionDescriptor.getResolvedObjectString().setVsBufSize(10240);
        mqSubscriptionDescriptor.getSelectionString().setVsBufSize(10240);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 634, (Object)mqSubscriptionDescriptor);
        }
        return mqSubscriptionDescriptor;
    }

    public boolean isDurable() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "isDurable()", (Object)this.durable);
        }
        return this.durable;
    }

    public boolean isManaged() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "isManaged()", (Object)this.managed);
        }
        return this.managed;
    }

    public boolean isSubscribed() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "isSubscribed()", (Object)this.subscribed);
        }
        return this.subscribed;
    }

    public MQSubscription getSubscriptionReference() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getSubscriptionReference()", (Object)this.subscriptionReference);
        }
        return this.subscriptionReference;
    }

    public MQDestination getUnmanagedDestinationReference() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getUnmanagedDestinationReference()", (Object)this.unmanagedDestinationReference);
        }
        return this.unmanagedDestinationReference;
    }

    public synchronized void close() throws MQException {
        int traceContext = 0;
        int fid = 635;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 635);
        }
        if (this.Hobj.getHobj().equals(CMQC.jmqi_MQHO_UNUSABLE_HOBJ) || this.Hobj.getHobj().equals(CMQC.jmqi_MQHO_NONE)) {
            this.setOpen(false);
            if (this.subscriptionReference != null) {
                this.subscriptionReference.setOpen(false);
            }
        } else {
            super.close();
            if (this.subscriptionReference != null && !this.subscriptionReference.Hobj.getHobj().equals(CMQC.jmqi_MQHO_UNUSABLE_HOBJ) && !this.subscriptionReference.Hobj.getHobj().equals(CMQC.jmqi_MQHO_NONE)) {
                this.subscriptionReference.close();
            }
        }
        if (this.parentQmgr != null) {
            this.parentQmgr.unregisterTopic(this);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 635);
        }
    }
}

