/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQTopic;
import com.ibm.mq.Pint;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQSD;
import com.ibm.mq.jmqi.MQSRO;

public class MQSubscription
extends MQManagedObject {
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQSubscription.java, java.classes, k700, k700-L080529 1.18.1.1 08/06/01 08:55:16";
    private MQTopic topic;

    protected MQSubscription(MQTopic mqTopic, MQSD mqSubscriptionDescriptor) throws MQException {
        int traceContext = 0;
        int fid = 617;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 617, new Object[]{mqTopic, mqSubscriptionDescriptor});
        }
        this.topic = mqTopic;
        this.parentQmgr = this.topic.parentQmgr;
        this.Hconn = this.parentQmgr.Hconn;
        this.connected = this.parentQmgr.connected;
        this.osession = this.parentQmgr.osession;
        this.setConnectionReference(this.parentQmgr);
        this.setName(mqSubscriptionDescriptor.getObjectString().getVsString());
        this.setOpenOptions(mqSubscriptionDescriptor.getOptions());
        this.setAlternateUserId(mqSubscriptionDescriptor.getAlternateUserId());
        this.subscribe(mqSubscriptionDescriptor);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 617);
        }
    }

    protected void subscribe(MQSD mqSubscriptionDescriptor) throws MQException {
        int traceContext = 0;
        int fid = 618;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 618, new Object[]{mqSubscriptionDescriptor});
        }
        Pint completionCode = new Pint();
        Pint reason = new Pint();
        JmqiMQ jmqi = this.osession.getJmqi();
        jmqi.MQSUB(this.Hconn.getHconn(), mqSubscriptionDescriptor, this.topic.Hobj, this.Hobj, (com.ibm.mq.jmqi.handles.Pint)completionCode, (com.ibm.mq.jmqi.handles.Pint)reason);
        if (completionCode.x != 0 || reason.x != 0) {
            this.resourceOpen = false;
            MQException exception = new MQException(completionCode.x, reason.x, (Object)this, this.osession.getLastJmqiException());
            this.parentQmgr.errorOccurred(exception);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 618, (Throwable)exception);
            }
            throw exception;
        }
        this.resourceOpen = true;
        this.setOpen(true);
        this.setName(mqSubscriptionDescriptor.getResolvedObjectString().getVsString());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 618);
        }
    }

    public int requestPublicationUpdate(int options) throws MQException {
        int traceContext = 0;
        int fid = 619;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 619, new Object[]{new Integer(options)});
        }
        Pint completionCode = new Pint();
        Pint reason = new Pint();
        JmqiMQ jmqi = this.osession.getJmqi();
        MQSRO mqsro = this.env.newMQSRO();
        mqsro.setOptions(options);
        jmqi.MQSUBRQ(this.Hconn.getHconn(), this.Hobj, 1, mqsro, (com.ibm.mq.jmqi.handles.Pint)completionCode, (com.ibm.mq.jmqi.handles.Pint)reason);
        if (completionCode.x != 0 || reason.x != 0) {
            MQException exception = new MQException(completionCode.x, reason.x, (Object)this, this.osession.getLastJmqiException());
            this.parentQmgr.errorOccurred(exception);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 619, (Throwable)exception);
            }
            throw exception;
        }
        int traceRet1 = mqsro.getNumPublications();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 619, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void inquire(int[] selectors, int[] intAttrs, byte[] charAttrs) throws MQException {
        int traceContext = 0;
        int fid = 620;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 620, new Object[]{selectors, intAttrs, charAttrs});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 620);
        }
    }

    public synchronized void set(int[] selectors, int[] intAttrs, byte[] charAttrs) throws MQException {
        int traceContext = 0;
        int fid = 621;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 621, new Object[]{selectors, intAttrs, charAttrs});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 621);
        }
    }

    public String getAttributeString(int aSelector, int length) throws MQException {
        int traceContext = 0;
        int fid = 622;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 622, new Object[]{new Integer(aSelector), new Integer(length)});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 622, null);
        }
        return null;
    }

    public void setAttributeString(int aSelector, String aValue, int length) throws MQException {
        int traceContext = 0;
        int fid = 623;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 623, new Object[]{new Integer(aSelector), aValue, new Integer(length)});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 623);
        }
    }

    public String getAlternateUserId() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getAlternateUserId()", null);
        }
        return null;
    }

    public String getDescription() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getDescription()", null);
        }
        return null;
    }

    public int getOpenOptions() throws MQException {
        int traceRet1 = -1;
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getOpenOptions()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }
}

