/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQDestination;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPropertyDescriptor;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.constants.CMQC;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.handles.Hobj;
import com.ibm.mq.jmqi.handles.Pint;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;

public class MQQueue
extends MQDestination {
    static final String sccsid = "@(#)  com.ibm.mq/src/com/ibm/mq/MQQueue.java, java.classes, k700, k700-L080529 1.47.1.1 08/06/01 08:59:20";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected MQQueueManager mgr = null;
    protected MQSESSION osession = null;
    private static final int MQCA_CREATION_DATE = 2004;
    private static final int MQ_CREATION_DATE_LENGTH = 12;
    private static final int MQCA_CREATION_TIME = 2005;
    private static final int MQ_CREATION_TIME_LENGTH = 8;
    private static final int MQIA_CURRENT_Q_DEPTH = 3;
    private static final int MQIA_DEFINITION_TYPE = 7;
    private static final int MQIA_Q_TYPE = 20;
    private static final int MQIA_MAX_Q_DEPTH = 15;
    private static final int MQIA_MAX_MSG_LENGTH = 13;
    private static final int MQIA_OPEN_INPUT_COUNT = 17;
    private static final int MQIA_OPEN_OUTPUT_COUNT = 18;
    private static final int MQIA_SHAREABILITY = 23;
    private static final int MQIA_INHIBIT_PUT = 10;
    private static final int MQIA_INHIBIT_GET = 9;
    private static final int MQIA_TRIGGER_CONTROL = 24;
    private static final int MQCA_TRIGGER_DATA = 2023;
    private static final int MQ_TRIGGER_DATA_LENGTH = 64;
    private static final int MQIA_TRIGGER_DEPTH = 29;
    private static final int MQIA_TRIGGER_MSG_PRIORITY = 26;
    private static final int MQIA_TRIGGER_TYPE = 28;
    private static final int MQIA_NPM_CLASS = 78;
    private static final int MQCA_REMOTE_Q_MGR_NAME = 2017;
    private static final int MQCA_REMOTE_Q_NAME = 2018;
    private static final int MQCA_BASE_Q_NAME = 2002;
    private static final int MQNPM_CLASS_HIGH = 10;
    private static final int MQ_Q_NAME_LENGTH = 48;
    private static final byte[] MQMI_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    protected MQQueue() {
        super(1);
        int traceContext = 0;
        int fid = 311;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 311);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 311, "sccsid = ", (Object)sccsid);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 311);
        }
    }

    public MQQueue(MQQueueManager qMgr, String queueName, int openOptions, String queueManagerName, String dynamicQueueName, String alternateUserId) throws MQException {
        super(1, qMgr, queueName, openOptions, alternateUserId);
        int traceContext = 0;
        int fid = 312;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 312, new Object[]{qMgr, queueName, new Integer(openOptions), queueManagerName, dynamicQueueName, alternateUserId});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 312, "sccsid = ", (Object)sccsid);
        }
        this.mgr = qMgr;
        this.mqca_description = 2013;
        MQOD mqObjectDescriptor = this.createMQOD();
        if (this.isValidStringParameter(queueManagerName)) {
            mqObjectDescriptor.setObjectQMgrName(queueManagerName);
        }
        if (this.isValidStringParameter(dynamicQueueName)) {
            mqObjectDescriptor.setDynamicQName(dynamicQueueName);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 312, "queue = " + mqObjectDescriptor.getObjectName() + "\nqueue manager = " + mqObjectDescriptor.getObjectQMgrName() + "\ndynamic queue name = " + mqObjectDescriptor.getDynamicQName() + "\nalternate user id = " + mqObjectDescriptor.getAlternateUserId() + "\noptions = " + openOptions, (Object)"");
        }
        this.open(mqObjectDescriptor);
        qMgr.registerQueue(this);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 312);
        }
    }

    public synchronized void putMsg2(MQMsg2 message, MQPutMessageOptions putMessageOptions) throws MQException {
        int traceContext = 0;
        int fid = 325;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 325, new Object[]{message, putMessageOptions});
        }
        if (message == null) {
            MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI028");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (putMessageOptions == null) {
            MQException traceRet2 = new MQException(2, 2173, (Object)this, "MQJI029");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        putMessageOptions.invalidDestCount = 1;
        putMessageOptions.knownDestCount = 0;
        putMessageOptions.unknownDestCount = 0;
        if ((putMessageOptions.options & 6) == 0) {
            putMessageOptions.options |= 4;
        }
        if (this.osession == null && this.mgr != null) {
            this.osession = this.mgr.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet3 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        if (!this.resourceOpen) {
            MQException traceRet4 = new MQException(2, 2019, (Object)this, "MQJI027");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        if ((putMessageOptions.options & 0x300) != 0) {
            if (putMessageOptions.contextReference != null) {
                putMessageOptions.contextReferenceHandle = putMessageOptions.contextReference.getHandle();
                if (putMessageOptions.contextReferenceHandle == -1) {
                    MQException traceRet5 = new MQException(2, 2097, (Object)this);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)traceRet5, 5);
                    }
                    throw traceRet5;
                }
                if (this.mgr != putMessageOptions.contextReference.mgr) {
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, COMP_JN, 325, "Connection references do not match", (Object)"");
                    }
                    MQException traceRet6 = new MQException(2, 2097, (Object)this);
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)traceRet6, 6);
                    }
                    throw traceRet6;
                }
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 325, "Obtained context reference handle:", (Object)Integer.toString(putMessageOptions.contextReferenceHandle));
                }
            } else {
                if (this.trace.isOn) {
                    this.trace.dataFmt(this.env, COMP_JN, 325, "Context reference queue is null", (Object)"");
                }
                MQException traceRet7 = new MQException(2, 2097, (Object)this);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)traceRet7, 7);
                }
                throw traceRet7;
            }
        }
        ByteBuffer msgData = message.getInternalBuffer();
        int messageDataLength = message.getMessageDataLength();
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 325, "Message length = ", (Object)Integer.toString(messageDataLength));
            this.trace.dataFmt(this.env, COMP_JN, 325, "put options = " + putMessageOptions.options + "\nmessage type = " + message.getMessageType() + "\nencoding = " + message.getEncoding() + "\ncharacter set = " + message.getCharacterSet() + "\nformat = " + message.getFormat() + "\nmessage id, correlation id follow:", (Object)"");
            this.trace.dataFmt(this.env, COMP_JN, 325, "messageId = ", (Object)message.getMessageId());
            this.trace.dataFmt(this.env, COMP_JN, 325, "correlId = ", (Object)message.getCorrelationId());
        }
        this.osession.MQPUT(this.Hconn.getHconn(), this.Hobj.getHobj(), message, putMessageOptions, messageDataLength, msgData, (Pint)this.completionCode, (Pint)this.reason);
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 325, "Returned messageId = ", (Object)message.getMessageId());
        }
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
            this.parentQmgr.errorOccurred(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 325, (Throwable)mqe, 8);
            }
            throw mqe;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 325);
        }
    }

    public synchronized void putMsg2(MQMsg2 message) throws MQException {
        int traceContext = 0;
        int fid = 326;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 326, new Object[]{message});
        }
        this.putMsg2(message, new MQPutMessageOptions());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 326);
        }
    }

    public synchronized void putForwardMessage(MQMessage message) throws MQException, IOException {
        int traceContext = 0;
        int fid = 652;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 652, new Object[]{message});
        }
        this.putForwardMessage(message, new MQPutMessageOptions());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 652);
        }
    }

    public synchronized void putForwardMessage(MQMessage message, MQPutMessageOptions putMessageOptions) throws MQException, IOException {
        int traceContext = 0;
        int fid = 653;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 653, new Object[]{message, putMessageOptions});
        }
        if (message == null) {
            MQException traceRet1 = new MQException(2, 2026, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 653, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (putMessageOptions == null) {
            MQException traceRet1 = new MQException(2, 2173, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 653, (Throwable)traceRet1, 2);
            }
            throw traceRet1;
        }
        MQMessage newMsg = new MQMessage();
        if ((putMessageOptions.options & 0x800000) != 0) {
            newMsg = this.copyMDFromOldMsgIntoFwdMsg(message, newMsg);
            putMessageOptions.options &= 0xFF7FFFFF;
        }
        Enumeration propertyNames = message.getPropertyNames("%");
        MQPropertyDescriptor descriptor = new MQPropertyDescriptor();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Object value = message.getObjectProperty(name, descriptor);
            if (!this.validToCopy(descriptor.copyOptions, 2)) continue;
            newMsg.setObjectProperty(name, descriptor, value);
        }
        this.put(newMsg, putMessageOptions);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 653);
        }
    }

    public synchronized void putReplyMessage(MQMessage message) throws MQException, IOException {
        int traceContext = 0;
        int fid = 654;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 654, new Object[]{message});
        }
        this.putReplyMessage(message, new MQPutMessageOptions());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 654);
        }
    }

    public synchronized void putReplyMessage(MQMessage message, MQPutMessageOptions putMessageOptions) throws MQException, IOException {
        int traceContext = 0;
        int fid = 655;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 655, new Object[]{message, putMessageOptions});
        }
        if (message == null) {
            MQException traceRet1 = new MQException(2, 2026, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 655, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (putMessageOptions == null) {
            MQException traceRet1 = new MQException(2, 2173, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 655, (Throwable)traceRet1, 2);
            }
            throw traceRet1;
        }
        MQMessage newMsg = new MQMessage();
        if ((putMessageOptions.options & 0x800000) != 0) {
            newMsg = this.copyMDFromOldMsgIntoReplyMsg(message, newMsg, putMessageOptions.options);
            putMessageOptions.options &= 0xFF7FFFFF;
        }
        Enumeration propertyNames = message.getPropertyNames("%");
        MQPropertyDescriptor descriptor = new MQPropertyDescriptor();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Object value = message.getObjectProperty(name, descriptor);
            if (!this.validToCopy(descriptor.copyOptions, 8)) continue;
            newMsg.setObjectProperty(name, descriptor, value);
        }
        this.put(newMsg, putMessageOptions);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 655);
        }
    }

    public synchronized void putReportMessage(MQMessage message) throws MQException, IOException {
        int traceContext = 0;
        int fid = 656;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 656, new Object[]{message});
        }
        this.putReportMessage(message, new MQPutMessageOptions());
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 656);
        }
    }

    public synchronized void putReportMessage(MQMessage message, MQPutMessageOptions putMessageOptions) throws MQException, IOException {
        int traceContext = 0;
        int fid = 657;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 657, new Object[]{message, putMessageOptions});
        }
        if (message == null) {
            MQException traceRet1 = new MQException(2, 2026, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 657, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (putMessageOptions == null) {
            MQException traceRet1 = new MQException(2, 2173, (Object)this);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 657, (Throwable)traceRet1, 2);
            }
            throw traceRet1;
        }
        MQMessage newMsg = new MQMessage();
        newMsg = this.copyMDFromOldMsgIntoReportMsg(message, newMsg, putMessageOptions.options);
        Enumeration propertyNames = message.getPropertyNames("%");
        MQPropertyDescriptor descriptor = new MQPropertyDescriptor();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Object value = message.getObjectProperty(name, descriptor);
            if (!this.validToCopy(descriptor.copyOptions, 16)) continue;
            newMsg.setObjectProperty(name, descriptor, value);
        }
        this.put(newMsg, putMessageOptions);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 657);
        }
    }

    private boolean validToCopy(int oldMsgCopyOpts, int newMsgCopyOpts) {
        int traceContext = 0;
        int fid = 658;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 658, new Object[]{new Integer(oldMsgCopyOpts), new Integer(newMsgCopyOpts)});
        }
        boolean traceRet1 = false;
        if ((oldMsgCopyOpts & 1) != 0) {
            traceRet1 = true;
        } else if ((oldMsgCopyOpts & 0x16) == newMsgCopyOpts) {
            traceRet1 = true;
        } else if ((oldMsgCopyOpts & newMsgCopyOpts) == newMsgCopyOpts) {
            traceRet1 = true;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 658, (Object)traceRet1);
        }
        return traceRet1;
    }

    private MQMessage copyMDFromOldMsgIntoFwdMsg(MQMessage oldMsg, MQMessage newMsg) throws MQException, IOException {
        int traceContext = 0;
        int fid = 659;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 659, new Object[]{oldMsg, newMsg});
        }
        newMsg.accountingToken = oldMsg.accountingToken;
        newMsg.applicationIdData = oldMsg.applicationIdData;
        newMsg.applicationOriginData = oldMsg.applicationOriginData;
        newMsg.backoutCount = oldMsg.backoutCount;
        newMsg.characterSet = oldMsg.characterSet;
        newMsg.correlationId = oldMsg.correlationId;
        newMsg.encoding = oldMsg.encoding;
        newMsg.expiry = oldMsg.expiry;
        newMsg.feedback = oldMsg.feedback;
        newMsg.format = oldMsg.format;
        newMsg.groupId = oldMsg.groupId;
        newMsg.messageFlags = oldMsg.messageFlags;
        newMsg.messageId = oldMsg.messageId;
        newMsg.messageSequenceNumber = oldMsg.messageSequenceNumber;
        newMsg.messageType = oldMsg.messageType;
        newMsg.offset = oldMsg.offset;
        newMsg.originalLength = oldMsg.originalLength;
        newMsg.persistence = oldMsg.persistence;
        newMsg.priority = oldMsg.priority;
        newMsg.putApplicationName = oldMsg.putApplicationName;
        newMsg.putApplicationType = oldMsg.putApplicationType;
        newMsg.putDateTime = oldMsg.putDateTime;
        newMsg.replyToQueueManagerName = oldMsg.replyToQueueManagerName;
        newMsg.replyToQueueName = oldMsg.replyToQueueName;
        newMsg.report = oldMsg.report;
        newMsg.userId = oldMsg.userId;
        byte[] b = new byte[oldMsg.getMessageLength()];
        oldMsg.seek(0);
        oldMsg.readFully(b);
        newMsg.write(b);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 659, (Object)newMsg);
        }
        return newMsg;
    }

    private MQMessage copyMDFromOldMsgIntoReplyMsg(MQMessage oldMsg, MQMessage newMsg, int putOpts) throws MQException, IOException {
        int traceContext = 0;
        int fid = 660;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 660, new Object[]{oldMsg, newMsg, new Integer(putOpts)});
        }
        newMsg.report = (oldMsg.report & 0x4000) != 0 && (oldMsg.report & 0x8000000) != 0 ? 0x8000000 : 0;
        newMsg.messageType = 2;
        newMsg.expiry = (oldMsg.report & 0x4000) != 0 ? oldMsg.expiry : -1;
        newMsg.feedback = 0;
        if ((oldMsg.report & 0x80) != 0) {
            newMsg.messageId = oldMsg.messageId;
        } else if ((putOpts & 0x40) == 0) {
            newMsg.messageId = CMQC.MQMI_NONE;
        }
        if ((oldMsg.report & 0x40) != 0) {
            newMsg.correlationId = oldMsg.correlationId;
        } else if ((putOpts & 0x80) == 0) {
            newMsg.correlationId = oldMsg.correlationId;
        }
        newMsg.backoutCount = 0;
        newMsg.replyToQueueName = "";
        newMsg.replyToQueueManagerName = "";
        newMsg.groupId = CMQC.MQGI_NONE;
        newMsg.messageSequenceNumber = 1;
        newMsg.offset = 0;
        newMsg.messageFlags = 0;
        newMsg.originalLength = -1;
        byte[] b = new byte[oldMsg.getMessageLength()];
        oldMsg.seek(0);
        oldMsg.readFully(b);
        newMsg.write(b);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 660, (Object)newMsg);
        }
        return newMsg;
    }

    private MQMessage copyMDFromOldMsgIntoReportMsg(MQMessage oldMsg, MQMessage newMsg, int putOpts) throws MQException, IOException {
        int traceContext = 0;
        int fid = 661;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 661, new Object[]{oldMsg, newMsg, new Integer(putOpts)});
        }
        newMsg.report = (oldMsg.report & 0x4000) != 0 && (oldMsg.report & 0x8000000) != 0 ? 0x8000000 : 0;
        newMsg.messageType = 4;
        newMsg.expiry = (oldMsg.report & 0x4000) != 0 ? oldMsg.expiry : -1;
        newMsg.feedback = oldMsg.feedback;
        if ((oldMsg.report & 0x80) != 0) {
            newMsg.messageId = oldMsg.messageId;
        } else if ((putOpts & 0x40) == 0) {
            newMsg.messageId = CMQC.MQMI_NONE;
        }
        if ((oldMsg.report & 0x40) != 0) {
            newMsg.correlationId = oldMsg.correlationId;
        } else if ((putOpts & 0x80) == 0) {
            newMsg.correlationId = oldMsg.correlationId;
        }
        newMsg.backoutCount = 0;
        newMsg.replyToQueueName = "";
        newMsg.replyToQueueManagerName = "";
        byte[] b = new byte[oldMsg.getMessageLength()];
        oldMsg.seek(0);
        oldMsg.readFully(b);
        newMsg.write(b);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 661, (Object)newMsg);
        }
        return newMsg;
    }

    public synchronized void close() throws MQException {
        int traceContext = 0;
        int fid = 327;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 327);
        }
        super.close();
        if (this.connectionReference != null) {
            this.connectionReference.unregisterQueue(this);
        }
        this.mgr = null;
        this.connectionReference = null;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 327);
        }
    }

    public int getQueueType() throws MQException {
        int traceRet1 = this.getInt(20);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getQueueType()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getCurrentDepth() throws MQException {
        int traceRet1 = this.getInt(3);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getCurrentDepth()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getDefinitionType() throws MQException {
        int traceRet1 = this.getInt(7);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getDefinitionType()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getMaximumDepth() throws MQException {
        int traceRet1 = this.getInt(15);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getMaximumDepth()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getMaximumMessageLength() throws MQException {
        int traceRet1 = this.getInt(13);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getMaximumMessageLength()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getOpenInputCount() throws MQException {
        int traceRet1 = this.getInt(17);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getOpenInputCount()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getOpenOutputCount() throws MQException {
        int traceRet1 = this.getInt(18);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getOpenOutputCount()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getShareability() throws MQException {
        int traceRet1 = this.getInt(23);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getShareability()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getInhibitPut() throws MQException {
        int traceRet1 = this.getInt(10);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getInhibitPut()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setInhibitPut(int inhibit) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setInhibitPut(int)", (Object)new Integer(inhibit));
        }
        this.setInt(10, inhibit);
    }

    public int getInhibitGet() throws MQException {
        int traceRet1 = this.getInt(9);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getInhibitGet()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setInhibitGet(int inhibit) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setInhibitGet(int)", (Object)new Integer(inhibit));
        }
        this.setInt(9, inhibit);
    }

    public int getTriggerControl() throws MQException {
        int traceRet1 = this.getInt(24);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getTriggerControl()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setTriggerControl(int trigger) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setTriggerControl(int)", (Object)new Integer(trigger));
        }
        this.setInt(24, trigger);
    }

    public String getTriggerData() throws MQException {
        String traceRet1 = this.getString(2023, 64);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getTriggerData()", (Object)traceRet1);
        }
        return traceRet1;
    }

    public void setTriggerData(String data) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setTriggerData(String)", (Object)data);
        }
        this.setString(2023, data, 64);
    }

    public int getTriggerDepth() throws MQException {
        int traceRet1 = this.getInt(29);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getTriggerDepth()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setTriggerDepth(int depth) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setTriggerDepth(int)", (Object)new Integer(depth));
        }
        this.setInt(29, depth);
    }

    public int getTriggerMessagePriority() throws MQException {
        int traceRet1 = this.getInt(26);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getTriggerMessagePriority()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setTriggerMessagePriority(int priority) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setTriggerMessagePriority(int)", (Object)new Integer(priority));
        }
        this.setInt(26, priority);
    }

    public int getTriggerType() throws MQException {
        int traceRet1 = this.getInt(28);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getTriggerType()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public void setTriggerType(int type) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setTriggerType(int)", (Object)new Integer(type));
        }
        this.setInt(28, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNPMClassHigh() {
        block42: {
            traceContext = 0;
            fid = 329;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, MQQueue.COMP_JN, 329);
            }
            myQueue = null;
            try {
                try {
                    try {
                        myQueue = this.mgr.accessQueue(this.name, 32);
                    }
                    catch (Exception e) {
                        if (this.trace.isOn) {
                            this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)e, 1);
                        }
                        myQueue = null;
                    }
                    v0 = res = myQueue != null && myQueue.getInt(78) == 10;
                    if (this.trace.isOn) {
                        this.trace.dataFmt(this.env, MQQueue.COMP_JN, 329, "isNPMClassHigh=", (Object)Boolean.toString(res));
                    }
                    if (this.trace.isOn) {
                        this.trace.exit(traceContext, (Object)this, MQQueue.COMP_JN, 329, (Object)res, 1);
                    }
                    var5_7 = res;
                    var13_10 = null;
                    if (!this.trace.isOn) break block42;
                }
                catch (MQException mq) {
                    if (this.trace.isOn) {
                        this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mq, 2);
                    }
                    try {
                        qType = myQueue.getInt(20);
                        if (qType == 1 || qType == 2) {
                            if (this.trace.isOn) {
                                this.trace.dataFmt(this.env, MQQueue.COMP_JN, 329, "NPMCLASS(HIGH) unsupported, qType=", (Object)Integer.toString(qType));
                            }
                            if (this.trace.isOn) {
                                this.trace.exit(traceContext, (Object)this, MQQueue.COMP_JN, 329, (Object)false, 2);
                            }
                            var6_24 = false;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (MQException mq2) {
                        if (this.trace.isOn) {
                            this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mq2, 3);
                        }
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, MQQueue.COMP_JN, 329, "inquire failed with: ", (Object)mq2);
                        }
                        if (this.trace.isOn) {
                            this.trace.exit(traceContext, (Object)this, MQQueue.COMP_JN, 329, (Object)false, 6);
                        }
                        var6_28 = false;
                        var13_15 = null;
                        if (this.trace.isOn) {
                            this.trace.finallyBlock((Object)this, MQQueue.COMP_JN, 329);
                        }
                        try {
                            if (myQueue == null) return var6_28;
                            myQueue.close();
                            return var6_28;
                        }
                        catch (MQException mqe) {
                            if (this.trace.isOn == false) return var6_28;
                            this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mqe, 4);
                        }
                        return var6_28;
                    }
                    var13_11 = null;
                    if (this.trace.isOn) {
                        this.trace.finallyBlock((Object)this, MQQueue.COMP_JN, 329);
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 756->767)] { 
lbl62:
                    // 1 sources

                    if (myQueue == null) return var6_24;
                    myQueue.close();
                    return var6_24;
lbl65:
                    // 1 sources

                    catch (MQException mqe) {
                        if (this.trace.isOn == false) return var6_24;
                        this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mqe, 4);
                    }
                    return var6_24;
lbl-1000:
                    // 1 sources

                    {
                        if (qType != 3) ** GOTO lbl-1000
                        inq = new int[1];
                        CAresult = new byte[48];
                        inq[0] = 2002;
                        myQueue.inquire(inq, null, CAresult);
                        res = new String(CAresult);
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, MQQueue.COMP_JN, 329, "alias, resolves to =", (Object)res);
                        }
                        theQueue = this.mgr.accessQueue(res, 32);
                        traceRet1 = theQueue.isNPMClassHigh();
                        if (this.trace.isOn) {
                            this.trace.exit(traceContext, (Object)this, MQQueue.COMP_JN, 329, (Object)traceRet1, 3);
                        }
                        var11_37 = traceRet1;
                    }
                    var13_12 = null;
                    if (this.trace.isOn) {
                        this.trace.finallyBlock((Object)this, MQQueue.COMP_JN, 329);
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 756->767)] { 
lbl87:
                    // 1 sources

                    if (myQueue == null) return var11_37;
                    myQueue.close();
                    return var11_37;
lbl90:
                    // 1 sources

                    catch (MQException mqe) {
                        if (this.trace.isOn == false) return var11_37;
                        this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mqe, 4);
                    }
                    return var11_37;
lbl-1000:
                    // 1 sources

                    {
                        if (qType != 6) ** GOTO lbl-1000
                        inq = new int[2];
                        CAresult = new byte[96];
                        inq[0] = 2017;
                        inq[1] = 2018;
                        myQueue.inquire(inq, null, CAresult);
                        res = new String(CAresult);
                        theQueue = this.mgr.accessQueue(res, 32);
                        traceRet2 = theQueue.isNPMClassHigh();
                        if (this.trace.isOn) {
                            this.trace.exit(traceContext, (Object)this, MQQueue.COMP_JN, 329, (Object)traceRet2, 4);
                        }
                        var11_38 = traceRet2;
                    }
                    var13_13 = null;
                    if (this.trace.isOn) {
                        this.trace.finallyBlock((Object)this, MQQueue.COMP_JN, 329);
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 756->767)] { 
lbl111:
                    // 1 sources

                    if (myQueue == null) return var11_38;
                    myQueue.close();
                    return var11_38;
lbl114:
                    // 1 sources

                    catch (MQException mqe) {
                        if (this.trace.isOn == false) return var11_38;
                        this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mqe, 4);
                    }
                    return var11_38;
lbl-1000:
                    // 1 sources

                    {
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, MQQueue.COMP_JN, 329, "unexpected qType=", (Object)Integer.toString(qType));
                        }
                        if (this.trace.isOn) {
                            this.trace.exit(traceContext, (Object)this, MQQueue.COMP_JN, 329, (Object)false, 5);
                        }
                        var6_27 = false;
                    }
                    var13_14 = null;
                    if (this.trace.isOn) {
                        this.trace.finallyBlock((Object)this, MQQueue.COMP_JN, 329);
                    }
                    ** try [egrp 7[TRYBLOCK] [13 : 756->767)] { 
lbl128:
                    // 1 sources

                    if (myQueue == null) return var6_27;
                    myQueue.close();
                    return var6_27;
lbl131:
                    // 1 sources

                    catch (MQException mqe) {
                        if (this.trace.isOn == false) return var6_27;
                        this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mqe, 4);
                    }
                    return var6_27;
                }
            }
            catch (Throwable var12_39) {
                var13_16 = null;
                if (this.trace.isOn) {
                    this.trace.finallyBlock((Object)this, MQQueue.COMP_JN, 329);
                }
                try {}
                catch (MQException mqe) {
                    if (this.trace.isOn == false) throw var12_39;
                    this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mqe, 4);
                    throw var12_39;
                }
                if (myQueue == null) throw var12_39;
                myQueue.close();
                throw var12_39;
            }
            this.trace.finallyBlock((Object)this, MQQueue.COMP_JN, 329);
        }
        try {}
        catch (MQException mqe) {
            if (this.trace.isOn == false) return var5_7;
            this.trace.catchBlock((Object)this, MQQueue.COMP_JN, 329, (Throwable)mqe, 4);
            return var5_7;
        }
        if (myQueue == null) return var5_7;
        myQueue.close();
        return var5_7;
    }

    final int getHandle() {
        int traceContext = 0;
        int fid = 509;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 509);
        }
        Hobj hobj = CMQC.jmqi_MQHO_UNUSABLE_HOBJ;
        if (this.resourceOpen) {
            hobj = this.Hobj.getHobj();
        }
        int traceRet1 = hobj.getIntegerHandle();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 509, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }
}

