/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.handles.Phconn;
import com.ibm.mq.jmqi.handles.Phobj;

public class MQManagedObject
extends JmqiObject {
    static final String sccsid = "@(#)  com.ibm.mq/src/com/ibm/mq/MQManagedObject.java, java.classes, k700, k700-L080529 1.38.1.1 08/06/01 08:56:57";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected Phobj Hobj;
    protected Phconn Hconn;
    protected String pszName;
    protected boolean connected;
    protected boolean resourceOpen;
    protected static final int MQCA_Q_DESC = 2013;
    protected static final int MQCA_Q_MGR_DESC = 2014;
    protected static final int MQCA_PROCESS_DESC = 2011;
    protected static final int MQ_DESC_LENGTH = 64;
    protected MQSESSION osession = null;
    MQQueueManager parentQmgr = null;
    protected int mqca_description = 2014;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    public String alternateUserId = "";
    public String name = "";
    public int openOptions = 32;
    public boolean isOpen = false;
    protected boolean openStatus = false;
    public MQQueueManager connectionReference = null;
    public int closeOptions = 0;

    protected MQManagedObject() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 164;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 164);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 164, "sccsid = ", (Object)sccsid);
        }
        this.resourceOpen = false;
        this.connected = false;
        this.Hconn = MQSESSION.getJmqiEnv().newPhconn();
        this.Hobj = MQSESSION.getJmqiEnv().newPhobj();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 164);
        }
    }

    public void inquire(int[] selectors, int[] intAttrs, byte[] charAttrs) throws MQException {
        int traceContext = 0;
        int fid = 165;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 165, new Object[]{selectors, intAttrs, charAttrs});
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 165, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!this.resourceOpen) {
            MQException traceRet2 = new MQException(2, 2019, (Object)this, "MQJI016");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 165, (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (selectors == null || selectors.length == 0) {
            MQException traceRet3 = new MQException(2, 2067, (Object)this, "MQJI017");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 165, (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        int numInts = 0;
        if (intAttrs != null) {
            numInts = intAttrs.length;
        }
        int numChars = 0;
        if (charAttrs != null) {
            numChars = charAttrs.length;
        }
        this.osession.MQINQ(this.Hconn.getHconn(), this.Hobj.getHobj(), selectors.length, selectors, numInts, intAttrs, numChars, charAttrs, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            this.parentQmgr.errorOccurred(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 165, (Throwable)mqe, 4);
            }
            throw mqe;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 165);
        }
    }

    public synchronized void set(int[] selectors, int[] intAttrs, byte[] charAttrs) throws MQException {
        int traceContext = 0;
        int fid = 166;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 166, new Object[]{selectors, intAttrs, charAttrs});
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 166, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (!this.resourceOpen) {
            MQException traceRet2 = new MQException(2, 2019, (Object)this, "MQJI016");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 166, (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (selectors == null || selectors.length == 0) {
            MQException traceRet3 = new MQException(2, 2067, (Object)this, "MQJI017");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 166, (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        int numInts = 0;
        if (intAttrs != null) {
            numInts = intAttrs.length;
        }
        int numChars = 0;
        if (charAttrs != null) {
            numChars = charAttrs.length;
        }
        this.osession.MQSET(this.Hconn.getHconn(), this.Hobj.getHobj(), selectors.length, selectors, numInts, intAttrs, numChars, charAttrs, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
            this.parentQmgr.errorOccurred(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 166, (Throwable)mqe, 4);
            }
            throw mqe;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 166);
        }
    }

    public synchronized void close() throws MQException {
        int traceContext = 0;
        int fid = 167;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 167);
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 167, 1);
            }
            return;
        }
        if (this.resourceOpen) {
            this.osession.MQCLOSE(this.Hconn.getHconn(), this.Hobj, this.closeOptions, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
                this.parentQmgr.errorOccurred(mqe);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 167, (Throwable)mqe);
                }
                throw mqe;
            }
            this.resourceOpen = false;
        }
        this.isOpen = false;
        this.openStatus = false;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 167, 2);
        }
    }

    protected void finalize() {
        int traceContext;
        block5: {
            traceContext = 0;
            int fid = 168;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 168);
            }
            if (this.resourceOpen) {
                try {
                    this.close();
                }
                catch (MQException e) {
                    if (!this.trace.isOn) break block5;
                    this.trace.catchBlock((Object)this, COMP_JN, 168, (Throwable)e);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 168);
        }
    }

    protected final int getInt(int aSelector) throws MQException {
        int traceContext = 0;
        int fid = 169;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 169, new Object[]{new Integer(aSelector)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 169, "selector = ", (Object)Integer.toString(aSelector));
        }
        int[] selectors = new int[]{aSelector};
        int[] intAttrs = new int[1];
        this.inquire(selectors, intAttrs, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 169, (Object)new Integer(intAttrs[0]));
        }
        return intAttrs[0];
    }

    protected final void setInt(int aSelector, int aValue) throws MQException {
        int traceContext = 0;
        int fid = 170;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 170, new Object[]{new Integer(aSelector), new Integer(aValue)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 170, "selector = ", (Object)Integer.toString(aSelector));
            this.trace.dataFmt(this.env, COMP_JN, 170, "value    = ", (Object)Integer.toString(aValue));
        }
        int[] selectors = new int[]{aSelector};
        int[] intAttrs = new int[]{aValue};
        this.set(selectors, intAttrs, null);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 170);
        }
    }

    protected final String getString(int aSelector, int length) throws MQException {
        String result;
        int traceContext = 0;
        int fid = 171;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 171, new Object[]{new Integer(aSelector), new Integer(length)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 171, "selector = ", (Object)Integer.toString(aSelector));
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 171, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        int charEncoding = this.osession.getCharEncoding();
        if (charEncoding == 1) {
            int[] selectors = new int[]{aSelector};
            byte[] charAttrs = new byte[length];
            this.inquire(selectors, null, charAttrs);
            result = MQEnvironment.stringFromBytes(charAttrs);
        } else {
            if (!this.resourceOpen) {
                MQException traceRet2 = new MQException(2, 2019, (Object)this, "MQJI016");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 171, (Throwable)traceRet2, 2);
                }
                throw traceRet2;
            }
            result = this.osession.MQINQ(this.Hconn.getHconn(), this.Hobj.getHobj(), aSelector, length, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
                this.parentQmgr.errorOccurred(mqe);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 171, (Throwable)mqe, 3);
                }
                throw mqe;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 171, (Object)result);
        }
        return result;
    }

    public String getAttributeString(int aSelector, int length) throws MQException {
        int traceContext = 0;
        int fid = 172;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 172, new Object[]{new Integer(aSelector), new Integer(length)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 172, "selector = ", (Object)Integer.toString(aSelector));
        }
        String result = this.getString(aSelector, length);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 172, (Object)result);
        }
        return result;
    }

    protected final void setString(int aSelector, String aValue, int length) throws MQException {
        int traceContext = 0;
        int fid = 173;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 173, new Object[]{new Integer(aSelector), aValue, new Integer(length)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 173, "selector = ", (Object)Integer.toString(aSelector));
            this.trace.dataFmt(this.env, COMP_JN, 173, "value    = ", (Object)aValue);
        }
        if (this.osession == null && this.connectionReference != null) {
            this.osession = this.connectionReference.getSession();
        }
        if (!this.connected || this.osession == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 173, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        int charEncoding = this.osession.getCharEncoding();
        if (charEncoding == 1) {
            int[] selectors = new int[]{aSelector};
            int padStart = -1;
            byte[] charAttrs = new byte[length];
            if (aValue != null) {
                block19: {
                    byte[] strBytes = MQEnvironment.bytesFromString(aValue);
                    try {
                        System.arraycopy(strBytes, 0, charAttrs, 0, Math.min(length, aValue.length()));
                    }
                    catch (Exception ex) {
                        if (!this.trace.isOn) break block19;
                        this.trace.catchBlock((Object)this, COMP_JN, 173, (Throwable)ex);
                    }
                }
                if (aValue.length() < length) {
                    padStart = aValue.length();
                }
            } else {
                padStart = 0;
            }
            if (padStart != -1) {
                for (int i = padStart; i < length; ++i) {
                    charAttrs[i] = 32;
                }
            }
            this.set(selectors, null, charAttrs);
        } else {
            if (!this.resourceOpen) {
                MQException traceRet2 = new MQException(2, 2019, (Object)this, "MQJI016");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 173, (Throwable)traceRet2, 2);
                }
                throw traceRet2;
            }
            this.osession.MQSET(this.Hconn.getHconn(), this.Hobj.getHobj(), aSelector, aValue, length, this.completionCode, this.reason);
            if (this.completionCode.x != 0 || this.reason.x != 0) {
                MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
                this.parentQmgr.errorOccurred(mqe);
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 173, (Throwable)mqe, 3);
                }
                throw mqe;
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 173);
        }
    }

    public void setAttributeString(int aSelector, String aValue, int length) throws MQException {
        int traceContext = 0;
        int fid = 174;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 174, new Object[]{new Integer(aSelector), aValue, new Integer(length)});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 174, "selector = ", (Object)Integer.toString(aSelector));
            this.trace.dataFmt(this.env, COMP_JN, 174, "value    = ", (Object)aValue);
        }
        this.setString(aSelector, aValue, length);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 174);
        }
    }

    public String getDescription() throws MQException {
        String traceRet1 = this.getString(this.mqca_description, 64);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getDescription()", (Object)traceRet1);
        }
        return traceRet1;
    }

    public String getAlternateUserId() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getAlternateUserId()", (Object)this.alternateUserId);
        }
        return this.alternateUserId;
    }

    protected void setAlternateUserId(String alternateUserId) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setAlternateUserId(String)", (Object)alternateUserId);
        }
        this.alternateUserId = alternateUserId == null ? "" : alternateUserId;
    }

    public String getName() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getName()", (Object)this.name);
        }
        return this.name;
    }

    protected void setName(String name) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setName(String)", (Object)name);
        }
        this.name = name;
    }

    public int getOpenOptions() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getOpenOptions()", (Object)new Integer(this.openOptions));
        }
        return this.openOptions;
    }

    protected void setOpenOptions(int openOptions) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setOpenOptions(int)", (Object)new Integer(openOptions));
        }
        this.openOptions = openOptions;
    }

    public MQQueueManager getConnectionReference() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getConnectionReference()", (Object)this.connectionReference);
        }
        return this.connectionReference;
    }

    public boolean isOpen() {
        int fid = 163;
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "isOpen()", (Object)this.openStatus);
        }
        return this.openStatus;
    }

    protected void setOpen(boolean open) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setOpen(boolean)", (Object)open);
        }
        this.isOpen = open;
        this.openStatus = open;
    }

    protected void setConnectionReference(MQQueueManager connectionReference) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setConnectionReference(MQQueueManager)", (Object)connectionReference);
        }
        this.connectionReference = connectionReference;
    }

    public int getCloseOptions() throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getCloseOptions()", (Object)new Integer(this.closeOptions));
        }
        return this.closeOptions;
    }

    public void setCloseOptions(int closeOptions) throws MQException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setCloseOptions(int)", (Object)new Integer(closeOptions));
        }
        this.closeOptions = closeOptions;
    }
}

