/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQDistributionListItem;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mq.jmqi.JmqiException;
import com.ibm.mq.jmqi.JmqiMQ;
import com.ibm.mq.jmqi.MQOD;
import com.ibm.mq.jmqi.system.JmqiSP;
import com.ibm.mq.jmqi.system.JmqiSystemEnvironment;
import com.ibm.mq.jmqi.system.SpiOpenOptions;
import java.nio.ByteBuffer;

public class MQDistributionList
extends MQManagedObject {
    static final String sccsid = "@(#)  com.ibm.mq/src/com/ibm/mq/MQDistributionList.java, java.classes, k700, k700-L080529 1.34.1.1 08/06/01 08:54:14";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MQSESSION osession = null;
    private int knownDestCount;
    private int unknownDestCount;
    private int invalidDestCount;
    private MQQueueManager mgr = null;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    private MQDistributionListItem[] items = null;

    public MQDistributionList(MQQueueManager qMgr, MQDistributionListItem[] litems, int openOptions, String alternateUserId) throws MQException {
        int queueManagerCmdLevel;
        int traceContext = 0;
        int fid = 88;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 88, new Object[]{qMgr, litems, new Integer(openOptions), alternateUserId});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JM, 88, "sccsid", (Object)sccsid);
        }
        if (qMgr == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI001");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 88, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        this.osession = qMgr.getSession();
        if (!qMgr.connected) {
            MQException traceRet2 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 88, (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        if (!qMgr.getDistributionListCapable()) {
            MQException traceRet3 = new MQException(2, 2044, (Object)this, "MQJI030");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 88, (Throwable)traceRet3, 3);
            }
            throw traceRet3;
        }
        if (litems == null) {
            MQException traceRet4 = new MQException(2, 2155, (Object)this, "MQJI003");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 88, (Throwable)traceRet4, 4);
            }
            throw traceRet4;
        }
        for (int rec = 0; rec < litems.length; ++rec) {
            if (litems[rec] == null) {
                MQException traceRet5 = new MQException(2, 2154, (Object)this, "MQJI006");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 88, (Throwable)traceRet5, 5);
                }
                throw traceRet5;
            }
            if (rec > 0) {
                litems[rec].setPreviousDistributedItem(litems[rec - 1]);
            }
            if (rec >= litems.length - 1) continue;
            litems[rec].setNextDistributedItem(litems[rec + 1]);
        }
        this.items = litems;
        com.ibm.mq.MQOD od = new com.ibm.mq.MQOD(this.items);
        if (alternateUserId != null && alternateUserId.length() > 0) {
            od.AlternateUserId = alternateUserId;
        }
        this.Hconn = qMgr.Hconn;
        this.connected = qMgr.connected;
        if (this.trace.isOn) {
            for (int rec = 0; rec < litems.length; ++rec) {
                String traceQMgr = litems[rec].queueManagerName;
                String traceQ = litems[rec].queueName;
                if (traceQMgr == null) {
                    traceQMgr = "<null>";
                }
                if (traceQ == null) {
                    traceQ = "<null>";
                }
                this.trace.dataFmt(this.env, COMP_JN, 88, "DistributionList: '", (Object)(traceQMgr + "' '" + traceQ));
            }
        }
        JmqiMQ jmqi = this.osession.getJmqi();
        try {
            queueManagerCmdLevel = this.Hconn.getHconn().getCmdLevel();
        }
        catch (JmqiException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 88, (Throwable)e);
            }
            MQException traceRet6 = new MQException(e.getCompCode(), e.getReason(), (Object)this, e);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 88, (Throwable)traceRet6, 6);
            }
            throw traceRet6;
        }
        if (queueManagerCmdLevel >= 700) {
            JmqiSP jmqiSP = (JmqiSP)jmqi;
            SpiOpenOptions spiOpenOptions = ((JmqiSystemEnvironment)this.env).newSpiOpenOptions();
            spiOpenOptions.setOptions(openOptions);
            MQOD mqObjectDecriptor = od.getJMQIStructure();
            jmqiSP.spiOpen(this.Hconn.getHconn(), mqObjectDecriptor, spiOpenOptions, this.Hobj, (com.ibm.mq.jmqi.handles.Pint)this.completionCode, (com.ibm.mq.jmqi.handles.Pint)this.reason);
            od.updateFromJMQIStructure();
        } else {
            this.osession.MQOPEN(this.Hconn.getHconn(), od, openOptions, this.Hobj, this.completionCode, this.reason);
        }
        if (this.completionCode.x == 2) {
            this.resourceOpen = false;
            this.isOpen = false;
            this.openStatus = false;
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this);
            qMgr.errorOccurred(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 88, (Throwable)mqe, 7);
            }
            throw mqe;
        }
        this.resourceOpen = true;
        this.isOpen = true;
        this.openStatus = true;
        this.mgr = qMgr;
        this.openOptions = openOptions;
        this.parentQmgr = qMgr;
        this.connectionReference = qMgr;
        if (alternateUserId != null) {
            this.alternateUserId = alternateUserId;
        }
        qMgr.registerDistributionList(this);
        this.knownDestCount = od.getKnownDestCount();
        this.unknownDestCount = od.getUnknownDestCount();
        this.invalidDestCount = od.getInvalidDestCount();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 88);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized void put(MQMessage message, MQPutMessageOptions putMessageOptions) throws MQException {
        int traceContext;
        block53: {
            traceContext = 0;
            int fid = 89;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 89, new Object[]{message, putMessageOptions});
            }
            MQMessage putmd = message;
            if (message == null) {
                MQException traceRet1 = new MQException(2, 2026, (Object)this, "MQJI008");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)traceRet1, 1);
                }
                throw traceRet1;
            }
            if (putMessageOptions == null) {
                MQException traceRet2 = new MQException(2, 2173, (Object)this, "MQJI009");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)traceRet2, 2);
                }
                throw traceRet2;
            }
            if (!this.connected) {
                MQException traceRet3 = new MQException(2, 2018, (Object)this, "MQJI002");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)traceRet3, 3);
                }
                throw traceRet3;
            }
            if (!this.openStatus) {
                MQException traceRet4 = new MQException(2, 2019, (Object)this, "MQJI011");
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)traceRet4, 4);
                }
                throw traceRet4;
            }
            MQMessage mQMessage = message;
            synchronized (mQMessage) {
                MQException exception;
                block50: {
                    block49: {
                        exception = null;
                        message.performProcessingBeforePut();
                        ByteBuffer msgData = message.getBuffer();
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 89, "message", (Object)("Message length = " + msgData.capacity() + " bytes."));
                            this.trace.dataFmt(this.env, COMP_JN, 89, "put options = " + putMessageOptions.options + "\nmessage type = " + message.messageType + "\nencoding = " + message.encoding + "\ncharacter set = " + message.characterSet + "\nformat = " + message.format + "\nmessage id, correlation id, groupId  follow:", (Object)"");
                            this.trace.dataFmt(this.env, COMP_JN, 89, "messageId", (Object)message.messageId);
                            this.trace.dataFmt(this.env, COMP_JN, 89, "correlId", (Object)message.correlationId);
                            this.trace.dataFmt(this.env, COMP_JN, 89, "grouId", (Object)message.groupId);
                        }
                        if ((putMessageOptions.options & 0x300) != 0) {
                            if (this.trace.isOn) {
                                this.trace.dataFmt(this.env, COMP_JN, 89, "Checking Context Reference", (Object)"");
                            }
                            if (putMessageOptions.contextReference != null) {
                                putMessageOptions.contextReferenceHandle = putMessageOptions.contextReference.getHandle();
                                if (putMessageOptions.contextReferenceHandle == -1) {
                                    MQException traceRet5 = new MQException(2, 2097, (Object)this);
                                    if (this.trace.isOn) {
                                        this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)traceRet5, 5);
                                    }
                                    throw traceRet5;
                                }
                                if (this.mgr != putMessageOptions.contextReference.mgr) {
                                    if (this.trace.isOn) {
                                        this.trace.dataFmt(this.env, COMP_JN, 89, "MQDistributionList:put", (Object)"Connection references do not match");
                                    }
                                    MQException traceRet6 = new MQException(2, 2097, (Object)this);
                                    if (this.trace.isOn) {
                                        this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)traceRet6, 6);
                                    }
                                    throw traceRet6;
                                }
                                if (this.trace.isOn) {
                                    this.trace.dataFmt(this.env, COMP_JN, 89, "reference handle", (Object)("Obtained context reference handle:" + putMessageOptions.contextReferenceHandle));
                                }
                            } else {
                                if (this.trace.isOn) {
                                    this.trace.dataFmt(this.env, COMP_JN, 89, "Context reference queue is null", (Object)"");
                                }
                                MQException traceRet7 = new MQException(2, 2097, (Object)this);
                                if (this.trace.isOn) {
                                    this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)traceRet7, 7);
                                }
                                throw traceRet7;
                            }
                        }
                        putMessageOptions.version2(this.items);
                        this.osession.MQPUT(this.Hconn.getHconn(), this.Hobj.getHobj(), putmd, putMessageOptions, msgData.limit(), msgData, (com.ibm.mq.jmqi.handles.Pint)this.completionCode, (com.ibm.mq.jmqi.handles.Pint)this.reason);
                        if (this.trace.isOn) {
                            this.trace.dataFmt(this.env, COMP_JN, 89, "Returned message Id : ", (Object)message.messageId);
                        }
                        if (this.completionCode.x != 0 || this.reason.x != 0) {
                            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
                            this.parentQmgr.errorOccurred(mqe);
                            if (this.trace.isOn) {
                                this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)mqe, 8);
                            }
                            throw mqe;
                        }
                        Object var11_18 = null;
                        if (!this.trace.isOn) break block49;
                        this.trace.finallyBlock((Object)this, COMP_JN, 89);
                    }
                    try {
                        message.performProcessingAfterPut();
                    }
                    catch (MQException e2) {
                        if (this.trace.isOn) {
                            this.trace.catchBlock((Object)this, COMP_JN, 89, (Throwable)e2, 2);
                        }
                        if (exception != null) break block50;
                        exception = e2;
                    }
                }
                if (exception != null) {
                    if (this.trace.isOn) {
                        this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)exception, 9);
                    }
                    throw exception;
                }
                break block53;
                {
                    catch (MQException e) {
                        block51: {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 89, (Throwable)e, 1);
                            }
                            exception = e;
                            Object var11_19 = null;
                            if (this.trace.isOn) {
                                this.trace.finallyBlock((Object)this, COMP_JN, 89);
                            }
                            try {
                                message.performProcessingAfterPut();
                            }
                            catch (MQException e2) {
                                if (this.trace.isOn) {
                                    this.trace.catchBlock((Object)this, COMP_JN, 89, (Throwable)e2, 2);
                                }
                                if (exception != null) break block51;
                                exception = e2;
                            }
                        }
                        if (exception != null) {
                            if (this.trace.isOn) {
                                this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)exception, 9);
                            }
                            throw exception;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block52: {
                        Object var11_20 = null;
                        if (this.trace.isOn) {
                            this.trace.finallyBlock((Object)this, COMP_JN, 89);
                        }
                        try {
                            message.performProcessingAfterPut();
                        }
                        catch (MQException e2) {
                            if (this.trace.isOn) {
                                this.trace.catchBlock((Object)this, COMP_JN, 89, (Throwable)e2, 2);
                            }
                            if (exception != null) break block52;
                            exception = e2;
                        }
                    }
                    if (exception != null) {
                        if (this.trace.isOn) {
                            this.trace.throwing((Object)this, COMP_JN, 89, (Throwable)exception, 9);
                        }
                        throw exception;
                    }
                    throw throwable;
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 89);
        }
    }

    public synchronized void close() throws MQException {
        int traceContext = 0;
        int fid = 90;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 90);
        }
        super.close();
        if (this.mgr != null) {
            this.mgr.unregisterDistributionList(this);
        }
        this.isOpen = false;
        this.openStatus = false;
        this.mgr = null;
        this.connectionReference = null;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 90);
        }
    }

    public int getValidDestinationCount() {
        int traceRet1 = this.knownDestCount + this.unknownDestCount;
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getValidDestinationCount()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public int getInvalidDestinationCount() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getInvalidDestinationCount()", (Object)new Integer(this.invalidDestCount));
        }
        return this.invalidDestCount;
    }

    public MQDistributionListItem getFirstDistributionListItem() {
        int traceContext = 0;
        int fid = 511;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 511);
        }
        if (this.items == null || this.items.length == 0) {
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 511, null, 1);
            }
            return null;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 511, (Object)this.items[0], 2);
        }
        return this.items[0];
    }

    protected void finalize() {
        int traceContext;
        block5: {
            traceContext = 0;
            int fid = 91;
            if (this.trace.isOn) {
                traceContext = this.trace.entry_OO((Object)this, COMP_JN, 91);
            }
            if (this.openStatus) {
                try {
                    this.close();
                }
                catch (MQException e) {
                    if (!this.trace.isOn) break block5;
                    this.trace.catchBlock((Object)this, COMP_JN, 91, (Throwable)e);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 91);
        }
    }
}

