/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BindingsConnectionRequestInfo;
import com.ibm.mq.ClientConnectionRequestInfo;
import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnection;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.ReasonCodeInfo;
import com.ibm.mq.jmqi.JmqiObject;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

class MQClientManagedConnectionFactoryJ11
extends JmqiObject
implements MQManagedConnectionFactory {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQClientManagedConnectionFactoryJ11.java, java.classes, k700, k700-L080529 1.40.1.1 08/06/01 08:52:51";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -1400003784925523083L;
    private String fieldQMGR = "";
    private String fieldServerName = "";
    private int fieldPortNumber = 1414;
    private String fieldChannel = "";
    private int fieldCCSID = 819;
    PrintWriter logWriter = null;

    MQClientManagedConnectionFactoryJ11(String qmgr, Hashtable props) {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 58;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 58, new Object[]{qmgr, props});
        }
        this.setQMGR(qmgr);
        String svrName = MQEnvironment.getStringProperty("hostname", props);
        this.setServerName(svrName != null ? svrName : "localhost");
        this.setPortNumber(MQEnvironment.getIntegerProperty("port", props));
        this.setChannel(MQEnvironment.getStringProperty("channel", props));
        this.setCCSID(MQEnvironment.getIntegerProperty("CCSID", props));
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 58);
        }
    }

    public void setQMGR(String value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setQMGR(String)", (Object)value);
        }
        this.fieldQMGR = value;
    }

    public String getQMGR() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getQMGR()", (Object)this.fieldQMGR);
        }
        return this.fieldQMGR;
    }

    public void setServerName(String value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setServerName(String)", (Object)value);
        }
        this.fieldServerName = value;
    }

    public String getServerName() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getServerName()", (Object)this.fieldServerName);
        }
        return this.fieldServerName;
    }

    public void setPortNumber(int value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setPortNumber(int)", (Object)new Integer(value));
        }
        this.fieldPortNumber = value;
    }

    public int getPortNumber() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getPortNumber()", (Object)new Integer(this.fieldPortNumber));
        }
        return this.fieldPortNumber;
    }

    public void setChannel(String value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setChannel(String)", (Object)value);
        }
        this.fieldChannel = value;
    }

    public String getChannel() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getChannel()", (Object)this.fieldChannel);
        }
        return this.fieldChannel;
    }

    public void setCCSID(int value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setCCSID(int)", (Object)new Integer(value));
        }
        this.fieldCCSID = value;
    }

    public int getCCSID() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getCCSID()", (Object)new Integer(this.fieldCCSID));
        }
        return this.fieldCCSID;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setLogWriter(java.io.PrintWriter)", (Object)out);
        }
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getLogWriter()", (Object)this.logWriter);
        }
        return this.logWriter;
    }

    public Object createConnectionFactory(MQConnectionManager cxManager) throws ResourceException {
        int traceContext = 0;
        int fid = 59;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 59, new Object[]{cxManager});
        }
        NotSupportedException traceRet1 = new NotSupportedException(MQException.getNLSMsg((String)"MQCCF_NOT_SUPPURTED"));
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 59, (Throwable)traceRet1);
        }
        throw traceRet1;
    }

    public Object createConnectionFactory() throws ResourceException {
        int traceContext = 0;
        int fid = 60;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 60);
        }
        NotSupportedException traceRet1 = new NotSupportedException(MQException.getNLSMsg((String)"MQCCF_NOT_SUPPURTED"));
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 60, (Throwable)traceRet1);
        }
        throw traceRet1;
    }

    MQManagedConnectionJ11 _createManagedConnection(ConnectionRequestInfo cxRequestInfo, boolean mode) throws ResourceException {
        MQManagedConnectionJ11 mancon;
        int traceContext = 0;
        int fid = 61;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 61, new Object[]{cxRequestInfo, mode});
        }
        if (!(cxRequestInfo instanceof ClientConnectionRequestInfo)) {
            String msg = MQException.getNLSMsg((String)"MQJI039");
            ResourceException traceRet1 = new ResourceException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 61, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        ClientConnectionRequestInfo cCxReqInf = (ClientConnectionRequestInfo)cxRequestInfo;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("transport", "MQSeries Client");
        properties.put("hostname", this.getServerName());
        properties.put("port", new Integer(this.getPortNumber()));
        properties.put("channel", this.getChannel());
        properties.put("CCSID", new Integer(this.getCCSID()));
        if (cCxReqInf.ccdtUrl != null) {
            properties.put("CCDT URL", cCxReqInf.ccdtUrl);
        }
        properties.put("connectOptions", new Integer(cCxReqInf.connectOptions));
        properties.put("sharingConversations", new Integer(cCxReqInf.sharingConversations));
        if (cCxReqInf.securityExit != null) {
            properties.put("channelSecurityExit", cCxReqInf.securityExit);
        }
        if (cCxReqInf.securityExitUserData != null) {
            properties.put("channelSecurityExitUserData", cCxReqInf.securityExitUserData);
        }
        if (cCxReqInf.sendExit != null) {
            properties.put("channelSendExit", cCxReqInf.sendExit);
        }
        if (cCxReqInf.sendExitUserData != null) {
            properties.put("channelSendExitUserData", cCxReqInf.sendExitUserData);
        }
        if (cCxReqInf.receiveExit != null) {
            properties.put("channelReceiveExit", cCxReqInf.receiveExit);
        }
        if (cCxReqInf.receiveExitUserData != null) {
            properties.put("channelReceiveExitUserData", cCxReqInf.receiveExitUserData);
        }
        if (cCxReqInf.exitClasspath != null) {
            properties.put("exitClasspath", cCxReqInf.exitClasspath);
        }
        if (cCxReqInf.userName != null) {
            properties.put("userID", cCxReqInf.userName);
        }
        if (cCxReqInf.password != null) {
            properties.put("password", cCxReqInf.password);
        }
        if (cCxReqInf.xaRequired) {
            properties.put("XAReq", new Boolean(true));
        }
        if (cCxReqInf.useQmCcsid) {
            properties.put("Use QM CCSID", new Boolean(true));
        }
        if (cCxReqInf.sslCipherSuite != null) {
            properties.put("SSL Cipher Suite", cCxReqInf.sslCipherSuite);
        }
        if (cCxReqInf.sslPeername != null) {
            properties.put("SSL Peer Name", cCxReqInf.sslPeername);
        }
        if (cCxReqInf.sslCertStores != null) {
            properties.put("SSL CertStores", cCxReqInf.sslCertStores);
        }
        if (cCxReqInf.sslSocketFactory != null) {
            properties.put("SSL Socket Factory", cCxReqInf.sslSocketFactory);
        }
        if (cCxReqInf.sslResetCount != null) {
            properties.put("KeyResetCount", cCxReqInf.sslResetCount);
        }
        if (cCxReqInf.sslFipsRequired != null) {
            properties.put("SSL Fips Required", cCxReqInf.sslFipsRequired);
        }
        if (cCxReqInf.localAddress != null) {
            properties.put("Local Address Property", cCxReqInf.localAddress);
        }
        if (cCxReqInf.hdrCompList != null) {
            properties.put("Header Compression Property", cCxReqInf.hdrCompList);
        }
        if (cCxReqInf.msgCompList != null) {
            properties.put("Message Compression Property", cCxReqInf.msgCompList);
        }
        if (cCxReqInf.connTag != null) {
            properties.put("ConnTag Property", cCxReqInf.connTag);
        }
        if (cCxReqInf.jmqiFlags != 0) {
            properties.put("JMQI FLAGS", new Integer(cCxReqInf.jmqiFlags));
        }
        try {
            mancon = mode ? new MQManagedConnectionJ11(this.fieldQMGR, properties, cxRequestInfo, this) : new MQManagedConnection(this.fieldQMGR, properties, cxRequestInfo, this);
            mancon.setLogWriter(this.logWriter);
        }
        catch (MQException mqe) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 61, (Throwable)mqe);
            }
            ResourceException re = ReasonCodeInfo.getResourceException(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 61, (Throwable)re, 2);
            }
            throw re;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 61, (Object)mancon);
        }
        return mancon;
    }

    public MQManagedConnectionJ11 createManagedConnection(ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        int traceContext = 0;
        int fid = 62;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 62, new Object[]{cxRequestInfo});
        }
        MQManagedConnectionJ11 traceRet1 = this._createManagedConnection(cxRequestInfo, true);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 62, (Object)traceRet1);
        }
        return traceRet1;
    }

    public MQManagedConnectionJ11 matchManagedConnections(Vector connectionSet, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        int traceContext = 0;
        int fid = 63;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 63, new Object[]{connectionSet, cxRequestInfo});
        }
        MQManagedConnectionJ11 out = null;
        if (!(cxRequestInfo instanceof BindingsConnectionRequestInfo)) {
            ResourceException traceRet1 = new ResourceException(MQException.getNLSMsg((String)"MQINVCRF_OBJECT"));
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 63, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        Enumeration enumVar = connectionSet.elements();
        while (enumVar.hasMoreElements() && out == null) {
            try {
                MQManagedConnectionJ11 candidate = (MQManagedConnectionJ11)((Object)enumVar.nextElement());
                if (!candidate.isSuitable(cxRequestInfo, this)) continue;
                out = candidate;
            }
            catch (ClassCastException e) {
                if (!this.trace.isOn) continue;
                this.trace.catchBlock((Object)this, COMP_JN, 63, (Throwable)e, 1);
            }
            catch (NullPointerException e) {
                if (!this.trace.isOn) continue;
                this.trace.catchBlock((Object)this, COMP_JN, 63, (Throwable)e, 2);
            }
        }
        if (this.trace.isOn) {
            if (out == null) {
                this.trace.dataFmt(this.env, COMP_JN, 63, "No suitable MQManagedConnection found", (Object)"");
            } else {
                this.trace.dataFmt(this.env, COMP_JN, 63, "Suitable MQManagedConnection found: ", (Object)out);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 63, (Object)out);
        }
        return out;
    }

    public int hashCode() {
        int fid = 64;
        int traceRet1 = this.getClass().hashCode();
        return traceRet1;
    }

    public boolean equals(Object obj) {
        int fid = 65;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MQClientManagedConnectionFactoryJ11 other = (MQClientManagedConnectionFactoryJ11)obj;
        return MQClientManagedConnectionFactoryJ11.twoStringsEqual(this.fieldQMGR, other.fieldQMGR) && this.fieldServerName.equals(other.fieldServerName) && this.fieldPortNumber == other.fieldPortNumber && this.fieldChannel.equals(other.fieldChannel) && this.fieldCCSID == other.fieldCCSID;
    }

    public Object clone() {
        int traceContext = 0;
        int fid = 66;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 66);
        }
        try {
            Object traceRet1 = super.clone();
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 66, traceRet1);
            }
            return traceRet1;
        }
        catch (CloneNotSupportedException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 66, (Throwable)e);
            }
            IllegalAccessError traceRet2 = new IllegalAccessError();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 66, (Throwable)traceRet2);
            }
            throw traceRet2;
        }
    }

    static boolean twoStringsEqual(String a, String b) {
        boolean result = a == null && b == null ? true : (a == null || b == null ? false : a.equals(b));
        return result;
    }
}

