/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQSESSION;
import com.ibm.mq.exits.MQCD;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.JmqiUtils;
import java.util.Collection;
import java.util.Iterator;

public class MQChannelDefinition
extends JmqiObject {
    static final String sccsid = "@(#)  com.ibm.mq/src/com/ibm/mq/MQChannelDefinition.java, java.classes, k700, k700-L080529 1.32.1.1 08/06/01 08:52:23";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MQCD jmqiStructure = MQSESSION.getJmqiEnv().newMQCD();
    public String channelName;
    public String queueManagerName;
    public int maxMessageLength;
    public String securityUserData;
    public String sendUserData;
    public String receiveUserData;
    public String connectionName;
    public String remoteUserId;
    public String remotePassword;
    public String sslPeerName;
    public String localAddress;
    public Collection hdrCompList = null;
    public Collection msgCompList = null;
    public String sslCipherSuite;
    public int sharingConversations = 10;

    public MQChannelDefinition() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 49;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 49);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 49);
        }
    }

    private int calcMinimumVersion() {
        int traceContext = 0;
        int fid = 50;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 50);
        }
        int version = 2;
        if (this.remoteUserId != null && this.remoteUserId.length() > 12) {
            version = 6;
        }
        if (this.remotePassword != null && this.remotePassword.length() > 12) {
            version = 6;
        }
        if (this.localAddress != null && this.localAddress.length() > 0) {
            version = 7;
        }
        if (this.sslCipherSuite != null && this.sslCipherSuite.length() > 0) {
            version = 7;
        }
        if (this.sslPeerName != null && this.sslPeerName.length() > 0) {
            version = 7;
        }
        if (this.hdrCompList != null && this.hdrCompList.size() > 0) {
            version = 8;
        }
        if (this.msgCompList != null && this.msgCompList.size() > 0) {
            version = 8;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 50, (Object)new Integer(version));
        }
        return version;
    }

    protected MQCD getJMQIStructure(boolean fipsRequired) {
        int traceContext = 0;
        int fid = 51;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 51, new Object[]{fipsRequired});
        }
        this.jmqiStructure.setVersion(this.calcMinimumVersion());
        this.jmqiStructure.setChannelName(this.channelName);
        this.jmqiStructure.setQMgrName(this.queueManagerName);
        this.jmqiStructure.setMaxMsgLength(this.maxMessageLength);
        this.jmqiStructure.setConnectionName(this.connectionName);
        this.jmqiStructure.setRemoteUserIdentifier(this.remoteUserId);
        this.jmqiStructure.setRemotePassword(this.remotePassword);
        this.jmqiStructure.setSslPeerName(this.sslPeerName);
        this.jmqiStructure.setLocalAddress(this.localAddress);
        this.jmqiStructure.setSharingConversations(this.sharingConversations);
        String cipherSpec = null;
        if (this.sslCipherSuite != null) {
            cipherSpec = JmqiUtils.toCipherSpec((String)this.sslCipherSuite, (boolean)fipsRequired);
        }
        this.jmqiStructure.setSslCipherSpec(cipherSpec);
        this.jmqiStructure.setSecurityUserData(this.securityUserData);
        this.jmqiStructure.setSendUserData(this.sendUserData);
        this.jmqiStructure.setReceiveUserData(this.receiveUserData);
        Collection localHdrCompList = this.hdrCompList;
        if (localHdrCompList != null) {
            int[] hdrCompListArray = new int[localHdrCompList.size()];
            Iterator iterator = localHdrCompList.iterator();
            int entryIndex = 0;
            while (iterator.hasNext()) {
                Object hdrCompEntry = iterator.next();
                hdrCompListArray[entryIndex] = hdrCompEntry instanceof Integer ? (Integer)hdrCompEntry : 0;
                ++entryIndex;
            }
            this.jmqiStructure.setHdrCompList(hdrCompListArray);
        } else {
            this.jmqiStructure.setHdrCompList(null);
        }
        Collection localMsgCompList = this.msgCompList;
        if (localMsgCompList != null) {
            int[] msgCompListArray = new int[localMsgCompList.size()];
            Iterator iterator = localMsgCompList.iterator();
            int entryIndex = 0;
            while (iterator.hasNext()) {
                Object msgCompEntry = iterator.next();
                msgCompListArray[entryIndex] = msgCompEntry instanceof Integer ? (Integer)msgCompEntry : 0;
                ++entryIndex;
            }
            this.jmqiStructure.setMsgCompList(msgCompListArray);
        } else {
            this.jmqiStructure.setMsgCompList(null);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 51, (Object)this.jmqiStructure);
        }
        return this.jmqiStructure;
    }
}

