/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.BindingsConnectionRequestInfo;
import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedConnection;
import com.ibm.mq.MQManagedConnectionFactory;
import com.ibm.mq.MQManagedConnectionJ11;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;
import com.ibm.mq.ReasonCodeInfo;
import com.ibm.mq.jmqi.JmqiObject;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

class MQBindingsManagedConnectionFactoryJ11
extends JmqiObject
implements MQManagedConnectionFactory {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQBindingsManagedConnectionFactoryJ11.java, java.classes, k700, k700-L080529 1.34.1.1 08/06/01 08:51:43";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final long serialVersionUID = -3221376675852376439L;
    private String fieldQMGR = "";
    PrintWriter logWriter = null;

    MQBindingsManagedConnectionFactoryJ11(String qmgr, Hashtable props) {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 39;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 39, new Object[]{qmgr, props});
        }
        this.setQMGR(qmgr);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 39);
        }
    }

    public void setQMGR(String value) {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setQMGR(String)", (Object)value);
        }
        this.fieldQMGR = value;
    }

    public String getQMGR() {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getQMGR()", (Object)this.fieldQMGR);
        }
        return this.fieldQMGR;
    }

    public Object createConnectionFactory(MQConnectionManager cxManager) throws ResourceException {
        int traceContext = 0;
        int fid = 40;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 40, new Object[]{cxManager});
        }
        NotSupportedException traceRet1 = new NotSupportedException(MQException.getNLSMsg((String)"MQCCF_NOT_SUPPURTED"));
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 40, (Throwable)traceRet1);
        }
        throw traceRet1;
    }

    public Object createConnectionFactory() throws ResourceException {
        int traceContext = 0;
        int fid = 41;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 41);
        }
        NotSupportedException traceRet1 = new NotSupportedException(MQException.getNLSMsg((String)"MQCCF_NOT_SUPPURTED"));
        if (this.trace.isOn) {
            this.trace.throwing((Object)this, COMP_JN, 41, (Throwable)traceRet1);
        }
        throw traceRet1;
    }

    MQManagedConnectionJ11 _createManagedConnection(ConnectionRequestInfo cxRequestInfo, boolean mode) throws ResourceException {
        MQManagedConnectionJ11 mancon;
        int traceContext = 0;
        int fid = 42;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 42, new Object[]{cxRequestInfo, mode});
        }
        if (!(cxRequestInfo instanceof BindingsConnectionRequestInfo)) {
            String msg = MQException.getNLSMsg((String)"MQJI039");
            ResourceException traceRet1 = new ResourceException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 42, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        BindingsConnectionRequestInfo bCxReqInf = (BindingsConnectionRequestInfo)cxRequestInfo;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        properties.put("transport", "MQSeries Bindings");
        properties.put("connectOptions", new Integer(bCxReqInf.connectOptions));
        if (bCxReqInf.multiThread != null) {
            properties.put("Thread access", bCxReqInf.multiThread);
        }
        if (bCxReqInf.threadAffinity != null) {
            properties.put("Thread affinity", bCxReqInf.threadAffinity);
        }
        if (bCxReqInf.userName != null) {
            properties.put("userID", bCxReqInf.userName);
        }
        if (bCxReqInf.password != null) {
            properties.put("password", bCxReqInf.password);
        }
        if (bCxReqInf.authenticateBindings != null) {
            properties.put("Bindings Authentication", bCxReqInf.authenticateBindings);
        }
        if (bCxReqInf.connTag != null) {
            properties.put("ConnTag Property", bCxReqInf.connTag);
        }
        try {
            if (mode) {
                mancon = new MQManagedConnectionJ11(this.fieldQMGR, properties, cxRequestInfo, this);
                Pint pCompCode = new Pint();
                Pint pReason = new Pint();
                mancon.authenticate(pCompCode, pReason);
            } else {
                mancon = new MQManagedConnection(this.fieldQMGR, properties, cxRequestInfo, this);
            }
            mancon.setLogWriter(this.logWriter);
        }
        catch (MQException mqe) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 42, (Throwable)mqe);
            }
            ResourceException re = ReasonCodeInfo.getResourceException(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 42, (Throwable)re, 2);
            }
            throw re;
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 42, (Object)mancon);
        }
        return mancon;
    }

    public MQManagedConnectionJ11 createManagedConnection(ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        int traceContext = 0;
        int fid = 43;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 43, new Object[]{cxRequestInfo});
        }
        MQManagedConnectionJ11 traceRet1 = this._createManagedConnection(cxRequestInfo, true);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 43, (Object)traceRet1);
        }
        return traceRet1;
    }

    public MQManagedConnectionJ11 matchManagedConnections(Vector connectionSet, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        int traceContext = 0;
        int fid = 44;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 44, new Object[]{connectionSet, cxRequestInfo});
        }
        MQManagedConnectionJ11 out = null;
        if (!(cxRequestInfo instanceof BindingsConnectionRequestInfo)) {
            String msg = MQException.getNLSMsg((String)"MQJI039");
            ResourceException traceRet1 = new ResourceException(msg);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 44, (Throwable)traceRet1);
            }
            throw traceRet1;
        }
        Enumeration enumVar = connectionSet.elements();
        while (enumVar.hasMoreElements() && out == null) {
            try {
                MQManagedConnectionJ11 candidate = (MQManagedConnectionJ11)((Object)enumVar.nextElement());
                if (!candidate.isSuitable(cxRequestInfo, this)) continue;
                out = candidate;
            }
            catch (ClassCastException e) {
                if (!this.trace.isOn) continue;
                this.trace.catchBlock((Object)this, COMP_JN, 44, (Throwable)e, 1);
            }
            catch (NullPointerException e) {
                if (!this.trace.isOn) continue;
                this.trace.catchBlock((Object)this, COMP_JN, 44, (Throwable)e, 2);
            }
        }
        if (this.trace.isOn) {
            if (out == null) {
                this.trace.dataFmt(this.env, COMP_JN, 44, "No suitable MQManagedConnection found", (Object)"");
            } else {
                this.trace.dataFmt(this.env, COMP_JN, 44, "Suitable MQManagedConnection found: ", (Object)out);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 44, (Object)out);
        }
        return out;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "setLogWriter(java.io.PrintWriter)", (Object)out);
        }
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getLogWriter()", (Object)this.logWriter);
        }
        return this.logWriter;
    }

    public int hashCode() {
        int fid = 45;
        int traceRet1 = this.getClass().hashCode();
        return traceRet1;
    }

    public boolean equals(Object obj) {
        int fid = 46;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MQBindingsManagedConnectionFactoryJ11 other = (MQBindingsManagedConnectionFactoryJ11)obj;
        return MQBindingsManagedConnectionFactoryJ11.twoStringsEqual(this.fieldQMGR, other.fieldQMGR);
    }

    public Object clone() {
        int traceContext = 0;
        int fid = 47;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 47);
        }
        try {
            Object traceRet1 = super.clone();
            if (this.trace.isOn) {
                this.trace.exit(traceContext, (Object)this, COMP_JN, 47, traceRet1);
            }
            return traceRet1;
        }
        catch (CloneNotSupportedException e) {
            if (this.trace.isOn) {
                this.trace.catchBlock((Object)this, COMP_JN, 47, (Throwable)e);
            }
            IllegalAccessError traceRet2 = new IllegalAccessError();
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 47, (Throwable)traceRet2);
            }
            throw traceRet2;
        }
    }

    static boolean twoStringsEqual(String a, String b) {
        boolean result = a == null && b == null ? true : (a == null || b == null ? false : a.equals(b));
        return result;
    }
}

