/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.DuplicateLeafException;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.QMTreeException;
import com.ibm.mq.TreeElt;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

abstract class AbstractTree
extends JmqiObject {
    private final Collection leaves = new ArrayList();
    private final Collection nodes = new ArrayList();
    private TreeElt root = null;

    public AbstractTree() {
        this(null);
        int traceContext = 0;
        int fid = 732;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 732);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 732);
        }
    }

    public AbstractTree(TreeElt root) {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 733;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 733, new Object[]{root});
        }
        if (root == null) {
            root = new TreeElt();
        } else {
            this.root = root;
        }
        this.nodes.add(root);
        this.leaves.add(root);
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 733);
        }
    }

    public TreeElt root() {
        int traceContext = 0;
        int fid = 734;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 734);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 734, (Object)this.root);
        }
        return this.root;
    }

    public Collection leaves() {
        int traceContext = 0;
        int fid = 735;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 735);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 735, (Object)this.leaves);
        }
        return this.leaves;
    }

    public TreeElt parent(TreeElt elt) {
        int traceContext = 0;
        int fid = 736;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 736, new Object[]{elt});
        }
        TreeElt traceRet1 = elt.getParent();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 736, (Object)traceRet1);
        }
        return traceRet1;
    }

    public Collection children(TreeElt elt) {
        int traceContext = 0;
        int fid = 737;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 737, new Object[]{elt});
        }
        Collection traceRet1 = elt.children();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 737, (Object)traceRet1);
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(TreeElt elt, Object o) throws QMTreeException {
        int traceContext = 0;
        int fid = 738;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 738, new Object[]{elt, o});
        }
        TreeElt treeElt = this.root;
        synchronized (treeElt) {
            if (this.leafContains(o)) {
                DuplicateLeafException traceRet1 = new DuplicateLeafException();
                if (this.trace.isOn) {
                    this.trace.throwing((Object)this, COMP_JN, 738, (Throwable)traceRet1);
                }
                throw traceRet1;
            }
            TreeElt newElt = new TreeElt(elt, o);
            elt.addChild(newElt);
            if (elt.children().size() == 1) {
                this.leaves.remove(elt);
            }
            this.nodes.add(newElt);
            this.leaves.add(newElt);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 738);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeElt getChild(TreeElt elt, Object obj) {
        int traceContext = 0;
        int fid = 739;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 739, new Object[]{elt, obj});
        }
        TreeElt found = null;
        TreeElt treeElt = this.root;
        synchronized (treeElt) {
            if (elt != null && obj != null) {
                Collection c = elt.children();
                Iterator i = c.iterator();
                while (found == null && i.hasNext()) {
                    TreeElt t = (TreeElt)i.next();
                    Object o = t.getElement();
                    if (!obj.equals(o)) continue;
                    found = t;
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 739, found);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild(TreeElt elt, Object o) throws QMTreeException {
        int traceContext = 0;
        int fid = 740;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 740, new Object[]{elt, o});
        }
        TreeElt treeElt = this.root;
        synchronized (treeElt) {
            Collection c = elt.children();
            if (o != null && c.size() != 0) {
                Iterator i = c.iterator();
                TreeElt t = null;
                boolean found = false;
                while (!found && i.hasNext()) {
                    t = (TreeElt)i.next();
                    found = o.equals(t.getElement());
                }
                if (t != null) {
                    this.removeDescendants(t);
                    elt.removeChild(t);
                    this.nodes.remove(t);
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 740);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leafContains(Object obj) {
        int traceContext = 0;
        int fid = 741;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 741, new Object[]{obj});
        }
        boolean found = false;
        TreeElt treeElt = this.root;
        synchronized (treeElt) {
            if (obj != null) {
                Iterator i = this.leaves.iterator();
                while (!found && i.hasNext()) {
                    TreeElt te = (TreeElt)i.next();
                    Object o = te.getElement();
                    if (!obj.equals(o)) continue;
                    found = true;
                }
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 741, (Object)found);
        }
        return found;
    }

    public int size() {
        int traceContext = 0;
        int fid = 742;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 742);
        }
        int traceRet1 = this.nodes.size();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 742, (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer strbf = new StringBuffer();
        TreeElt treeElt = this.root;
        synchronized (treeElt) {
            strbf.append("Root  : " + this.root + "\n");
            strbf.append("Leaves: " + this.leaves + "\n");
            strbf.append("Nodes : " + this.nodes + "\n\n");
            if (this.root != null) {
                this.printChildren(this.root, strbf);
            }
        }
        return strbf.toString();
    }

    private void removeDescendants(TreeElt t) {
        Collection c;
        int traceContext = 0;
        int fid = 743;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 743, new Object[]{t});
        }
        if ((c = t.children()).size() != 0) {
            Iterator i = c.iterator();
            while (i.hasNext()) {
                TreeElt tn = (TreeElt)i.next();
                this.removeDescendants(tn);
            }
        }
        this.nodes.remove(t);
        if (this.leaves.contains(t)) {
            this.leaves.remove(t);
            if (t.getParent() != null && t.getParent().children().size() == 1) {
                this.leaves.add(t.getParent());
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 743);
        }
    }

    private void printChildren(TreeElt t, StringBuffer b) {
        int traceContext = 0;
        int fid = 744;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 744, new Object[]{t, b});
        }
        b.append("node '" + t + "', depth " + t.depth() + " ");
        Collection c = t.children();
        if (c.size() == 0) {
            b.append(", no children\n");
        } else {
            b.append(", " + c.size() + " children " + c + "\n");
            Iterator i = c.iterator();
            while (i.hasNext()) {
                TreeElt nt = (TreeElt)i.next();
                this.printChildren(nt, b);
            }
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 744);
        }
    }
}

