/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.NonPrintableAsciiPBEKey;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordHashGenerator;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.PBEKeySpec;

final class RecordHashGeneratorFactory {
    private RecordHashGeneratorFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static RecordHashGenerator newRecordHashGenerator(FileHeader header) {
        if (header.getMajorVersionNumber().equals(VersionNumber.THREE)) {
            return new RecordHashGeneratorV3Impl();
        }
        return new RecordHashGeneratorV4Impl();
    }

    private static final class RecordHashGeneratorV4Impl
    implements RecordHashGenerator {
        private RecordHashGeneratorV4Impl() {
        }

        public ByteSequence generateHash(FileHeader header, Record record, String password) throws NullPointerException, NoSuchAlgorithmException, IOException {
            if (record == null || password == null) {
                throw new NullPointerException();
            }
            Mac md = Mac.getInstance("HmacSHA1");
            try {
                md.init(new NonPrintableAsciiPBEKey(new PBEKeySpec(password.toCharArray())));
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            ByteSequence recordpwd = record.append(ByteSequenceFactory.newByteSequence(password.getBytes("UTF-8")));
            byte[] recordpwdBytes = new byte[recordpwd.length()];
            recordpwd.getInputStream().read(recordpwdBytes);
            byte[] digest = md.doFinal(recordpwdBytes);
            return ByteSequenceFactory.newByteSequence(digest);
        }
    }

    private static final class RecordHashGeneratorV3Impl
    implements RecordHashGenerator {
        private RecordHashGeneratorV3Impl() {
        }

        public ByteSequence generateHash(FileHeader header, Record record, String password) throws NullPointerException, NoSuchAlgorithmException, IOException {
            if (record == null || password == null) {
                throw new NullPointerException();
            }
            MessageDigest md = MessageDigest.getInstance("MD5");
            ByteSequence recordpwd = record.append(ByteSequenceFactory.newByteSequence(password.getBytes("UTF-8")));
            byte[] recordpwdBytes = new byte[recordpwd.length()];
            recordpwd.getInputStream().read(recordpwdBytes);
            byte[] digest = md.digest(recordpwdBytes);
            return ByteSequenceFactory.newByteSequence(digest);
        }
    }
}

