/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BadRecordFlagException;
import com.ibm.security.cmskeystore.Buffer;
import com.ibm.security.cmskeystore.BufferFactory;
import com.ibm.security.cmskeystore.ByteSequenceInputStream;
import com.ibm.security.cmskeystore.ByteSequenceInputStreamFactory;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.Record;
import com.ibm.security.cmskeystore.RecordEncoding;
import com.ibm.security.cmskeystore.RecordEncodingFactory;
import com.ibm.security.cmskeystore.RecordFlag;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceFactory;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.io.InputStream;

final class RecordFactory {
    private RecordFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static Record newRecord(InputStream in, int length) throws NullPointerException, IllegalArgumentException, BadRecordFlagException, IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        if (length < 0) {
            throw new IllegalArgumentException();
        }
        ByteSequenceInputStream bsis = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        ByteSequence s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        RecordFlag recordFlag = RecordFlag.recordFlagFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(s));
        if (recordFlag == null) {
            throw new BadRecordFlagException();
        }
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence recordId = IntableByteSequenceFactory.newIntableByteSequence(s);
        RecordEncoding encoding = RecordEncodingFactory.newRecordEncoding(BufferFactory.newBuffer(in));
        if (encoding == null) {
            return null;
        }
        Buffer label = BufferFactory.newBuffer(in);
        if (label == null) {
            return null;
        }
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence issuerRecordId = IntableByteSequenceFactory.newIntableByteSequence(s);
        Buffer signatureHash = BufferFactory.newBuffer(in);
        if (signatureHash == null) {
            return null;
        }
        Buffer unsignedCertHash = BufferFactory.newBuffer(in);
        if (unsignedCertHash == null) {
            return null;
        }
        Buffer subjectNameHash = BufferFactory.newBuffer(in);
        if (subjectNameHash == null) {
            return null;
        }
        Buffer subjectPublicKeyInfoHash = BufferFactory.newBuffer(in);
        if (subjectPublicKeyInfoHash == null) {
            return null;
        }
        Buffer issuerAndSerialNumberHash = BufferFactory.newBuffer(in);
        if (issuerAndSerialNumberHash == null) {
            return null;
        }
        int l = recordFlag.length() + recordId.length() + encoding.length() + label.length() + issuerRecordId.length() + signatureHash.length() + unsignedCertHash.length() + subjectNameHash.length() + subjectPublicKeyInfoHash.length() + issuerAndSerialNumberHash.length();
        int len = length - l;
        if (len < 0) {
            throw new IllegalArgumentException();
        }
        in.skip(len);
        return new RecordImpl(recordFlag, recordId, encoding, label, issuerRecordId, signatureHash, unsignedCertHash, subjectNameHash, subjectPublicKeyInfoHash, issuerAndSerialNumberHash, len);
    }

    private static final class RecordImpl
    implements Record {
        private final RecordFlag recordFlag;
        private final IntableByteSequence recordId;
        private final RecordEncoding encoding;
        private final Buffer label;
        private final IntableByteSequence issuerRecordId;
        private final Buffer signatureHash;
        private final Buffer unsignedCertHash;
        private final Buffer subjectNameHash;
        private final Buffer subjectPublicKeyInfoHash;
        private final Buffer issuerAndSerialNumberHash;
        private final ByteSequence sequence;

        RecordImpl(RecordFlag recordFlag, IntableByteSequence recordId, RecordEncoding encoding, Buffer label, IntableByteSequence issuerRecordId, Buffer signatureHash, Buffer unsignedCertHash, Buffer subjectNameHash, Buffer subjectPublicKeyInfoHash, Buffer issuerAndSerialNumberHash, int length) {
            this.recordFlag = recordFlag;
            this.recordId = recordId;
            this.encoding = encoding;
            this.label = label;
            this.issuerRecordId = issuerRecordId;
            this.signatureHash = signatureHash;
            this.unsignedCertHash = unsignedCertHash;
            this.subjectNameHash = subjectNameHash;
            this.subjectPublicKeyInfoHash = subjectPublicKeyInfoHash;
            this.issuerAndSerialNumberHash = issuerAndSerialNumberHash;
            ByteSequence s = recordFlag.append(recordId).append(encoding).append(label).append(issuerRecordId).append(signatureHash).append(unsignedCertHash).append(subjectNameHash).append(subjectPublicKeyInfoHash).append(issuerAndSerialNumberHash);
            this.sequence = length == 0 ? s : s.append(ByteSequenceFactory.newConstantByteSequence((byte)0, length));
        }

        public RecordFlag getRecordFlag() {
            return this.recordFlag;
        }

        public IntableByteSequence getRecordId() {
            return this.recordId;
        }

        public RecordEncoding getEncoding() {
            return this.encoding;
        }

        public Buffer getLabel() {
            return this.label;
        }

        public IntableByteSequence getIssuerRecordId() {
            return this.issuerRecordId;
        }

        public Buffer getSignatureHash() {
            return this.signatureHash;
        }

        public Buffer getUnsignedCertHash() {
            return this.unsignedCertHash;
        }

        public Buffer getSubjectNameHash() {
            return this.subjectNameHash;
        }

        public Buffer getSubjectPublicKeyInfoHash() {
            return this.subjectPublicKeyInfoHash;
        }

        public Buffer getIssuerAndSerialNumberHash() {
            return this.issuerAndSerialNumberHash;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index);
        }

        public int length() {
            return this.sequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return this.sequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.lastIndexOf(position, b);
        }

        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        public String toHexString() {
            return this.sequence.toHexString();
        }

        public String toString() {
            return ((Object)this.sequence).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                byte e2;
                byte e1 = it1.getNextByte();
                if (e1 == (e2 = it2.getNextByte())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.sequence).hashCode();
        }
    }
}

