/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.ui.DialogTemplate;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DeployUIManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class AboutDialog
extends JDialog
implements DeploySIListener {
    private SingleInstanceImpl sil = null;
    private static String ABOUT_JAVA_ID = "com_sun_deploy_AboutJava-" + Config.getProperty("deployment.version");

    public AboutDialog(JFrame jFrame, boolean bl, boolean bl2) {
        super((Frame)jFrame, bl);
        if (bl2) {
            this.initSIImpl();
        }
        this.initComponents();
    }

    public AboutDialog(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, bl);
        this.initComponents();
    }

    public AboutDialog(JDialog jDialog, boolean bl) {
        super((Dialog)jDialog, bl);
        this.initComponents();
    }

    private void initSIImpl() {
        this.sil = new SingleInstanceImpl();
        this.sil.addSingleInstanceListener(this, ABOUT_JAVA_ID);
    }

    public static boolean shouldStartNewInstance() {
        return !SingleInstanceManager.isServerRunning(ABOUT_JAVA_ID) || !SingleInstanceManager.connectToServer("");
    }

    private void initComponents() {
        this.setTitle(this.getMessage("about.dialog.title"));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AboutDialog.this.closeDialog(windowEvent);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setForeground(new Color(210, 219, 228));
        jPanel.setBackground(new Color(210, 219, 228));
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        URL uRL = ClassLoader.getSystemResource("com/sun/deploy/resources/image/aboutjava.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.getAccessibleContext().setAccessibleName(this.getMessage("common.java.logo"));
        jLabel.getAccessibleContext().setAccessibleDescription(this.getMessage("common.java.logo"));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        int n = imageIcon.getIconWidth() - 20;
        String string = this.getMessage("about.product.name");
        String string2 = this.getMessage("about.license.note");
        String string3 = this.getMessage("about.sun.copyright");
        String string4 = this.getMessage("about.copyright");
        String string5 = this.getMessage("about.legal.note");
        String string6 = string + "\n" + string2 + "\n" + string3 + "\n" + string4 + "\n" + string5;
        UITextArea uITextArea = new UITextArea(DialogTemplate.getSubpanelFontSize(), n, false);
        uITextArea.setText(string6);
        uITextArea.setForeground(new Color(112, 114, 119));
        uITextArea.getAccessibleContext().setAccessibleName(uITextArea.getText());
        uITextArea.getAccessibleContext().setAccessibleDescription(uITextArea.getText());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        Font font = ResourceManager.getUIFont().deriveFont((float)DialogTemplate.getSubpanelFontSize());
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        gridBagLayout.setConstraints(uITextArea, gridBagConstraints);
        jPanel.add(uITextArea);
        JLabel jLabel2 = new JLabel();
        ImageIcon imageIcon2 = ResourceManager.getIcon("ibm.logo.image");
        jLabel2.setIcon(imageIcon2);
        jLabel2.getAccessibleContext().setAccessibleName(this.getMessage("common.ibm.logo"));
        jLabel2.getAccessibleContext().setAccessibleDescription(this.getMessage("common.ibm.logo"));
        gridBagConstraints.insets = new Insets(0, 10, 45, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        JPanel jPanel2 = new JPanel(new FlowLayout(2, 10, 10));
        JButton jButton = new JButton(this.getMessage("about.option.close"));
        jButton.getAccessibleContext().setAccessibleDescription(this.getMessage("about.option.close"));
        jButton.setMnemonic(ResourceManager.getVKCode("common.cancel_btn.mnemonic"));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AboutDialog.this.okBtnActionPerformed(actionEvent);
            }
        };
        jButton.addActionListener(abstractAction);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(2).put(keyStroke, "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        jPanel2.add(jButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        this.setResizable(false);
    }

    private void okBtnActionPerformed(ActionEvent actionEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        if (this.sil != null) {
            this.sil.removeSingleInstanceListener(this);
        }
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }

    public void newActivation(String[] stringArray) {
        this.toFront();
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    static {
        DeployUIManager.setLookAndFeel();
    }
}

