/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.ibm.security.bootstrap.RSACore;
import com.ibm.security.bootstrap.RSAPadding;
import com.sun.deploy.security.MSCryptoRSAPrivateKey;
import com.sun.deploy.util.Trace;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;

public final class MSCryptoNONEwithRSASignature
extends SignatureSpi {
    private byte[] buffer;
    private int bufOfs;
    private MSCryptoRSAPrivateKey privateKey = null;

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new InvalidKeyException("Key not supported");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof MSCryptoRSAPrivateKey)) {
            throw new InvalidKeyException("Key not supported");
        }
        this.privateKey = (MSCryptoRSAPrivateKey)privateKey;
        int n = this.privateKey.bitLength() + 7 >> 3;
        if (n < 64) {
            throw new InvalidKeyException("RSA keys should be at least 512 bits long");
        }
        this.bufOfs = 0;
        try {
            RSAPadding rSAPadding = RSAPadding.getInstance((int)1, (int)n, (SecureRandom)this.appRandom);
            int n2 = rSAPadding.getMaxDataSize();
            this.buffer = new byte[n2];
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            Trace.securityPrintException(invalidAlgorithmParameterException);
        }
    }

    private void update(byte[] byArray, int n, int n2) {
        if (n2 == 0 || byArray == null) {
            return;
        }
        if (this.bufOfs + n2 > this.buffer.length) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(byArray, n, this.buffer, this.bufOfs, n2);
        this.bufOfs += n2;
    }

    protected void engineUpdate(byte by) throws SignatureException {
        byte[] byArray = new byte[]{by};
        this.update(byArray, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.update(byArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] engineSign() throws SignatureException {
        if (this.bufOfs > this.buffer.length) {
            throw new SignatureException("Data must not be longer than " + this.buffer.length + " bytes");
        }
        try {
            byte[] byArray = RSACore.convert((byte[])this.buffer, (int)0, (int)this.bufOfs);
            byte[] byArray2 = MSCryptoNONEwithRSASignature.nativeSignHash(byArray, byArray.length, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
            byte[] byArray3 = this.convertEndianArray(byArray2);
            return byArray3;
        }
        finally {
            this.bufOfs = 0;
        }
    }

    private byte[] convertEndianArray(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = byArray[byArray.length - i - 1];
        }
        return byArray2;
    }

    private static native byte[] nativeSignHash(byte[] var0, int var1, int var2, int var3) throws SignatureException;

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        throw new SignatureException("Signature verification not supported");
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }
}

