/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net;

import com.sun.deploy.Environment;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.cache.CacheEntry;
import com.sun.deploy.config.Config;
import com.sun.deploy.jardiff.JarDiffPatcher;
import com.sun.deploy.jardiff.Patcher;
import com.sun.deploy.net.BasicHttpRequest;
import com.sun.deploy.net.FailedDownloadException;
import com.sun.deploy.net.HttpDownload;
import com.sun.deploy.net.HttpDownloadHelper;
import com.sun.deploy.net.HttpDownloadListener;
import com.sun.deploy.net.HttpRequest;
import com.sun.deploy.net.HttpResponse;
import com.sun.deploy.net.HttpUtils;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.net.URLEncoder;
import com.sun.deploy.net.offline.DeployOfflineManager;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.util.VersionID;
import com.sun.deploy.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class DownloadEngine {
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    public static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final int BASIC_DOWNLOAD_PROTOCOL = 1;
    private static final int VERSION_DOWNLOAD_PROTOCOL = 2;
    private static final int EXTENSION_DOWNLOAD_PROTOCOL = 3;
    public static final int NORMAL_CONTENT = 0;
    public static final int NATIVE_CONTENT = 1;
    public static final int JAR_CONTENT = 2;
    private static int BUF_SIZE = 8192;
    private static final String defaultLocaleString = Locale.getDefault().toString();
    private static HttpRequest _httpRequestImpl;
    private static HttpDownload _httpDownloadImpl;
    private static int jarCompression;
    private static Hashtable noCacheJarFileList;
    private static ArrayList updateCheckDoneList;
    private static final Object syncObject;

    static boolean isPack200Supported() {
        return Config.isJavaVersionAtLeast15();
    }

    public static void setJarCompressionLevel(int n) {
        jarCompression = n;
    }

    public static int getJarCompressionLevel() {
        if (jarCompression == -1) {
            String string = Config.getProperty("deployment.cache.jarcompression");
            string = string.trim();
            try {
                jarCompression = Integer.valueOf(string);
                if (jarCompression < 0 || jarCompression > 9) {
                    jarCompression = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                jarCompression = 0;
            }
        }
        return jarCompression;
    }

    public static String getCachedResourceFilePath(URL uRL, String string) throws IOException {
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = Cache.getCacheEntry(uRL, null, string);
            if (cacheEntry != null) {
                return cacheEntry.getResourceFilename();
            }
        } else {
            JarFile jarFile = (JarFile)Cache.getLoadedResource(uRL.toString());
            if (jarFile != null) {
                return jarFile.getName();
            }
        }
        throw new IOException("Cannot find cached resource for URL: " + uRL.toString());
    }

    public static URL getResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        return DownloadEngine.getResource(uRL, string, string2, downloadDelegate, bl, 0);
    }

    public static URL getResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, int n) throws IOException {
        File file;
        URL uRL2 = null;
        Cache.removeLoadedResource(uRL.toString());
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, n);
            if (cacheEntry != null) {
                uRL2 = URLUtil.fileToURL(new File(cacheEntry.getResourceFilename()));
            }
        } else if ((n == 2 || DownloadEngine.isAlwaysCached(uRL.toString().toLowerCase())) && (file = DownloadEngine.getJarFileWithoutCache(uRL, string, string2, downloadDelegate)) != null) {
            JarFile jarFile = new JarFile(file);
            Cache.addLoadedResource(uRL.toString(), jarFile);
        }
        return uRL2;
    }

    static boolean isZipFile(String string) {
        return string.toLowerCase().endsWith(".zip");
    }

    public static boolean isAlwaysCached(String string) {
        return string.toLowerCase().endsWith(".jar") || string.toLowerCase().endsWith(".jarjar") || string.toLowerCase().endsWith(".zip");
    }

    public static long getCachedLastModified(URL uRL, String string, String string2) throws IOException {
        CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false);
        if (cacheEntry != null) {
            return cacheEntry.getLastModified();
        }
        return 0L;
    }

    public static long getCachedSize(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl);
        if (cacheEntry != null) {
            return cacheEntry.getSize();
        }
        return 0L;
    }

    public static void clearNoCacheJarFileList() {
        noCacheJarFileList.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getJarFileWithoutCache(final URL uRL, String string, final String string2, final DownloadDelegate downloadDelegate) throws IOException {
        Object object;
        int n;
        JarFile jarFile;
        File file;
        OutputStream outputStream;
        byte[] byArray;
        block24: {
            File file2 = (File)noCacheJarFileList.get(uRL.toString());
            if (file2 != null) {
                return file2;
            }
            byArray = new byte[8192];
            URL uRL2 = DownloadEngine.getRequestURL(uRL, string, string2, null, null, null, null, false, null, 0);
            URLConnection uRLConnection = uRL2.openConnection();
            if (DownloadEngine.isPack200Supported()) {
                uRLConnection.setRequestProperty("accept-encoding", "pack200-gzip,gzip");
            } else {
                uRLConnection.setRequestProperty("accept-encoding", "gzip");
            }
            InputStream inputStream = uRLConnection.getInputStream();
            int n2 = uRLConnection.getContentLength();
            String string3 = uRLConnection.getContentEncoding();
            int n3 = 0;
            if (downloadDelegate != null) {
                downloadDelegate.setTotalSize(n2);
            }
            HttpDownloadListener httpDownloadListener = downloadDelegate == null ? null : new HttpDownloadListener(){

                public boolean downloadProgress(int n, int n2) {
                    downloadDelegate.downloading(uRL, string2, n, n2, false);
                    return true;
                }
            };
            outputStream = null;
            file = null;
            jarFile = null;
            Trace.println(ResourceManager.getString("httpDownloadHelper.doingDownload", uRL == null ? "" : uRL.toString(), n2, string3), TraceLevel.NETWORK);
            try {
                try {
                    file = File.createTempFile("jar_cache", null);
                    file.deleteOnExit();
                    outputStream = new FileOutputStream(file);
                    n = 0;
                    if (string3 != null && string3.equals("pack200-gzip")) {
                        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
                        object = Pack200.newUnpacker();
                        object.unpack((InputStream)new GZIPInputStream(inputStream, BUF_SIZE), jarOutputStream);
                        jarOutputStream.close();
                    } else {
                        if (string3 != null && string3.equals("gzip")) {
                            inputStream = new GZIPInputStream(inputStream, BUF_SIZE);
                        }
                        while ((n = inputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n);
                            if ((n3 += n) > n2 && n2 != 0) {
                                n3 = n2;
                            }
                            if (httpDownloadListener == null) continue;
                            httpDownloadListener.downloadProgress(n3, n2);
                        }
                    }
                    jarFile = new JarFile(file);
                }
                catch (IOException iOException) {
                    if (file != null) {
                        file.delete();
                    }
                    throw iOException;
                }
                Object var20_21 = null;
                if (inputStream == null) break block24;
            }
            catch (Throwable throwable) {
                Object var20_22 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (outputStream != null) {
            outputStream.close();
        }
        if (jarFile != null) {
            n = jarFile.size();
            int n4 = 0;
            if (downloadDelegate != null) {
                downloadDelegate.validating(uRL, 0, n);
            }
            object = jarFile.entries();
            while (object.hasMoreElements()) {
                JarEntry jarEntry = (JarEntry)object.nextElement();
                int n5 = 0;
                try {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                    while ((n5 = bufferedInputStream.read(byArray, 0, byArray.length)) != -1) {
                    }
                }
                catch (ZipException zipException) {
                    throw new JARSigningException(uRL, string2, 2, zipException);
                }
                catch (SecurityException securityException) {
                    throw new JARSigningException(uRL, string2, 2, securityException);
                }
                if (downloadDelegate == null) continue;
                downloadDelegate.validating(uRL, ++n4, n);
            }
            jarFile.close();
        }
        noCacheJarFileList.put(uRL.toString(), file);
        return file;
    }

    public static JarFile getCachedJarFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedJarFile(uRL, string, false);
    }

    public static JarFile getUpdatedJarFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedJarFile(uRL, string, true);
    }

    private static JarFile getCachedJarFile(URL uRL, String string, boolean bl) throws IOException {
        if (Cache.isCacheEnabled()) {
            CacheEntry cacheEntry = null;
            cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl);
            if (cacheEntry != null) {
                return cacheEntry.getJarFile();
            }
        } else {
            JarFile jarFile = (JarFile)Cache.getLoadedResource(uRL.toString());
            if (jarFile != null) {
                return jarFile;
            }
            File file = DownloadEngine.getJarFileWithoutCache(uRL, null, string, null);
            if (file != null) {
                JarFile jarFile2 = new JarFile(file);
                Cache.addLoadedResource(uRL.toString(), jarFile2);
                return jarFile2;
            }
        }
        return null;
    }

    public static File getCachedShortcutImage(URL uRL, String string) throws IOException {
        return DownloadEngine.getShortcutImage(uRL, string, false);
    }

    public static File getUpdatedShortcutImage(URL uRL, String string) throws IOException {
        return DownloadEngine.getShortcutImage(uRL, string, true);
    }

    private static File getShortcutImage(URL uRL, String string, boolean bl) throws IOException {
        CacheEntry cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl);
        if (cacheEntry != null) {
            cacheEntry.generateShortcutImage();
            return cacheEntry.getDataFile();
        }
        return null;
    }

    public static File getCachedFileNative(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("jar")) {
            String string = uRL.getPath();
            int n = string.indexOf("!/");
            if (n > 0) {
                try {
                    String string2;
                    String string3 = string.substring(n + 2);
                    URL uRL2 = new URL(string.substring(0, n));
                    CacheEntry cacheEntry = Cache.getCacheEntry(uRL2, null, null);
                    if (cacheEntry != null && (string2 = cacheEntry.getNativeLibPath()) != null) {
                        return new File(string2, string3);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Trace.ignored(malformedURLException);
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                }
            }
            return null;
        }
        return DownloadEngine.getCachedFile(uRL);
    }

    public static File getCachedFile(URL uRL) throws IOException {
        return DownloadEngine.getCachedFile(uRL, null);
    }

    public static File getCachedFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getCachedFile(uRL, string, false, false, null);
    }

    public static File getUpdatedFile(URL uRL, String string) throws IOException {
        return DownloadEngine.getUpdatedFile(uRL, string, false, null);
    }

    public static File getUpdatedFile(URL uRL, String string, boolean bl, String string2) throws IOException {
        return DownloadEngine.getCachedFile(uRL, string, true, bl, string2);
    }

    public static File getCachedFile(URL uRL, String string, boolean bl, boolean bl2, String string2) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, bl, bl2, string2, 0);
        if (cacheEntry != null) {
            return cacheEntry.getDataFile();
        }
        return null;
    }

    public static File getCachedResource(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl);
        if (cacheEntry != null) {
            File file = new File(cacheEntry.getResourceFilename());
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static boolean isJarFileCorrupted(URL uRL, String string) {
        block14: {
            ZipFile zipFile;
            block13: {
                zipFile = null;
                CacheEntry cacheEntry = null;
                cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, null, string, null, false);
                zipFile = new JarFile(cacheEntry.getResourceFilename(), false);
                if (zipFile == null) break block13;
                boolean bl = false;
                Object var6_6 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                return bl;
            }
            Object var6_7 = null;
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
                break block14;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            break block14;
            {
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                    Object var6_8 = null;
                    try {
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        break block14;
                    }
                    catch (IOException iOException2) {
                        Trace.ignoredException(iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                throw throwable;
            }
        }
        return true;
    }

    public static boolean isResourceCached(URL uRL, String string, String string2) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false);
        return cacheEntry != null;
    }

    public static void removeCachedResource(URL uRL, String string, String string2) {
        CacheEntry cacheEntry = null;
        try {
            cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, null, false);
        }
        catch (IOException iOException) {
            Trace.ignoredException(iOException);
        }
        if (cacheEntry != null) {
            Cache.removeCacheEntry(cacheEntry);
        }
    }

    public static Map getCachedHeaders(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        CacheEntry cacheEntry = null;
        cacheEntry = DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl);
        if (cacheEntry != null) {
            return cacheEntry.getHeaders();
        }
        return null;
    }

    public static HttpRequest getHttpRequestImpl() {
        return _httpRequestImpl;
    }

    public static HttpDownload getHttpDownloadImpl() {
        return _httpDownloadImpl;
    }

    /*
     * Loose catch block
     */
    public static File applyPatch(File file, File file2, final URL uRL, final String string, final DownloadDelegate downloadDelegate, String string2) throws FailedDownloadException {
        File file3;
        block17: {
            JarDiffPatcher jarDiffPatcher = new JarDiffPatcher();
            file3 = new File(string2);
            FileOutputStream fileOutputStream = null;
            boolean bl = false;
            fileOutputStream = new FileOutputStream(file3);
            Patcher.PatchDelegate patchDelegate = null;
            if (downloadDelegate != null) {
                downloadDelegate.patching(uRL, string, 0);
                patchDelegate = new Patcher.PatchDelegate(){

                    public void patching(int n) {
                        downloadDelegate.patching(uRL, string, n);
                    }
                };
            }
            try {
                jarDiffPatcher.applyPatch(patchDelegate, file.getPath(), file2.getPath(), fileOutputStream);
            }
            catch (IOException iOException) {
                throw new FailedDownloadException(uRL, string, iOException);
            }
            bl = true;
            Object var13_13 = null;
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
            }
            if (!bl) {
                file3.delete();
            }
            file2.delete();
            if (downloadDelegate != null && !bl) {
                downloadDelegate.downloadFailed(uRL, string);
            }
            break block17;
            {
                catch (IOException iOException) {
                    throw new FailedDownloadException(uRL, string, iOException);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                if (!bl) {
                    file3.delete();
                }
                file2.delete();
                if (downloadDelegate != null && !bl) {
                    downloadDelegate.downloadFailed(uRL, string);
                }
                throw throwable;
            }
        }
        return file3;
    }

    public static boolean isJnlpURL(URL uRL) {
        try {
            HttpResponse httpResponse = DownloadEngine.getHttpRequestImpl().doHeadRequest(uRL);
            return httpResponse.getContentType().equals(JNLP_MIME_TYPE);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void addToUpdateCheckDoneList(String string) {
        if (string != null) {
            updateCheckDoneList.add(string);
        }
    }

    public static void clearUpdateCheckDoneList() {
        updateCheckDoneList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUpdateAvailable(URL uRL, String string) throws IOException {
        URL uRL2 = HttpUtils.removeQueryStringFromURL(uRL);
        Object object = syncObject;
        synchronized (object) {
            if (updateCheckDoneList.contains(uRL.toString())) {
                return false;
            }
        }
        object = Cache.getCacheEntry(string == null ? uRL : uRL2, null, string);
        if (object == null) {
            return true;
        }
        if (string != null) {
            return false;
        }
        if (!DownloadEngine.isValidationRequired((CacheEntry)object)) {
            return false;
        }
        if (!DeployOfflineManager.promptUserGoOnline(uRL)) {
            throw new FailedDownloadException(uRL, null, null, true);
        }
        URL uRL3 = DownloadEngine.getRequestURL(uRL, null, string, null, null, null, null, false, null, string == null ? 1 : 2);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        long l = -1L;
        l = ((CacheEntry)object).getLastModified();
        httpResponse = httpRequest.doGetRequestEX(uRL3, l);
        if (httpResponse == null) {
            return true;
        }
        int n = httpResponse.getStatusCode();
        httpResponse.disconnect();
        if (n == 304) {
            Object object2 = syncObject;
            synchronized (object2) {
                updateCheckDoneList.add(uRL.toString());
            }
            long l2 = httpResponse.getExpiration();
            if (l2 != 0L) {
                ((CacheEntry)object).updateExpirationInIndexFile(l2);
            }
            return false;
        }
        return true;
    }

    private static CacheEntry actionDownload(CacheEntry cacheEntry, final URL uRL, URL uRL2, String string, String string2, final DownloadDelegate downloadDelegate, int n, boolean bl) throws IOException {
        boolean bl2 = false;
        String string3 = null;
        if (cacheEntry != null && string2 != null) {
            long l;
            if (cacheEntry.getVersion() != null && new VersionString(string2).contains(new VersionID(cacheEntry.getVersion()))) {
                return cacheEntry;
            }
            if (Environment.isJavaPlugin() && (l = cacheEntry.getExpirationDate()) != 0L && new Date().after(new Date(l))) {
                cacheEntry = null;
            }
        }
        if (cacheEntry != null) {
            string3 = cacheEntry.getVersion();
        }
        CacheEntry cacheEntry2 = null;
        try {
            Object object;
            Object object2;
            HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
            HttpResponse httpResponse = null;
            long l = -1L;
            if (cacheEntry != null) {
                l = cacheEntry.getLastModified();
            }
            try {
                httpResponse = httpRequest.doGetRequestEX(uRL2, l);
            }
            catch (FailedDownloadException failedDownloadException) {
                throw failedDownloadException;
            }
            catch (IOException iOException) {
                Trace.ignoredException(iOException);
                httpResponse = httpRequest.doGetRequest(uRL2, false);
            }
            int n2 = httpResponse.getStatusCode();
            if (n2 == 404) {
                throw new FailedDownloadException(uRL, string2, new IOException("HTTP response 404"));
            }
            if (n2 == 304) {
                httpResponse.disconnect();
                return cacheEntry;
            }
            int n3 = httpResponse.getContentLength();
            long l2 = httpResponse.getLastModified();
            long l3 = httpResponse.getExpiration();
            if (Environment.isImportMode() && Environment.getImportModeExpiration() != null && l3 != 0L) {
                object2 = new Date(l3);
                if (((Date)object2).before(Environment.getImportModeExpiration())) {
                    httpResponse.disconnect();
                    return null;
                }
            } else if (Environment.isImportMode() && Environment.getImportModeTimestamp() != null && l2 != 0L && ((Date)(object2 = new Date(l2))).before(Environment.getImportModeTimestamp())) {
                httpResponse.disconnect();
                return null;
            }
            object2 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
            if (string2 != null && object2 == null && Environment.getImportModeCodebaseOverride() != null && new VersionID(string2).isSimpleVersion()) {
                object2 = string2;
            }
            if (cacheEntry != null) {
                if (object2 != null && new VersionString((String)object2).contains(string3)) {
                    httpResponse.disconnect();
                    return cacheEntry;
                }
                if (n3 == cacheEntry.getContentLength() && l2 == l && string3 == null) {
                    httpResponse.disconnect();
                    return cacheEntry;
                }
                if (string3 == null) {
                    bl2 = true;
                }
            }
            if (downloadDelegate != null) {
                downloadDelegate.setTotalSize(n3);
            }
            if (object2 == null && Environment.isJavaPlugin()) {
                object2 = string2;
            }
            Object object3 = object2;
            String string4 = httpResponse.getContentType();
            boolean bl3 = string4 != null && string4.equalsIgnoreCase(JARDIFF_MIME_TYPE);
            Trace.println(ResourceManager.getString("downloadEngine.serverResponse", String.valueOf(n3), new Date(l2).toString(), (String)object2, string4), TraceLevel.NETWORK);
            if (string4 != null && string4.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                String string5 = bufferedReader.readLine();
                bufferedReader.close();
                throw new FailedDownloadException(uRL2, string2, new IOException("Error returned: " + string5));
            }
            if (object2 == null && string2 != null) {
                throw new FailedDownloadException(uRL, string2, new IOException("missing version response from server"));
            }
            if (object2 != null && string2 != null && !bl) {
                if (!new VersionString(string2).contains((String)object2)) {
                    throw new FailedDownloadException(uRL, string2, new IOException("bad version response from server:" + (String)object2));
                }
                object = new VersionID((String)object2);
                if (!((VersionID)object).isSimpleVersion()) {
                    throw new FailedDownloadException(uRL, string2, new IOException("bad version response from server:" + (String)object2));
                }
            }
            object = downloadDelegate == null ? null : new HttpDownloadListener((String)object3){
                private final /* synthetic */ String val$responseVersion;
                {
                    this.val$responseVersion = string;
                }

                public boolean downloadProgress(int n, int n2) {
                    downloadDelegate.downloading(uRL, this.val$responseVersion, n, n2, false);
                    return true;
                }
            };
            return Cache.downloadResourceToCache(uRL, (String)object2, httpResponse, (HttpDownloadListener)object, downloadDelegate, bl2, uRL2, cacheEntry, bl3, n);
        }
        catch (Exception exception) {
            if (cacheEntry2 != null) {
                Cache.removeCacheEntry(cacheEntry2);
            }
            if (exception instanceof JARSigningException) {
                throw (JARSigningException)exception;
            }
            if (exception instanceof FailedDownloadException) {
                throw (FailedDownloadException)exception;
            }
            throw new FailedDownloadException(uRL2, string2, exception);
        }
    }

    private static void addURLArgument(StringBuffer stringBuffer, String string, String string2) {
        try {
            stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
            stringBuffer.append('&');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Trace.ignoredException(unsupportedEncodingException);
        }
    }

    private static URL getRequestURL(URL uRL, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string3 == null && string2 != null) {
            string3 = Cache.getCacheEntryVersion(uRL, string);
        }
        if (string2 != null && n == 2) {
            DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string2);
            if (string3 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_CURRENT_VERSION_ID, string3);
            }
        }
        if (string2 != null && n == 3) {
            if (bl) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_PLATFORM_VERSION_ID, string2);
            } else {
                DownloadEngine.addURLArgument(stringBuffer, ARG_VERSION_ID, string2);
            }
            DownloadEngine.addURLArgument(stringBuffer, ARG_ARCH, Config.getOSArch());
            DownloadEngine.addURLArgument(stringBuffer, ARG_OS, Config.getOSName());
            DownloadEngine.addURLArgument(stringBuffer, ARG_LOCALE, defaultLocaleString);
            if (string7 != null) {
                DownloadEngine.addURLArgument(stringBuffer, ARG_KNOWN_PLATFORMS, string7);
            }
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, '?');
        }
        try {
            if (Environment.getImportModeCodebaseOverride() != null && Environment.getImportModeCodebase() != null) {
                return new URL(Environment.getImportModeCodebaseOverride() + uRL.getFile().substring(Environment.getImportModeCodebase().getFile().length()) + stringBuffer);
            }
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile() + stringBuffer);
        }
        catch (MalformedURLException malformedURLException) {
            Trace.ignoredException(malformedURLException);
            return null;
        }
    }

    private static CacheEntry getCacheEntry(CacheEntry cacheEntry, URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, String string3, int n) throws IOException {
        int n2 = 1;
        if (string3 != null) {
            n2 = 3;
        } else if (string2 != null) {
            n2 = 2;
        }
        URL uRL2 = DownloadEngine.getRequestURL(uRL, string, string2, null, null, null, null, bl, string3, n2);
        return DownloadEngine.actionDownload(cacheEntry, uRL, uRL2, string, string2, downloadDelegate, n, bl);
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, int n) throws IOException {
        return DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, false, null, n);
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl) throws IOException {
        return DownloadEngine.getResourceCacheEntry(uRL, string, string2, downloadDelegate, bl, false, null, 0);
    }

    private static boolean isValidationRequired(CacheEntry cacheEntry) {
        if (cacheEntry == null) {
            return true;
        }
        boolean bl = true;
        if (!cacheEntry.isExpired()) {
            bl = false;
        }
        if (cacheEntry.isHttpNoCacheEnabled()) {
            bl = true;
        }
        return bl;
    }

    private static CacheEntry getResourceCacheEntry(URL uRL, String string, String string2, DownloadDelegate downloadDelegate, boolean bl, boolean bl2, String string3, int n) throws IOException {
        if (!Cache.isCacheEnabled()) {
            return null;
        }
        CacheEntry cacheEntry = (CacheEntry)Cache.getLoadedResource(uRL.toString());
        if (cacheEntry != null) {
            String string4 = cacheEntry.getVersion();
            if (string2 == null && string4 == null || string2 != null && string4 != null && string4.compareTo(string2) >= 0) {
                return cacheEntry;
            }
        }
        cacheEntry = Cache.getCacheEntry(uRL, string, string2);
        if (bl) {
            if (!DeployOfflineManager.promptUserGoOnline(uRL)) {
                throw new FailedDownloadException(uRL, null, null, true);
            }
            if (!DeployOfflineManager.isGlobalOffline() && DownloadEngine.isValidationRequired(cacheEntry)) {
                cacheEntry = DownloadEngine.getCacheEntry(cacheEntry, uRL, string, string2, downloadDelegate, bl2, string3, n);
            }
        }
        if (cacheEntry != null && bl) {
            Cache.addLoadedResource(uRL.toString(), cacheEntry);
            Cache.touch(new File(cacheEntry.getResourceFilename() + Cache.getIndexFileExtension()));
        }
        return cacheEntry;
    }

    public static String getAvailableVersion(URL uRL, String string, boolean bl, String string2) {
        int n = string2 != null ? 3 : 2;
        URL uRL2 = DownloadEngine.getRequestURL(uRL, null, string, null, null, null, null, bl, string2, n);
        HttpRequest httpRequest = DownloadEngine.getHttpRequestImpl();
        HttpResponse httpResponse = null;
        String string3 = null;
        try {
            httpResponse = httpRequest.doGetRequest(uRL2);
            if (httpResponse != null) {
                string3 = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
                httpResponse.disconnect();
            }
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
        return string3;
    }

    static {
        jarCompression = -1;
        noCacheJarFileList = new Hashtable();
        _httpRequestImpl = new BasicHttpRequest();
        _httpDownloadImpl = new HttpDownloadHelper(_httpRequestImpl);
        updateCheckDoneList = new ArrayList();
        syncObject = new Object();
    }

    public static interface DownloadProgress {
        public void jreDownload(String var1, URL var2);

        public void extensionDownload(String var1, int var2);

        public void progress(URL var1, String var2, long var3, long var5, int var7);

        public void validating(URL var1, String var2, long var3, long var5, int var7);

        public void patching(URL var1, String var2, int var3, int var4);

        public void downloadFailed(URL var1, String var2);
    }

    public static interface DownloadDelegate {
        public void setTotalSize(long var1);

        public void downloading(URL var1, String var2, int var3, int var4, boolean var5);

        public void validating(URL var1, int var2, int var3);

        public void patching(URL var1, String var2, int var3);

        public void downloadFailed(URL var1, String var2);
    }
}

