/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.math.BigInteger;
import java.security.ProviderException;
import java.util.concurrent.atomic.AtomicInteger;

public class Session {
    private static final long MAX_IDLE_TIME = 180000L;
    private SessionManager manager;
    private PKCS11Session session;
    private boolean isObjSess;
    private boolean hasObjs;
    private long lastAccess;
    private final AtomicInteger createdObjects;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");

    Session(SessionManager manager, PKCS11Session sess, boolean isObjSess) {
        this.manager = manager;
        this.session = sess;
        this.isObjSess = isObjSess;
        this.lastAccess = System.currentTimeMillis();
        this.createdObjects = new AtomicInteger();
    }

    boolean hasObjects() {
        return this.createdObjects.intValue() > 0;
    }

    void addObject() {
        int n = this.createdObjects.incrementAndGet();
    }

    void removeObject() {
        int n = this.createdObjects.decrementAndGet();
        if (n == 0) {
            this.manager.demoteObjSession(this);
        } else if (n < 0) {
            throw new ProviderException("Internal error: objects created " + n);
        }
    }

    int[] getMechanismList() {
        return this.session.getSlot().getMechanismList();
    }

    void setObjSession(boolean isObjSession) {
        this.isObjSess = isObjSession;
    }

    boolean isAlive(long currentTime) {
        return currentTime - this.lastAccess < 180000L;
    }

    void setAccessTime(long time) {
        this.lastAccess = time;
    }

    long getAccessTime() {
        return this.lastAccess;
    }

    public void login(boolean isSo, Object PIN) throws PKCS11Exception {
        this.session.login(isSo, PIN);
    }

    public void logout() throws PKCS11Exception {
        this.session.logout();
    }

    public PKCS11Object createObject(int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        return this.session.createObject(attrTypes, attrValues);
    }

    public void destroyObject(PKCS11Object obj) throws PKCS11Exception {
        this.session.destroyObject(obj);
    }

    public boolean getBoolAttributeValue(PKCS11Object obj, int attribute) {
        try {
            return this.session.getBoolAttributeValue(obj, attribute);
        }
        catch (PKCS11Exception ex) {
            return false;
        }
    }

    public Object getAttrValue(PKCS11Object obj, int attr) {
        Object rtn;
        try {
            rtn = this.session.getAttributeValue(obj, attr);
        }
        catch (PKCS11Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"Session", "getAttrValue", "return null, attr=" + attr);
            }
            rtn = null;
        }
        return rtn;
    }

    public Object[] getAttrValues(PKCS11Object obj, int[] attrs) {
        Object[] rtn;
        try {
            rtn = this.session.getAttributeValues(obj, attrs, attrs.length);
        }
        catch (PKCS11Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)"Session", "getAttrValues", "exception = " + ex.getMessage());
            }
            rtn = new Object[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                rtn[i] = this.getAttrValue(obj, attrs[i]);
            }
        }
        return rtn;
    }

    public void seedRandom(byte[] data, int offset, int len) throws PKCS11Exception {
        this.session.seedRandom(data, offset, len);
    }

    public void generateRandom(byte[] outdata, int outoffset, int len) throws PKCS11Exception {
        this.session.generateRandom(outdata, outoffset, len);
    }

    public PKCS11Object[] generateKeyPair(int mech, Object param, int[] pubTypes, Object[] pubValues, int[] privTypes, Object[] privValues) throws PKCS11Exception {
        return this.session.generateKeyPair(mech, param, pubTypes, pubValues, privTypes, privValues);
    }

    public PKCS11Object generateKey(int mech, Object param, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        return this.session.generateKey(mech, param, attrTypes, attrValues);
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    public BigInteger getBigIntegerAttributeValue(PKCS11Object obj, int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass((int)type) != BigInteger.class) {
            throw new PKCS11Exception(18);
        }
        return (BigInteger)this.session.getAttributeValue(obj, type);
    }

    public int sign(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.sign(indata, inoffset, inlen, outdata, outoffset);
    }

    public void signInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.session.signInit(mech, param, key);
    }

    public void signUpdate(byte[] indata, int inoffset, int inlen) throws PKCS11Exception {
        this.session.signUpdate(indata, inoffset, inlen);
    }

    public int signFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.signFinal(outdata, outoffset);
    }

    public PKCS11Object copy(PKCS11Object origObj, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        return this.session.copy(origObj, attrTypes, attrValues);
    }

    public void findObjectsInit(int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        this.session.findObjectsInit(attrTypes, attrValues);
    }

    public void findObjectsFinal() throws PKCS11Exception {
        this.session.findObjectsFinal();
    }

    public PKCS11Object findObject() throws PKCS11Exception {
        return this.session.findObject();
    }

    public void close() throws PKCS11Exception {
        this.session.close();
    }

    public boolean verifyFinal(byte[] sig, int sigoffset, int siglen) throws PKCS11Exception {
        return this.session.verifyFinal(sig, sigoffset, siglen);
    }

    public void verifyUpdate(byte[] indata, int inoffset, int inlen) throws PKCS11Exception {
        this.session.verifyUpdate(indata, inoffset, inlen);
    }

    public boolean verify(byte[] data, int dataoffset, int datalen, byte[] sig, int sigoffset, int siglen) throws PKCS11Exception {
        return this.session.verify(data, dataoffset, datalen, sig, sigoffset, siglen);
    }

    public void verifyInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.session.verifyInit(mech, param, key);
    }

    public void digestInit(int mech, Object param) throws PKCS11Exception {
        this.session.digestInit(mech, param);
    }

    public void digestUpdate(byte[] indata, int inoffset, int inlen) throws PKCS11Exception {
        this.session.digestUpdate(indata, inoffset, inlen);
    }

    public int digestFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.digestFinal(outdata, outoffset);
    }

    public PKCS11Object deriveKey(int mech, Object param, PKCS11Object baseKey, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        return this.session.deriveKey(mech, param, baseKey, attrTypes, attrValues);
    }

    public void decryptInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.session.decryptInit(mech, param, key);
    }

    public int decryptUpdate(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.decryptUpdate(indata, inoffset, inlen, outdata, outoffset);
    }

    public int decryptFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.decryptFinal(outdata, outoffset);
    }

    public int decrypt(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.decrypt(indata, inoffset, inlen, outdata, outoffset);
    }

    public void encryptInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.session.encryptInit(mech, param, key);
    }

    public int encryptUpdate(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.encryptUpdate(indata, inoffset, inlen, outdata, outoffset);
    }

    public int encryptFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.encryptFinal(outdata, outoffset);
    }

    public int encrypt(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.encrypt(indata, inoffset, inlen, outdata, outoffset);
    }

    public PKCS11Object unwrapKey(int mech, Object param, PKCS11Object unwrappingKey, byte[] inkeydata, int inkeyoffset, int inkeylen, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        return this.session.unwrapKey(mech, param, unwrappingKey, inkeydata, inkeyoffset, inkeylen, attrTypes, attrValues);
    }

    public int wrapKey(int mech, Object param, PKCS11Object wrappingKey, PKCS11Object key, byte[] outdata, int outoffset) throws PKCS11Exception {
        return this.session.wrapKey(mech, param, wrappingKey, key, outdata, outoffset);
    }

    public Object getID() {
        return this.session.getID();
    }
}

