/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11RSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdRSA;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Date;

public final class RSAPrivateKey
extends PrivateKeyInfo
implements PKCS11RSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    private Session session = null;
    private SessionManager sessionManager = null;
    static final long serialVersionUID = 4424187430958879494L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.RSA;
    private byte[] id = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isSensitive = null;
    private Boolean isSecondaryAuth = null;
    private Integer authPinFlags = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isSignRecover = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private BigInteger modulus = null;
    private BigInteger publicExponent = null;
    private BigInteger privateExponent = null;
    private BigInteger prime1 = null;
    private BigInteger prime2 = null;
    private BigInteger exponent1 = null;
    private BigInteger exponent2 = null;
    private BigInteger coefficient = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.RSAPrivateKey";

    public RSAPrivateKey(Session session, PKCS11Object object) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "RSAPrivateKey");
        }
        this.sessionManager = session.getSessionManager();
        this.object = object;
        this.algid = new AlgIdRSA();
        if (this.getModulus() != null && this.getPrivateExponent() != null && this.getPublicExponent() != null && this.getPrime1() != null && this.getPrime2() != null && this.getExponent1() != null && this.getExponent2() != null && this.getCoefficient() != null) {
            try {
                DerValue[] value = new DerValue[9];
                value[0] = new DerValue(2, version.toByteArray());
                value[1] = new DerValue(2, this.modulus.toByteArray());
                value[2] = new DerValue(2, this.publicExponent.toByteArray());
                value[3] = new DerValue(2, this.privateExponent.toByteArray());
                value[4] = new DerValue(2, this.prime1.toByteArray());
                value[5] = new DerValue(2, this.prime2.toByteArray());
                value[6] = new DerValue(2, this.exponent1.toByteArray());
                value[7] = new DerValue(2, this.exponent2.toByteArray());
                value[8] = new DerValue(2, this.coefficient.toByteArray());
                DerOutputStream out = new DerOutputStream();
                out.putSequence(value);
                this.key = out.toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode: " + e.getMessage());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPrivateKey");
        }
    }

    public RSAPrivateKey(Session session, PKCS11Object object, byte[] id, byte[] subject, String label, Boolean isToken, Boolean isSensitive, Boolean isSign, Boolean isDecrypt, Boolean isUnwrap, Boolean isExtractable, BigInteger modulus, BigInteger publicExponent) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{object, id, subject, label, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent};
            debug.entry(16384L, (Object)className, "RSAPrivateKey", parms);
        }
        this.sessionManager = session.getSessionManager();
        this.object = object;
        if (id != null) {
            this.id = new byte[id.length];
            System.arraycopy(id, 0, this.id, 0, id.length);
        } else {
            this.id = (byte[])this.getValue(session, this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getValue(session, this.object, 257);
        }
        this.label = label != null ? new String(label) : (String)this.getValue(session, this.object, 3);
        this.isToken = (Boolean)this.getValue(session, this.object, 1);
        this.isSensitive = (Boolean)this.getValue(session, this.object, 259);
        this.isSign = (Boolean)this.getValue(session, this.object, 264);
        this.isDecrypt = (Boolean)this.getValue(session, this.object, 261);
        this.isUnwrap = (Boolean)this.getValue(session, this.object, 263);
        this.isExtractable = (Boolean)this.getValue(session, this.object, 354);
        if (modulus != null) {
            this.modulus = new BigInteger(modulus.toByteArray());
        }
        if (publicExponent != null) {
            this.publicExponent = new BigInteger(publicExponent.toByteArray());
        }
        this.isPrivate = (Boolean)this.getValue(session, this.object, 2);
        this.isModifiable = (Boolean)this.getValue(session, this.object, 368);
        this.startDate = (Date)this.getValue(session, this.object, 272);
        this.endDate = (Date)this.getValue(session, this.object, 273);
        this.isDerive = (Boolean)this.getValue(session, this.object, 268);
        this.isLocal = (Boolean)this.getValue(session, this.object, 355);
        this.isSecondaryAuth = (Boolean)this.getValue(session, this.object, 512);
        this.authPinFlags = (Integer)this.getValue(session, this.object, 513);
        this.isSignRecover = (Boolean)this.getValue(session, this.object, 265);
        this.isAlwaysSensitive = (Boolean)this.getValue(session, this.object, 357);
        this.isNeverExtractable = (Boolean)this.getValue(session, this.object, 356);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "RSAPrivateKey");
        }
    }

    public RSAPrivateKey(Session session, PKCS11Object object, byte[] id, byte[] subject, String label, Boolean isToken, Boolean isSensitive, Boolean isSign, Boolean isDecrypt, Boolean isUnwrap, Boolean isExtractable, BigInteger modulus, BigInteger publicExponent, BigInteger privateExponent, BigInteger prime1, BigInteger prime2, BigInteger exponent1, BigInteger exponent2, BigInteger coefficient) throws InvalidKeyException {
        this(session, object, id, subject, label, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent);
        if (debug != null) {
            Object[] parms = new Object[]{object, id, subject, label, isToken, isSensitive, isSign, isDecrypt, isUnwrap, isExtractable, modulus, publicExponent, privateExponent, prime1, prime2, exponent1, exponent2, coefficient};
            debug.entry(16384L, (Object)className, "RSAPrivateKey", parms);
        }
        if (privateExponent != null) {
            this.privateExponent = new BigInteger(privateExponent.toByteArray());
        }
        if (prime1 != null) {
            this.prime1 = new BigInteger(prime1.toByteArray());
        }
        if (prime2 != null) {
            this.prime2 = new BigInteger(prime2.toByteArray());
        }
        if (exponent1 != null) {
            this.exponent1 = new BigInteger(exponent1.toByteArray());
        }
        if (exponent2 != null) {
            this.exponent2 = new BigInteger(exponent2.toByteArray());
        }
        if (coefficient != null) {
            this.coefficient = new BigInteger(coefficient.toByteArray());
        }
        this.algid = new AlgIdRSA();
        if (this.modulus != null && this.privateExponent != null && this.publicExponent != null && this.prime1 != null && this.prime2 != null && this.exponent1 != null && this.exponent2 != null && this.coefficient != null) {
            try {
                DerValue[] value = new DerValue[9];
                value[0] = new DerValue(2, version.toByteArray());
                value[1] = new DerValue(2, this.modulus.toByteArray());
                value[2] = new DerValue(2, this.publicExponent.toByteArray());
                value[3] = new DerValue(2, this.privateExponent.toByteArray());
                value[4] = new DerValue(2, this.prime1.toByteArray());
                value[5] = new DerValue(2, this.prime2.toByteArray());
                value[6] = new DerValue(2, this.exponent1.toByteArray());
                value[7] = new DerValue(2, this.exponent2.toByteArray());
                value[8] = new DerValue(2, this.coefficient.toByteArray());
                DerOutputStream out = new DerOutputStream();
                out.putSequence(value);
                this.key = out.toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode: " + e.getMessage());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "RSAPrivateKey");
            }
        }
    }

    @Override
    public PKCS11Object getObject() {
        return this.object;
    }

    @Override
    public Boolean getToken() {
        if (this.isToken == null && this.object != null) {
            this.isToken = (Boolean)this.getValue(this.object, 1);
        }
        return this.isToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rm() {
        Session sess = null;
        if (this.session != null) {
            this.session.removeObject();
        }
        if (this.object != null) {
            try {
                sess = this.sessionManager.getOpSession();
                sess.destroyObject(this.getObject());
                this.object = null;
                this.session = null;
            }
            catch (Exception exception) {
            }
            finally {
                this.sessionManager.releaseSession(sess);
            }
        }
    }

    protected void finalize() {
    }

    @Override
    public Boolean getPrivate() {
        if (this.isPrivate == null && this.object != null) {
            this.isPrivate = (Boolean)this.getValue(this.object, 2);
        }
        return this.isPrivate;
    }

    @Override
    public String getLabel() {
        if (this.label == null && this.object != null) {
            this.label = (String)this.getValue(this.object, 3);
        }
        return this.label;
    }

    @Override
    public Boolean getModifiable() {
        if (this.isModifiable == null && this.object != null) {
            this.isModifiable = (Boolean)this.getValue(this.object, 368);
        }
        return this.isModifiable;
    }

    @Override
    public Integer getKeyType() {
        return this.keyType;
    }

    @Override
    public byte[] getID() {
        if (this.id == null && this.object != null) {
            this.id = (byte[])this.getValue(this.object, 258);
        }
        if (this.id != null) {
            return (byte[])this.id.clone();
        }
        return null;
    }

    @Override
    public Date getStartDate() {
        if (this.startDate == null && this.object != null) {
            this.startDate = (Date)this.getValue(this.object, 272);
        }
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate == null && this.object != null) {
            this.endDate = (Date)this.getValue(this.object, 273);
        }
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    @Override
    public Boolean getDerive() {
        if (this.isDerive == null && this.object != null) {
            this.isDerive = (Boolean)this.getValue(this.object, 268);
        }
        return this.isDerive;
    }

    @Override
    public Boolean getLocal() {
        if (this.isLocal == null && this.object != null) {
            this.isLocal = (Boolean)this.getValue(this.object, 355);
        }
        return this.isLocal;
    }

    @Override
    public byte[] getSubject() {
        if (this.subject == null && this.object != null) {
            this.subject = (byte[])this.getValue(this.object, 257);
        }
        if (this.subject != null) {
            return (byte[])this.subject.clone();
        }
        return null;
    }

    @Override
    public Boolean getSensitive() {
        if (this.isSensitive == null && this.object != null) {
            this.isSensitive = (Boolean)this.getValue(this.object, 259);
        }
        return this.isSensitive;
    }

    @Override
    public Boolean getSecondaryAuth() {
        if (this.isSecondaryAuth == null && this.object != null) {
            this.isSecondaryAuth = (Boolean)this.getValue(this.object, 512);
        }
        return this.isSecondaryAuth;
    }

    @Override
    public Integer getAuthPinFlags() {
        if (this.authPinFlags == null && this.object != null) {
            this.authPinFlags = (Integer)this.getValue(this.object, 513);
        }
        return this.authPinFlags;
    }

    @Override
    public Boolean getDecrypt() {
        if (this.isDecrypt == null && this.object != null) {
            this.isDecrypt = (Boolean)this.getValue(this.object, 261);
        }
        return this.isDecrypt;
    }

    @Override
    public Boolean getSign() {
        if (this.isSign == null && this.object != null) {
            this.isSign = (Boolean)this.getValue(this.object, 264);
        }
        return this.isSign;
    }

    @Override
    public Boolean getSignRecover() {
        if (this.isSignRecover == null && this.object != null) {
            this.isSignRecover = (Boolean)this.getValue(this.object, 265);
        }
        return this.isSignRecover;
    }

    @Override
    public Boolean getUnwrap() {
        if (this.isUnwrap == null && this.object != null) {
            this.isUnwrap = (Boolean)this.getValue(this.object, 263);
        }
        return this.isUnwrap;
    }

    @Override
    public Boolean getExtractable() {
        if (this.isExtractable == null && this.object != null) {
            this.isExtractable = (Boolean)this.getValue(this.object, 354);
        }
        return this.isExtractable;
    }

    @Override
    public Boolean getAlwaysSensitive() {
        if (this.isAlwaysSensitive == null && this.object != null) {
            this.isAlwaysSensitive = (Boolean)this.getValue(this.object, 357);
        }
        return this.isAlwaysSensitive;
    }

    @Override
    public Boolean getNeverExtractable() {
        if (this.isNeverExtractable == null && this.object != null) {
            this.isNeverExtractable = (Boolean)this.getValue(this.object, 356);
        }
        return this.isNeverExtractable;
    }

    @Override
    public BigInteger getModulus() {
        if (this.modulus == null && this.object != null) {
            this.modulus = (BigInteger)this.getValue(this.object, 288);
        }
        return this.modulus;
    }

    @Override
    public BigInteger getPublicExponent() {
        if (this.publicExponent == null && this.object != null) {
            this.publicExponent = (BigInteger)this.getValue(this.object, 290);
        }
        return this.publicExponent;
    }

    @Override
    public BigInteger getPrivateExponent() {
        if (this.privateExponent == null && this.object != null) {
            this.privateExponent = (BigInteger)this.getValue(this.object, 291);
        }
        return this.privateExponent;
    }

    @Override
    public BigInteger getPrime1() {
        if (this.prime1 == null && this.object != null) {
            this.prime1 = (BigInteger)this.getValue(this.object, 292);
        }
        return this.prime1;
    }

    @Override
    public BigInteger getPrime2() {
        if (this.prime2 == null && this.object != null) {
            this.prime2 = (BigInteger)this.getValue(this.object, 293);
        }
        return this.prime2;
    }

    @Override
    public BigInteger getExponent1() {
        if (this.exponent1 == null && this.object != null) {
            this.exponent1 = (BigInteger)this.getValue(this.object, 294);
        }
        return this.exponent1;
    }

    @Override
    public BigInteger getExponent2() {
        if (this.exponent2 == null && this.object != null) {
            this.exponent2 = (BigInteger)this.getValue(this.object, 295);
        }
        return this.exponent2;
    }

    @Override
    public BigInteger getCoefficient() {
        if (this.coefficient == null && this.object != null) {
            this.coefficient = (BigInteger)this.getValue(this.object, 296);
        }
        return this.coefficient;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.getPrime1();
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.getPrime2();
    }

    @Override
    public BigInteger getPrimeExponentP() {
        if (this.exponent1 == null && this.object != null) {
            this.exponent1 = (BigInteger)this.getValue(this.object, 294);
        }
        return this.exponent1;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        if (this.exponent2 == null && this.object != null) {
            this.exponent2 = (BigInteger)this.getValue(this.object, 295);
        }
        return this.exponent2;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.getCoefficient();
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " RSA Private Key: ";
        output = output + "\n Token: ";
        if (this.getToken() != null) {
            output = output + this.isToken;
        }
        output = output + "\n Private: ";
        if (this.getPrivate() != null) {
            output = output + this.isPrivate;
        }
        output = output + "\n Label: ";
        if (this.getLabel() != null) {
            output = output + this.label;
        }
        output = output + "\n Modifiable: ";
        if (this.getModifiable() != null) {
            output = output + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        output = output + "\n ID: ";
        if (this.getID() != null) {
            try {
                output = output + new String(this.id, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                output = output + new String(this.id);
            }
        }
        output = output + "\n Start Date: ";
        if (this.getStartDate() != null) {
            output = output + this.startDate.toString();
        }
        output = output + "\n End Date: ";
        if (this.getEndDate() != null) {
            output = output + this.endDate.toString();
        }
        output = output + "\n Derive: ";
        if (this.getDerive() != null) {
            output = output + this.isDerive;
        }
        output = output + "\n Local: ";
        if (this.getLocal() != null) {
            output = output + this.isLocal;
        }
        output = output + "\n Subject: ";
        if (this.getSubject() != null) {
            try {
                X500Name x500name = new X500Name(this.subject);
                output = output + x500name.toString();
            }
            catch (IOException ex) {
                try {
                    UnstructuredName uname = new UnstructuredName(this.subject);
                    output = output + uname.toString();
                }
                catch (IOException ex2) {
                    try {
                        output = output + new String(this.subject, "8859_1");
                    }
                    catch (UnsupportedEncodingException e) {
                        output = output + new String(this.subject);
                    }
                }
            }
        }
        output = output + "\n Sensitive: ";
        if (this.getSensitive() != null) {
            output = output + this.isSensitive;
        }
        output = output + "\n SecondaryAuth: ";
        if (this.getSecondaryAuth() != null) {
            output = output + this.isSecondaryAuth;
        }
        output = output + "\n AuthPinFlags: ";
        if (this.getAuthPinFlags() != null) {
            output = output + Integer.toBinaryString(this.authPinFlags);
        }
        output = output + "\n Decrypt: ";
        if (this.getDecrypt() != null) {
            output = output + this.isDecrypt;
        }
        output = output + "\n Sign: ";
        if (this.getSign() != null) {
            output = output + this.isSign;
        }
        output = output + "\n SignRecover: ";
        if (this.getSignRecover() != null) {
            output = output + this.isSignRecover;
        }
        output = output + "\n isExtractable: ";
        if (this.getExtractable() != null) {
            output = output + this.isExtractable;
        }
        output = output + "\n Always Sensitive: ";
        if (this.getAlwaysSensitive() != null) {
            output = output + this.isAlwaysSensitive;
        }
        output = output + "\n Never Extractable: ";
        if (this.getNeverExtractable() != null) {
            output = output + this.isNeverExtractable;
        }
        output = output + "\n Unwrap: ";
        if (this.getUnwrap() != null) {
            output = output + this.isUnwrap;
        }
        output = output + "\n Modulus: ";
        if (this.getModulus() != null) {
            output = output + this.modulus.toString();
        }
        output = output + "\n Public Exponent: ";
        if (this.getPublicExponent() != null) {
            output = output + this.publicExponent.toString();
        }
        output = output + "\n Private Exponent: ";
        if (this.getPrivateExponent() != null) {
            output = output + this.privateExponent.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n Prime1: ";
        if (this.getPrime1() != null) {
            output = output + this.prime1.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n Prime2: ";
        if (this.getPrime2() != null) {
            output = output + this.prime2.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n Exponent1: ";
        if (this.getExponent1() != null) {
            output = output + this.exponent1.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n Exponent2: ";
        if (this.getExponent2() != null) {
            output = output + this.exponent2.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n Coefficient: ";
        if (this.getCoefficient() != null) {
            output = output + this.coefficient.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        return output;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object result = null;
        Session session = this.sessionManager.getOpSession();
        result = session.getAttrValue(pkcs11obj, attr);
        this.sessionManager.releaseSession(session);
        return result;
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    @Override
    public String getFormat() {
        return "PKCS#11";
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    public void setSession(Session sess) {
        this.session = sess;
    }
}

