/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import java.util.Set;

public final class ECPKCS11KeyPairGenerator
extends KeyPairGeneratorSpi {
    private int modlen = 256;
    private SessionManager sessionManager = null;
    private Config config = null;
    private AlgorithmParameterSpec params;
    private Boolean isToken = new Boolean(false);
    private Boolean isSensitive = new Boolean(false);
    private Boolean sign = new Boolean(true);
    private Boolean encrypt = new Boolean(true);
    private Boolean wrapping = new Boolean(true);
    private Boolean extractable = null;
    private boolean paramsUsed = false;
    private SecureRandom random;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.ECPKCS11KeyPairGenerator";

    public ECPKCS11KeyPairGenerator(Provider provider) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "ECPKCS11KeyPairGenerator");
        }
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "ECPKCS11KeyPairGenerator");
        }
    }

    public ECPKCS11KeyPairGenerator() {
        this(Security.getProvider("IBMPKCS11Impl"));
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        ECParameterSpec ecParams;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)params, (Object)random);
        }
        if (params == null) {
            throw new InvalidAlgorithmParameterException("ECParameterSpec must be specified");
        }
        if (params instanceof ECParameterSpec) {
            ecParams = PKCS11ECKeyFactory.getECParameterSpec((ECParameterSpec)params);
            if (ecParams == null) {
                throw new InvalidAlgorithmParameterException("Unsupported curve: " + params);
            }
        } else if (params instanceof ECGenParameterSpec) {
            String name = ((ECGenParameterSpec)params).getName();
            ecParams = PKCS11ECKeyFactory.getECParameterSpec(name);
            if (ecParams == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + name);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        this.params = ecParams;
        this.random = random;
        this.modlen = ecParams.getCurve().getField().getFieldSize();
        if (this.modlen < 112) {
            throw new InvalidAlgorithmParameterException("Key size must be at least 112 bit");
        }
        if (this.modlen > 2048) {
            throw new InvalidAlgorithmParameterException("Key size must be at most 2048 bit");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "initialize", (Object)(" " + keysize), (Object)random);
        }
        if (keysize < 112) {
            throw new RuntimeException("Key size must be at least 112 bit");
        }
        if (keysize > 2048) {
            throw new RuntimeException("Key size must be at most 2048 bit");
        }
        this.modlen = keysize;
        this.random = random;
        this.params = PKCS11ECKeyFactory.getECParameterSpec(keysize);
        if (this.params == null) {
            throw new InvalidParameterException("No EC parameters available for key size " + keysize + " bits");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "initialize");
        }
    }

    public void initialize(int strength) {
        this.initialize(strength, null);
    }

    @Override
    public KeyPair generateKeyPair() {
        PKCS11Object[] pKCS11ObjectArray;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "generateKeyPair");
        }
        HashMap<Object, Object> hattrs = null;
        hattrs = this.config != null ? this.config.getAttributes("GENERATE", PKCS11Object.PUBLIC_KEY, PKCS11Object.ECDSA) : new HashMap();
        byte[] encodedParams = PKCS11ECKeyFactory.encodeParameters((ECParameterSpec)this.params);
        int size = hattrs.size() + 1;
        int[] pubTypes = new int[size];
        Object[] pubValues = new Object[size];
        Set<Object> keyset = hattrs.keySet();
        int count = 0;
        for (Integer n : keyset) {
            pubTypes[count] = n;
            pubValues[count++] = hattrs.get(n);
            if (debug == null) continue;
            debug.text(16384L, (Object)"ECPKCS11KeyPairGenerator", "generateKeyPair", "pub attribute type = " + pubTypes[count - 1] + " pub attribute value = " + pubValues[count - 1]);
        }
        pubTypes[count] = 384;
        pubValues[count] = encodedParams;
        hattrs = this.config != null ? this.config.getAttributes("GENERATE", PKCS11Object.PRIVATE_KEY, PKCS11Object.ECDSA) : new HashMap();
        size = hattrs.size();
        int[] privTypes = new int[size];
        Object[] objectArray = new Object[size];
        keyset = hattrs.keySet();
        count = 0;
        for (Integer n : keyset) {
            privTypes[count] = n;
            objectArray[count++] = hattrs.get(n);
            if (debug == null) continue;
            debug.text(16384L, (Object)"ECPKCS11KeyPairGenerator", "generateKeyPair", "priv attribute type = " + privTypes[count - 1] + " priv attribute value = " + objectArray[count - 1]);
        }
        String error = "";
        Object var11_13 = null;
        KeyPair pair = null;
        Session session = null;
        int objcount = 0;
        try {
            session = this.sessionManager.getObjSession();
            pKCS11ObjectArray = session.generateKeyPair(4160, null, pubTypes, pubValues, privTypes, objectArray);
            for (int i = 0; i < pKCS11ObjectArray.length; ++i) {
                if (!session.getBoolAttributeValue(pKCS11ObjectArray[i], 1)) continue;
                session.addObject();
                ++objcount;
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_1", (Throwable)e);
            }
            this.sessionManager.releaseSession(session);
            throw new RuntimeException(e.getMessage());
        }
        PKCS11Object[] returnobjs = this.orderObjects(session, pKCS11ObjectArray);
        PKCS11Object pubObj = returnobjs[0];
        PKCS11Object privObj = returnobjs[1];
        try {
            PKCS11ECPublicKey pubKey = new PKCS11ECPublicKey(session, pubObj, null, null, null);
            if (!session.getBoolAttributeValue(pubObj, 1)) {
                pubKey.setSession(session);
                session.addObject();
            }
            PKCS11ECPrivateKey privKey = null;
            if (this.isSensitive.booleanValue()) {
                privKey = new PKCS11ECPrivateKey(session, privObj, null, null, null, (byte[])this.getValue(session, privObj, 384));
            } else {
                try {
                    privKey = new PKCS11ECPrivateKey(session, privObj, null, null, null, (byte[])this.getValue(session, privObj, 384), (BigInteger)this.getValue(session, privObj, 17));
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)className, "generateKeyPair_2", (Throwable)ex);
                    }
                    privKey = new PKCS11ECPrivateKey(session, privObj, null, null, null, (byte[])this.getValue(session, privObj, 384));
                }
            }
            if (!session.getBoolAttributeValue(privObj, 1)) {
                privKey.setSession(session);
                session.addObject();
            }
            pair = new KeyPair(pubKey, privKey);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "generateKeyPair_3", (Throwable)e);
            }
            for (int i = 0; i < objcount; ++i) {
                session.removeObject();
            }
            pair = null;
        }
        this.sessionManager.releaseSession(session);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateKeyPair");
        }
        return pair;
    }

    private PKCS11Object[] orderObjects(Session session, PKCS11Object[] objs) {
        if (debug != null) {
            String objString = objs.toString();
            debug.entry(16384L, (Object)className, "orderObjects", (Object)objString);
        }
        Integer objsType0 = (Integer)this.getValue(session, objs[0], 0);
        Integer objsType1 = (Integer)this.getValue(session, objs[1], 0);
        PKCS11Object privObj = null;
        PKCS11Object pubObj = null;
        if (objsType0.equals(PKCS11Object.PUBLIC_KEY) && objsType1.equals(PKCS11Object.PRIVATE_KEY)) {
            pubObj = objs[0];
            privObj = objs[1];
        } else if (objsType0.equals(PKCS11Object.PRIVATE_KEY) && objsType1.equals(PKCS11Object.PUBLIC_KEY)) {
            pubObj = objs[1];
            privObj = objs[0];
        } else {
            if (debug != null) {
                debug.text(16384L, (Object)className, "orderObjects", "Token returns invalid objects");
            }
            throw new RuntimeException("Token returns invalid objects");
        }
        objs[0] = pubObj;
        objs[1] = privObj;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "orderObjects", (Object)objs);
        }
        return objs;
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }
}

