/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECPublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.CK_ECDH1_DERIVE_PARAMS;
import com.ibm.pkcs11.PKCS11Object;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class ECDHPKCS11KeyAgreement
extends KeyAgreementSpi {
    private SessionManager sessionManager = null;
    private Provider provider = null;
    private Config config = null;
    private PKCS11ECPrivateKey privateKey;
    private byte[] publicValue;
    private int secretLen;
    public static final int CKD_NULL = 1;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");

    public ECDHPKCS11KeyAgreement(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.provider = provider;
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
    }

    public ECDHPKCS11KeyAgreement(Provider provider) {
        this(provider, null);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof PrivateKey)) {
            throw new InvalidKeyException("Key must be instance of PrivateKey");
        }
        this.privateKey = (PKCS11ECPrivateKey)new PKCS11ECKeyFactory(this.provider).implTranslatePrivateKey((PrivateKey)key);
        this.publicValue = null;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, random);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.publicValue != null) {
            throw new IllegalStateException("Phase already executed");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Only two party agreement supported, lastPhase must be true");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("Key must be a PublicKey with algorithm EC");
        }
        if (key instanceof PKCS11ECPublicKey) {
            this.publicValue = ((PKCS11ECPublicKey)key).getEncodedW();
        } else {
            ECPublicKey ecKey = (ECPublicKey)key;
            this.publicValue = PKCS11ECKeyFactory.getEncodedPublicValue(ecKey);
        }
        int keyLenBits = ((ECPublicKey)key).getParams().getCurve().getField().getFieldSize();
        this.secretLen = keyLenBits - 7 >> 3;
        if (debug != null) {
            debug.text(16384L, (Object)"ECDHPKCS11KeyAgreement", "engineDoPhase", "secret len = " + this.secretLen);
        }
        return null;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            SecretKey skey = this.generateSecret(session, "Generic");
            byte[] secret = (byte[])session.getAttrValue(((GeneralKey)skey).getObject(), 17);
            session.destroyObject(((GeneralKey)skey).getObject());
            this.sessionManager.releaseSession(session);
            return secret;
        }
        catch (Exception ex) {
            this.sessionManager.releaseSession(session);
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] secret;
        SecretKey skey;
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            skey = this.generateSecret(session, "Generic");
            secret = (byte[])session.getAttrValue(((GeneralKey)skey).getObject(), 17);
        }
        catch (Exception ex) {
            this.sessionManager.releaseSession(session);
            throw new IllegalStateException(ex);
        }
        session.destroyObject(((GeneralKey)skey).getObject());
        this.sessionManager.releaseSession(session);
        if (offset + secret.length > sharedSecret.length) {
            throw new ShortBufferException("Need " + secret.length + " bytes, only " + (sharedSecret.length - offset) + " available");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        Session session = null;
        try {
            session = this.sessionManager.getObjSession();
            SecretKey skey = this.generateSecret(session, algorithm);
            ((GeneralKey)skey).setSession(session);
            this.sessionManager.releaseSession(session);
            return skey;
        }
        catch (NoSuchAlgorithmException ex) {
            this.sessionManager.releaseSession(session);
            throw ex;
        }
        catch (Exception ex) {
            this.sessionManager.releaseSession(session);
            throw new IllegalStateException(ex);
        }
    }

    private SecretKey generateSecret(Session session, String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        if (algorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm must not be null");
        }
        if (this.privateKey == null || this.publicValue == null) {
            throw new IllegalStateException("Not initialized correctly");
        }
        Integer keytype = PKCS11Object.GENERIC_SECRET;
        int keyLen = 8;
        if (this.secretLen > 0) {
            keyLen = this.secretLen;
        }
        if (algorithm.equalsIgnoreCase("Generic")) {
            keytype = PKCS11Object.GENERIC_SECRET;
        } else if (algorithm.equalsIgnoreCase("DES")) {
            keyLen = 8;
            keytype = PKCS11Object.DES;
        } else if (algorithm.equalsIgnoreCase("DESede") || algorithm.equalsIgnoreCase("TripleDES") || algorithm.equalsIgnoreCase("3DES")) {
            keyLen = 24;
            keytype = PKCS11Object.DES3;
        } else if (algorithm.equalsIgnoreCase("Blowfish")) {
            keyLen = 56;
            keytype = PKCS11Object.BLOWFISH;
        } else if (algorithm.equalsIgnoreCase("AES")) {
            keyLen = 16;
            keytype = PKCS11Object.AES;
        } else if (algorithm.equalsIgnoreCase("RC4")) {
            keytype = PKCS11Object.RC4;
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm " + algorithm);
        }
        HashMap<Integer, Object> attributes = new HashMap<Integer, Object>();
        attributes.put(0, PKCS11Object.SECRET_KEY);
        attributes.put(256, keytype);
        attributes.put(353, keyLen);
        if (this.config != null) {
            attributes.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, keytype));
        }
        int[] secretKeyTypes = new int[attributes.size()];
        Object[] secretKeyValues = new Object[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (debug != null) {
                debug.text(16384L, (Object)"ECDHPKCS11KeyAgreement", "generateSecret", "secret key type = " + (Integer)entry.getKey() + ", value = " + entry.getValue());
            }
            if ((Integer)entry.getKey() == 353) {
                if (algorithm.equalsIgnoreCase("Generic") || algorithm.equalsIgnoreCase("RC4")) {
                    Integer val = (Integer)entry.getValue();
                    if (val > this.secretLen) {
                        throw new IllegalStateException("Key size is out of range.");
                    }
                    secretKeyTypes[i] = (Integer)entry.getKey();
                    secretKeyValues[i++] = entry.getValue();
                    continue;
                }
                secretKeyTypes[i] = 353;
                secretKeyValues[i++] = keyLen;
                continue;
            }
            secretKeyTypes[i] = (Integer)entry.getKey();
            secretKeyValues[i++] = entry.getValue();
        }
        CK_ECDH1_DERIVE_PARAMS ckParams = new CK_ECDH1_DERIVE_PARAMS(1, null, this.publicValue);
        PKCS11Object generatedSecret = session.deriveKey(4176, ckParams, this.privateKey.getObject(), secretKeyTypes, secretKeyValues);
        GeneralKey secretKey = new GeneralKey(session, generatedSecret, algorithm);
        return secretKey;
    }
}

