/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.PKCS11DSAPrivateKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcs9.UnstructuredName;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X500Name;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Date;

public final class DSAPrivateKey
extends PrivateKeyInfo
implements PKCS11DSAPrivateKey,
Serializable {
    private PKCS11Object object = null;
    private Session session = null;
    private SessionManager sessionManager;
    static final long serialVersionUID = 5036993835514453788L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.DSA;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isSensitive = null;
    private Boolean isSecondaryAuth = null;
    private Integer authPinFlags = null;
    private Boolean isDecrypt = null;
    private Boolean isSign = null;
    private Boolean isSignRecover = null;
    private Boolean isUnwrap = null;
    private Boolean isExtractable = null;
    private Boolean isAlwaysSensitive = null;
    private Boolean isNeverExtractable = null;
    private BigInteger prime = null;
    private BigInteger subprime = null;
    private BigInteger base = null;
    private BigInteger value = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.DSAPrivateKey";

    DSAPrivateKey(Session session, PKCS11Object object, String label, byte[] ID, byte[] subject, Boolean isToken, Boolean isSensitive, Boolean isExtractable) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPrivateKey(...) 2");
        }
        this.sessionManager = session.getSessionManager();
        this.object = object;
        this.label = label != null ? label : (String)this.getAttrValue(session, this.object, 3);
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getAttrValue(session, this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getAttrValue(session, this.object, 257);
        }
        this.isToken = (Boolean)this.getAttrValue(session, this.object, 1);
        this.isSensitive = (Boolean)this.getAttrValue(session, this.object, 259);
        this.isExtractable = (Boolean)this.getAttrValue(session, this.object, 354);
        this.isPrivate = (Boolean)this.getAttrValue(session, this.object, 2);
        this.isModifiable = (Boolean)this.getAttrValue(session, this.object, 368);
        this.startDate = (Date)this.getAttrValue(session, this.object, 272);
        this.endDate = (Date)this.getAttrValue(session, this.object, 273);
        this.isDerive = (Boolean)this.getAttrValue(session, this.object, 268);
        this.isLocal = (Boolean)this.getAttrValue(session, this.object, 355);
        this.isSecondaryAuth = (Boolean)this.getAttrValue(session, this.object, 512);
        this.authPinFlags = (Integer)this.getAttrValue(session, this.object, 513);
        this.isDecrypt = (Boolean)this.getAttrValue(session, this.object, 261);
        this.isSign = (Boolean)this.getAttrValue(session, this.object, 264);
        this.isSignRecover = (Boolean)this.getAttrValue(session, this.object, 265);
        this.isUnwrap = (Boolean)this.getAttrValue(session, this.object, 263);
        this.isAlwaysSensitive = (Boolean)this.getAttrValue(session, this.object, 357);
        this.isNeverExtractable = (Boolean)this.getAttrValue(session, this.object, 356);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPrivateKey(...) 2");
        }
    }

    public DSAPrivateKey(Session session, PKCS11Object object, String label, byte[] ID, byte[] subject, Boolean isToken, Boolean isSensitive, Boolean isExtractable, BigInteger prime, BigInteger subprime, BigInteger base, BigInteger value) throws InvalidKeyException {
        this(session, object, label, ID, subject, isToken, isSensitive, isExtractable);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPrivateKey(...) 1");
        }
        if (prime != null) {
            this.prime = new BigInteger(prime.toByteArray());
        }
        if (subprime != null) {
            this.subprime = new BigInteger(subprime.toByteArray());
        }
        if (base != null) {
            this.base = new BigInteger(base.toByteArray());
        }
        if (value != null) {
            this.value = new BigInteger(value.toByteArray());
        }
        if (prime != null && subprime != null && base != null) {
            this.algid = new AlgIdDSA(prime, subprime, base);
        }
        if (this.value != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode x: " + e.getMessage());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPrivateKey(...) 1");
        }
    }

    public DSAPrivateKey(Session session, PKCS11Object object) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "DSAPrivateKey(...) 3");
        }
        this.sessionManager = session.getSessionManager();
        this.object = object;
        if (this.getPrime() != null && this.getSubprime() != null && this.getBase() != null) {
            this.algid = new AlgIdDSA(this.prime, this.subprime, this.base);
        }
        if (this.getValue() != null) {
            try {
                this.key = new DerValue(2, this.value.toByteArray()).toByteArray();
                this.encode();
            }
            catch (IOException e) {
                throw new InvalidKeyException("could not DER encode x: " + e.getMessage());
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "DSAPrivateKey(...) 3");
        }
    }

    void setSession(Session sess) {
        this.session = sess;
    }

    @Override
    public PKCS11Object getObject() {
        return this.object;
    }

    @Override
    public Boolean getToken() {
        if (this.isToken == null && this.object != null) {
            this.isToken = (Boolean)this.getAttrValue(this.object, 1);
        }
        return this.isToken;
    }

    @Override
    public Boolean getPrivate() {
        if (this.isPrivate == null && this.object != null) {
            this.isPrivate = (Boolean)this.getAttrValue(this.object, 2);
        }
        return this.isPrivate;
    }

    @Override
    public String getLabel() {
        if (this.label == null && this.object != null) {
            this.label = (String)this.getAttrValue(this.object, 3);
        }
        return this.label;
    }

    @Override
    public Boolean getModifiable() {
        if (this.isModifiable == null && this.object != null) {
            this.isModifiable = (Boolean)this.getAttrValue(this.object, 368);
        }
        return this.isModifiable;
    }

    @Override
    public Integer getKeyType() {
        return this.keyType;
    }

    @Override
    public byte[] getID() {
        if (this.ID == null && this.object != null) {
            this.ID = (byte[])this.getAttrValue(this.object, 258);
        }
        if (this.ID != null) {
            return (byte[])this.ID.clone();
        }
        return null;
    }

    @Override
    public Date getStartDate() {
        if (this.startDate == null && this.object != null) {
            this.startDate = (Date)this.getAttrValue(this.object, 272);
        }
        if (this.startDate != null) {
            return (Date)this.startDate.clone();
        }
        return null;
    }

    @Override
    public Date getEndDate() {
        if (this.endDate == null && this.object != null) {
            this.endDate = (Date)this.getAttrValue(this.object, 273);
        }
        if (this.endDate != null) {
            return (Date)this.endDate.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rm() {
        Session sess = null;
        if (this.session != null) {
            this.session.removeObject();
        }
        if (this.object != null) {
            try {
                sess = this.sessionManager.getOpSession();
                sess.destroyObject(this.getObject());
                this.session = null;
                this.object = null;
            }
            catch (Exception exception) {
            }
            finally {
                this.sessionManager.releaseSession(sess);
            }
        }
    }

    protected void finalize() {
    }

    @Override
    public Boolean getDerive() {
        if (this.isDerive == null && this.object != null) {
            this.isDerive = (Boolean)this.getAttrValue(this.object, 268);
        }
        return this.isDerive;
    }

    @Override
    public Boolean getLocal() {
        if (this.isLocal == null && this.object != null) {
            this.isLocal = (Boolean)this.getAttrValue(this.object, 355);
        }
        return this.isLocal;
    }

    @Override
    public byte[] getSubject() {
        if (this.subject == null && this.object != null) {
            this.subject = (byte[])this.getAttrValue(this.object, 257);
        }
        if (this.subject == null) {
            return null;
        }
        return (byte[])this.subject.clone();
    }

    @Override
    public Boolean getSensitive() {
        if (this.isSensitive == null && this.object != null) {
            this.isSensitive = (Boolean)this.getAttrValue(this.object, 259);
        }
        return this.isSensitive;
    }

    @Override
    public Boolean getSecondaryAuth() {
        if (this.isSecondaryAuth == null && this.object != null) {
            this.isSecondaryAuth = (Boolean)this.getAttrValue(this.object, 512);
        }
        return this.isSecondaryAuth;
    }

    @Override
    public Integer getAuthPinFlags() {
        if (this.authPinFlags == null && this.object != null) {
            this.authPinFlags = (Integer)this.getAttrValue(this.object, 513);
        }
        return this.authPinFlags;
    }

    @Override
    public Boolean getDecrypt() {
        if (this.isDecrypt == null && this.object != null) {
            this.isDecrypt = (Boolean)this.getAttrValue(this.object, 261);
        }
        return this.isDecrypt;
    }

    @Override
    public Boolean getSign() {
        if (this.isSign == null && this.object != null) {
            this.isSign = (Boolean)this.getAttrValue(this.object, 264);
        }
        return this.isSign;
    }

    @Override
    public Boolean getSignRecover() {
        if (this.isSignRecover == null && this.object != null) {
            this.isSignRecover = (Boolean)this.getAttrValue(this.object, 265);
        }
        return this.isSignRecover;
    }

    @Override
    public Boolean getUnwrap() {
        if (this.isUnwrap == null && this.object != null) {
            this.isUnwrap = (Boolean)this.getAttrValue(this.object, 263);
        }
        return this.isUnwrap;
    }

    @Override
    public Boolean getExtractable() {
        if (this.isExtractable == null && this.object != null) {
            this.isExtractable = (Boolean)this.getAttrValue(this.object, 354);
        }
        return this.isExtractable;
    }

    @Override
    public Boolean getAlwaysSensitive() {
        if (this.isAlwaysSensitive == null && this.object != null) {
            this.isAlwaysSensitive = (Boolean)this.getAttrValue(this.object, 357);
        }
        return this.isAlwaysSensitive;
    }

    @Override
    public Boolean getNeverExtractable() {
        if (this.isNeverExtractable == null && this.object != null) {
            this.isNeverExtractable = (Boolean)this.getAttrValue(this.object, 356);
        }
        return this.isNeverExtractable;
    }

    @Override
    public BigInteger getPrime() {
        if (this.prime == null && this.object != null) {
            this.prime = (BigInteger)this.getAttrValue(this.object, 304);
        }
        return this.prime;
    }

    @Override
    public BigInteger getSubprime() {
        if (this.subprime == null && this.object != null) {
            this.subprime = (BigInteger)this.getAttrValue(this.object, 305);
        }
        return this.subprime;
    }

    @Override
    public BigInteger getBase() {
        if (this.base == null && this.object != null) {
            this.base = (BigInteger)this.getAttrValue(this.object, 306);
        }
        return this.base;
    }

    @Override
    public BigInteger getValue() {
        byte[] bytes;
        if (this.value == null && this.object != null && (bytes = (byte[])this.getAttrValue(this.object, 17)) != null) {
            this.value = new BigInteger(1, bytes);
        }
        return this.value;
    }

    @Override
    public BigInteger getX() {
        return this.getValue();
    }

    @Override
    public DSAParams getParams() {
        try {
            if (this.algid == null) {
                return null;
            }
            if (this.algid instanceof DSAParams) {
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (algParams == null) {
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            return null;
        }
    }

    public Session getSession() {
        return this.session;
    }

    public String toString() {
        String prov = "IBMPKCS11Impl";
        String output = prov + " DSA Private Key: ";
        output = output + "\n Token: ";
        if (this.getToken() != null) {
            output = output + this.isToken;
        }
        output = output + "\n Private: ";
        if (this.getPrivate() != null) {
            output = output + this.isPrivate;
        }
        output = output + "\n Label: ";
        if (this.getLabel() != null) {
            output = output + this.label;
        }
        output = output + "\n Modifiable: ";
        if (this.getModifiable() != null) {
            output = output + this.isModifiable;
        }
        output = output + "\n KeyType: " + this.keyType.toString();
        output = output + "\n ID: ";
        if (this.getID() != null) {
            try {
                output = output + new String(this.ID, "8859_1");
            }
            catch (UnsupportedEncodingException e) {
                output = output + new String(this.ID);
            }
        }
        output = output + "\n Start Date: ";
        if (this.getStartDate() != null) {
            output = output + this.startDate.toString();
        }
        output = output + "\n End Date: ";
        if (this.getEndDate() != null) {
            output = output + this.endDate.toString();
        }
        output = output + "\n Derive: ";
        if (this.getDerive() != null) {
            output = output + this.isDerive;
        }
        output = output + "\n Local: ";
        if (this.getLocal() != null) {
            output = output + this.isLocal;
        }
        output = output + "\n Subject: ";
        if (this.getSubject() != null) {
            try {
                X500Name x500name = new X500Name(this.subject);
                output = output + x500name.toString();
            }
            catch (IOException ex) {
                try {
                    UnstructuredName uname = new UnstructuredName(this.subject);
                    output = output + uname.toString();
                }
                catch (IOException ex2) {
                    try {
                        output = output + new String(this.subject, "8859_1");
                    }
                    catch (UnsupportedEncodingException e) {
                        output = output + new String(this.subject);
                    }
                }
            }
        }
        output = output + "\n Sensitive: ";
        if (this.getSensitive() != null) {
            output = output + this.isSensitive;
        }
        output = output + "\n SecondaryAuth: ";
        if (this.getSecondaryAuth() != null) {
            output = output + this.isSecondaryAuth;
        }
        output = output + "\n AuthPinFlags: ";
        if (this.getAuthPinFlags() != null) {
            output = output + Integer.toBinaryString(this.authPinFlags);
        }
        output = output + "\n Decrypt: ";
        if (this.getDecrypt() != null) {
            output = output + this.isDecrypt;
        }
        output = output + "\n sign: ";
        if (this.getSign() != null) {
            output = output + this.isSign;
        }
        output = output + "\n SignRecover: ";
        if (this.getSignRecover() != null) {
            output = output + this.isSignRecover;
        }
        output = output + "\n Extractable: ";
        if (this.getExtractable() != null) {
            output = output + this.isExtractable;
        }
        output = output + "\n Always Sensitive: ";
        if (this.getAlwaysSensitive() != null) {
            output = output + this.isAlwaysSensitive;
        }
        output = output + "\n Never Sensitive: ";
        if (this.getNeverExtractable() != null) {
            output = output + this.isNeverExtractable;
        }
        output = output + "\n prime: ";
        if (this.getPrime() != null) {
            output = output + this.prime.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n subprime: ";
        if (this.getSubprime() != null) {
            output = output + this.subprime.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n base: ";
        if (this.getBase() != null) {
            output = output + this.base.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        output = output + "\n value: ";
        if (this.getValue() != null) {
            output = output + this.value.toString();
        } else if (this.getSensitive() != null && this.isSensitive.booleanValue()) {
            output = output + "(ATTRIBUTE_SENSITIVE)";
        }
        return output;
    }

    @Override
    public String getFormat() {
        return "PKCS#11";
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    private Object getAttrValue(Session sess, PKCS11Object pkcs11obj, int attr) {
        return sess.getAttrValue(pkcs11obj, attr);
    }

    private Object getAttrValue(PKCS11Object pkcs11obj, int attr) {
        Object result = null;
        Session sess = this.sessionManager.getOpSession();
        result = sess.getAttrValue(pkcs11obj, attr);
        this.sessionManager.releaseSession(sess);
        return result;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }
}

