/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.DirectoryArchiveLoadStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public abstract class XmlBasedImportStrategyImpl
extends ImportStrategyImpl {
    private static final String className = XmlBasedImportStrategyImpl.class.getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");

    public ModuleFile getModuleFile() {
        return (ModuleFile)this.getArchive();
    }

    protected EObject primLoadDeploymentDescriptor() throws Exception {
        Resource resource = null;
        resource = this.getModuleFile().getDeploymentDescriptorResource();
        EObject root = null;
        root = ArchiveUtil.getRoot(resource);
        return root;
    }

    protected boolean allowNullResource() {
        return false;
    }

    protected void versionCheck(EObject targetObject) {
        String methodName = "versionCheck";
        String archiveURI = this.getArchive().getURI();
        logger.entering(className, methodName, "Archive [ " + archiveURI + " ]");
        XMLResource xmlResource = (XMLResource)targetObject.eResource();
        if (xmlResource == null) {
            if (this.allowNullResource()) {
                logger.logp(Level.FINER, className, methodName, "Null resource loading descriptor for [ " + archiveURI + " ] (expected)");
            } else {
                logger.logp(Level.FINEST, className, methodName, "Null resource loading descriptor for [ " + archiveURI + " ]");
            }
        } else {
            int moduleVersionId = xmlResource.getModuleVersionID();
            int j2eeVersionId = xmlResource.getJ2EEVersionID();
            String publicId = xmlResource.getPublicId();
            String systemId = xmlResource.getSystemId();
            logger.finer("Module Version ID [ " + moduleVersionId + " ]");
            logger.finer("J2EE Version ID [ " + j2eeVersionId + " ]");
            logger.finer("Public ID [ " + publicId + " ]");
            logger.finer("System ID [ " + systemId + " ]");
        }
        logger.exiting(className, methodName);
    }

    public static boolean markedDeleted(Archive anArchive, Archive.ModuleTypeEnum moduleType) {
        boolean isDirectory;
        String methodName = "markedDeleted";
        logger.logp(Level.FINEST, className, methodName, "ENTRY Module type [ {0} ]", (Object)moduleType);
        boolean markedDeleted = false;
        if (moduleType == Archive.ModuleTypeEnum.WAR && (isDirectory = anArchive.getLoadStrategy() instanceof DirectoryArchiveLoadStrategyImpl) && anArchive.containsFile("web_module_deleted")) {
            markedDeleted = true;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", Boolean.toString(markedDeleted));
        return markedDeleted;
    }

    public static boolean validFilename(Archive anArchive, String filename, Archive.ModuleTypeEnum moduleType) {
        String methodName = "validFilename";
        logger.logp(Level.FINEST, className, methodName, "ENTRY Module type [ {0} ]", (Object)moduleType);
        boolean validFilename = false;
        if (moduleType == Archive.ModuleTypeEnum.WAR) {
            if (filename.endsWith(".war")) {
                validFilename = true;
            } else if (filename.endsWith(".sar")) {
                validFilename = true;
            } else if (!filename.contains(".")) {
                validFilename = true;
            } else if (anArchive.getLoadStrategy() instanceof DirectoryArchiveLoadStrategyImpl) {
                validFilename = true;
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN false - archive does not end with .war or .sar or is not a directory ");
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", Boolean.toString(validFilename));
        return validFilename;
    }

    public static boolean containsBlockingDescriptor(Archive anArchive, Archive.ModuleTypeEnum moduleType) {
        String methodName = "containsBlockingDescriptor";
        logger.entering(className, methodName, anArchive.getURI());
        logger.logp(Level.FINEST, className, methodName, "Module type [ {0} ]", (Object)moduleType);
        boolean foundBlockingDescriptor = false;
        String blockingDescriptor = null;
        if (moduleType != Archive.ModuleTypeEnum.EAR && anArchive.containsFile("META-INF/application.xml")) {
            blockingDescriptor = "META-INF/application.xml";
            foundBlockingDescriptor = true;
        } else if (moduleType != Archive.ModuleTypeEnum.CLIENT && anArchive.containsFile("META-INF/application-client.xml")) {
            blockingDescriptor = "META-INF/application-client.xml";
            foundBlockingDescriptor = true;
        } else if (moduleType != Archive.ModuleTypeEnum.WAR && anArchive.containsFile("WEB-INF/web.xml")) {
            blockingDescriptor = "WEB-INF/web.xml";
            foundBlockingDescriptor = true;
        } else if (moduleType != Archive.ModuleTypeEnum.EJB && anArchive.containsFile("META-INF/ejb-jar.xml")) {
            blockingDescriptor = "META-INF/ejb-jar.xml";
            foundBlockingDescriptor = true;
        } else if (moduleType != Archive.ModuleTypeEnum.RAR && anArchive.containsFile("META-INF/ra.xml")) {
            blockingDescriptor = "META-INF/ra.xml";
            foundBlockingDescriptor = true;
        }
        if (foundBlockingDescriptor) {
            logger.logp(Level.FINEST, className, methodName, "Archive contains blocking descriptor[ {0} ]", blockingDescriptor);
        }
        logger.exiting(className, methodName, foundBlockingDescriptor);
        return foundBlockingDescriptor;
    }

    public static boolean hasBlockingExtension(String archiveURI, Archive.ModuleTypeEnum moduleType) {
        String methodName = "hasBlockingExtension";
        logger.entering(className, methodName, archiveURI);
        boolean foundBlockingExtension = false;
        String blockingExtension = null;
        if (moduleType != Archive.ModuleTypeEnum.EAR && archiveURI.endsWith(".ear")) {
            blockingExtension = ".ear";
            foundBlockingExtension = true;
        } else if (moduleType != Archive.ModuleTypeEnum.WAR && archiveURI.endsWith(".war")) {
            blockingExtension = ".war";
            foundBlockingExtension = true;
        } else if (moduleType != Archive.ModuleTypeEnum.RAR && archiveURI.endsWith(".rar")) {
            blockingExtension = ".rar";
            foundBlockingExtension = true;
        } else if (moduleType == Archive.ModuleTypeEnum.EAR) {
            if (archiveURI.endsWith(".jar")) {
                blockingExtension = ".jar";
                foundBlockingExtension = true;
            } else if (archiveURI.endsWith(".zip")) {
                blockingExtension = ".zip";
                foundBlockingExtension = true;
            }
        }
        if (foundBlockingExtension) {
            logger.logp(Level.FINEST, className, methodName, "Archive ends in blocked extension[ {0} ]", blockingExtension);
        }
        logger.exiting(className, methodName, foundBlockingExtension);
        return foundBlockingExtension;
    }
}

