/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.logging.Level;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveTypeDiscriminatorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ImportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.War25ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.XmlBasedImportStrategyImpl;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class War22ImportStrategyImpl
extends XmlBasedImportStrategyImpl {
    protected static Discriminator discriminator;

    public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
        return War22ImportStrategyImpl.getDiscriminator().createImportStrategy(old, newArchive);
    }

    public static ArchiveTypeDiscriminator getDiscriminator() {
        if (discriminator == null) {
            discriminator = new Discriminator();
        }
        return discriminator;
    }

    public WARFile getWARFile() {
        return (WARFile)this.getArchive();
    }

    public void importMetaData() throws Exception {
        this.loadDeploymentDescriptor();
    }

    public void loadDeploymentDescriptor() throws Exception {
        WebApp webapp = (WebApp)this.primLoadDeploymentDescriptor();
        this.versionCheck((EObject)webapp);
        WARFile warFile = this.getWARFile();
        warFile.setDeploymentDescriptor(webapp);
        if (webapp.getVersionID() >= 25) {
            warFile.setExportStrategy(new War25ExportStrategyImpl());
        }
    }

    public static class Discriminator
    extends ArchiveTypeDiscriminatorImpl {
        protected static final String className = Discriminator.class.getName();

        public boolean canImport(Archive anArchive) {
            String methodName = "canImport";
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "ENTRY archive [ {0} ]", anArchive);
            Archive.ModuleVersionEnum version = Archive.ModuleVersionEnum.WAR22;
            String archiveURI = anArchive.getURI();
            if (anArchive.isSetCanImportAs(version)) {
                boolean canImport = anArchive.getCanImportAs(version);
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN cached WAR22 value [ {0} ]", Boolean.toString(canImport));
                return canImport;
            }
            boolean canImport = this.determineCanImport(anArchive, archiveURI);
            anArchive.setCanImportAs(version, canImport);
            anArchive.closeArchiveZipFile();
            XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN WAR22 [ {0} ]", Boolean.toString(canImport));
            return canImport;
        }

        private boolean determineCanImport(Archive anArchive, String archiveURI) {
            String methodName = "determineCanImport";
            XmlBasedImportStrategyImpl.logger.entering(className, methodName, archiveURI);
            if (XmlBasedImportStrategyImpl.markedDeleted(anArchive, Archive.ModuleTypeEnum.WAR)) {
                XmlBasedImportStrategyImpl.logger.logp(Level.FINER, className, methodName, "RETURN false - archive marked deleted");
                return false;
            }
            return anArchive.containsFile("WEB-INF/web.xml");
        }

        public ImportStrategy createImportStrategy(Archive old, Archive newArchive) {
            return new War22ImportStrategyImpl();
        }

        public String getUnableToOpenMessage() {
            return this.getXmlDDMessage(CommonArchiveResourceHandler.WAR_File, "WEB-INF/web.xml");
        }

        public Archive createConvertedArchive() {
            return ImportStrategyImpl.getArchiveFactory().createWARFile();
        }
    }
}

