/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.strategy;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.EJBJarFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ExportStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.ejb.EJBJar;

public class EjbJar30ExportStrategyImpl
extends ExportStrategyImpl {
    public static final String className = EjbJar30ExportStrategyImpl.class.getName();
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    public static final URI EJBJAR_DD_URI = URI.createURI("META-INF/ejb-jar.xml");
    public static final URI EJBJAR_MERGED_DD_URI = URI.createURI("META-INF/ejb-jar_merged.xml");

    public void preSave(SaveStrategy aSaveStrategy) throws SaveFailureException {
        String methodName = "preSave";
        logger.logp(Level.FINER, className, methodName, "ENTRY Archive [ {0} ]", this.getArchive().getURI());
        EJBJarFileImpl ejbJarFile = (EJBJarFileImpl)aSaveStrategy.getArchive();
        ResourceSet resourceSet = ejbJarFile.getResourceSet();
        Resource ddResource = resourceSet.getResource(EJBJAR_DD_URI, false);
        logger.logp(Level.FINER, className, methodName, "ddResource [ {0} ]", ddResource);
        Resource mergedDDResource = resourceSet.getResource(EJBJAR_MERGED_DD_URI, false);
        logger.logp(Level.FINER, className, methodName, "mergedDDResource [ {0} ]", mergedDDResource);
        if (mergedDDResource != null) {
            EJBJar mergedEjbJar = (EJBJar)mergedDDResource.getContents().get(0);
            boolean metadataComplete = mergedEjbJar.isMetadataComplete();
            logger.logp(Level.FINER, className, methodName, "Metadata flag [ {0} ]", new Boolean(metadataComplete));
            if (metadataComplete) {
                ddResource.getContents().clear();
                ArrayList cachedContents = new ArrayList();
                cachedContents.addAll(mergedDDResource.getContents());
                ddResource.getContents().addAll(cachedContents);
                resourceSet.getResources().remove(mergedDDResource);
                ejbJarFile.setDeploymentDescriptorGen(mergedEjbJar);
                ejbJarFile.setMergedDeploymentDescriptorGen(null);
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }
}

