/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.commonarchivecore.internal.AnnotationsProcessor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsProcessorException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class EJBJarFileImpl
extends ModuleFileImpl
implements EJBJarFile {
    protected EJBJar deploymentDescriptor = null;
    protected EJBJar mergedDeploymentDescriptor = null;
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private static final String className = EJBJarFileImpl.class.getName();
    public static final boolean UNMERGED_DESCRIPTOR = false;
    public static final boolean MERGED_DESCRIPTOR = true;
    protected EJBJarSignature ejbJarSignature = null;
    protected EJBJarSignature ejbJarSignatureMerged = null;

    protected String getDDObjectId() {
        return "ejb-jar_ID";
    }

    public boolean isGeneratedDD() {
        if (this.deploymentDescriptor == null) {
            this.getDeploymentDescriptor(false);
        }
        return super.isGeneratedDD();
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.EJB_JAR_FILE;
    }

    public List getAssociatedFiles(EnterpriseBean ejb) {
        String className;
        ArrayList<String> classNames = new ArrayList<String>();
        ArrayList<File> result = new ArrayList<File>();
        if (ejb.getVersionID() <= 11) {
            classNames.add(ejb.getHomeInterfaceName());
            classNames.add(ejb.getRemoteInterfaceName());
        } else if (ejb.getVersionID() >= 20) {
            if (ejb.hasRemoteClient()) {
                classNames.add(ejb.getHomeInterfaceName());
                classNames.add(ejb.getRemoteInterfaceName());
            }
            if (ejb.hasLocalClient()) {
                classNames.add(ejb.getLocalHomeInterfaceName());
                classNames.add(ejb.getLocalInterfaceName());
            }
        }
        classNames.add(ejb.getEjbClassName());
        if (ejb.isEntity() && !(className = ((Entity)ejb).getPrimaryKeyName()).startsWith("java")) {
            classNames.add(className);
        }
        for (int i = 0; i < classNames.size(); ++i) {
            String className2 = (String)classNames.get(i);
            if (className2 == null) continue;
            String classUri = ArchiveUtil.classNameToUri(className2);
            String javaUri = ArchiveUtil.classNameToJavaUri(className2);
            try {
                result.add(this.getFile(classUri));
            }
            catch (FileNotFoundException iox) {
                // empty catch block
            }
            try {
                result.add(this.getFile(javaUri));
                continue;
            }
            catch (FileNotFoundException iox) {
                // empty catch block
            }
        }
        return result;
    }

    public EJBJar getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(true);
    }

    public void displayResourceStatus() {
        Resource useResource;
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        String methodName = "displayResourceStatus";
        StringBuffer sb = new StringBuffer("\n\nEJBJar URI [ ").append(this.getURI()).append(" ] \n");
        EJBJar useDescriptor = this.basicGetDeploymentDescriptor();
        EJBJar useMergedDescriptor = this.mergedDeploymentDescriptor;
        sb.append("Original descriptor: \n").append(useDescriptor);
        if (useDescriptor != null) {
            useResource = useDescriptor.eResource();
            sb.append("Original descriptor resource [ ").append(useResource).append(" ] \n");
            if (useResource != null) {
                sb.append("Original descriptor resourceSet [ ").append(useResource.getResourceSet()).append(" ] \n");
            }
        }
        sb.append("Merged descriptor: \n").append(useMergedDescriptor);
        if (useMergedDescriptor != null) {
            useResource = useMergedDescriptor.eResource();
            sb.append("Merged descriptor resource [ ").append(useResource).append(" ] \n");
            logger.logp(Level.FINER, className, methodName, "Merged descriptor resource [ {0} ]", useResource);
            if (useResource != null) {
                sb.append("Merged descriptor resourceSet [ ").append(useResource.getResourceSet()).append(" ] \n");
            }
        }
        LoadStrategy useStrategy = this.getLoadStrategy();
        sb.append("Load strategy [ ").append(useStrategy).append(" ] \n");
        if (useStrategy != null) {
            ResourceSet resourceSet = useStrategy.getResourceSet();
            sb.append("Load strategy resource set [ ").append(resourceSet).append(" ] \n");
            if (resourceSet != null) {
                Iterator useResources = resourceSet.getResources().iterator();
                int resourceNo = 0;
                while (useResources.hasNext()) {
                    Resource nextResource = (Resource)useResources.next();
                    sb.append("  Resource [ ").append(resourceNo).append(" ] \n").append(" [ ").append(nextResource).append(" ] \n");
                    Iterator contents = nextResource.getContents().iterator();
                    if (!contents.hasNext()) {
                        sb.append("     No contents!!\n");
                    } else {
                        int contentNo = 0;
                        while (contents.hasNext()) {
                            Object nextContent = contents.next();
                            sb.append("    Content [ ").append(contentNo).append(" ] \n").append(" [ ").append(nextContent).append(" ] \n");
                            ++contentNo;
                        }
                    }
                    ++resourceNo;
                }
            }
        }
        logger.logp(Level.FINER, className, methodName, sb.toString());
    }

    public EJBJar getDeploymentDescriptor(boolean mergeContent) throws DeploymentDescriptorLoadException {
        String methodName = "getDeploymentDescriptor";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", this.getURI());
        logger.logp(Level.FINER, className, methodName, "mergeContent [ {0} ]", new Boolean(mergeContent));
        if (mergeContent && this.mergedDeploymentDescriptor != null) {
            this.updateSignature(this.mergedDeploymentDescriptor, methodName, true);
            if (logger.isLoggable(Level.FINER)) {
                StringBuffer sb = new StringBuffer("RETURN Using cached merged EJB JAR File deployment descriptor for archive [ ").append(this.getURI()).append(" ]:").append(this.mergedDeploymentDescriptor);
                logger.logp(Level.FINER, className, methodName, sb.toString());
            }
            return this.mergedDeploymentDescriptor;
        }
        EJBJar dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (DeploymentDescriptorLoadException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        EJBJar ddGen = this.getDeploymentDescriptorGen();
        ddGen.storeJ2EEVersionID();
        this.setModuleVersion(ddGen.getVersionID());
        if (mergeContent) {
            logger.logp(Level.FINER, className, methodName, "ddGen.isMetadataComplete() [ {0} ]", ddGen.isMetadataComplete());
            logger.logp(Level.FINER, className, methodName, "EJBJar.isAnnotationsSupported() [ {0} ]", this.isAnnotationsSupported());
            if (!ddGen.isMetadataComplete() && this.isAnnotationsSupported()) {
                logger.logp(Level.FINER, className, methodName, "Condition(s) for processing annotations passed.");
                this.mergedDeploymentDescriptor = (EJBJar)this.copyDeploymentDescriptor((EObject)ddGen);
                this.processAnnotations(this.mergedDeploymentDescriptor);
                this.mergedDeploymentDescriptor.storeJ2EEVersionID();
                this.updateSignature(this.mergedDeploymentDescriptor, methodName, true);
                this.closeArchiveZipFile();
                if (logger.isLoggable(Level.FINER)) {
                    StringBuffer sb = new StringBuffer("RETURN merged EJB JAR File deployment descriptor for archive [ ").append(this.getURI()).append(" ]:").append(this.mergedDeploymentDescriptor);
                    logger.logp(Level.FINER, className, methodName, sb.toString());
                }
                return this.mergedDeploymentDescriptor;
            }
            logger.logp(Level.FINER, className, methodName, "Condition(s) for processing annotations did NOT pass.");
        }
        this.updateSignature(ddGen, methodName, false);
        this.closeArchiveZipFile();
        if (logger.isLoggable(Level.FINER)) {
            StringBuffer sb = new StringBuffer("RETURN EJB JAR File deployment descriptor for archive [ ").append(this.getURI()).append(" ]:").append(ddGen);
            logger.logp(Level.FINER, className, methodName, sb.toString());
        }
        return ddGen;
    }

    private void processAnnotations(EJBJar ejbJarDD) throws AnnotationsException {
        AnnotationsProcessor processor;
        String methodName = "processAnnotations";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", this.getURI());
        try {
            processor = this.getAnnotationsProcessor();
        }
        catch (AnnotationsProcessorException ape) {
            logger.throwing(className, methodName, (Throwable)((Object)ape));
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_annotations_processor_load_failure_0, new Object[]{ape}));
            logger.logp(Level.FINER, className, methodName, "RETURN");
            return;
        }
        MergeData mergeData = this.createMergeData((EObject)ejbJarDD);
        try {
            processor.merge(mergeData);
        }
        catch (Exception e) {
            this.processMergeException(e);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    protected void cleanupOnClose() {
        logger.logp(Level.FINER, className, "cleanupOnClose", "ENTRY/RETURN");
        this.mergedDeploymentDescriptor = null;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/ejb-jar.xml";
    }

    public int getNoDescriptorVersionID() {
        return 30;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getStandardDeploymentDescriptor(true);
    }

    public EObject getStandardDeploymentDescriptor(boolean merge) throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(merge);
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isEJBJarFile() {
        return true;
    }

    public boolean isImportedFrom10() {
        return this.getImportStrategy() != null && this.getImportStrategy().isEJB10();
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        EJBJar ejbJar = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createEJBJar();
        resource.setID((EObject)ejbJar, "ejb-jar_ID");
        this.setDeploymentDescriptorGen(ejbJar);
        resource.getContents().add(ejbJar);
        return ejbJar;
    }

    public void setDeploymentDescriptor(EJBJar ejbJar) {
        String methodName = "setDeploymentDescriptor";
        if (ArchiveUtil.isMergedDD((EObject)ejbJar)) {
            logger.logp(Level.SEVERE, className, methodName, "Attempted to set the merged descriptor as the main deployment descriptor of EJB JAR Module [ {0} ]", this.getURI());
            logger.throwing(className, methodName, new Exception());
        }
        this.setDeploymentDescriptorGen(ejbJar);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)ejbJar);
    }

    public EJBJar getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject oldDeploymentDescriptor = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (EJBJar)this.eResolveProxy(oldDeploymentDescriptor);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public EJBJar basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(EJBJar newDeploymentDescriptor) {
        EJBJar oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public void setMergedDeploymentDescriptorGen(EJBJar newMergedDeploymentDescriptor) {
        this.mergedDeploymentDescriptor = newMergedDeploymentDescriptor;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor((EJBJar)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    protected void updateSignature(EJBJar ejbJar, String triggerMethod, boolean isMerged) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        if (isMerged) {
            if (this.ejbJarSignatureMerged == null) {
                this.ejbJarSignatureMerged = new EJBJarSignature();
            }
            if (this.ejbJarSignatureMerged.updateSignature(ejbJar, triggerMethod)) {
                logger.logp(Level.FINER, className, triggerMethod, "A changed was detected on the merged descriptor for EJBJar [ {0} ]", this.getURI());
            }
        } else {
            if (this.ejbJarSignature == null) {
                this.ejbJarSignature = new EJBJarSignature();
            }
            if (this.ejbJarSignature.updateSignature(ejbJar, triggerMethod)) {
                logger.logp(Level.FINER, className, triggerMethod, "A changed was detected on the un-merged descriptor for EJBJar [ {0} ]", this.getURI());
            }
        }
    }

    public boolean isAnnotationsSupported() {
        int version = this.getSpecVersionID();
        return version >= 30;
    }

    public boolean requiresIterationOnSave() {
        if (this.mergedDeploymentDescriptor == null) {
            return false;
        }
        return this.mergedDeploymentDescriptor.isMetadataComplete();
    }

    protected class EJBJarSignature {
        public int ejbCount = -1;
        public HashSet ejbTypes = null;

        protected EJBJarSignature() {
        }

        protected boolean updateSignature(EJBJar ejbJar, String triggerMethod) {
            if (ejbJar == null) {
                if (this.ejbCount != -1) {
                    logger.logp(Level.FINER, className, triggerMethod, "Update to EJB count detected: Old count [ {0} ]; new count [ {1} ]", new Object[]{new Integer(this.ejbCount), new Integer(-1)});
                    if (this.ejbTypes != null) {
                        for (String nextEJBType : this.ejbTypes) {
                            logger.logp(Level.FINER, className, triggerMethod, "Removed EJB [ {0} ]", nextEJBType);
                        }
                    }
                    this.ejbTypes = null;
                    this.ejbCount = -1;
                    return true;
                }
                return false;
            }
            if (this.ejbCount == -1) {
                this.ejbCount = ejbJar.getEnterpriseBeans().size();
                logger.logp(Level.FINER, className, triggerMethod, "Update of EJB count detected: Old count [ {0} ]; new count [ {1} ]", new Object[]{new Integer(-1), new Integer(this.ejbCount)});
                if (this.ejbCount == 0) {
                    logger.logp(Level.FINER, className, triggerMethod, "WARNING: No EJBs are present");
                }
                this.ejbTypes = this.getEJBTypes(ejbJar);
                for (String nextEJBType : this.ejbTypes) {
                    logger.logp(Level.FINER, className, triggerMethod, "Added EJB [ {0} ]", nextEJBType);
                }
                return true;
            }
            HashSet newEJBTypes = this.getEJBTypes(ejbJar);
            int newEJBCount = newEJBTypes.size();
            if (this.ejbCount != newEJBCount) {
                logger.logp(Level.FINER, className, triggerMethod, "Update of EJB count detected: Old count [ {0} ]; new count [ {1} ]", new Object[]{new Integer(this.ejbCount), new Integer(newEJBCount)});
            }
            boolean changedEJBs = false;
            int numDuplicateEJBs = 0;
            for (String nextEJBType : this.ejbTypes) {
                if (!newEJBTypes.contains(nextEJBType)) {
                    logger.logp(Level.FINER, className, triggerMethod, "Removed EJB [ {0} ]", nextEJBType);
                    changedEJBs = true;
                    continue;
                }
                ++numDuplicateEJBs;
            }
            if (numDuplicateEJBs != newEJBTypes.size()) {
                logger.logp(Level.FINER, className, triggerMethod, "Removed a total of [ {0} ] EJBs", new Integer(this.ejbTypes.size() - numDuplicateEJBs));
                int numNewEJBs = 0;
                for (String nextNewEJBType : newEJBTypes) {
                    if (this.ejbTypes.contains(nextNewEJBType)) continue;
                    logger.logp(Level.FINER, className, triggerMethod, "Added EJB [ {0} ]", nextNewEJBType);
                    ++numNewEJBs;
                    changedEJBs = true;
                }
                logger.logp(Level.FINER, className, triggerMethod, "Added a total of [ {0} ] EJBs", new Integer(numNewEJBs));
            }
            if (changedEJBs) {
                this.ejbCount = newEJBCount;
                this.ejbTypes = newEJBTypes;
            }
            return changedEJBs;
        }

        protected HashSet getEJBTypes(EJBJar ejbJar) {
            HashSet<String> newEJBTypes = new HashSet<String>();
            for (EnterpriseBean nextEJB : ejbJar.getEnterpriseBeans()) {
                newEJBTypes.add(this.getEJBType(nextEJB));
            }
            return newEJBTypes;
        }

        protected String getEJBType(EnterpriseBean ejb) {
            return "[ " + ejb.getClass().getName() + " ] [ " + ejb.getName() + " ]";
        }
    }
}

