/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.application.ConnectorModule;
import org.eclipse.jst.j2ee.application.EjbModule;
import org.eclipse.jst.j2ee.application.JavaClientModule;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.internal.impl.ApplicationClientResourceFactory;
import org.eclipse.jst.j2ee.common.EjbRef;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.EmptyResourceException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ObjectNotFoundException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveOptions;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.looseconfig.internal.LooseArchive;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.internal.impl.EJBJarResourceFactory;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.internal.impl.ConnectorResourceFactory;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.internal.impl.WebAppResourceFactory;
import org.eclipse.wst.common.internal.emf.resource.FileNameResourceFactoryRegistry;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class EARFileImpl
extends ModuleFileImpl
implements EARFile {
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private static String className = EARFileImpl.class.getName();
    private boolean _libraryDirectoryNameComputed = false;
    private String _libraryDirectoryName = null;
    protected Application deploymentDescriptor = null;
    protected EList moduleRefs = null;
    protected EARSignature earSignature = null;

    public boolean isGeneratedDD() {
        if (this.deploymentDescriptor == null) {
            this.getDeploymentDescriptor();
        }
        return super.isGeneratedDD();
    }

    public ModuleFile getModuleFile(Module moduleDescriptor) {
        String methodName = "getModuleFile";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", moduleDescriptor);
        ModuleRef ref = this.getModuleRef(moduleDescriptor);
        ModuleFile mf = ref == null ? null : ref.getModuleFile();
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", mf);
        return mf;
    }

    public ModuleFile addCopy(ModuleFile aModuleFile) throws DuplicateObjectException {
        Object result = this.primAddCopyRef(aModuleFile);
        if (result instanceof ModuleRef) {
            return ((ModuleRef)result).getModuleFile();
        }
        return (ModuleFile)result;
    }

    protected String getDDObjectId() {
        return "Application_ID";
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.EAR_FILE;
    }

    public Archive addCopy(Archive anArchive) throws DuplicateObjectException {
        if (anArchive.isModuleFile()) {
            return this.addCopy((ModuleFile)anArchive);
        }
        Archive copy = super.addCopy(anArchive);
        return copy;
    }

    protected Object primAddCopyRef(ModuleFile aModuleFile) throws DuplicateObjectException {
        EList refs = this.getModuleRefs();
        if (aModuleFile.isEARFile()) {
            return (ModuleFile)super.addCopy(aModuleFile);
        }
        this.checkAddValid(aModuleFile);
        ModuleFile copy = this.getCommonArchiveFactory().copy(aModuleFile);
        Module newModule = this.createModuleForCopying(aModuleFile);
        this.getFiles().add(copy);
        if (!copy.getURI().equals(newModule.getUri())) {
            copy.setURI(newModule.getUri());
        }
        this.getDeploymentDescriptor().getModules().add(newModule);
        ModuleRef aRef = this.createModuleRef(newModule, copy);
        refs.add(aRef);
        return aRef;
    }

    public ModuleRef addCopyRef(ModuleFile aModuleFile) throws DuplicateObjectException {
        Object result = this.primAddCopyRef(aModuleFile);
        if (result instanceof ModuleRef) {
            return (ModuleRef)result;
        }
        return null;
    }

    public SecurityRole addCopy(SecurityRole aRole, Module aModule) throws DuplicateObjectException {
        String methodName = "addCopy";
        String moduleURI = aModule.getUri();
        String roleName = aRole.getRoleName();
        logger.logp(Level.FINER, className, methodName, "ENTER role name [ {0} ] module URI [ {1} ]", new Object[]{roleName, moduleURI});
        EObject dd = null;
        try {
            dd = this.getDeploymentDescriptor(aModule);
        }
        catch (Exception e) {
            logger.throwing(className, methodName, e);
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.EJB_security_roles_error_processing_0, new Object[]{aModule, e.getMessage()}));
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        SecurityRole copy = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)aRole);
        if (aModule.isEjbModule()) {
            logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
            EJBJar ejbJar = (EJBJar)dd;
            if (ejbJar.containsSecurityRole(roleName)) {
                DuplicateObjectException doe = new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_module_EXC_, new Object[]{aModule.getUri(), roleName}), ejbJar.getAssemblyDescriptor().getSecurityRoleNamed(roleName));
                logger.throwing(className, methodName, doe);
                throw doe;
            }
            this.getAssemblyDescriptorAddIfNecessary(ejbJar).getSecurityRoles().add(copy);
        } else if (aModule.isWebModule()) {
            logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
            WebApp webApp = (WebApp)dd;
            if (webApp.containsSecurityRole(roleName)) {
                DuplicateObjectException doe = new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_module_EXC_, new Object[]{aModule.getUri(), roleName}), webApp.getSecurityRoleNamed(roleName));
                logger.throwing(className, methodName, doe);
                throw doe;
            }
            webApp.getSecurityRoles().add(copy);
        }
        this.addCopyIfNotExists(aRole);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", copy);
        return copy;
    }

    public SecurityRole addCopyIfNotExists(SecurityRole aRole) {
        Application dd = this.getDeploymentDescriptor();
        SecurityRole copy = null;
        if (!dd.containsSecurityRole(aRole.getRoleName())) {
            copy = (SecurityRole)EtoolsCopyUtility.createCopy((EObject)aRole);
            dd.getSecurityRoles().add(copy);
        }
        return copy;
    }

    protected void checkDuplicate(String aUri) throws DuplicateObjectException {
        if (this.isDuplicate(aUri)) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_resource_EXC_, new Object[]{aUri, this.getURI()}));
        }
    }

    protected Module createModuleForCopying(ModuleFile aModuleFile) {
        WebModule aModule = null;
        if (aModuleFile.isWARFile()) {
            aModule = this.getApplicationFactory().createWebModule();
        } else if (aModuleFile.isEJBJarFile()) {
            aModule = this.getApplicationFactory().createEjbModule();
        } else if (aModuleFile.isApplicationClientFile()) {
            aModule = this.getApplicationFactory().createJavaClientModule();
        } else if (aModuleFile.isRARFile()) {
            aModule = this.getApplicationFactory().createConnectorModule();
        }
        aModule.setUri(aModuleFile.getURI());
        return aModule;
    }

    public EObject getAltDeploymentDescriptor(Module aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        XMLResource ddRes;
        String altDD = aModule.getAltDD();
        if (ArchiveUtil.isNullOrEmpty(altDD)) {
            return null;
        }
        if (!this.isMofResourceLoaded(altDD.trim())) {
            this.registerResourceFactory(aModule, altDD);
        }
        if (!(ddRes = (XMLResource)this.getMofResource(altDD.trim())).isAlt()) {
            ddRes.setIsAlt(true);
            ddRes.setApplication(this.getDeploymentDescriptor());
        }
        return ArchiveUtil.getRoot((Resource)ddRes);
    }

    public List getApplicationClientFiles() {
        ArrayList<File> clientFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File aFile = (File)fileList.get(i);
            if (!aFile.isApplicationClientFile()) continue;
            clientFiles.add(aFile);
        }
        return clientFiles;
    }

    protected ApplicationFactory getApplicationFactory() {
        return ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory();
    }

    protected AssemblyDescriptor getAssemblyDescriptorAddIfNecessary(EJBJar ejbJar) {
        String methodName = "getAssemblyDescriptorAddIfNecessary";
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", ejbJar);
        AssemblyDescriptor ad = ejbJar.getAssemblyDescriptor();
        if (ad == null) {
            ad = ((EjbPackage)EPackage.Registry.INSTANCE.getEPackage("ejb.xmi")).getEjbFactory().createAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(ad);
            logger.logp(Level.FINER, className, methodName, "created Assembly Descriptor");
        } else {
            logger.logp(Level.FINER, className, methodName, "got existing Assembly Descriptor");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", ad);
        return ad;
    }

    public Application getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        Application a;
        String methodName = "getDeploymentDescriptor";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", this.getURI());
        Application dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                logger.logp(Level.FINER, className, methodName, "Must import metadata");
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                DeploymentDescriptorLoadException dle = new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
                logger.throwing(className, methodName, (Throwable)((Object)dle));
                logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.EARFile_dd_load_error_0, new Object[]{e.getMessage()}));
                throw dle;
            }
        }
        if ((a = this.getDeploymentDescriptorGen()) != null) {
            a.storeJ2EEVersionID();
        } else {
            logger.logp(Level.WARNING, className, methodName, "Null deployment descriptor for EAR [ {0} ]", this.getURI());
        }
        this.updateSignature(a, methodName);
        logger.logp(Level.FINER, className, methodName, "RETURN EAR File deployment descriptor [ {0} ]", a);
        return a;
    }

    public Connector getDeploymentDescriptor(ConnectorModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (Connector)this.getDeploymentDescriptor((Module)aModule);
    }

    public EJBJar getDeploymentDescriptor(EjbModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (EJBJar)this.getDeploymentDescriptor((Module)aModule);
    }

    public ApplicationClient getDeploymentDescriptor(JavaClientModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return (ApplicationClient)this.getDeploymentDescriptor((Module)aModule);
    }

    public EObject getDeploymentDescriptor(Module aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        return this.getDeploymentDescriptor(aModule, true);
    }

    public EObject getDeploymentDescriptor(Module aModule, boolean merge) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        String methodName = "getDeploymentDescriptor - module";
        String moduleURI = aModule.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", moduleURI);
        EObject dd = this.getAltDeploymentDescriptor(aModule);
        if (dd == null) {
            dd = this.getModuleFile(aModule).getStandardDeploymentDescriptor(merge);
            logger.logp(Level.FINER, className, methodName, "got standard Deployment Descriptor");
        } else {
            logger.logp(Level.FINER, className, methodName, "got alternate Deployment Descriptor");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", dd);
        return dd;
    }

    public WebApp getDeploymentDescriptor(WebModule aModule) throws FileNotFoundException, ResourceLoadException, EmptyResourceException {
        String methodName = "getDeploymentDescriptor - webmodule";
        String moduleURI = aModule.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTER [ {0} ]", moduleURI);
        WebApp wa = (WebApp)this.getDeploymentDescriptor((Module)aModule);
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", wa);
        return wa;
    }

    protected void cleanupOnClose() {
        logger.logp(Level.FINER, className, "cleanupOnClose", "ENTRY/RETURN");
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/application.xml";
    }

    public int getNoDescriptorVersionID() {
        return 50;
    }

    public List getEJBJarFiles() {
        ArrayList<File> ejbJarFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File aFile = (File)fileList.get(i);
            if (!aFile.isEJBJarFile()) continue;
            ejbJarFiles.add(aFile);
        }
        return ejbJarFiles;
    }

    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref) {
        String link = ref.getLink();
        if (link == null) {
            return null;
        }
        List jarFiles = this.getEJBJarFiles();
        for (int i = 0; i < jarFiles.size(); ++i) {
            EnterpriseBean bean = ((EJBJarFile)jarFiles.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(link);
            if (bean == null) continue;
            return bean;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnterpriseBean getEnterpiseBeanFromRef(EjbRef ref, String moduleUri) {
        String link = ref.getLink();
        if (link == null) {
            return null;
        }
        if (link.indexOf(35) == -1) {
            EJBJar jar;
            EnterpriseBean linkedEJB = null;
            XMLResource res = (XMLResource)ref.eResource();
            if (res instanceof EJBResource && (jar = ((EJBResource)res).getEJBJar()) != null) {
                linkedEJB = jar.getEnterpiseBeanFromRef(ref);
            }
            if (linkedEJB != null) return linkedEJB;
            List jarFiles = this.getEJBJarFiles();
            for (int i = 0; i < jarFiles.size(); ++i) {
                linkedEJB = ((EJBJarFile)jarFiles.get(i)).getDeploymentDescriptor().getEnterpriseBeanNamed(link);
                if (linkedEJB == null) continue;
                return linkedEJB;
            }
            return null;
        } else {
            String ejbJarUri;
            String ejbBeanName = link.substring(link.indexOf("#") + 1, link.length());
            String ejbJarName = link.substring(0, link.indexOf("#"));
            if (ejbBeanName == null || ejbJarName == null || (ejbJarUri = ArchiveUtil.deriveEARRelativeURI(ejbJarName, moduleUri)) == null) return null;
            try {
                File aFile = this.getFile(ejbJarUri);
                if (aFile == null || !aFile.isEJBJarFile()) {
                    return null;
                }
                EJBJarFile jarFile = (EJBJarFile)this.getFile(ejbJarUri);
                EList ejbs = jarFile.getDeploymentDescriptor().getEnterpriseBeans();
                if (ejbs == null || ejbs.isEmpty()) return null;
                for (EnterpriseBean ejbBean : ejbs) {
                    if (ejbBean == null || !ejbBean.getName().equals(ejbBeanName)) continue;
                    return ejbBean;
                }
                return null;
            }
            catch (FileNotFoundException fe) {
                return null;
            }
        }
    }

    public Module getModule(String aUri) {
        EList modules = this.getDeploymentDescriptor().getModules();
        int numModules = modules.size();
        for (int i = 0; i < numModules; ++i) {
            Module module = (Module)modules.get(i);
            if (!module.getUri().equalsIgnoreCase(aUri)) continue;
            return module;
        }
        return null;
    }

    public Module getModule(String aUri, String altDD) {
        return this.getDeploymentDescriptor().getModule(aUri, altDD);
    }

    private boolean isSimilarModule(Module earFileModule, Module requestedModule) {
        String methodName = "isSimilarModule";
        String requestedUri = requestedModule.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTER module [ (0} ]", earFileModule);
        String earFileModuleUri = earFileModule.getUri();
        if (requestedUri == null) {
            requestedUri = "";
        }
        if (earFileModuleUri == null) {
            earFileModuleUri = "";
        }
        if (!requestedUri.equalsIgnoreCase(earFileModuleUri)) {
            logger.logp(Level.FINER, className, methodName, "RETURN false - URI's did not match");
            return false;
        }
        String requestedAltDD = requestedModule.getAltDD();
        String earFileModuleAltDD = earFileModule.getAltDD();
        if (requestedAltDD == null) {
            requestedAltDD = "";
        }
        if (earFileModuleAltDD == null) {
            earFileModuleAltDD = "";
        }
        if (requestedAltDD.length() == 0 && earFileModuleAltDD.length() == 0) {
            logger.logp(Level.FINER, className, methodName, "RETURN true - Alt DD's not specified so no futher comparison is needed");
            return true;
        }
        if (!requestedAltDD.equalsIgnoreCase(earFileModuleAltDD)) {
            logger.logp(Level.FINER, className, methodName, "RETURN false - Alt DD's did not match");
            return false;
        }
        logger.logp(Level.FINER, className, methodName, "RETURN true - modules passed all similarity tests");
        return true;
    }

    public ModuleRef getModuleRef(Module moduleDescriptor) {
        ModuleRef ref;
        int i;
        String methodName = "getModuleRef";
        logger.logp(Level.FINER, className, methodName, "ENTRY [ {0} ]", moduleDescriptor);
        EList refs = this.getModuleRefs();
        for (i = 0; i < refs.size(); ++i) {
            ref = (ModuleRef)refs.get(i);
            if (ref.getModule() != moduleDescriptor) continue;
            logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", ref);
            return ref;
        }
        if (moduleDescriptor != null) {
            logger.logp(Level.FINER, className, methodName, "Matching Module object not found - searching for similar Module.");
            refs = this.getModuleRefs();
            for (i = 0; i < refs.size(); ++i) {
                ref = (ModuleRef)refs.get(i);
                Module earFileModule = ref.getModule();
                if (!this.isSimilarModule(earFileModule, moduleDescriptor)) continue;
                logger.logp(Level.FINER, className, methodName, "RETURN similar module [ {0} ]", ref);
                return ref;
            }
        }
        logger.logp(Level.FINER, className, methodName, "RETURN null");
        return null;
    }

    public List getModuleFiles() {
        ArrayList<File> moduleFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File aFile = (File)fileList.get(i);
            if (!aFile.isModuleFile()) continue;
            moduleFiles.add(aFile);
        }
        return moduleFiles;
    }

    protected ArchiveOptions getOptionsForOpening(String aUri) throws IOException {
        LoadStrategy strategy = this.getCommonArchiveFactory().createChildLoadStrategy(aUri, this.getLoadStrategy());
        return this.getOptions().cloneWith(strategy, aUri);
    }

    protected ArchiveOptions getOptionsForOpening(LooseArchive loose) throws IOException, OpenFailureException {
        String binariesPath = loose.getBinariesPath();
        if (binariesPath == null) {
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.open_nested_EXC_, new Object[]{loose.getUri(), this.getURI()}), null);
        }
        LoadStrategy strategy = this.getCommonArchiveFactory().createLoadStrategy(binariesPath);
        strategy.setLooseArchive(loose);
        return this.getOptions().cloneWith(strategy, loose.getUri());
    }

    public List getRARFiles() {
        ArrayList<File> rarFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File aFile = (File)fileList.get(i);
            if (!aFile.isRARFile()) continue;
            rarFiles.add(aFile);
        }
        return rarFiles;
    }

    public EList getRolesFromAllModules() {
        BasicEList roleList = new BasicEList();
        EList modules = this.getDeploymentDescriptor().getModules();
        int n = modules.size();
        for (int i = 0; i < n; ++i) {
            Module aModule = (Module)modules.get(i);
            EList roles = this.getRolesFromModule(aModule);
            int m = roles.size();
            for (int j = 0; j < m; ++j) {
                roleList.add(roles.get(j));
            }
        }
        return roleList;
    }

    public EList getRolesFromModule(Module aModule) {
        String methodName = "getRolesFromModule";
        String moduleURI = aModule.getUri();
        logger.entering(className, methodName, moduleURI);
        EList roleList = new BasicEList();
        try {
            if (aModule.isWebModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                roleList = this.getDeploymentDescriptor((WebModule)aModule).getSecurityRoles();
            } else if (aModule.isEjbModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                roleList = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)aModule)).getSecurityRoles();
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.EARFile_roles_error_processing_0, new Object[]{aModule, this.getURI(), e.getMessage()}));
            logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        logger.exiting(className, methodName, roleList);
        return roleList;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public EObject getStandardDeploymentDescriptor(boolean merge) throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public List getWARFiles() {
        ArrayList<File> warFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File aFile = (File)fileList.get(i);
            if (!aFile.isWARFile()) continue;
            warFiles.add(aFile);
        }
        return warFiles;
    }

    public void initializeAfterOpen() {
        super.initializeAfterOpen();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isEARFile() {
        return true;
    }

    public boolean isNestedArchive(String aUri) {
        if (super.isNestedArchive(aUri)) {
            return true;
        }
        return this.getDeploymentDescriptor().getFirstModule(aUri) != null;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        Application appl = ((ApplicationPackage)EPackage.Registry.INSTANCE.getEPackage("application.xmi")).getApplicationFactory().createApplication();
        resource.setID((EObject)appl, "Application_ID");
        this.setDeploymentDescriptorGen(appl);
        resource.getContents().add(appl);
        return appl;
    }

    public Archive openNestedArchive(LooseArchive loose) throws OpenFailureException {
        String methodName = "openNestedArchive - loose";
        String looseArchiveURI = loose.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTRY - loose archive URI [ {0} ]", looseArchiveURI);
        Module m = this.getDeploymentDescriptor().getFirstModule(looseArchiveURI);
        logger.logp(Level.FINER, className, methodName, "Got module [ {0} ]", m);
        if (m == null) {
            Archive a = super.openNestedArchive(loose);
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        try {
            Archive a;
            String binariesPath = loose.getBinariesPath();
            java.io.File file = new java.io.File(binariesPath);
            if (!file.exists()) {
                a = this.getCommonArchiveFactory().openNestedArchive(loose, (Archive)this);
            } else {
                ArchiveOptions archiveOptions = this.getOptionsForOpening(loose);
                a = this.openNestedArchive(m, archiveOptions);
            }
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        catch (IOException ex) {
            logger.logp(Level.FINER, className, methodName, "java.io.IOException with module [ {0} ]", m.getUri());
            logger.logp(Level.FINER, className, methodName, "RETURN null");
            return null;
        }
    }

    public Archive openNestedArchive(String aUri) throws OpenFailureException {
        String methodName = "openNestedArchive - URI";
        logger.logp(Level.FINER, className, methodName, "ENTRY - URI [ {0} ]", aUri);
        try {
            String altBinariesPath;
            String parentBinariesPath = this.getBinariesPath();
            logger.logp(Level.FINER, className, methodName, "Found parentBinariesPath [ {0} ]", parentBinariesPath);
            ArchiveOptions ao = this.getOptions();
            if (ao.isSetAltBinariesPath() && (altBinariesPath = ao.getAltBinariesPath()) != null) {
                logger.logp(Level.FINER, className, methodName, "Found altBinariesPath in archiveOptions [ {0} ]", parentBinariesPath);
                parentBinariesPath = altBinariesPath;
            }
            this.options.setParentEarBinariesPath(parentBinariesPath);
            logger.logp(Level.FINER, className, methodName, "Saved parentBinariesPath in archiveOptions [ {0} ]", parentBinariesPath);
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.WARNING, className, methodName, "Couldn't set binariesPath in archive options.  Continuing without it.");
        }
        Module m = this.getDeploymentDescriptor().getFirstModule(aUri);
        logger.logp(Level.FINER, className, methodName, "Got module [ {0} ]", m);
        if (m == null) {
            Archive a = super.openNestedArchive(aUri);
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        try {
            ArchiveOptions archiveOptions = this.getOptionsForOpening(aUri);
            Archive a = this.openNestedArchive(m, archiveOptions);
            if (a == null) {
                logger.logp(Level.FINER, className, methodName, "RETURN null");
            } else {
                logger.logp(Level.FINER, className, methodName, "RETURN archive [ {0} ]", a.getURI());
            }
            return a;
        }
        catch (IOException ex) {
            logger.logp(Level.FINER, className, methodName, "java.io.IOException with archive [ {0} ]", aUri);
            logger.logp(Level.FINER, className, methodName, "RETURN null");
            return null;
        }
    }

    protected Archive openNestedArchive(Module m, ArchiveOptions archiveOptions) throws OpenFailureException {
        String methodName = "openNestedArchive - module";
        String aUri = m.getUri();
        logger.logp(Level.FINER, className, methodName, "ENTRY - module URI [ {0} ]", aUri);
        try {
            ModuleFile a;
            try {
                String parentBinariesPath = this.getBinariesPath();
                logger.logp(Level.FINER, className, methodName, "Found parentBinariesPath [ {0} ]", parentBinariesPath);
                String altBinariesPath = this.getOptions().getAltBinariesPath();
                if (altBinariesPath != null) {
                    logger.logp(Level.FINER, className, methodName, "Found altBinariesPath in archiveOptions [ {0} ]", altBinariesPath);
                    parentBinariesPath = altBinariesPath;
                }
                archiveOptions.setParentEarBinariesPath(parentBinariesPath);
                logger.logp(Level.FINER, className, methodName, "Saved parentBinariesPath [ {0} ] in archiveOptions", parentBinariesPath);
            }
            catch (FileNotFoundException e) {
                logger.logp(Level.WARNING, className, methodName, "Couldn't set binariesPath in archive options.  Continuing without it.");
            }
            archiveOptions.setParentEarFile(this);
            if (m.isWebModule()) {
                a = this.getCommonArchiveFactory().openWARFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
            if (m.isEjbModule()) {
                a = this.getCommonArchiveFactory().openEJBJarFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
            if (m.isJavaModule()) {
                a = this.getCommonArchiveFactory().openApplicationClientFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
            if (m.isConnectorModule()) {
                a = this.getCommonArchiveFactory().openRARFile(archiveOptions, aUri);
                logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ]", a);
                return a;
            }
        }
        catch (OpenFailureException ex) {
            logger.logp(Level.WARNING, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.EARFile_open_nested_archive_failure_0, new Object[]{ex.getMessage()}));
            logger.logp(Level.FINER, className, methodName, "RETURN Throwing OpenFailureException");
            throw new OpenFailureException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.nested_open_fail_EXC_, new Object[]{aUri, this.getURI()}), (Exception)((Object)ex));
        }
        logger.logp(Level.FINER, className, methodName, "RETURN null");
        return null;
    }

    public void pushDownRole(SecurityRole role) {
        if (role == null) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.Parameter_should_not_be_nu_EXC_);
        }
        EList modules = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < modules.size(); ++i) {
            Module m = (Module)modules.get(i);
            this.pushDownRole(role, m);
        }
    }

    public void pushDownRole(SecurityRole role, Module aModule) {
        String methodName = "pushDownRole";
        String moduleURI = aModule.getUri();
        String roleName = role.getRoleName();
        logger.entering(className, methodName, new Object[]{roleName, moduleURI});
        try {
            if (aModule.isWebModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                WebApp dd = this.getDeploymentDescriptor((WebModule)aModule);
                if (dd.getSecurityRoleNamed(roleName) == null) {
                    dd.getSecurityRoles().add(EtoolsCopyUtility.createCopy((EObject)role));
                }
            } else if (aModule.isEjbModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                AssemblyDescriptor assembly = this.getAssemblyDescriptorAddIfNecessary(this.getDeploymentDescriptor((EjbModule)aModule));
                if (assembly.getSecurityRoleNamed(roleName) == null) {
                    assembly.getSecurityRoles().add(EtoolsCopyUtility.createCopy((EObject)role));
                }
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.EARFile_roles_error_processing_0, new Object[]{aModule, this.getURI(), e.getMessage()}));
            logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        logger.exiting(className, methodName);
    }

    protected void registerResourceFactory(Module aModule, String aUri) {
        Resource.Factory factory = null;
        if (aModule.isEjbModule()) {
            factory = EJBJarResourceFactory.getRegisteredFactory();
        } else if (aModule.isWebModule()) {
            factory = WebAppResourceFactory.getRegisteredFactory();
        } else if (aModule.isJavaModule()) {
            factory = ApplicationClientResourceFactory.getRegisteredFactory();
        } else if (aModule.isConnectorModule()) {
            factory = ConnectorResourceFactory.getRegisteredFactory();
        }
        if (factory != null) {
            ResourceSet set = this.getResourceSet();
            ((FileNameResourceFactoryRegistry)set.getResourceFactoryRegistry()).registerLastFileSegment(aUri, factory);
        }
    }

    public void remove(ModuleRef aModuleRef) {
        String methodName = "remove";
        logger.entering(className, methodName, aModuleRef);
        if (aModuleRef == null) {
            return;
        }
        Module aModule = aModuleRef.getModule();
        if (aModule != null) {
            this.getDeploymentDescriptor().getModules().remove(aModule);
        }
        this.getModuleRefs().remove(aModuleRef);
        ModuleFile mf = aModuleRef.getModuleFile();
        if (this.getModuleRefs(mf).isEmpty()) {
            logger.logp(Level.FINER, className, methodName, "Removing EAR file list entry for module [ {0} ]", mf.getURI());
            this.getFiles().remove(mf);
        }
        logger.exiting(className, methodName);
    }

    public List getModuleRefs(ModuleFile aModuleFile) {
        EList refs = this.getModuleRefs();
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>(1);
        for (int i = 0; i < refs.size(); ++i) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (ref.getModuleFile() != aModuleFile) continue;
            result.add(ref);
        }
        return result;
    }

    protected void renameRolesInModuleDDs(String existingRoleName, String newRoleName) {
        String methodName = "renameRolesInModuleDDs";
        logger.entering(className, methodName, new Object[]{existingRoleName, newRoleName});
        EList modules = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < modules.size(); ++i) {
            Module m = (Module)modules.get(i);
            try {
                if (m.isEjbModule()) {
                    logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                    this.getDeploymentDescriptor((EjbModule)m).renameSecurityRole(existingRoleName, newRoleName);
                    continue;
                }
                if (!m.isWebModule()) continue;
                logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                this.getDeploymentDescriptor((WebModule)m).renameSecurityRole(existingRoleName, newRoleName);
                continue;
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.EARFile_roles_error_processing_0, new Object[]{m, this.getURI(), e.getMessage()}));
                logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
                String ddName = "";
                if (m.isWebModule()) {
                    ddName = "WEB-INF/web.xml";
                } else if (m.isEjbModule()) {
                    ddName = "META-INF/ejb-jar.xml";
                }
                throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, m.getUri(), this.getURI()}), e);
            }
        }
        logger.exiting(className, methodName);
    }

    public void renameSecurityRole(String existingRoleName, String newRoleName) throws ObjectNotFoundException, DuplicateObjectException {
        Application app = this.getDeploymentDescriptor();
        SecurityRole aRole = app.getSecurityRoleNamed(existingRoleName);
        if (aRole == null) {
            throw new ObjectNotFoundException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.no_sec_role_EXC_, new Object[]{this.getURI(), existingRoleName}));
        }
        if (app.getSecurityRoleNamed(newRoleName) != null) {
            throw new DuplicateObjectException(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.dup_sec_role_EXC_, new Object[]{this.getURI(), newRoleName}), app.getSecurityRoleNamed(newRoleName));
        }
        aRole.setRoleName(newRoleName);
        this.renameRolesInModuleDDs(existingRoleName, newRoleName);
    }

    public void rollUpRoles() {
        EList modules = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < modules.size(); ++i) {
            Module aModule = (Module)modules.get(i);
            this.rollUpRoles(aModule);
        }
    }

    public void rollUpRoles(Module aModule) {
        String methodName = "rollUpRoles";
        String moduleURI = aModule.getUri();
        logger.entering(className, methodName, moduleURI);
        List securityRoles = null;
        try {
            if (aModule.isWebModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be a Web Module");
                securityRoles = this.getDeploymentDescriptor((WebModule)aModule).getSecurityRoles();
            } else if (aModule.isEjbModule()) {
                logger.logp(Level.FINER, className, methodName, "Module found to be an EJB Module");
                EJBJar dd = this.getDeploymentDescriptor((EjbModule)aModule);
                if (dd != null) {
                    securityRoles = this.getAssemblyDescriptorAddIfNecessary(dd).getSecurityRoles();
                }
            }
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.EARFile_roles_error_processing_0, new Object[]{aModule, this.getURI(), e.getMessage()}));
            logger.exiting(className, methodName, "Throwing DeploymentDescriptorLoadException");
            String ddName = "";
            if (aModule.isWebModule()) {
                ddName = "WEB-INF/web.xml";
            } else if (aModule.isEjbModule()) {
                ddName = "META-INF/ejb-jar.xml";
            }
            throw new DeploymentDescriptorLoadException(CommonArchiveResourceHandler.getString("dd_in_ear_load_EXC_", new Object[]{ddName, aModule.getUri(), this.getURI()}), e);
        }
        if (securityRoles == null) {
            logger.exiting(className, methodName, "No security roles found");
            return;
        }
        int numRoles = securityRoles.size();
        for (int i = 0; i < numRoles; ++i) {
            this.addCopyIfNotExists((SecurityRole)securityRoles.get(i));
        }
        logger.logp(Level.FINER, className, methodName, "RETURN Found {0} security roles", Integer.toString(numRoles));
    }

    public void setDeploymentDescriptor(Application l) {
        this.setDeploymentDescriptorGen(l);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)l);
    }

    public void setDeploymentDescriptor_noDD(Application l) {
        String methodName = "setDeploymentDescriptor_noDD";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        this.setDeploymentDescriptorGen(l);
        try {
            this.replaceRoot(this.makeMofResource(this.getDeploymentDescriptorUri()), (EObject)l);
        }
        catch (DuplicateObjectException e) {
            logger.logp(Level.FINER, className, methodName, "Ignoring DuplicateObjectException");
        }
        logger.logp(Level.FINER, className, methodName, "RETURN");
    }

    public Application getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject oldDeploymentDescriptor = (InternalEObject)this.deploymentDescriptor;
            this.deploymentDescriptor = (Application)this.eResolveProxy(oldDeploymentDescriptor);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public Application basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(Application newDeploymentDescriptor) {
        Application oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getModuleRefs()).basicAdd(otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 9: {
                return ((InternalEList)this.getModuleRefs()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                return this.getModuleRefs();
            }
            case 10: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.getModuleRefs().clear();
                this.getModuleRefs().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setDeploymentDescriptor((Application)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.getModuleRefs().clear();
                return;
            }
            case 10: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.moduleRefs != null && !this.moduleRefs.isEmpty();
            }
            case 10: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public EList getModuleRefsGen() {
        if (this.moduleRefs == null) {
            this.moduleRefs = new EObjectContainmentWithInverseEList(ModuleRef.class, this, 9, 1);
        }
        return this.moduleRefs;
    }

    public EList getModuleRefs() {
        EList refs = this.getModuleRefsGen();
        if (refs.isEmpty()) {
            this.initRefs(refs);
        }
        return refs;
    }

    public void initRefs(EList refs) {
        EList modules = this.getDeploymentDescriptor().getModules();
        for (int i = 0; i < modules.size(); ++i) {
            Module module = (Module)modules.get(i);
            refs.add(this.createModuleRef(module, null));
        }
    }

    protected ModuleRef createModuleRef(Module aModule, ModuleFile aFile) {
        ModuleRef newRef = null;
        if (aModule.isEjbModule()) {
            newRef = this.getCommonArchiveFactory().createEJBModuleRef();
        } else if (aModule.isWebModule()) {
            newRef = this.getCommonArchiveFactory().createWebModuleRef();
        } else if (aModule.isConnectorModule()) {
            newRef = this.getCommonArchiveFactory().createConnectorModuleRef();
        } else if (aModule.isJavaModule()) {
            newRef = this.getCommonArchiveFactory().createClientModuleRef();
        }
        newRef.setModule(aModule);
        newRef.setModuleFile(aFile);
        return newRef;
    }

    public List getClientModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        for (int i = 0; i < refs.size(); ++i) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (!ref.isClient()) continue;
            result.add(ref);
        }
        return result;
    }

    public List getConnectorModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        for (int i = 0; i < refs.size(); ++i) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (!ref.isConnector()) continue;
            result.add(ref);
        }
        return result;
    }

    public List getEJBModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        for (int i = 0; i < refs.size(); ++i) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (!ref.isEJB()) continue;
            result.add(ref);
        }
        return result;
    }

    public List getWebModuleRefs() {
        ArrayList<ModuleRef> result = new ArrayList<ModuleRef>();
        EList refs = this.getModuleRefs();
        for (int i = 0; i < refs.size(); ++i) {
            ModuleRef ref = (ModuleRef)refs.get(i);
            if (!ref.isWeb()) continue;
            result.add(ref);
        }
        return result;
    }

    public List getFARFiles() {
        ArrayList<File> farFiles = new ArrayList<File>();
        EList fileList = this.getFiles();
        for (int i = 0; i < fileList.size(); ++i) {
            File aFile = (File)fileList.get(i);
            if (!aFile.isFARFile()) continue;
            farFiles.add(aFile);
        }
        return farFiles;
    }

    public List getArchivesOfType(String type) {
        return Collections.EMPTY_LIST;
    }

    public Map getEJBReferences(boolean filterLinkedReferences, boolean filterNonLinkedReferences) throws ArchiveWrappedException {
        Application app;
        if (!(filterLinkedReferences && filterNonLinkedReferences || (app = this.getDeploymentDescriptor()) == null)) {
            EList modules = app.getModules();
            Map references = null;
            for (int i = 0; i < modules.size(); ++i) {
                Module module = (Module)modules.get(i);
                try {
                    references = this.collectEJBReferences(module, filterLinkedReferences, filterNonLinkedReferences, references);
                    continue;
                }
                catch (ResourceLoadException e) {
                    throw new ArchiveWrappedException((Exception)((Object)e));
                }
                catch (FileNotFoundException e) {
                    throw new ArchiveWrappedException(e);
                }
                catch (EmptyResourceException e) {
                    throw new ArchiveWrappedException(e);
                }
            }
            return references;
        }
        return Collections.EMPTY_MAP;
    }

    private Map collectEJBReferences(Module module, boolean filterLinkedReferences, boolean filterNonLinkedReferences, Map references) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        HashMap myReferences = references;
        List moduleReferences = this.getEJBReferences(module);
        if (moduleReferences != null && !moduleReferences.isEmpty()) {
            EjbRef ref = null;
            ArrayList<EjbRef> filteredRefs = null;
            String link = null;
            for (int i = 0; i < moduleReferences.size(); ++i) {
                ref = (EjbRef)moduleReferences.get(i);
                link = ref.getLink();
                if ((link == null || link.length() <= 0 || filterLinkedReferences) && (link != null && link.length() != 0 || filterNonLinkedReferences)) continue;
                if (filteredRefs == null) {
                    filteredRefs = new ArrayList<EjbRef>(moduleReferences.size());
                }
                filteredRefs.add(ref);
            }
            if (filteredRefs != null) {
                if (myReferences == null) {
                    myReferences = new HashMap();
                }
                myReferences.put(module, filteredRefs);
            }
        }
        return myReferences;
    }

    private List getEJBReferences(Module module) throws ResourceLoadException, FileNotFoundException, EmptyResourceException {
        if (module != null) {
            ApplicationClient appClient;
            if (module.isEjbModule()) {
                EJBJar ejbJar = this.getDeploymentDescriptor((EjbModule)module);
                return this.getEJBReferences(ejbJar);
            }
            if (module.isWebModule()) {
                WebApp webApp = this.getDeploymentDescriptor((WebModule)module);
                if (webApp != null) {
                    return webApp.getEjbRefs();
                }
            } else if (module.isJavaModule() && (appClient = this.getDeploymentDescriptor((JavaClientModule)module)) != null) {
                return appClient.getEjbReferences();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private List getEJBReferences(EJBJar ejbJar) {
        if (ejbJar != null) {
            EList ejbs = ejbJar.getEnterpriseBeans();
            ArrayList refs = null;
            EnterpriseBean ejb = null;
            for (int i = 0; i < ejbs.size(); ++i) {
                ejb = (EnterpriseBean)ejbs.get(i);
                if (refs == null) {
                    refs = new ArrayList();
                }
                refs.addAll(ejb.getEjbRefs());
            }
            if (refs != null) {
                return refs;
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected void updateSignature(Application application, String triggerMethod) {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        if (this.earSignature == null) {
            this.earSignature = new EARSignature();
        }
        this.earSignature.updateSignature(application, triggerMethod);
    }

    public boolean isAnnotationsSupported() {
        return false;
    }

    public String getLibraryDirectoryName() {
        String methodName = "getLibraryDirectoryName";
        logger.logp(Level.FINER, className, methodName, "ENTRY  [ {0} ]", this.getURI());
        if (this._libraryDirectoryNameComputed) {
            logger.logp(Level.FINER, className, methodName, "RETURN cached library directory name [ {0} ]", this._libraryDirectoryName);
            return this._libraryDirectoryName;
        }
        Application app = this.getDeploymentDescriptor();
        String lib = null;
        if (app != null && app.getJ2EEVersionID() >= 50) {
            logger.logp(Level.FINER, className, methodName, "JavaEE5 (or higher) case");
            if (app.isSetLibraryDirectory()) {
                lib = app.getLibraryDirectory();
                if (lib.equals("")) {
                    lib = null;
                }
            } else {
                logger.logp(Level.FINER, className, methodName, "JavaEE5: No set library directory; using default");
                lib = "lib";
            }
        } else {
            logger.logp(Level.FINER, className, methodName, "Pre-JavaEE5 case; the lib directory is not supported");
            lib = null;
        }
        this._libraryDirectoryNameComputed = true;
        this._libraryDirectoryName = lib;
        logger.logp(Level.FINER, className, methodName, "RETURN Library directory name [ {0} ]", this._libraryDirectoryName);
        return this._libraryDirectoryName;
    }

    public java.io.File getLibraryDirectory() {
        String methodName = "getLibraryDirectory";
        logger.logp(Level.FINER, className, methodName, "ENTRY  [ {0} ]", this.getURI());
        String libDirName = this.getLibraryDirectoryName();
        if (libDirName == null) {
            logger.logp(Level.FINER, className, methodName, "RETURN Library Directory [ null ]");
            return null;
        }
        try {
            String slash = System.getProperty("file.separator");
            libDirName = this.getBinariesPath() + slash + libDirName + slash;
            logger.logp(Level.FINER, className, methodName, "Library Directory [ {0} ]", libDirName);
        }
        catch (FileNotFoundException e) {
            logger.logp(Level.WARNING, className, methodName, "RETURN null - No EAR BinariesPath");
            return null;
        }
        java.io.File libDirFile = new java.io.File(libDirName);
        if (!libDirFile.exists()) {
            logger.logp(Level.FINER, className, methodName, "RETURN null - Specified lib [ {0} ] does not exist", libDirName);
            return null;
        }
        if (!libDirFile.isDirectory()) {
            logger.logp(Level.WARNING, className, methodName, "RETURN null - Specified lib [ {0} ] not a directory", libDirName);
            return null;
        }
        return libDirFile;
    }

    protected class EARSignature {
        public int moduleCount = -1;
        public HashSet moduleTypes = null;

        protected EARSignature() {
        }

        protected void updateSignature(Application application, String triggerMethod) {
            if (application == null) {
                if (this.moduleCount != -1) {
                    logger.logp(Level.FINER, className, triggerMethod, "Update to module count detected: Old count [ {0} ]; new count [ {1} ]", new Object[]{new Integer(this.moduleCount), new Integer(-1)});
                    if (this.moduleTypes != null) {
                        for (String nextModuleType : this.moduleTypes) {
                            logger.logp(Level.FINER, className, triggerMethod, "Removed module [ {0} ]", nextModuleType);
                        }
                    }
                    this.moduleTypes = null;
                    this.moduleCount = -1;
                }
            } else if (this.moduleCount == -1) {
                this.moduleCount = application.getModules().size();
                logger.logp(Level.FINER, className, triggerMethod, "Update of module count detected: Old count [ {0} ]; new count [ {1} ]", new Object[]{new Integer(-1), new Integer(this.moduleCount)});
                if (this.moduleCount == 0) {
                    logger.logp(Level.FINER, className, triggerMethod, "WARNING: No modules are present");
                }
                this.moduleTypes = this.getModuleTypes(application);
                for (String nextModuleType : this.moduleTypes) {
                    logger.logp(Level.FINER, className, triggerMethod, "Added module [ {0} ]", nextModuleType);
                }
            } else {
                HashSet newModuleTypes = this.getModuleTypes(application);
                int newModuleCount = newModuleTypes.size();
                if (this.moduleCount != newModuleCount) {
                    logger.logp(Level.FINER, className, triggerMethod, "Update of module count detected: Old count [ {0} ]; new count [ {1} ]", new Object[]{new Integer(this.moduleCount), new Integer(newModuleCount)});
                }
                boolean changedModules = false;
                int numDuplicateModules = 0;
                for (String nextModuleType : this.moduleTypes) {
                    if (!newModuleTypes.contains(nextModuleType)) {
                        logger.logp(Level.FINER, className, triggerMethod, "Removed module [ {0} ]", nextModuleType);
                        changedModules = true;
                        continue;
                    }
                    ++numDuplicateModules;
                }
                if (numDuplicateModules != newModuleTypes.size()) {
                    logger.logp(Level.FINER, className, triggerMethod, "Removed a total of [ {0} ] modules", new Integer(this.moduleTypes.size() - numDuplicateModules));
                    int numNewModules = 0;
                    for (String nextNewModuleType : newModuleTypes) {
                        if (this.moduleTypes.contains(nextNewModuleType)) continue;
                        logger.logp(Level.FINER, className, triggerMethod, "Added module [ {0} ]", nextNewModuleType);
                        changedModules = true;
                        ++numNewModules;
                    }
                    logger.logp(Level.FINER, className, triggerMethod, "Added a total of [ {0} ] modules", new Integer(numNewModules));
                }
                if (changedModules) {
                    this.moduleCount = newModuleCount;
                    this.moduleTypes = newModuleTypes;
                }
            }
        }

        protected HashSet getModuleTypes(Application application) {
            HashSet<String> newModuleTypes = new HashSet<String>();
            for (Module nextModule : application.getModules()) {
                newModuleTypes.add(this.getModuleType(nextModule));
            }
            return newModuleTypes;
        }

        protected String getModuleType(Module module) {
            return "[ " + module.getClass().getName() + " ] [ " + module.getUri() + " ]";
        }
    }
}

