/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.FileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;

public abstract class ContainerImpl
extends FileImpl
implements Container {
    protected static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private static final String className = ContainerImpl.class.getName();
    protected LoadStrategy loadStrategy;
    protected Map fileIndex;
    protected FileNotificationAdapter fileIndexAdapter;
    protected EList files = null;

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.CONTAINER;
    }

    public boolean containsFile(String aUri) {
        String key;
        String string = key = aUri.startsWith("/") ? ArchiveUtil.truncateFromFrontIgnoreCase(aUri, "/") : aUri;
        if (this.isIndexed()) {
            return this.getFileIndex().containsKey(key);
        }
        return this.getLoadStrategy().contains(key);
    }

    public String getAbsolutePath() throws FileNotFoundException {
        return this.getLoadStrategy().getAbsolutePath();
    }

    public File getFile(String URI2) throws FileNotFoundException {
        Map map;
        File file;
        String methodName = "getFile";
        logger.entering(className, methodName, URI2);
        if (!this.isIndexed()) {
            logger.logp(Level.FINER, className, methodName, "Container not indexed, get new list of files");
            this.getFiles();
        }
        if ((file = (File)(map = this.getFileIndex()).get(URI2)) == null) {
            for (String currentKey : map.keySet()) {
                if (!URI2.equalsIgnoreCase(currentKey)) continue;
                logger.logp(Level.WARNING, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.ContainerImpl_missing_file_with_different_URI, new Object[]{URI2, currentKey}));
            }
            logger.exiting(className, methodName, "Throwing FileNotFoundException");
            throw new FileNotFoundException(URI2);
        }
        logger.exiting(className, methodName, file);
        return file;
    }

    protected Map getFileIndex() {
        String methodName = "getFileIndex";
        logger.logp(Level.FINER, className, methodName, "ENTRY");
        if (this.fileIndex == null) {
            this.getFileIndexAdapter().rebuildFileIndex();
        }
        logger.logp(Level.FINER, className, methodName, "RETURN fileIndex {0}", this.fileIndex);
        return this.fileIndex;
    }

    protected FileNotificationAdapter getFileIndexAdapter() {
        if (this.fileIndexAdapter == null) {
            this.fileIndexAdapter = new FileNotificationAdapter();
            this.eAdapters().add(this.fileIndexAdapter);
        }
        return this.fileIndexAdapter;
    }

    public EList getFiles() {
        String methodName = "getFiles";
        String useUri = this.getURI();
        logger.logp(Level.FINEST, className, methodName, "ENTER [ {0} ]", useUri);
        EList filesList = this.getFilesGen();
        logger.logp(Level.FINEST, className, methodName, "Number of files [ {0} ]", new Integer(filesList.size()));
        if (!this.isIndexed()) {
            logger.logp(Level.FINER, className, methodName, "Files list is not indexed");
            if (filesList.isEmpty()) {
                logger.logp(Level.FINER, className, methodName, "Empty files list; filling from load strategy");
                LoadStrategy ls = this.getLoadStrategy();
                if (ls == null) {
                    logger.logp(Level.WARNING, className, methodName, "No load strategy is available for [ {0} ]", useUri);
                } else {
                    logger.logp(Level.FINER, className, methodName, "Load strategy [ {0} ]", ls);
                    filesList.addAll(ls.collectFiles());
                    logger.logp(Level.FINER, className, methodName, "Collected list of {0} files", new Integer(filesList.size()));
                }
            }
            logger.logp(Level.FINEST, className, methodName, "Build file index");
            this.getFileIndex();
        }
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer messageBuffer = new StringBuffer("Complete list of returned files:\n");
            Iterator useFiles = filesList.iterator();
            while (useFiles.hasNext()) {
                messageBuffer.append(useFiles.next());
                messageBuffer.append("\n");
            }
            logger.logp(Level.FINEST, className, methodName, messageBuffer.toString());
        }
        logger.logp(Level.FINER, className, methodName, "RETURN [ {0} ] with [ {1} ] files", new Object[]{useUri, new Integer(filesList.size())});
        return filesList;
    }

    public InputStream getInputStream(String aUri) throws IOException, FileNotFoundException {
        if (this.isIndexed()) {
            return this.getFile(aUri).getInputStream();
        }
        return this.primGetInputStream(aUri);
    }

    public LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public boolean isContainer() {
        return true;
    }

    public boolean isIndexed() {
        return this.fileIndex != null;
    }

    public InputStream primGetInputStream(String aUri) throws IOException, FileNotFoundException {
        return this.getLoadStrategy().getInputStream(aUri);
    }

    public void rebuildFileIndex() {
        this.getFileIndexAdapter().rebuildFileIndex();
    }

    public void setLoadStrategy(LoadStrategy newLoadStrategy) {
        if (newLoadStrategy != null) {
            newLoadStrategy.setContainer(this);
            if (this.loadStrategy != null) {
                newLoadStrategy.setRendererType(this.loadStrategy.getRendererType());
                newLoadStrategy.setReadOnly(this.loadStrategy.isReadOnly());
                this.loadStrategy.setContainer(null);
                this.loadStrategy.close();
            }
        }
        this.loadStrategy = newLoadStrategy;
    }

    public EList getFilesGen() {
        String methodName = "getFilesGen";
        logger.entering(className, methodName, this);
        if (this.files == null) {
            logger.logp(Level.FINER, className, methodName, "Creating new list of files");
            this.files = new EObjectContainmentWithInverseEList(File.class, this, 7, 6);
        }
        logger.logp(Level.FINER, className, methodName, "RETURN list of [ {0} ] files", Integer.toString(this.files.size()));
        return this.files;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getFiles()).basicAdd(otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return ((InternalEList)this.getFiles()).basicRemove(otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getFiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.getFiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void clearFiles() {
        boolean oldDelivery = this.eDeliver();
        this.files.clear();
        this.eSetDeliver(oldDelivery);
        if (this.isIndexed()) {
            this.eAdapters().remove(this.fileIndexAdapter);
            this.fileIndexAdapter = null;
            this.fileIndex = null;
        }
    }

    protected class FileNotificationAdapter
    extends AdapterImpl {
        protected FileNotificationAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return type == "FileNotificationAdapter";
        }

        public void addIndexedFile(String newValue, Notifier notifier) {
            ContainerImpl.this.fileIndex.put(newValue, notifier);
            if (notifier.eAdapters() == null || !notifier.eAdapters().contains(this)) {
                notifier.eAdapters().add(this);
            }
        }

        public void removeIndexedFile(String oldValue, Notifier notifier) {
            ContainerImpl.this.fileIndex.remove(oldValue);
            notifier.eAdapters().remove(this);
        }

        public void notifyChanged(Notification notification) {
            if (ContainerImpl.this.fileIndex == null || notification.getFeature() == null) {
                return;
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getFile_URI()) && ((File)notification.getNotifier()).getContainer() == ContainerImpl.this) {
                ContainerImpl.this.fileIndex.remove(notification.getOldValue());
                ContainerImpl.this.fileIndex.put(notification.getNewValue(), notification.getNotifier());
            }
            if (notification.getFeature().equals(CommonarchivePackage.eINSTANCE.getContainer_Files()) && notification.getNotifier() == ContainerImpl.this) {
                switch (notification.getEventType()) {
                    case 3: {
                        File file = (File)notification.getNewValue();
                        this.addIndexedFile(file.getURI(), file);
                        break;
                    }
                    case 4: {
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (File)notification.getOldValue());
                        break;
                    }
                    case 5: {
                        this.filesAdded((List)notification.getNewValue());
                        break;
                    }
                    case 6: {
                        this.filesRemoved((List)notification.getOldValue());
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 1: {
                        if (notification.getPosition() == -1) break;
                        File file = (File)notification.getNewValue();
                        this.removeIndexedFile(((File)notification.getOldValue()).getURI(), (File)notification.getOldValue());
                        this.addIndexedFile(file.getURI(), file);
                    }
                }
            }
        }

        public void filesAdded(List newFiles) {
            for (int i = 0; i < newFiles.size(); ++i) {
                File file = (File)newFiles.get(i);
                this.addIndexedFile(file.getURI(), file);
            }
        }

        public void filesRemoved(List oldFiles) {
            for (int i = 0; i < oldFiles.size(); ++i) {
                File file = (File)oldFiles.get(i);
                this.removeIndexedFile(file.getURI(), file);
            }
        }

        public void rebuildFileIndex() {
            String methodName = "rebuildFileIndex";
            logger.logp(Level.FINER, className, methodName, "ENTRY");
            this.removeAdaptersIfNecessary();
            ContainerImpl.this.fileIndex = new HashMap();
            if (ContainerImpl.this.getFiles().size() > 0) {
                for (File file : ContainerImpl.this.getFiles()) {
                    this.addIndexedFile(file.getURI(), file);
                }
            }
            logger.logp(Level.FINER, className, methodName, "RETURN");
        }

        public void removeAdaptersIfNecessary() {
            if (ContainerImpl.this.fileIndex == null) {
                return;
            }
            for (File aFile : ContainerImpl.this.fileIndex.values()) {
                aFile.eAdapters().remove(this);
            }
        }
    }
}

